/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;

public class Line {
    double x0;
    double y0;
    double x1;
    double y1;

    Line(double d, double d2, double d3, double d4) {
        this.x0 = d;
        this.y0 = d2;
        this.x1 = d3;
        this.y1 = d4;
    }

    Line(Point point, Point point2) {
        this.x0 = point.x;
        this.y0 = point.y;
        this.x1 = point2.x;
        this.y1 = point2.y;
    }

    double slope() {
        if (this.x1 - this.x0 == 0.0) {
            return 1.0;
        }
        return (this.y1 - this.y0) / (this.x1 - this.x0);
    }

    public static boolean linesIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Line.relativeCCW(d, d2, d3, d4, d5, d6) * Line.relativeCCW(d, d2, d3, d4, d7, d8) <= 0 && Line.relativeCCW(d5, d6, d7, d8, d, d2) * Line.relativeCCW(d5, d6, d7, d8, d3, d4) <= 0;
    }

    public boolean intersects(Line line) {
        return Line.linesIntersect(line.x0, line.y0, line.x1, line.y1, this.x0, this.y0, this.x1, this.y1);
    }

    public static int relativeCCW(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d5 -= d) * (d4 -= d2) - (d6 -= d2) * (d3 -= d);
        if (d7 == 0.0 && (d7 = d5 * d3 + d6 * d4) > 0.0 && (d7 = (d5 -= d3) * d3 + (d6 -= d4) * d4) < 0.0) {
            d7 = 0.0;
        }
        return d7 < 0.0 ? -1 : (d7 > 0.0 ? 1 : 0);
    }

    Point intersection(Line line) {
        if (this.slope() == line.slope()) {
            return null;
        }
        double d = (this.b() - line.b()) / (line.slope() - this.slope());
        double d2 = this.slope() * d + this.b();
        return new Point((int)d, (int)d2);
    }

    double intersectionX(Line line) {
        if (this.slope() == line.slope()) {
            boolean bl = true;
        }
        double d = (this.b() - line.b()) / (line.slope() - this.slope());
        return d;
    }

    double intersectionY(Line line) {
        if (this.slope() == line.slope()) {
            boolean bl = true;
        }
        double d = (this.b() - line.b()) / (line.slope() - this.slope());
        double d2 = this.slope() * d + this.b();
        return d2;
    }

    Point midpoint() {
        double d = this.x0 + (this.x1 - this.x0) / (double)2;
        double d2 = this.y0 + (this.y1 - this.y0) / (double)2;
        return new Point((int)d, (int)d2);
    }

    Point fractionalPoint(int n, int n2) {
        double d = this.x0 + (double)n * ((this.x1 - this.x0) / (double)n2);
        double d2 = this.y0 + (double)n * ((this.y1 - this.y0) / (double)n2);
        return new Point((int)d, (int)d2);
    }

    Point startPoint() {
        return new Point((int)this.x0, (int)this.y0);
    }

    Point endPoint() {
        return new Point((int)this.x1, (int)this.y1);
    }

    double b() {
        return this.y0 - this.x0 * this.slope();
    }

    double length() {
        double d = this.x1 - this.x0;
        double d2 = this.y1 - this.y0;
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
    }

    double xAtY(double d) {
        return (d - this.b()) / this.slope();
    }

    double yAtX(double d) {
        return this.slope() * d + this.b();
    }

    public String toString() {
        return String.valueOf(String.valueOf("(")) + this.x0 + "," + this.y0 + ") , (" + this.x1 + "," + this.y1 + ")";
    }
}

