/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AxisPieBarObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_PieBar
extends JChart_2D_Pie {
    public static final int PIEBAR_RISER_WIDTH = 2000;
    public static final int ID_TOPLINE = 300;
    public static final int ID_BOTTOMLINE = 400;
    protected RelativeAxisObj m_Y1Axis;
    protected String[] m_DataLabel;
    protected Rectangle[] m_RiserRect;
    protected Point m_ptTopBar;
    protected Point m_ptBottomBar;
    protected double m_fSliceValue;
    protected int m_nBarThickCoord;
    protected boolean m_bPieBarSliceIsOK;
    protected boolean m_bDataTextDisplay;
    protected int m_nDepthRadius;
    protected boolean m_bAutoshading;
    protected Point m_frontOffset;
    protected double[] m_groupValues;

    public void calcBar() {
        int n;
        Object object;
        int n2;
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_groupValues = new double[this.m_nTotalGroups];
        double[] dArray = new double[this.m_nTotalGroups];
        int[] nArray = new int[this.m_nTotalGroups];
        int n3 = -1;
        Point point = new Point(this.m_frontOffset.x, this.m_frontOffset.y);
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0 && this.m_nPieBarSlice < this.m_nTotalSeries);
        PfjAssert.pfjAssert(this.m_nGroups > 0);
        PfjAssert.pfjAssert(this.m_fPieTotal > 0.0);
        PfjAssert.pfjAssert(this.m_Y1Axis);
        int n4 = groupsEnumerator.getFirstGroup();
        int n5 = groupsEnumerator.getLastGroup();
        while (groupsEnumerator.hasMoreElements()) {
            n3 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
            n2 = groupsEnumerator.peekAtGroupBefore(n3);
            if (n3 != n4) {
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            }
            this.m_groupValues[n3] = Math.max(this.getDataValue((int)this.m_nPieBarSlice, (int)n3).m_fValue, 0.0);
            dArray[n3] = n3 == n4 ? this.m_groupValues[n3] : dArray[n2] + this.m_groupValues[n3];
        }
        double d = n3 == -1 ? 0.0 : dArray[n3];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalGroups];
            this.m_RiserRect = new Rectangle[this.m_nTotalGroups];
            object = this.m_Perspective.getDataTextFormatPattern();
            n = this.m_Perspective.getDataTextFormat();
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                double d2;
                n3 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
                double d3 = d2 = TDGNumberFormat.isPercentFormat(n) ? dArray[n3] / d : dArray[n3];
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(3, this.m_nPieBarSlice, n3, -1, -3);
                    this.m_DataLabel[n3] = this.m_Perspective.getNumberFormatCallBack().toString(this.m_groupValues[n3]);
                    continue;
                }
                this.m_DataLabel[n3] = TDGNumberFormat.toString(this.m_Perspective, n, this.m_groupValues[n3], (String)object);
            }
        }
        int n6 = (int)this.m_Y1Axis.getValueCoord(0.0);
        int n7 = (int)this.m_Y1Axis.getValueCoord(d) - n6;
        int n8 = (this.m_rPieFrame.height - n7) / 2;
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            n3 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
            n2 = groupsEnumerator.peekAtGroupBefore(n3);
            if (n3 != n4) {
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            }
            nArray[n3] = (int)this.m_Y1Axis.getValueCoord(dArray[n3]);
            int n9 = this.m_rPieFrame.x + this.m_rPieFrame.width - this.m_nBarThickCoord;
            int n10 = n9 + this.m_nBarThickCoord;
            int n11 = n3 == n4 ? n6 + n8 : nArray[n2] + n8;
            int n12 = nArray[n3] + n8;
            Rectangle rectangle = new Rectangle(n9, n11, n10 - n9, n12 - n11);
            if (this.m_bDataTextDisplay) {
                this.m_RiserRect[n3] = rectangle;
            }
            if (n3 == n5) {
                this.m_ptTopBar = new Point(n9, n12);
                this.m_ptBottomBar = new Point(n9, n6 + n8);
            }
            int n13 = n3 % this.m_nSeriesLooping;
            IdentObj identObj = new IdentObj(331, this.m_nPieBarSlice, n13);
            IdentObj identObj2 = new IdentObj(-3, -3, n13);
            BlackBoxIF blackBoxIF = this.assignSeriesColor(identObj2);
            if (this.m_nDepthRadius > 0 && this.m_Frame != null) {
                Polygon polygon;
                double d4;
                if (this.m_nDepthAngle > 90) {
                    rectangle.x += point.x;
                    if (n3 == n5) {
                        this.m_ptTopBar = new Point(rectangle.x, n12);
                        this.m_ptBottomBar = new Point(rectangle.x, n6 + n8);
                    }
                }
                object = new Point(0, 0);
                rectangle.x -= point.x;
                rectangle.y -= point.y;
                if (this.m_bAutoshading) {
                    d4 = 1.0;
                    polygon = new Polygon();
                    polygon.addPoint(rectangle.x, rectangle.y);
                    polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                    polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                    polygon.addPoint(rectangle.x, rectangle.y);
                    new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d4);
                } else {
                    new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF, null);
                }
                if (this.m_nDepthAngle != 90) {
                    n = this.m_nDepthAngle > 90 ? rectangle.x : rectangle.x + rectangle.width;
                    polygon = new Polygon();
                    polygon.addPoint(n, rectangle.y);
                    polygon.addPoint(n, rectangle.y + rectangle.height);
                    polygon.addPoint(n + (point.x - ((Point)object).x), rectangle.y + rectangle.height + (point.y - ((Point)object).y));
                    polygon.addPoint(n + (point.x - ((Point)object).x), rectangle.y + (point.y - ((Point)object).y));
                    polygon.addPoint(n, rectangle.y);
                    d4 = this.m_bAutoshading ? 0.6 : 1.0;
                    IdentObj identObj3 = new IdentObj(334, this.m_nPieBarSlice, n13);
                    new DetPolygon(this.m_Detectiv, identObj3, polygon, blackBoxIF, d4);
                }
                if (this.m_nDepthAngle == 0 || this.m_nDepthAngle == 180) continue;
                polygon = new Polygon();
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                polygon.addPoint(rectangle.x + rectangle.width + (point.x - ((Point)object).x), rectangle.y + rectangle.height + (point.y - ((Point)object).y));
                polygon.addPoint(rectangle.x + (point.x - ((Point)object).x), rectangle.y + rectangle.height + (point.y - ((Point)object).y));
                polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
                d4 = 0.8;
                IdentObj identObj4 = new IdentObj(335, this.m_nPieBarSlice, n13);
                new DetPolygon(this.m_Detectiv, identObj4, polygon, blackBoxIF, d4);
                continue;
            }
            new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF, null);
        }
    }

    protected Rectangle calcDataValuePosition(int n, Dimension dimension) {
        Point point = new Point(this.m_RiserRect[n].x + this.m_RiserRect[n].width / 2, this.m_RiserRect[n].y + this.m_RiserRect[n].height);
        Rectangle rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double d = this.m_Perspective.getDataTextAngle(this.m_nPieBarSlice, n);
                double d2 = this.m_Perspective.getDataTextRadius(this.m_nPieBarSlice, n);
                rectangle.x += (int)(Math.cos(d * (Math.PI / 180)) * d2 * (double)40);
                rectangle.y += (int)(Math.sin(d * (Math.PI / 180)) * d2 * (double)40);
                break;
            }
            case 1: {
                rectangle.y += dimension.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                rectangle.y -= dimension.height / 2;
                break;
            }
            case 4: {
                rectangle.y = this.m_RiserRect[n].y + this.m_RiserRect[n].height / 2 - dimension.height / 2;
                break;
            }
            case 5: {
                rectangle.y = (int)this.m_Y1Axis.getValueCoord(0.0);
            }
        }
        return rectangle;
    }

    public void calcSinglePie() {
        super.calcSinglePie();
        if (this.m_bPieBarSliceIsOK) {
            this.m_Y1Axis = null;
            this.createY1Axis();
            this.calcBar();
            this.drawConnectingLines();
            if (this.m_bDataTextDisplay) {
                this.drawDataValues();
            }
        }
    }

    protected void copyParams() {
        super.copyParams();
        this.m_fSliceValue = this.getSeriesTotal(this.m_nPieBarSlice);
        if (this.m_fSliceValue < 0.0) {
            this.m_fSliceValue = 0.0;
        }
        this.m_bPieBarSliceIsOK = this.m_fSliceValue > 0.0;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        if (seriesEnumerator.getRelativeSeries(this.m_nPieBarSlice) == -1) {
            this.m_bPieBarSliceIsOK = false;
        }
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_DataLabel = null;
        this.m_RiserRect = null;
        this.m_nBarThickCoord = 2000 * this.m_Perspective.getRiserWidth() / 100;
        Rectangle rectangle = this.m_Perspective.getRect(this.m_Perspective.getPieFrame());
        if (this.m_nBarThickCoord > rectangle.width / 5) {
            this.m_nBarThickCoord = rectangle.width / 5;
        }
        this.m_nDepthRadius = this.m_Perspective.getPieDepth();
        this.m_bAutoshading = this.m_Perspective.getAutoshading();
        double d = this.m_nBarThickCoord;
        double d2 = d * (double)this.m_nDepthRadius / (double)100;
        double d3 = d2 * Math.cos((double)this.m_nDepthAngle * (Math.PI / 180));
        double d4 = d2 * Math.sin((double)this.m_nDepthAngle * (Math.PI / 180));
        this.m_frontOffset = new Point((int)d3, (int)d4);
    }

    protected void createY1Axis() {
        MinMaxObj minMaxObj = new MinMaxObj(0.0, this.m_fSliceValue);
        int n = 0;
        int n2 = 100;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        this.m_Y1Axis = new AxisPieBarObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl2, bl3, n, n2);
        this.m_Y1Axis.calc();
    }

    public void drawConnectingLines() {
        IdentObj identObj = this.m_Perspective.getPieBarConnectLines();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        int n = this.m_Perspective.getLineWidth(identObj);
        int n2 = this.m_ptTopSlice.x;
        int n3 = this.m_ptTopSlice.y;
        int n4 = this.m_ptTopBar.x - this.m_frontOffset.x;
        int n5 = this.m_ptTopBar.y - this.m_frontOffset.y;
        IdentObj identObj2 = new IdentObj(identObj);
        identObj2.setMiscID(300);
        new DetLine(this.m_Detectiv, identObj2, n2, n3, n4, n5, blackBoxObj, null, n);
        n2 = this.m_ptBottomSlice.x;
        n3 = this.m_ptBottomSlice.y;
        n4 = this.m_ptBottomBar.x - this.m_frontOffset.x;
        n5 = this.m_ptBottomBar.y - this.m_frontOffset.y;
        identObj2 = new IdentObj(identObj);
        identObj2.setMiscID(400);
        new DetLine(this.m_Detectiv, identObj2, n2, n3, n4, n5, blackBoxObj, null, n);
    }

    protected void drawDataValues() {
        int n;
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Vector<String> vector = new Vector<String>(this.m_nGroups);
        Dimension dimension = new Dimension(5000, 1600);
        IdentObj identObj = this.m_Perspective.getDataText();
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        while (groupsEnumerator.hasMoreElements()) {
            n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            vector.addElement(this.m_DataLabel[n]);
        }
        int n2 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n2, vector, dimension, this.m_Perspective.m_VC);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            if (this.m_DataLabel[n] == null) continue;
            Rectangle rectangle = this.calcDataValuePosition(n, dimension);
            IdentObj identObj2 = new IdentObj(identObj.getObjectID(), this.m_nPieBarSlice, n);
            new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n], rectangle, textStyleObj, (BlackBoxIF)blackBoxObj, false, null);
        }
    }

    public int getBarThickness() {
        return this.m_nBarThickCoord;
    }

    protected int getSliceObjectID(int n) {
        int n2;
        switch (n) {
            case 298: {
                n2 = 332;
                break;
            }
            case 299: {
                n2 = 333;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    protected double getPieRotation() {
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0 && this.m_nPieBarSlice < this.m_nTotalSeries);
        PfjAssert.pfjAssert(this.m_nGroups > 0);
        PfjAssert.pfjAssert(this.m_nSeries > 0);
        PfjAssert.pfjAssert(this.m_fPieTotal > 0.0);
        double d = 0.0;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            if (n >= this.m_nPieBarSlice) break;
            double d2 = this.getSeriesTotal(n);
            if (!(d2 > 0.0)) continue;
            d += d2;
        }
        double d3 = d / this.m_fPieTotal;
        double d4 = this.m_fSliceValue / this.m_fPieTotal;
        return 0.25 - d3 - d4 / 2.0;
    }

    protected boolean isPieBarSliceOK() {
        return this.m_bPieBarSliceIsOK;
    }

    public void releaseReferences() {
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public double getGroupValueForBar(int n) {
        return this.m_groupValues[n];
    }
}

