/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.Perspective;

public class GroupsEnumerator {
    static final boolean FORWARD = true;
    static final boolean REVERSE = false;
    int[] m_groupArray;
    int m_index;

    GroupsEnumerator(Perspective perspective, Access access, boolean bl) {
        DataRange dataRange = access.getViewableDataRangeSG(perspective);
        int n = dataRange.getColStart();
        int n2 = dataRange.getColStop();
        int n3 = n2 - n + 1;
        int n4 = 0;
        this.m_index = 0;
        if (n3 < 0) {
            this.m_groupArray = new int[0];
            return;
        }
        this.m_groupArray = new int[n3];
        if (bl) {
            int n5 = 0;
            int n6 = n;
            while (n6 <= n2) {
                this.m_groupArray[n5++] = n6++;
                ++n4;
            }
        } else {
            int n7 = n3 - 1;
            int n8 = n;
            while (n8 <= n2) {
                this.m_groupArray[n7--] = n8++;
                ++n4;
            }
        }
    }

    public int getAbsoluteGroup(int n) {
        return this.groupAt(n);
    }

    public int getFirstGroup() {
        return this.groupAt(0);
    }

    public int getLastGroup() {
        return this.groupAt(this.m_groupArray.length - 1);
    }

    public int getNumGroups() {
        return this.m_groupArray.length;
    }

    public int getRelativeGroup(int n) {
        int n2 = 0;
        while (n2 < this.m_groupArray.length) {
            if (this.m_groupArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean hasMoreElements() {
        return this.m_index < this.m_groupArray.length;
    }

    public int nextGroup() {
        return this.m_groupArray[this.m_index++];
    }

    public int groupAt(int n) {
        try {
            int n2 = this.m_groupArray[n];
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = -1;
            return n3;
        }
    }

    public int peekAtNextGroup() {
        return this.groupAt(this.m_index);
    }

    public int peekAtGroupAfter(int n) {
        int n2 = this.getRelativeGroup(n);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.groupAt(n2 + 1);
        }
        return n3;
    }

    public int peekAtGroupBefore(int n) {
        int n2 = this.getRelativeGroup(n);
        int n3 = -1;
        if (n2 >= 1) {
            n3 = this.groupAt(n2 - 1);
        }
        return n3;
    }

    public void reset() {
        this.m_index = 0;
    }
}

