/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.DataEndPoints;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BaseAxis;
import oracle.dss.graph.gui.ReferenceLine;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class ValueAxis
extends BaseAxis
implements HelpContext {
    protected JPanel minimum;
    protected JLabel minimumLabel;
    protected JPanel maximum;
    protected JLabel maximumLabel;
    protected JPanel increment;
    protected JLabel incrementLabel;
    protected JPanel baseline;
    protected JLabel baselineLabel;
    protected DoubleTextField m_minimumField;
    protected DoubleTextField m_maximumField;
    protected DoubleTextField m_incrementField;
    protected DoubleTextField m_baselineField;
    protected JCheckBox m_minimumBox;
    protected JCheckBox m_maximumBox;
    protected JCheckBox m_incrementBox;
    protected JCheckBox m_logarithmicBox;
    protected FontButton m_scaleFontButton;
    protected JButton m_referenceLineButton;
    protected JPanel m_buttonPanel;
    protected JComboBox m_logChoice;
    protected JLabel m_base;
    protected JPanel logarithmic;
    protected int m_componentID;
    protected double m_oldMinimum;
    protected double m_oldMaximum;
    protected double m_oldIncrement;
    protected double m_oldBaseline;
    protected double m_oldLogBase;
    protected double m_currentLogBase;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected boolean m_incrChecked;
    protected boolean m_repeatWarnings = true;
    protected double m_currentMaxValue;
    protected double m_currentMinValue;
    protected double m_currentIncrValue;
    protected double m_currentBaselineValue;
    protected int m_multiplier = 10;
    protected ReferenceLine m_referenceLine;
    protected boolean m_bScaleLogarithmicChanged;
    protected boolean m_bLogarithmicBaseChanged;
    protected boolean m_bReferenceLineChanged;
    protected double autoTickStep;
    public static final String PROPERTY_AXIS_MAX_VALUE = "AxisMaxValue";
    public static final String PROPERTY_AXIS_MIN_VALUE = "AxisMinValue";
    public static final String PROPERTY_AXIS_MAJOR_TICK_STEP = "AxisMajorTickStep";
    public static final String PROPERTY_AXIS_AUTO_MAX = "AxisAutoMax";
    public static final String PROPERTY_AXIS_AUTO_MIN = "AxisAutoMin";
    public static final String PROPERTY_AXIS_AUTO_TICK_STEP = "AxisAutoTickStep";
    public static final String PROPERTY_AXIS_LOG_SCALE = "AxisLogScale";
    public static final String PROPERTY_AXIS_LOG_BASE = "AxisLogarithmicBase";

    public ValueAxis(Graph graph, int n) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        this.m_optionsLabel.setText(this.rBundle.getString("axis scale"));
        this.minimum = new JPanel();
        this.minimum.setLayout(new BoxLayout(this.minimum, 0));
        this.minimumLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Minimum")));
        this.minimumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Minimum")));
        this.minimum.add(this.minimumLabel);
        this.minimum.add(Box.createHorizontalStrut(12));
        this.m_minimumField = new DoubleTextField(graph.getLocale());
        this.minimumLabel.setLabelFor(this.m_minimumField);
        this.minimumLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Minimum ADA"));
        this.minimum.add(this.m_minimumField);
        this.minimum.add(Box.createHorizontalStrut(5));
        this.m_minimumBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 1")));
        this.m_minimumBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 1")));
        this.m_minimumBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 1 ADA"));
        this.m_minimumBox.setForeground(this.m_label.getForeground());
        this.minimum.add(this.m_minimumBox);
        this.maximum = new JPanel();
        this.maximum.setLayout(new BoxLayout(this.maximum, 0));
        this.maximumLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Maximum")));
        this.maximumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Maximum")));
        this.maximum.add(Box.createVerticalStrut(5));
        this.maximum.add(this.maximumLabel);
        this.maximum.add(Box.createHorizontalStrut(12));
        this.m_maximumField = new DoubleTextField(graph.getLocale());
        this.maximumLabel.setLabelFor(this.m_maximumField);
        this.maximumLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Maximum ADA"));
        this.maximum.add(this.m_maximumField);
        this.maximum.add(Box.createHorizontalStrut(5));
        this.m_maximumBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 2")));
        this.m_maximumBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 2")));
        this.m_maximumBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 2 ADA"));
        this.m_maximumBox.setForeground(this.m_label.getForeground());
        this.maximum.add(this.m_maximumBox);
        this.increment = new JPanel();
        this.increment.setLayout(new BoxLayout(this.increment, 0));
        this.incrementLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Increment")));
        this.incrementLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Increment")));
        this.increment.add(Box.createVerticalStrut(5));
        this.increment.add(this.incrementLabel);
        this.increment.add(Box.createHorizontalStrut(12));
        this.m_incrementField = new DoubleTextField(graph.getLocale());
        this.incrementLabel.setLabelFor(this.m_incrementField);
        this.incrementLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Increment ADA"));
        this.increment.add(this.m_incrementField);
        this.increment.add(Box.createHorizontalStrut(5));
        this.m_incrementBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 3")));
        this.m_incrementBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 3")));
        this.m_incrementBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 3 ADA"));
        this.m_incrementBox.setForeground(this.m_label.getForeground());
        this.increment.add(this.m_incrementBox);
        this.baseline = new JPanel();
        this.baseline.setLayout(new BoxLayout(this.baseline, 0));
        this.baselineLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Baseline value")));
        this.baselineLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Baseline value")));
        this.baseline.add(Box.createVerticalStrut(5));
        this.baseline.add(this.baselineLabel);
        this.baseline.add(Box.createHorizontalStrut(12));
        this.m_baselineField = new DoubleTextField(graph.getLocale());
        this.baselineLabel.setLabelFor(this.m_baselineField);
        this.baselineLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Baseline ADA"));
        this.baseline.add(this.m_baselineField);
        this.m_referenceLineButton = new JButton(StringUtils.stripMnemonic((String)this.rBundle.getString("ReferenceLines")));
        this.m_referenceLineButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("ReferenceLines")));
        this.m_referenceLineButton.setAlignmentX(0.0f);
        this.m_scaleFontButton = new FontButton();
        this.m_scaleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_scaleFontButton.setPaneLocale(graph.getLocale());
        this.initFontButton(this.m_scaleFontButton);
        this.m_scaleFontButton.setForeground(this.m_label.getForeground());
        this.m_buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.m_buttonPanel.setAlignmentX(0.0f);
        this.m_buttonPanel.add(this.m_referenceLineButton);
        this.m_buttonPanel.add(Box.createHorizontalStrut(10));
        this.m_buttonPanel.add(this.m_scaleFontButton);
        this.logarithmic = new JPanel();
        this.logarithmic.setLayout(new BoxLayout(this.logarithmic, 0));
        this.m_logarithmicBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Logarithmic scale")));
        this.m_logarithmicBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Logarithmic scale")));
        this.m_logarithmicBox.setForeground(this.m_label.getForeground());
        this.m_logChoice = new JComboBox<String>(new String[]{this.rBundle.getString("2"), this.rBundle.getString("NaturalLog"), this.rBundle.getString("10")});
        this.m_base = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Base")));
        this.m_base.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Base")));
        this.m_base.setLabelFor(this.m_logChoice);
        this.logarithmic.add(Box.createVerticalStrut(5));
        this.logarithmic.add(this.m_logarithmicBox);
        this.logarithmic.add(Box.createHorizontalStrut(24));
        this.logarithmic.add(this.m_base);
        this.logarithmic.add(Box.createHorizontalStrut(12));
        this.logarithmic.add(this.m_logChoice);
        this.minimum.setAlignmentX(0.0f);
        this.maximum.setAlignmentX(0.0f);
        this.increment.setAlignmentX(0.0f);
        this.baseline.setAlignmentX(0.0f);
        this.logarithmic.setAlignmentX(0.0f);
        this.m_mainPanel.add(this.minimum);
        this.m_mainPanel.add(this.maximum);
        this.m_mainPanel.add(this.increment);
        this.m_mainPanel.add(this.baseline);
        this.m_mainPanel.add(this.logarithmic);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.m_buttonPanel);
        this.m_mainPanel.add(Box.createGlue());
        this.m_componentID = n;
        this.m_minimumBox.addItemListener(this);
        this.m_maximumBox.addItemListener(this);
        this.m_incrementBox.addItemListener(this);
        this.m_logarithmicBox.addItemListener(this);
        this.m_logChoice.addItemListener(this);
        this._init();
        this.m_scaleFontButton.addPropertyChangeListener(this);
        this.m_referenceLineButton.addActionListener(this);
        this.m_minimumField.addCaretListener(this);
        this.m_maximumField.addCaretListener(this);
        this.m_incrementField.addCaretListener(this);
        this.m_baselineField.addCaretListener(this);
    }

    public ValueAxis(Graph graph, int n, int n2) {
        this(graph, n);
        this.m_errorTypes = n2;
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this._init();
    }

    public void setColorPalette(Color[][] colorArray) {
        super.setColorPalette(colorArray);
        this.m_scaleFontButton.setColorPalette(this.m_colorPalette);
    }

    public void setRepeatWarnings(boolean bl) {
        this.m_repeatWarnings = bl;
    }

    public boolean isRepeatWarnings() {
        return this.m_repeatWarnings;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.m_referenceLineButton) {
            ReferenceDialog referenceDialog = this.createReferenceDialog(this.rBundle.getString("Reference Lines"), true, this.m_referenceLine, this.m_bHelpEnabled);
            referenceDialog.show();
            this.m_referenceLine.resetFocus();
            referenceDialog.dispose();
            referenceDialog = null;
            this.m_bReferenceLineChanged = true;
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void _setLogChoiceIndex(double d) {
        if (d < Math.E) {
            this.m_logChoice.setSelectedIndex(0);
        } else if (d == Math.E) {
            this.m_logChoice.setSelectedIndex(1);
        } else if (d > Math.E) {
            this.m_logChoice.setSelectedIndex(2);
        }
        this.m_oldLogBase = this.m_currentLogBase = d;
    }

    private boolean isPercentGraph() {
        switch (this.m_graph.getGraphType()) {
            case 23: 
            case 30: 
            case 35: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    private boolean isPieGraph() {
        switch (this.m_graph.getGraphType()) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private boolean isBaselineGraph() {
        switch (this.m_graph.getGraphType()) {
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    private void _init() {
        this.baseline.setVisible(this.isBaselineGraph());
        this.m_minimumField.setEnabled(true);
        this.m_maximumField.setEnabled(true);
        this.m_incrementField.setEnabled(true);
        this.m_baselineField.setEnabled(true);
        this.m_minimumBox.setEnabled(true);
        this.m_maximumBox.setEnabled(true);
        this.m_logarithmicBox.setEnabled(true);
        this.m_logChoice.setEnabled(true);
        this.m_incrementBox.setEnabled(true);
        this.minimum.setVisible(true);
        this.maximum.setVisible(true);
        this.increment.setVisible(true);
        this.logarithmic.setVisible(true);
        this.m_optionsLabelPanel.setVisible(true);
        switch (this.m_componentID) {
            case 41: {
                this.setTitleText(this.rBundle.getString("X-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show X-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show X-Axis Title")));
                this.m_lineLabel.setText(this.rBundle.getString("X-Axis line options"));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("X-Title Font For FontButton"));
                this.m_fontButton.setRotationButtonMask(0);
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Axis Label")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Axis Label")));
                this.m_scaleFontButton.setDialogTitle(this.rBundle.getString("X-Axis Label For FontButton"));
                this.m_font = this.m_graph.getUIX1Title().getFont();
                this.m_oldAxisColor = this.m_graph.getUIX1Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getUIX1Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getUIX1Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_oldMinimum = this.m_graph.getUIX1Axis().getAxisMinValue();
                this.m_oldMaximum = this.m_graph.getUIX1Axis().getAxisMaxValue();
                this.m_oldIncrement = this.m_graph.getUIX1Axis().getMajorTickStep();
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getUIX1Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getUIX1Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getUIX1Title().getFont());
                if (this.m_graph.getUIX1Title().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getUIX1Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getUIX1Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getUIX1Title().getUIGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIX1Title().getTextRotation()));
                Color color = this.m_graph.getUIX1Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette(this.m_colorButton.getColorPalette(), color, this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_lineWidth.setLineWidth(this.m_graph.getUIX1Axis().getLineWidth());
                this.m_minimumBox.setSelected(this.m_graph.getUIX1Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getUIX1Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getUIX1Axis().isMajorTickStepAutomatic());
                this.m_incrChecked = this.m_incrementBox.isSelected();
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIX1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIX1Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                this.m_logarithmicBox.setSelected(this.m_graph.getUIX1Axis().isScaledLogarithmic());
                this.m_scaleFontButton.setComponentFont(this.m_graph.getUIDataX1TickLabel().getFont());
                this.m_scaleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIDataX1TickLabel().getTextRotation()));
                if (this.m_graph.getUIDataX1TickLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_scaleFontButton.setUnderlineStyle(true);
                } else {
                    this.m_scaleFontButton.setUnderlineStyle(false);
                }
                this.m_scaleFontButton.setComponentForeground(this.m_graph.getUIDataX1TickLabel().getUIGraphFont().getGraphFontColor());
                this._setLogChoiceIndex(this.m_graph.getUIX1Axis().getLogarithmicBase());
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                if (this.m_graph.getGraphType() == 65 || this.m_graph.getGraphType() == 66) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisTitlePanel.setVisible(false);
                    this.m_lineWidthPanel.setVisible(false);
                    break;
                }
                if (this.isPieGraph()) {
                    this.m_axisLinePanel.setVisible(false);
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    break;
                }
                this.m_axisTitlePanel.setVisible(true);
                this.m_lineWidthPanel.setVisible(true);
                this.m_axisLineSeparatorPanel.setVisible(true);
                this.m_axisLinePanel.setVisible(true);
                break;
            }
            case 46: {
                this.setTitleText(this.rBundle.getString("Y1-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show Y1-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show Y1-Axis Title")));
                this.m_lineLabel.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y1-Axis line options")));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y1-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y1-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("Y1-Title Font For FontButton"));
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y1-Axis Label Font")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y1-Axis Label Font")));
                this.m_scaleFontButton.setDialogTitle(this.rBundle.getString("Y1-Axis Label Font For FontButton"));
                this.m_font = this.m_graph.getUIY1Title().getFont();
                this.m_oldAxisColor = this.m_graph.getUIY1Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getUIY1Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getUIY1Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getUIY1Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getUIY1Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getUIY1Title().getFont());
                if (this.m_graph.getUIY1Title().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getUIY1Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getUIY1Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getUIY1Title().getUIGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIY1Title().getTextRotation()));
                this.m_lineWidth.setLineWidth(this.m_graph.getUIY1Axis().getLineWidth());
                Color color = this.m_graph.getUIY1Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette(this.m_colorButton.getColorPalette(), color, this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_baselineField.setNumber(new Double(this.m_graph.getUIY1Baseline().getValue()));
                this.m_minimumBox.setSelected(this.m_graph.getUIY1Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getUIY1Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getUIY1Axis().isMajorTickStepAutomatic());
                this.m_incrChecked = this.m_incrementBox.isSelected();
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY1Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxValue()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                if (this.m_graph.getGraphType() != 102) {
                    this.logarithmic.setVisible(true);
                    this.m_logarithmicBox.setSelected(this.m_graph.getUIY1Axis().isScaledLogarithmic());
                } else {
                    this.logarithmic.setVisible(false);
                }
                this.m_scaleFontButton.setComponentFont(this.m_graph.getUIDataY1TickLabel().getFont());
                if (this.m_graph.getUIDataY1TickLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_scaleFontButton.setUnderlineStyle(true);
                } else {
                    this.m_scaleFontButton.setUnderlineStyle(false);
                }
                this.m_scaleFontButton.setComponentForeground(this.m_graph.getUIDataY1TickLabel().getUIGraphFont().getGraphFontColor());
                this.m_scaleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIDataY1TickLabel().getTextRotation()));
                this._setLogChoiceIndex(this.m_graph.getUIY1Axis().getLogarithmicBase());
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.isPieGraph()) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisLinePanel.setVisible(false);
                    break;
                }
                this.m_axisLinePanel.setVisible(true);
                break;
            }
            case 51: {
                this.setTitleText(this.rBundle.getString("Y2-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show Y2-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show Y2-Axis Title")));
                this.m_lineLabel.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y2-Axis line options")));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y2-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y2-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("Y2-Title Font For FontButton"));
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y2-Axis Label Font")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y2-Axis Label Font")));
                this.m_scaleFontButton.setDialogTitle(this.rBundle.getString("Y2-Axis Label Font For FontButton"));
                this.m_font = this.m_graph.getUIY2Title().getFont();
                this.m_oldAxisColor = this.m_graph.getUIY2Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getUIY2Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getUIY2Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getUIY2Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getUIY2Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getUIY2Title().getFont());
                if (this.m_graph.getUIY2Title().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getUIY2Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getUIY2Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getUIY2Title().getUIGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIY2Title().getTextRotation()));
                this.m_lineWidth.setLineWidth(this.m_graph.getUIY2Axis().getLineWidth());
                Color color = this.m_graph.getUIY2Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette(this.m_colorButton.getColorPalette(), color, this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_baselineField.setNumber(new Double(this.m_graph.getUIY2Baseline().getValue()));
                this.m_minimumBox.setSelected(this.m_graph.getUIY2Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getUIY2Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getUIY2Axis().isMajorTickStepAutomatic());
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY2Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY2Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxValue()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                this.m_incrChecked = this.m_incrementBox.isSelected();
                this._setLogChoiceIndex(this.m_graph.getUIY2Axis().getLogarithmicBase());
                if (this.m_graph.getGraphType() != 102) {
                    this.logarithmic.setVisible(true);
                    this.m_logarithmicBox.setSelected(this.m_graph.getUIY2Axis().isScaledLogarithmic());
                } else {
                    this.logarithmic.setVisible(false);
                }
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_scaleFontButton.setComponentFont(this.m_graph.getUIDataY2TickLabel().getFont());
                if (this.m_graph.getUIDataY2TickLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_scaleFontButton.setUnderlineStyle(true);
                } else {
                    this.m_scaleFontButton.setUnderlineStyle(false);
                }
                this.m_scaleFontButton.setComponentForeground(this.m_graph.getUIDataY2TickLabel().getUIGraphFont().getGraphFontColor());
                this.m_scaleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIDataY2TickLabel().getTextRotation()));
                if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.isPieGraph()) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisLinePanel.setVisible(false);
                    break;
                }
                this.m_axisLinePanel.setVisible(true);
            }
        }
        this.m_lineWidth.setCellColor(this.m_colorButton.getSelectedColor());
        this.m_axisTitle.setForeground(this.m_fontButton.getComponentForeground());
        Font font = this.m_fontButton.getComponentFont();
        this.m_axisTitle.setFont(new Font(font.getName(), font.getStyle(), this.m_axisTitle.getFont().getSize()));
        if (this.m_logarithmicBox.isSelected()) {
            this.m_incrementBox.setSelected(true);
            this.m_incrementBox.setEnabled(false);
        }
        if (this.isPercentGraph()) {
            this.minimum.setVisible(false);
            this.maximum.setVisible(false);
            this.increment.setVisible(false);
            this.logarithmic.setVisible(false);
            this.m_optionsLabelPanel.setVisible(false);
            this.m_optionSeparatorPanel.setVisible(false);
        }
        if (this.m_graph.getGraphType() == 102 || this.isPieGraph()) {
            this.minimum.setVisible(false);
            this.maximum.setVisible(false);
            if (this.m_graph.getGraphType() != 102) {
                this.logarithmic.setVisible(false);
            }
        }
        this.m_referenceLine = new ReferenceLine(this.m_graph, this.m_componentID);
        this.m_bLineWidthChanged = false;
        this.m_bLineColorChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bScaleLogarithmicChanged = false;
        this.m_bLogarithmicBaseChanged = false;
        if (this.m_graph.getGraphType() >= 55 && this.m_graph.getGraphType() <= 60 || this.m_graph.getGraphType() >= 93 && this.m_graph.getGraphType() <= 94 || this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.m_graph.getGraphType() >= 70 && this.m_graph.getGraphType() <= 84 || this.m_graph.getGraphType() == 88) {
            this.m_referenceLineButton.setVisible(false);
        } else {
            this.m_referenceLineButton.setVisible(true);
        }
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_maximumField.setCaretPosition(0);
        this.m_maximumField.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_maximumField.getFont()).stringWidth(ValueAxis.this.m_maximumField.getText()) > ValueAxis.this.m_maximumField.getSize().width) {
                    ValueAxis.this.m_maximumField.setToolTipText(ValueAxis.this.m_maximumField.getText());
                } else {
                    ValueAxis.this.m_maximumField.setToolTipText(null);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ValueAxis.this.m_maximumField.setToolTipText(null);
            }
        });
        this.m_minimumField.setCaretPosition(0);
        this.m_minimumField.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_minimumField.getFont()).stringWidth(ValueAxis.this.m_minimumField.getText()) > ValueAxis.this.m_minimumField.getSize().width) {
                    ValueAxis.this.m_minimumField.setToolTipText(ValueAxis.this.m_minimumField.getText());
                } else {
                    ValueAxis.this.m_minimumField.setToolTipText(null);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ValueAxis.this.m_minimumField.setToolTipText(null);
            }
        });
        this.m_incrementField.setCaretPosition(0);
        this.m_incrementField.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_incrementField.getFont()).stringWidth(ValueAxis.this.m_incrementField.getText()) > ValueAxis.this.m_incrementField.getSize().width) {
                    ValueAxis.this.m_incrementField.setToolTipText(ValueAxis.this.m_incrementField.getText());
                } else {
                    ValueAxis.this.m_incrementField.setToolTipText(null);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ValueAxis.this.m_incrementField.setToolTipText(null);
            }
        });
        this.m_baselineField.setCaretPosition(0);
        this.m_baselineField.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_baselineField.getFont()).stringWidth(ValueAxis.this.m_baselineField.getText()) > ValueAxis.this.m_baselineField.getSize().width) {
                    ValueAxis.this.m_baselineField.setToolTipText(ValueAxis.this.m_baselineField.getText());
                } else {
                    ValueAxis.this.m_baselineField.setToolTipText(null);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ValueAxis.this.m_baselineField.setToolTipText(null);
            }
        });
    }

    private void calculatePanelSizes() {
        int n = Math.max(this.m_lineLabel.getPreferredSize().width, this.axisLinePanel.getPreferredSize().width);
        int n2 = this.m_lineLabel.getPreferredSize().height + 5 + this.axisLinePanel.getPreferredSize().height;
        this.m_axisLinePanel.setPreferredSize(new Dimension(n, n2));
        this.m_axisLinePanel.setMinimumSize(this.m_axisLinePanel.getPreferredSize());
        this.m_axisLinePanel.setMaximumSize(this.m_axisLinePanel.getPreferredSize());
        n = this.m_optionsLabel.getPreferredSize().width;
        n2 = this.m_optionsLabel.getPreferredSize().height + 5;
        this.m_optionsLabelPanel.setPreferredSize(new Dimension(n, n2));
        this.m_optionsLabelPanel.setMinimumSize(this.m_optionsLabelPanel.getPreferredSize());
        this.m_optionsLabelPanel.setMaximumSize(this.m_optionsLabelPanel.getPreferredSize());
        int n3 = this.getToolkit().getFontMetrics(this.minimumLabel.getFont()).stringWidth(this.minimumLabel.getText());
        int n4 = this.getToolkit().getFontMetrics(this.maximumLabel.getFont()).stringWidth(this.maximumLabel.getText());
        int n5 = this.getToolkit().getFontMetrics(this.incrementLabel.getFont()).stringWidth(this.incrementLabel.getText());
        int n6 = this.getToolkit().getFontMetrics(this.baselineLabel.getFont()).stringWidth(this.baselineLabel.getText());
        int n7 = this.isBaselineGraph() ? Math.max(Math.max(n3, n4), Math.max(n5, n6)) : Math.max(n3, Math.max(n4, n5));
        this.minimumLabel.setPreferredSize(new Dimension(n7, this.minimumLabel.getPreferredSize().height));
        this.minimumLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.minimumLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.m_minimumField.setPreferredSize(new Dimension(110, 20));
        this.m_minimumField.setMinimumSize(this.m_minimumField.getPreferredSize());
        this.m_minimumField.setMaximumSize(this.m_minimumField.getPreferredSize());
        n = this.minimumLabel.getPreferredSize().width + 12 + this.m_minimumField.getPreferredSize().width + 5 + this.m_minimumBox.getPreferredSize().width;
        n2 = Math.max(this.minimumLabel.getPreferredSize().height, Math.max(this.m_minimumField.getPreferredSize().height, this.m_minimumBox.getPreferredSize().height));
        this.minimum.setPreferredSize(new Dimension(n, n2));
        this.minimum.setMinimumSize(this.minimum.getPreferredSize());
        this.minimum.setMaximumSize(this.minimum.getPreferredSize());
        this.m_maximumField.setPreferredSize(new Dimension(110, 20));
        this.m_maximumField.setMinimumSize(this.m_maximumField.getPreferredSize());
        this.m_maximumField.setMaximumSize(this.m_maximumField.getPreferredSize());
        n = this.maximumLabel.getPreferredSize().width + 12 + this.m_maximumField.getPreferredSize().width + 5 + this.m_maximumBox.getPreferredSize().width;
        n2 = Math.max(this.maximumLabel.getPreferredSize().height, Math.max(this.m_maximumField.getPreferredSize().height, this.m_maximumBox.getPreferredSize().height)) + 5;
        this.maximum.setPreferredSize(new Dimension(n, n2));
        this.maximum.setMinimumSize(this.maximum.getPreferredSize());
        this.maximum.setMaximumSize(this.maximum.getPreferredSize());
        this.m_incrementField.setPreferredSize(new Dimension(110, 20));
        this.m_incrementField.setMinimumSize(this.m_incrementField.getPreferredSize());
        this.m_incrementField.setMaximumSize(this.m_incrementField.getPreferredSize());
        n = this.incrementLabel.getPreferredSize().width + 12 + this.m_incrementField.getPreferredSize().width + 5 + this.m_incrementBox.getPreferredSize().width;
        n2 = Math.max(this.incrementLabel.getPreferredSize().height, Math.max(this.m_incrementField.getPreferredSize().height, this.m_incrementBox.getPreferredSize().height)) + 5;
        this.increment.setPreferredSize(new Dimension(n, n2));
        this.increment.setMinimumSize(this.increment.getPreferredSize());
        this.increment.setMaximumSize(this.increment.getPreferredSize());
        this.m_baselineField.setPreferredSize(new Dimension(110, 20));
        this.m_baselineField.setMinimumSize(this.m_baselineField.getPreferredSize());
        this.m_baselineField.setMaximumSize(this.m_baselineField.getPreferredSize());
        n = this.baselineLabel.getPreferredSize().width + 12 + this.m_baselineField.getPreferredSize().width;
        n2 = Math.max(this.baselineLabel.getPreferredSize().height, this.m_baselineField.getPreferredSize().height) + 5;
        this.baseline.setPreferredSize(new Dimension(n, n2));
        this.baseline.setMinimumSize(this.baseline.getPreferredSize());
        this.baseline.setMaximumSize(this.baseline.getPreferredSize());
        this.m_logChoice.setPreferredSize(new Dimension(50, 25));
        this.m_logChoice.setMinimumSize(this.m_logChoice.getPreferredSize());
        this.m_logChoice.setMaximumSize(this.m_logChoice.getPreferredSize());
        n = this.m_logarithmicBox.getPreferredSize().width + 24 + this.m_base.getPreferredSize().width + 12 + this.m_logChoice.getPreferredSize().width;
        n2 = Math.max(this.m_logarithmicBox.getPreferredSize().height, Math.max(this.m_base.getPreferredSize().height, this.m_logChoice.getPreferredSize().height)) + 5;
        this.logarithmic.setPreferredSize(new Dimension(n, n2));
        this.logarithmic.setMinimumSize(this.logarithmic.getPreferredSize());
        this.logarithmic.setMaximumSize(this.logarithmic.getPreferredSize());
    }

    private void calculatePreferredSize() {
        int n = 0;
        int n2 = this.m_axisTitlePanel.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < (n2 = this.m_axisLinePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (!this.isPercentGraph()) {
            n2 = this.m_optionsLabelPanel.getPreferredSize().width;
            if (n < n2) {
                n = n2;
            }
            if (n < (n2 = this.minimum.getPreferredSize().width)) {
                n = n2;
            }
            if (n < (n2 = this.maximum.getPreferredSize().width)) {
                n = n2;
            }
            if (n < (n2 = this.increment.getPreferredSize().width)) {
                n = n2;
            }
        }
        if (this.isBaselineGraph() && n < (n2 = this.baseline.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.logarithmic.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_buttonPanel.getPreferredSize().width)) {
            n = n2;
        }
        n2 = n + 10 + 10;
        int n3 = 10 + this.m_label.getPreferredSize().height + 15 + this.m_axisTitlePanel.getPreferredSize().height + 15 + this.m_axisLinePanel.getPreferredSize().height + 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height + this.increment.getPreferredSize().height + this.baseline.getPreferredSize().height + this.logarithmic.getPreferredSize().height + 15 + this.m_buttonPanel.getPreferredSize().height + 10;
        if (!this.isBaselineGraph()) {
            n3 -= this.baseline.getPreferredSize().height;
        }
        switch (this.m_componentID) {
            case 41: {
                if (this.m_graph.getGraphType() == 65 || this.m_graph.getGraphType() == 66) {
                    n3 -= this.m_axisTitlePanel.getPreferredSize().height + 15;
                    break;
                }
                if (!this.isPieGraph()) break;
                n3 -= 15 + this.m_axisLinePanel.getPreferredSize().height;
                break;
            }
            case 46: 
            case 51: {
                if (this.m_graph.getGraphType() == 102) {
                    n3 -= this.logarithmic.getPreferredSize().height;
                }
                if ((this.m_graph.getGraphType() < 0 || this.m_graph.getGraphType() > 14) && !this.isPieGraph()) break;
                n3 -= 15 + this.m_axisLinePanel.getPreferredSize().height;
            }
        }
        if (this.isPercentGraph()) {
            n3 -= 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height + this.increment.getPreferredSize().height + this.logarithmic.getPreferredSize().height;
        }
        if (this.m_graph.getGraphType() == 102 || this.isPieGraph()) {
            n3 -= this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height;
            if (this.m_graph.getGraphType() != 102) {
                n3 -= this.logarithmic.getPreferredSize().height;
            }
        }
        this.prefSize = new Dimension(n2, n3);
    }

    public void apply() {
        this.applyAfterCheck();
    }

    public boolean applyAfterCheck() {
        if (!this.checkForBadInput()) {
            return false;
        }
        if (this.m_bReferenceLineChanged) {
            this.m_referenceLine.apply();
        }
        switch (this.m_componentID) {
            case 41: {
                Double d;
                if (this.m_graph.getGraphType() != 65 && this.m_graph.getGraphType() != 66) {
                    int n;
                    if (this.m_bTitleTextChanged) {
                        this.m_graph.getUIX1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                    }
                    if (this.m_bTitleVisibleChanged) {
                        this.m_graph.getUIX1Title().setVisible(this.m_showAxis.isSelected());
                    }
                    if (this.m_bTitleFontNameChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                    }
                    if (this.m_bTitleFontSizeChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                    }
                    if (this.m_bTitleFontBoldChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                    }
                    if (this.m_bTitleFontItalicChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                    }
                    if (this.m_bTitleFontUnderlineChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                    }
                    if (this.m_bTitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                        this.m_graph.getUIX1Title().setTextRotation(n);
                    }
                    if (this.m_bTitleAlignmentChanged) {
                        this.m_graph.getUIX1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                    }
                    if (this.m_bTitleFontColorChanged) {
                        this.m_graph.getUIX1Title().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                    }
                    if (this.m_bLineWidthChanged) {
                        this.m_graph.getUIX1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                    }
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getUIX1Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                this.m_graph.getUIX1Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                boolean bl = false;
                int n = 0;
                if (this.m_graph.getUIX1Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    bl = true;
                    n |= 1;
                }
                if (this.m_graph.getUIX1Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    bl = true;
                    n |= 2;
                }
                Double d2 = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && d2 != null) {
                    bl = true;
                    n |= 4;
                }
                Double d3 = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && d3 != null && this.m_graph.getUIX1Axis().getAxisMaxValue() != d3.doubleValue()) {
                    bl = true;
                    n |= 8;
                }
                if (bl) {
                    this.m_graph.beginAxisChanges();
                    if ((n & 1) != 0) {
                        this.m_graph.getUIX1Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((n & 2) != 0) {
                        this.m_graph.getUIX1Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((n & 4) != 0) {
                        this.m_graph.getUIX1Axis().setAxisMinValue(d2);
                    }
                    if ((n & 8) != 0) {
                        this.m_graph.getUIX1Axis().setAxisMaxValue(d3);
                    }
                    this.m_graph.endAxisChanges();
                }
                if (!this.m_incrementBox.isSelected() && (d = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getUIX1Axis().setMajorTickStep(d);
                }
                if (this.m_bScaleLogarithmicChanged) {
                    this.m_graph.getUIX1Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
                }
                if (this.m_bLabelFontNameChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontTypeface(this.m_scaleFontButton.getComponentFont().getName());
                }
                if (this.m_bLabelFontSizeChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontSize(this.m_scaleFontButton.getComponentFont().getSize());
                }
                if (this.m_bLabelFontBoldChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setFontBold(this.m_scaleFontButton.getComponentFont().isBold());
                }
                if (this.m_bLabelFontItalicChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setFontItalic(this.m_scaleFontButton.getComponentFont().isItalic());
                }
                if (this.m_bLabelFontUnderlineChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setUnderline(this.m_scaleFontButton.isUnderlineStyle());
                }
                if (this.m_bLabelFontColorChanged) {
                    this.m_graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontColor(this.m_scaleFontButton.getComponentForeground());
                }
                if (this.m_bLabelRotationChanged) {
                    this.m_graph.getUIDataX1TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_scaleFontButton.getTextRotation()));
                }
                if (!this.m_bLogarithmicBaseChanged) break;
                this.m_graph.getUIX1Axis().setLogarithmicBase(this.m_currentLogBase);
                break;
            }
            case 46: {
                Double d;
                int n;
                if (this.m_bTitleTextChanged) {
                    this.m_graph.getUIY1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                }
                if (this.m_bTitleVisibleChanged) {
                    this.m_graph.getUIY1Title().setVisible(this.m_showAxis.isSelected());
                }
                if (this.m_bTitleFontNameChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                }
                if (this.m_bTitleFontSizeChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bTitleFontBoldChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bTitleFontItalicChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bTitleFontUnderlineChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bTitleAlignmentChanged) {
                    this.m_graph.getUIY1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                }
                if (this.m_bTitleFontColorChanged) {
                    this.m_graph.getUIY1Title().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
                if (this.m_bTitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                    this.m_graph.getUIY1Title().setTextRotation(n);
                }
                if (this.m_bLineWidthChanged) {
                    this.m_graph.getUIY1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getUIY1Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                if (this.m_bLabelFontNameChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontTypeface(this.m_scaleFontButton.getComponentFont().getName());
                }
                if (this.m_bLabelFontSizeChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontSize(this.m_scaleFontButton.getComponentFont().getSize());
                }
                if (this.m_bLabelFontBoldChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setFontBold(this.m_scaleFontButton.getComponentFont().isBold());
                }
                if (this.m_bLabelFontItalicChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setFontItalic(this.m_scaleFontButton.getComponentFont().isItalic());
                }
                if (this.m_bLabelFontUnderlineChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setUnderline(this.m_scaleFontButton.isUnderlineStyle());
                }
                if (this.m_bLabelFontColorChanged) {
                    this.m_graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontColor(this.m_scaleFontButton.getComponentForeground());
                }
                if (this.m_bLabelRotationChanged) {
                    this.m_graph.getUIDataY1TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_scaleFontButton.getTextRotation()));
                }
                if (this.isPercentGraph()) {
                    return true;
                }
                this.m_graph.getUIY1Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                boolean bl = false;
                int n2 = 0;
                if (this.m_graph.getUIY1Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    bl = true;
                    n2 |= 1;
                }
                if (this.m_graph.getUIY1Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    bl = true;
                    n2 |= 2;
                }
                Double d4 = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && d4 != null) {
                    bl = true;
                    n2 |= 4;
                }
                Double d5 = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && d5 != null && this.m_graph.getUIY1Axis().getAxisMaxValue() != d5.doubleValue()) {
                    bl = true;
                    n2 |= 8;
                }
                if (bl) {
                    this.m_graph.beginAxisChanges();
                    if ((n2 & 1) != 0) {
                        this.m_graph.getUIY1Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((n2 & 2) != 0) {
                        this.m_graph.getUIY1Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((n2 & 4) != 0) {
                        this.m_graph.getUIY1Axis().setAxisMinValue(d4);
                    }
                    if ((n2 & 8) != 0) {
                        this.m_graph.getUIY1Axis().setAxisMaxValue(d5);
                    }
                    this.m_graph.endAxisChanges();
                }
                if (!this.m_incrementBox.isSelected() && (d = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getUIY1Axis().setMajorTickStep(d);
                }
                if ((d = this.m_baselineField.getNumber()) != null && this.isBaselineGraph()) {
                    this.m_graph.getUIY1Baseline().setValue(d);
                }
                if (this.m_bScaleLogarithmicChanged) {
                    this.m_graph.getUIY1Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
                }
                if (!this.m_bLogarithmicBaseChanged) break;
                this.m_graph.getUIY1Axis().setLogarithmicBase(this.m_currentLogBase);
                break;
            }
            case 51: {
                Double d;
                int n;
                if (this.m_bTitleTextChanged) {
                    this.m_graph.getUIY2Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                }
                if (this.m_bTitleVisibleChanged) {
                    this.m_graph.getUIY2Title().setVisible(this.m_showAxis.isSelected());
                }
                if (this.m_bTitleFontNameChanged) {
                    this.m_graph.getUIY2Title().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                }
                if (this.m_bTitleFontSizeChanged) {
                    this.m_graph.getUIY2Title().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bTitleFontBoldChanged) {
                    this.m_graph.getUIY2Title().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bTitleFontItalicChanged) {
                    this.m_graph.getUIY2Title().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bTitleFontUnderlineChanged) {
                    this.m_graph.getUIX1Title().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bTitleAlignmentChanged) {
                    this.m_graph.getUIY2Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                }
                if (this.m_bTitleFontColorChanged) {
                    this.m_graph.getUIY2Title().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
                if (this.m_bTitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                    this.m_graph.getUIY2Title().setTextRotation(n);
                }
                if (this.m_bLineWidthChanged) {
                    this.m_graph.getUIY2Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getUIY2Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                if (this.m_bLabelFontNameChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontTypeface(this.m_scaleFontButton.getComponentFont().getName());
                }
                if (this.m_bLabelFontSizeChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontSize(this.m_scaleFontButton.getComponentFont().getSize());
                }
                if (this.m_bLabelFontBoldChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setFontBold(this.m_scaleFontButton.getComponentFont().isBold());
                }
                if (this.m_bLabelFontItalicChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setFontItalic(this.m_scaleFontButton.getComponentFont().isItalic());
                }
                if (this.m_bLabelFontUnderlineChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setUnderline(this.m_scaleFontButton.isUnderlineStyle());
                }
                if (this.m_bLabelFontColorChanged) {
                    this.m_graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontColor(this.m_scaleFontButton.getComponentForeground());
                }
                if (this.m_bLabelRotationChanged) {
                    this.m_graph.getUIDataY2TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_scaleFontButton.getTextRotation()));
                }
                this.m_graph.getUIY2Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                if (!this.m_incrementBox.isSelected() && (d = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getUIY2Axis().setMajorTickStep(d);
                }
                if ((d = this.m_baselineField.getNumber()) != null && this.isBaselineGraph()) {
                    this.m_graph.getUIY2Baseline().setValue(d);
                }
                if (this.m_graph.getGraphType() == 102) {
                    return true;
                }
                boolean bl = false;
                int n3 = 0;
                if (this.m_graph.getUIY2Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    bl = true;
                    n3 |= 1;
                }
                if (this.m_graph.getUIY2Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    bl = true;
                    n3 |= 2;
                }
                Double d6 = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && d6 != null) {
                    bl = true;
                    n3 |= 4;
                }
                Double d7 = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && d7 != null && this.m_graph.getUIY2Axis().getAxisMaxValue() != d7.doubleValue()) {
                    bl = true;
                    n3 |= 8;
                }
                if (bl) {
                    this.m_graph.beginAxisChanges();
                    if ((n3 & 1) != 0) {
                        this.m_graph.getUIY2Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((n3 & 2) != 0) {
                        this.m_graph.getUIY2Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((n3 & 4) != 0) {
                        this.m_graph.getUIY2Axis().setAxisMinValue(d6);
                    }
                    if ((n3 & 8) != 0) {
                        this.m_graph.getUIY2Axis().setAxisMaxValue(d7);
                    }
                    this.m_graph.endAxisChanges();
                }
                if (this.m_bLogarithmicBaseChanged) {
                    this.m_graph.getUIY2Axis().setLogarithmicBase(this.m_currentLogBase);
                }
                if (!this.m_bScaleLogarithmicChanged) break;
                this.m_graph.getUIY2Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
            }
        }
        return true;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        super.caretUpdate(caretEvent);
        if (caretEvent.getSource() == this.m_minimumField) {
            this.m_minimumField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_minimumField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d != null) {
                double d2 = d;
                this.firePropertyChange(PROPERTY_AXIS_MIN_VALUE, this.m_oldMinimum, d2);
                this.m_oldMinimum = d2;
            }
        } else if (caretEvent.getSource() == this.m_maximumField) {
            this.m_maximumField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_maximumField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d != null) {
                double d3 = d;
                this.firePropertyChange(PROPERTY_AXIS_MAX_VALUE, this.m_oldMaximum, d3);
                this.m_oldMaximum = d3;
            }
        } else if (caretEvent.getSource() == this.m_incrementField) {
            this.m_incrementField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_incrementField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d != null) {
                double d4 = d;
                this.firePropertyChange(PROPERTY_AXIS_MAJOR_TICK_STEP, this.m_oldIncrement, d4);
                this.m_oldIncrement = d4;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.m_minimumBox) {
                this.m_minimumField.setEnabled(false);
                this.m_minimumField.setEditable(false);
                this.m_minimumField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 46: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinAutoValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MIN, false, true);
            } else if (itemEvent.getSource() == this.m_maximumBox) {
                this.m_maximumField.setEnabled(false);
                this.m_maximumField.setEditable(false);
                this.m_maximumField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 46: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxAutoValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MAX, false, true);
            } else if (itemEvent.getSource() == this.m_incrementBox) {
                this.m_incrementField.setEnabled(false);
                this.m_incrementField.setEditable(false);
                this.m_incrementField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        double d = this.m_graph.getUIX1Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(d));
                        break;
                    }
                    case 46: {
                        double d = this.m_graph.getUIY1Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(d));
                        break;
                    }
                    case 51: {
                        double d = this.m_graph.getUIY2Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(d));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_TICK_STEP, false, true);
            } else if (itemEvent.getSource() == this.m_logarithmicBox) {
                this.m_incrChecked = this.m_incrementBox.isSelected();
                this.m_incrementBox.setSelected(true);
                this.m_incrementBox.setEnabled(false);
                this.firePropertyChange(PROPERTY_AXIS_LOG_SCALE, false, true);
                this.m_logChoice.setEnabled(true);
                this.m_base.setEnabled(true);
                this.m_bScaleLogarithmicChanged = true;
            } else if (itemEvent.getSource() == this.m_logChoice) {
                int n = this.m_logChoice.getSelectedIndex();
                double d = 10.0;
                switch (n) {
                    case 0: {
                        d = 2.0;
                        break;
                    }
                    case 1: {
                        d = Math.E;
                        break;
                    }
                    case 2: {
                        d = 10.0;
                    }
                }
                this.m_currentLogBase = d;
                this.firePropertyChange(PROPERTY_AXIS_LOG_BASE, this.m_oldLogBase, this.m_currentLogBase);
                this.m_oldLogBase = this.m_currentLogBase;
                this.m_bLogarithmicBaseChanged = true;
            }
        } else if (itemEvent.getStateChange() == 2) {
            if (itemEvent.getSource() == this.m_minimumBox) {
                this.m_minimumField.setEnabled(true);
                this.m_minimumField.setEditable(true);
                this.m_minimumField.setBackground(Color.white);
                switch (this.m_componentID) {
                    case 41: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinValue()));
                        break;
                    }
                    case 46: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MIN, true, false);
            } else if (itemEvent.getSource() == this.m_maximumBox) {
                this.m_maximumField.setEnabled(true);
                this.m_maximumField.setEditable(true);
                this.m_maximumField.setBackground(Color.white);
                switch (this.m_componentID) {
                    case 41: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxValue()));
                        break;
                    }
                    case 46: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MAX, true, false);
            } else if (itemEvent.getSource() == this.m_incrementBox) {
                this.m_incrementField.setEnabled(true);
                this.m_incrementField.setEditable(true);
                this.m_incrementField.setBackground(Color.white);
                this.firePropertyChange(PROPERTY_AXIS_AUTO_TICK_STEP, true, false);
            } else if (itemEvent.getSource() == this.m_logarithmicBox) {
                this.m_incrementBox.setSelected(this.m_incrChecked);
                this.m_incrementBox.setEnabled(true);
                this.firePropertyChange(PROPERTY_AXIS_LOG_SCALE, true, false);
                this.m_logChoice.setEnabled(false);
                this.m_base.setEnabled(false);
                this.m_bScaleLogarithmicChanged = true;
            }
        }
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_scaleFontButton.setHelpProvider(helpProvider);
        this.m_fontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setMaxMultiplier(int n) {
        this.m_multiplier = n;
    }

    public int getMaxMultiplier() {
        return this.m_multiplier;
    }

    public void cleanUp() {
        this.m_minimumBox.removeItemListener(this);
        this.m_maximumBox.removeItemListener(this);
        this.m_incrementBox.removeItemListener(this);
        this.m_logarithmicBox.removeItemListener(this);
        this.m_logChoice.removeItemListener(this);
        this.m_scaleFontButton.removePropertyChangeListener(this);
        this.m_minimumField.removeCaretListener(this);
        this.m_maximumField.removeCaretListener(this);
        this.m_incrementField.removeCaretListener(this);
        this.m_baselineField.removeCaretListener(this);
        this.minimum.remove(this.m_minimumField);
        this.minimumLabel.setLabelFor(null);
        this.m_minimumField.cleanUp();
        this.m_minimumField = null;
        this.maximum.remove(this.m_maximumField);
        this.maximumLabel.setLabelFor(null);
        this.m_maximumField.cleanUp();
        this.m_maximumField = null;
        this.increment.remove(this.m_incrementField);
        this.incrementLabel.setLabelFor(null);
        this.m_incrementField.cleanUp();
        this.m_incrementField = null;
        this.baseline.remove(this.m_baselineField);
        this.baselineLabel.setLabelFor(null);
        this.m_baselineField.cleanUp();
        this.m_baselineField = null;
        super.cleanUp();
    }

    protected boolean checkForBadInput() {
        Object object;
        Object object2;
        Container container;
        Object object3;
        Object[] objectArray;
        this._initializeCurrentValues();
        boolean bl = this.m_logarithmicBox.isSelected();
        boolean bl2 = this.m_minimumBox.isSelected();
        boolean bl3 = this.m_maximumBox.isSelected();
        boolean bl4 = this.m_incrementBox.isSelected();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (this.m_errorTypes == 65535) {
            bl6 = true;
            bl7 = true;
        } else if (this.m_errorTypes == 1) {
            bl7 = true;
        } else if (this.m_errorTypes == 2) {
            bl6 = true;
        } else if (this.m_errorTypes == 4) {
            bl8 = true;
        }
        if (this.m_baselineField.getNumber() == null && this.isBaselineGraph()) {
            if (bl7) {
                ImageIcon imageIcon = new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif"));
                String string = this.rBundle.getString("Baseline value can't be empty");
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Baseline value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_minimumField.getNumber() == null && !bl2) {
            if (bl7) {
                ImageIcon imageIcon = new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif"));
                String string = this.rBundle.getString("Min value can't be empty");
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("min value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_maximumField.getNumber() == null && !bl3) {
            if (bl7) {
                ImageIcon imageIcon = new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif"));
                String string = this.rBundle.getString("Max value can't be empty");
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Max value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_incrementField.getNumber() == null && !bl4) {
            if (bl7) {
                ImageIcon imageIcon = new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif"));
                String string = this.rBundle.getString("Increment value can't be empty");
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Increment value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        double d = 0.0;
        d = !bl2 ? this.m_minimumField.getNumber() : this.m_currentMinValue;
        double d2 = 0.0;
        d2 = !bl3 ? this.m_maximumField.getNumber() : this.m_currentMaxValue;
        double d3 = 0.0;
        d3 = !bl4 ? this.m_incrementField.getNumber() : this.m_currentIncrValue;
        if (d2 <= d) {
            if (!bl2 || !bl3) {
                ImageIcon imageIcon = new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif"));
                if (!bl3) {
                    if (bl7 || bl8) {
                        String string = this.rBundle.getString("Max must be greater than min");
                        JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                        jOptionPane.getAccessibleContext().setAccessibleName(string);
                        JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                        jDialog.show();
                        this.m_maximumField.selectAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ValueAxis.this.m_maximumField.requestFocus();
                            }
                        });
                        if (!bl2) {
                            this.m_minimumField.selectAll();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ValueAxis.this.m_minimumField.requestFocus();
                                }
                            });
                        }
                        return false;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("Maximum value must be greater than minimum value.", this.getClass().getName(), "checkForBadInput");
                    }
                } else if (!bl2) {
                    if (bl7 || bl8) {
                        String string = this.rBundle.getString("Min must be less than max");
                        JOptionPane jOptionPane = new JOptionPane(string, 0, -1, imageIcon);
                        jOptionPane.getAccessibleContext().setAccessibleName(string);
                        JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                        jDialog.show();
                        this.m_minimumField.selectAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ValueAxis.this.m_minimumField.requestFocus();
                            }
                        });
                        return false;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("Minimum value must be less than maximum value.", this.getClass().getName(), "checkForBadInput");
                    }
                }
            } else {
                bl5 = true;
            }
        }
        if (bl5) {
            return true;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        DataEndPoints dataEndPoints = null;
        if (bl7 || bl6) {
            switch (this.m_componentID) {
                case 41: {
                    dataEndPoints = this.m_graph.getUIX1Axis().getDataEndPoints();
                    break;
                }
                case 46: {
                    dataEndPoints = this.m_graph.getUIY1Axis().getDataEndPoints();
                    break;
                }
                case 51: {
                    dataEndPoints = this.m_graph.getUIY2Axis().getDataEndPoints();
                }
            }
            if (dataEndPoints != null) {
                d4 = dataEndPoints.minimum;
                d5 = dataEndPoints.maximum;
            }
        }
        if (!bl2) {
            if (bl7 && dataEndPoints != null && d >= d5) {
                Object[] objectArray2 = new String[]{String.valueOf(new Double(d).longValue()), String.valueOf(new Double(d5).longValue())};
                String string = MessageFormat.format(this.rBundle.getString("Min greater than maxDataValue"), objectArray2);
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
                this.m_minimumField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValueAxis.this.m_minimumField.requestFocus();
                    }
                });
                return false;
            }
            if (bl6 && dataEndPoints != null && d > d4 && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMinValue != this.m_minimumField.getNumber())) {
                objectArray = new String[]{String.valueOf(new Double(d).longValue()), String.valueOf(new Double(d4).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Min greater than minDataValue"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (bl6 && dataEndPoints != null && this.isBaselineGraph() && this.m_baselineField.getNumber() != 0.0 && this.m_baselineField.getNumber() < d) {
                objectArray = new String[]{String.valueOf(new Double(d).longValue()), String.valueOf(new Double(d4).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Base line less than min"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (!bl && bl6 && dataEndPoints != null && d - d4 < (double)this.m_multiplier * (d4 - d5) && d4 != d5 && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMinValue != this.m_minimumField.getNumber())) {
                objectArray = new String[]{String.valueOf(new Double(d).longValue()), String.valueOf(new Double(d4).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Min is much smaller than minDataValue"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (bl) {
            if (!bl2 && d <= 0.0) {
                if (bl7 || bl8) {
                    objectArray = this.rBundle.getString("Min must be greater than zero for log");
                    object3 = new JOptionPane(objectArray, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                    ((JOptionPane)object3).getAccessibleContext().setAccessibleName((String)objectArray);
                    container = ((JOptionPane)object3).createDialog(this, this.m_applicationName);
                    ((Dialog)container).show();
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
                if (this.m_eh != null) {
                    this.m_eh.log("Minimum value must be greater than zero for logarithmic scale.", this.getClass().getName(), "checkForBadInput");
                }
            }
            if (bl6 && dataEndPoints != null && this.isBaselineGraph() && this.m_baselineField.getNumber() < 0.0) {
                objectArray = this.rBundle.getString("Base line log warning");
                object3 = new JOptionPane(objectArray, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)object3).getAccessibleContext().setAccessibleName((String)objectArray);
                container = ((JOptionPane)object3).createDialog(this, this.m_applicationName);
                ((Dialog)container).show();
                object2 = ((JOptionPane)object3).getValue();
                if (object2 == null || (Integer)object2 == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (!bl3) {
            if (!bl && bl6 && dataEndPoints != null && d2 - d5 > (double)this.m_multiplier * (d5 - d4) && d5 != d4 && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMaxValue != this.m_maximumField.getNumber())) {
                objectArray = new String[]{String.valueOf(new Double(d2).longValue()), String.valueOf(new Double(d5).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Max is much greater than maxDataValue"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_maximumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_maximumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (bl6 && dataEndPoints != null && d2 < d5 && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMaxValue != this.m_maximumField.getNumber())) {
                objectArray = new String[]{String.valueOf(new Double(d2).longValue()), String.valueOf(new Double(d5).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Max is less than maxDataValue"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_maximumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_maximumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (bl6 && dataEndPoints != null && this.isBaselineGraph() && this.m_baselineField.getNumber() != 0.0 && this.m_baselineField.getNumber() > d2) {
                objectArray = new String[]{String.valueOf(new Double(d2).longValue()), String.valueOf(new Double(d5).longValue())};
                object3 = MessageFormat.format(this.rBundle.getString("Base line greater than max"), objectArray);
                container = new JOptionPane(object3, 2, 0, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/Warn.gif")));
                ((JOptionPane)container).getAccessibleContext().setAccessibleName((String)object3);
                object2 = ((JOptionPane)container).createDialog(this, this.m_applicationName);
                ((Dialog)object2).show();
                object = ((JOptionPane)container).getValue();
                if (object == null || (Integer)object == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (!bl4 && d3 <= 0.0) {
            if (bl7 || bl8) {
                objectArray = this.rBundle.getString("Increment value must be greater than zero.");
                object3 = new JOptionPane(objectArray, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                ((JOptionPane)object3).getAccessibleContext().setAccessibleName((String)objectArray);
                container = ((JOptionPane)object3).createDialog(this, this.m_applicationName);
                ((Dialog)container).show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Increment value must be greater than zero.", this.getClass().getName(), "checkForBadInput");
            }
        }
        if (d3 > d2 - d && !this.m_incrementBox.isSelected()) {
            if (bl7 || bl8) {
                objectArray = this.rBundle.getString("Incr must not be greater than max-min");
                object3 = new JOptionPane(objectArray, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                ((JOptionPane)object3).getAccessibleContext().setAccessibleName((String)objectArray);
                container = ((JOptionPane)object3).createDialog(this, this.m_applicationName);
                ((Dialog)container).show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Increment value must not be greater than the difference between the maximum and the minimum.", this.getClass().getName(), "checkForBadInput");
            }
        }
        if (!bl4) {
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl9 = true;
            int n = this.m_graph.getGraphType();
            if (d2 > 0.0 && d >= 0.0) {
                if (bl3 && dataEndPoints != null && n != 102 && n != 93 && n != 94) {
                    d6 = (d5 - d) / (double)100;
                    d7 = d5 - d;
                } else if (bl3 && dataEndPoints == null) {
                    bl9 = false;
                } else if (!bl3 || n == 102 || n == 93 || n == 94) {
                    d6 = (d2 - d) / (double)100;
                    d7 = d2 - d;
                }
            } else if (d2 <= 0.0 && d < 0.0) {
                if (bl2 && dataEndPoints != null) {
                    d6 = -((d4 - d2) / (double)100);
                    d7 = -(d4 - d2);
                } else if (bl2 && dataEndPoints == null) {
                    bl9 = false;
                } else if (!bl2) {
                    d6 = -((d - d2) / (double)100);
                    d7 = d2 - d;
                }
            } else {
                if (dataEndPoints == null) {
                    bl9 = false;
                }
                if (bl2 && bl3 && dataEndPoints != null) {
                    d6 = (d5 - d4) / (double)100;
                    d7 = d5 - d4;
                } else if (!bl3 && !bl2) {
                    d6 = (d2 - d) / (double)100;
                    d7 = d2 - d;
                    bl9 = true;
                } else if (bl3 && dataEndPoints != null) {
                    d6 = (d5 - d) / (double)100;
                    d7 = d5 - d;
                } else if (bl2 && dataEndPoints != null) {
                    d6 = (d2 - d4) / (double)100;
                    d7 = d2 - d4;
                }
            }
            if (d3 < d6 && bl7 && bl9) {
                Object[] objectArray3 = new String[]{Double.toString(d6)};
                String string = MessageFormat.format(this.rBundle.getString("Too small increment"), objectArray3);
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (d3 > d7 && bl7 && bl9) {
                Object[] objectArray4 = new String[]{String.valueOf(new Double(d7).longValue())};
                String string = MessageFormat.format(this.rBundle.getString("Too large increment"), objectArray4);
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ValueAxis"), (String)"images/stop.gif")));
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
        }
        return true;
    }

    private void _initializeCurrentValues() {
        switch (this.m_componentID) {
            case 41: {
                this.m_currentMinValue = this.m_graph.getUIX1Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getUIX1Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getUIX1Axis().getMajorTickStep();
                break;
            }
            case 46: {
                this.m_currentMinValue = this.m_graph.getUIY1Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getUIY1Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getUIY1Axis().getMajorTickStep();
                break;
            }
            case 51: {
                this.m_currentMinValue = this.m_graph.getUIY2Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getUIY2Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getUIY2Axis().getMajorTickStep();
            }
        }
    }

    public void setDecimalSeparator(char c) {
        this.m_minimumField.setDecimalSeparator(c);
        this.m_maximumField.setDecimalSeparator(c);
        this.m_incrementField.setDecimalSeparator(c);
        this.m_baselineField.setDecimalSeparator(c);
        this.updateNumbers();
    }

    public void setGroupingSeparator(char c) {
        this.m_minimumField.setGroupingSeparator(c);
        this.m_maximumField.setGroupingSeparator(c);
        this.m_incrementField.setGroupingSeparator(c);
        this.m_baselineField.setGroupingSeparator(c);
        this.updateNumbers();
    }

    private void updateNumbers() {
        switch (this.m_componentID) {
            case 41: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIX1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIX1Axis().getAutoMajorTickStep()));
                    break;
                }
                this.m_incrementField.setNumber(new Double(this.m_graph.getUIX1Axis().getMajorTickStep()));
                break;
            }
            case 46: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY1Axis().getMajorTickStep()));
                }
                this.m_baselineField.setNumber(new Double(this.m_graph.getUIY1Baseline().getValue()));
                break;
            }
            case 51: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getUIY2Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY2Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getUIY2Axis().getMajorTickStep()));
                }
                this.m_baselineField.setNumber(new Double(this.m_graph.getUIY2Baseline().getValue()));
            }
        }
    }

    protected void initTitleFontButton(FontButton fontButton) {
        super.initTitleFontButton(fontButton);
        if (!(this.isGraphHorizontal() || this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.m_graph.getGraphType() >= 65 && this.m_graph.getGraphType() <= 66 || this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69)) {
            int n = 12;
            fontButton.setRotationButtonMask(n);
        } else {
            fontButton.setRotationButtonMask(0);
        }
    }

    private ReferenceDialog createReferenceDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
        ReferenceDialog referenceDialog = null;
        Container container = this;
        while (container != null) {
            if (container instanceof Dialog) {
                referenceDialog = new ReferenceDialog((Dialog)container, string, bl, jPanel, bl2);
                break;
            }
            if (container instanceof Frame) {
                referenceDialog = new ReferenceDialog((Frame)container, string, bl, jPanel, bl2);
                break;
            }
            container = SwingUtilities.getWindowAncestor(container);
        }
        if (container == null) {
            referenceDialog = new ReferenceDialog(null, string, bl, jPanel, bl2);
        }
        return referenceDialog;
    }

    class ReferenceDialog
    extends JDialog
    implements ActionListener,
    FocusListener,
    HelpContext {
        private boolean m_bHelpEnabled = true;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private Object[][] m_data;
        private int m_initialWidth;
        private int m_initialHeight;
        private final Border _sBorder = new EmptyBorder(6, 6, 8, 5);
        private final Border _sBorderButtons = new EmptyBorder(8, 10, 0, 10);

        public ReferenceDialog(Frame frame, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(frame);
            this._initDialog(string, bl, jPanel, bl2);
        }

        public ReferenceDialog(Dialog dialog, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(dialog);
            this._initDialog(string, bl, jPanel, bl2);
        }

        private void _initDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
            this.m_bHelpEnabled = bl2;
            this.setTitle(string);
            this.setModal(bl);
            this.m_panel = jPanel;
            JTable jTable = ((ReferenceLine)this.m_panel).getTable();
            this.m_data = new Object[jTable.getRowCount()][jTable.getColumnCount()];
            int n = 0;
            while (n < jTable.getRowCount()) {
                int n2 = 0;
                while (n2 < jTable.getColumnCount()) {
                    this.m_data[n][n2] = jTable.getValueAt(n, n2);
                    ++n2;
                }
                ++n;
            }
            this.init();
            this.pack();
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
            this.setLocationRelativeTo(ValueAxis.this.m_referenceLineButton);
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ ReferenceDialog this$0;

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$0.resetValues();
                }
                {
                    this.this$0 = referenceDialog;
                }
            });
            jPanel = null;
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String string) {
            this.m_strHelpContextID = string;
        }

        public void setHelpEnabled(boolean bl) {
            this.m_bHelpEnabled = bl;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            Object object;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                jComponent.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                jComponent.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane grayPane = new GrayPane((Component)this.m_panel);
            jComponent.add((Component)grayPane);
            DialogButtonBar dialogButtonBar = new DialogButtonBar();
            dialogButtonBar.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                object = ValueAxis.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)object));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
                dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.addFocusListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            object = new JPanel();
            this.okButton = new JButton(ValueAxis.this.rBundle.getString("OK"));
            dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.okButton.addFocusListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(ValueAxis.this.rBundle.getString("Cancel"));
            dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.addFocusListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)dialogButtonBar);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ ReferenceDialog this$0;

                public void componentResized(ComponentEvent componentEvent) {
                    int n;
                    int n2;
                    int n3 = n2 = this.this$0.getWidth();
                    int n4 = n = this.this$0.getHeight();
                    if (ReferenceDialog.access$7000071(this.this$0) != -1) {
                        n3 = Math.max(ReferenceDialog.access$7000071(this.this$0), n3);
                    }
                    if (ReferenceDialog.access$7000171(this.this$0) != -1) {
                        n4 = Math.max(ReferenceDialog.access$7000171(this.this$0), n4);
                    }
                    if (n2 != n3 || n != n4) {
                        this.this$0.setSize(n3, n4);
                    }
                    this.this$0.validate();
                }
                {
                    this.this$0 = referenceDialog;
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.getParent().repaint();
                this.resetValues();
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (actionEvent.getSource() == this.okButton) {
                this.setVisible(false);
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (actionEvent.getSource() == this.helpButton) {
                try {
                    if (ValueAxis.this.getHelpProvider() != null) {
                        ValueAxis.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.cancelButton) {
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (focusEvent.getSource() == this.okButton) {
                ValueAxis.this.m_referenceLine.resetFocusLast();
            } else if (focusEvent.getSource() == this.helpButton) {
                ValueAxis.this.m_referenceLine.resetFocusLast();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void resetValues() {
            int n;
            int n2;
            JTable jTable = ((ReferenceLine)this.m_panel).getTable();
            if (jTable.isEditing()) {
                n2 = jTable.getEditingRow();
                n = jTable.getEditingColumn();
                if (n2 >= 0 && n >= 0) {
                    jTable.getCellEditor(n2, n).cancelCellEditing();
                }
            }
            n2 = 0;
            while (n2 < jTable.getRowCount()) {
                n = 1;
                while (n < jTable.getColumnCount()) {
                    jTable.setValueAt(this.m_data[n2][n], n2, n);
                    ++n;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < jTable.getRowCount()) {
                jTable.setValueAt(this.m_data[n2][0], n2, 0);
                ++n2;
            }
        }

        static /* synthetic */ int access$7000171(ReferenceDialog referenceDialog) {
            return referenceDialog.m_initialHeight;
        }

        static /* synthetic */ int access$7000071(ReferenceDialog referenceDialog) {
            return referenceDialog.m_initialWidth;
        }
    }

    protected class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private JTextField m_text;
        private char Minus;
        private char Dec;
        private char Group;

        public NumberLocaleDocument(JTextField jTextField, Locale locale) {
            this.m_text = jTextField;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.Group = this.m_format.getDecimalFormatSymbols().getGroupingSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void setDecimalSeparator(char c) {
            DecimalFormatSymbols decimalFormatSymbols = this.m_format.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(c);
            this.Dec = decimalFormatSymbols.getDecimalSeparator();
            this.m_format.setDecimalFormatSymbols(decimalFormatSymbols);
        }

        public void setGroupingSeparator(char c) {
            DecimalFormatSymbols decimalFormatSymbols = this.m_format.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(c);
            this.Group = decimalFormatSymbols.getGroupingSeparator();
            this.m_format.setGroupingUsed(true);
            this.m_format.setDecimalFormatSymbols(decimalFormatSymbols);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                if (this.m_text.getText().length() == 0 && n == 0 && string.length() == 1 && (string.charAt(0) == this.Minus || string.charAt(0) == this.Dec)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(this.m_text.getText());
                stringBuffer.insert(n, string);
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = this.m_format.parse(stringBuffer.toString(), parsePosition);
                if (parsePosition.getIndex() != stringBuffer.length()) {
                    if (parsePosition.getIndex() == stringBuffer.length() - 1 && string.equals(new String(new char[]{this.Dec})) && this.m_text.getText().indexOf(this.Dec) == -1) {
                        super.insertString(n, string, attributeSet);
                    } else if (parsePosition.getIndex() == stringBuffer.length() - 1 && string.equals(new String(new char[]{this.Group}))) {
                        super.insertString(n, string, attributeSet);
                    }
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
            catch (Exception exception) {
                return;
            }
        }

        public void cleanUp() {
            this.m_format = null;
            this.m_text = null;
        }
    }

    protected class DoubleTextField
    extends JTextField {
        DecimalFormat m_format;
        NumberLocaleDocument m_document;

        public DoubleTextField(Locale locale) {
            this.m_format = (DecimalFormat)NumberFormat.getInstance(locale);
            this.m_format.setMinimumFractionDigits(2);
            this.m_format.setMaximumFractionDigits(10);
            this.m_format.setGroupingUsed(false);
            this.m_document = null.new NumberLocaleDocument(this, locale);
            this.setDocument(this.m_document);
        }

        public Double getNumber() {
            String string = this.getText();
            if (string == null || string.equals("")) {
                return null;
            }
            if (string.length() == 1) {
                char c = this.m_format.getDecimalFormatSymbols().getMinusSign();
                char c2 = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
                if (string.charAt(0) == c || string.charAt(0) == c2) {
                    return new Double(0.0);
                }
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this.m_format.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                return new Double(0.0);
            }
            return new Double(number.doubleValue());
        }

        public void setNumber(Double d) {
            this.setText(this.m_format.format(d));
        }

        public void setDecimalSeparator(char c) {
            DecimalFormatSymbols decimalFormatSymbols = this.m_format.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(c);
            this.m_format.setDecimalFormatSymbols(decimalFormatSymbols);
            this.m_document.setDecimalSeparator(c);
        }

        public void setGroupingSeparator(char c) {
            DecimalFormatSymbols decimalFormatSymbols = this.m_format.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(c);
            this.m_format.setGroupingUsed(true);
            this.m_format.setDecimalFormatSymbols(decimalFormatSymbols);
            this.m_document.setGroupingSeparator(c);
        }

        public void cleanUp() {
            this.setDocument(new DefaultStyledDocument());
            this.m_document.cleanUp();
            this.m_document = null;
            this.m_format = null;
        }
    }
}

