/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.dataView.Background;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Fill;
import oracle.dss.graph.Series;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.NewColorChoice1;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.SeriesOutOfRangeException;

public class FillColorTool
extends JToolBar
implements DataviewTool,
PropertyChangeListener {
    Object m_selectedObject;
    int m_selectedSeries;
    protected NewColorChoice1 m_fillColor = new NewColorChoice1();
    private Image m_fillColorImage;
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    protected ErrorHandler m_eh;

    public FillColorTool() {
        Icon icon = this.m_fillColor.getColorIcon("images/fillcolorwitharrow.gif");
        ImageIcon imageIcon = this.makeImage("images/l_fillcolorwitharrow.gif");
        this.m_fillColor.setIcon(icon);
        this.m_fillColor.setRolloverIcon(imageIcon);
        this.m_fillColor.setRolloverSelectedIcon(imageIcon);
        this.m_fillColor.setSelectedIcon(imageIcon);
        this.m_fillColor.setSelectedColor(new Color(153, 153, 153));
        icon = this.m_fillColor.getColorIcon("images/fillcolorwitharrow.gif");
        this.m_fillColor.setDisabledIcon(icon);
        this.m_fillColor.addPropertyChangeListener(this);
        this.m_fillColor.setEnabled(false);
        this.add((Component)((Object)this.m_fillColor));
        this.setBorder(null);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.m_fillColor.setToolTipText(this.rBundle.getString("FillColor"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        Object object = null;
        int n = 0;
        if (controllerEvent == null) {
            return;
        }
        ComponentHandle componentHandle = controllerEvent.getComponentHandle();
        if (componentHandle == null) {
            this.m_selectedObject = null;
            this.setEnabled(false);
            return;
        }
        if (componentHandle instanceof DataComponentHandle) {
            n = ((DataComponentHandle)componentHandle).getSeries();
            object = ((UIGraph)uIDataview).getUISeriesColor();
        } else if (componentHandle instanceof SeriesComponentHandle) {
            n = ((SeriesComponentHandle)componentHandle).getSeries();
            object = ((UIGraph)uIDataview).getUISeriesColor();
        } else {
            object = controllerEvent.getComponentHandle().getComponent();
        }
        if (object == this.m_selectedObject && n == this.m_selectedSeries) {
            return;
        }
        if (object == null) {
            this.m_fillColor.setEnabled(false);
            return;
        }
        this.m_enable = false;
        if (object instanceof Background) {
            this.m_selectedObject = object;
            this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(((Background)this.m_selectedObject).getBackground()));
            this.m_fillColor.setEnabled(true);
            this.m_fillColor.updateIconColor();
            this.m_enable = true;
            return;
        }
        if (object instanceof Series) {
            this.m_selectedObject = object;
            this.m_selectedSeries = n;
            try {
                if (((Series)this.m_selectedObject).getColor(this.m_selectedSeries) != null) {
                    this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(((Series)this.m_selectedObject).getColor(this.m_selectedSeries)));
                    this.m_fillColor.updateIconColor();
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                if (this.m_eh != null) {
                    this.m_eh.error(seriesOutOfRangeException, this.getClass().getName(), "propertyChange");
                }
                seriesOutOfRangeException.printStackTrace();
            }
            this.m_fillColor.setEnabled(true);
            this.m_enable = true;
            return;
        }
        if (object instanceof Fill) {
            this.m_selectedObject = object;
            Color color = ((Fill)this.m_selectedObject).getFillColor();
            try {
                this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.m_fillColor.setEnabled(true);
            this.m_fillColor.updateIconColor();
            this.m_enable = true;
            return;
        }
        this.m_fillColor.setEnabled(false);
        this.m_selectedObject = null;
        this.m_selectedSeries = 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || !this.m_enable) {
            return;
        }
        if (!propertyChangeEvent.getSource().equals((Object)this.m_fillColor) || !propertyChangeEvent.getPropertyName().equals("selectedColor")) {
            return;
        }
        if (this.m_selectedObject == null) {
            return;
        }
        if (this.m_selectedObject instanceof Series) {
            try {
                ((Series)this.m_selectedObject).setColor(this.m_fillColor.getSelectedColor(), this.m_selectedSeries);
                this.m_fillColor.updateIconColor();
                return;
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                if (this.m_eh != null) {
                    this.m_eh.error(seriesOutOfRangeException, this.getClass().getName(), "propertyChange");
                }
                seriesOutOfRangeException.printStackTrace();
            }
        }
        if (this.m_selectedObject instanceof Background) {
            ((Background)this.m_selectedObject).setBackground(this.m_fillColor.getSelectedColor());
            this.m_fillColor.updateIconColor();
            return;
        }
        if (this.m_selectedObject instanceof Fill) {
            ((Fill)this.m_selectedObject).setFillColor(this.m_fillColor.getSelectedColor());
            this.m_fillColor.updateIconColor();
            return;
        }
    }

    public void update() {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.m_fillColor.removePropertyChangeListener(this);
        this.remove((Component)((Object)this.m_fillColor));
        this.m_fillColor._filter = null;
        this.m_fillColor = null;
        this.rBundle = null;
    }
}

