/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ZTickLabel
extends BaseText
implements HorizontalAlignment {
    protected static final int ATTR_TEXTROTATION = 1;
    protected static final int ATTR_HORIZONTALALIGNMENT = 2;
    protected static final int ATTR_TICKLABELSKIPMODE = 3;
    protected static final int ATTR_TICKLABELSKIPCOUNT = 4;
    protected static final int ATTR_TICKLABELSKIPFIRST = 5;
    protected static final int ATTR_STYLE_MAXID = 6;
    protected int textRotation;
    protected int horizontalAlignment;
    protected int d_tickLabelSkipMode;
    protected int d_tickLabelSkipCount;
    protected int d_tickLabelSkipFirst;
    protected IdentObj m_identObj2;
    private static final String m_method_setTickLabelSkipCount = "void setTickLabelSkipCount( int count )";
    private static final String m_method_setTickLabelSkipFirst = "void setTickLabelSkipFirst( int first )";
    private static final String m_method_setTickLabelSkipMode = "void setTickLabelSkipMode( int mode )";

    public ZTickLabel(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO2Label();
        this.m_identObj2 = this.m_pfj.getO2DrillLabel();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.fontTypeface = GraphDefaultValues.getZTickLabelFontTypeface();
        this.fontColor = new Color(GraphDefaultValues.getZTickLabelFontColor());
        this.fontStyle = GraphDefaultValues.getZTickLabelFontStyle();
        this.fontSize = GraphDefaultValues.getZTickLabelFontSize();
        this.graphProportionalFontSize = GraphDefaultValues.getZTickLabelGraphProportionalFontSize();
        this.textRotation = GraphDefaultValues.getZTickLabelTextRotation();
        this.horizontalAlignment = GraphDefaultValues.getZTickLabelHorizontalAlignment();
        this.d_tickLabelSkipMode = GraphDefaultValues.getZTickLabelSkipMode();
        this.d_tickLabelSkipCount = GraphDefaultValues.getZTickLabelSkipCount();
        this.d_tickLabelSkipFirst = GraphDefaultValues.getZTickLabelSkipFirst();
    }

    void setAutoHorizAlignment() {
        int n = this.m_pfj.getTextRotation(this.m_identObj);
        int n2 = this.m_pfj.getTextJustHoriz(this.m_identObj);
        switch (n) {
            case 0: 
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        if (n2 != this.m_pfj.getTextJustHoriz(this.m_identObj)) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, n2);
        }
    }

    public boolean selectObject(int n, int n2) {
        if (n >= 0) {
            IdentObj identObj = this.m_identObj;
            identObj.setSeriesID(n);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, n);
            this.setAutoHorizAlignment();
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getTickLabelSkipCount() {
        return this.m_pfj.getSkipCount(this.m_identObj);
    }

    public void setTickLabelSkipCount(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid Tick Label Skip count", this.getClass().getName(), m_method_setTickLabelSkipCount);
        } else {
            this.m_pfj.setSkipCount(this.m_identObj, n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public int getTickLabelSkipFirst() {
        return this.m_pfj.getSkipBegin(this.m_identObj);
    }

    public void setTickLabelSkipFirst(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid first tick label", this.getClass().getName(), m_method_setTickLabelSkipFirst);
        } else {
            this.m_pfj.setSkipBegin(this.m_identObj, n);
            this.setPropertyOverrideFlags(5);
        }
    }

    public int getTickLabelSkipMode() {
        return this.m_pfj.getAutoSkip(this.m_identObj);
    }

    public void setTickLabelSkipMode(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid TickLabelSkipMode", this.getClass().getName(), m_method_setTickLabelSkipMode);
        } else {
            this.m_pfj.setAutoSkip(this.m_identObj, n);
            this.setPropertyOverrideFlags(3);
        }
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.convertSwingHAlignmentToPFJ(n);
        if (n2 == -1) {
            this.m_graph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        } else {
            this.m_pfj.setTextJustHoriz(this.m_identObj, n2);
            this.m_pfj.setTextJustHoriz(this.m_identObj2, n2);
            this.setPropertyOverrideFlags(2);
        }
    }

    public int getHorizontalAlignment() {
        return this.convertPFJHAlignmentToSwing(this.m_pfj.getTextJustHoriz(this.m_identObj));
    }

    protected String convertTickLabelSkipModeToString(int n) {
        String string = "TLS_NOSKIP";
        switch (n) {
            case 0: {
                string = "TLS_NOSKIP";
                break;
            }
            case 1: {
                string = "TLS_AUTOMATIC";
                break;
            }
            case 2: {
                string = "TLS_MANUAL";
            }
        }
        return string;
    }

    protected int convertTickLabelSkipModeToInt(String string) {
        if (string.equals("TLS_NOSKIP")) {
            return 0;
        }
        if (string.equals("TLS_AUTOMATIC")) {
            return 1;
        }
        if (string.equals("TLS_MANUAL")) {
            return 2;
        }
        return -1;
    }

    protected String getComponentName() {
        return "ZTickLabel";
    }

    protected int getStylePropertyCount() {
        return 6;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("tickLabelSkipMode", this.convertTickLabelSkipModeToString(this.getTickLabelSkipMode()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("tickLabelSkipCount", this.getTickLabelSkipCount());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty("tickLabelSkipFirst", this.getTickLabelSkipFirst());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            if (this.getTextRotation() == 0) {
                objectNode.addProperty("textRotation", "TR_HORIZ");
            } else if (this.getTextRotation() == 1) {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            }
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString(this.getHorizontalAlignment()));
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("tickLabelSkipMode");
        if (propertyNode != null) {
            this.setTickLabelSkipMode(this.convertTickLabelSkipModeToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("tickLabelSkipCount")) != null) {
            this.setTickLabelSkipCount(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("tickLabelSkipFirst")) != null) {
            this.setTickLabelSkipFirst(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("textRotation")) != null) {
            String string = propertyNode.getValueAsString();
            if (string.equals("TR_HORIZ")) {
                this.setTextRotation(0);
            } else if (string.equals("TR_HORIZ_ROTATE_90")) {
                this.setTextRotation(1);
            } else if (string.equals("TR_HORIZ_ROTATE_270")) {
                this.setTextRotation(2);
            }
        }
        if ((propertyNode = objectNode.getProperty("horizontalAlignment")) != null) {
            this.setHorizontalAlignment(this.convertHorizontalAlignmentToInt(propertyNode.getValueAsString()));
        }
    }

    public void resetStyle() {
        this.setTextRotation(this.textRotation);
        this.setHorizontalAlignment(this.horizontalAlignment);
        this.setTickLabelSkipMode(this.d_tickLabelSkipMode);
        this.setTickLabelSkipCount(this.d_tickLabelSkipCount);
        this.setTickLabelSkipFirst(this.d_tickLabelSkipFirst);
        super.resetStyle();
    }
}

