/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Font;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphFont;
import oracle.dss.graph.UIGraphFont;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseText
extends BaseGraphComponent
implements DataviewFontAttribute,
FontAttribute {
    protected static final int ATTR_FONTSIZEABSOLUTE = 0;
    protected static final int ATTR_BASETEXT_LASTID = 0;
    protected static final int ATTR_STYLE_MAXID = 1;
    protected String fontTypeface;
    protected int fontStyle;
    protected int fontSize;
    protected Color fontColor;
    protected int graphProportionalFontSize;
    protected GraphFont m_font;

    public BaseText(Graph graph) {
        super(graph);
    }

    public GraphFont getGraphFont() {
        if (this.m_font == null) {
            this.m_font = new GraphFont(this.m_graph, this.m_identObj, this.fontTypeface, this.fontStyle, this.fontSize, this.fontColor, this.graphProportionalFontSize);
        }
        return this.m_font;
    }

    public DataviewFont getDataviewFont() {
        return this.getGraphFont();
    }

    public UIGraphFont getUIGraphFont() {
        return this.getGraphFont();
    }

    public void setFont(Font font) {
        this.getGraphFont();
        this.m_font.setFont(font);
    }

    public Font getFont() {
        this.getGraphFont();
        return this.m_font.getFont();
    }

    public boolean isFontSizeAbsolute() {
        return this.m_pfj.getFontSizeAbsolute(this.m_identObj);
    }

    public void setFontSizeAbsolute(boolean bl) {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, bl);
        this.setPropertyOverrideFlags(0);
    }

    protected int getStylePropertyCount() {
        return 1;
    }

    protected GraphFont _getGraphFont() {
        return this.m_font;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        ObjectNode objectNode2;
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("fontSizeAbsolute", this.isFontSizeAbsolute());
            bl2 = true;
        }
        if ((objectNode2 = this.getGraphFont().getStyleXML(bl)) != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        ObjectNode objectNode2;
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("fontSizeAbsolute");
        if (propertyNode != null) {
            this.setFontSizeAbsolute(propertyNode.getValueAsBoolean());
        }
        if ((objectNode2 = objectNode.getPropertyValueAsObjectNode("GraphFont", true)) != null) {
            this.getGraphFont().setStyleXML(objectNode2);
        }
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        super.setNonstyleXML(objectNode);
        ObjectNode objectNode2 = objectNode.getPropertyValueAsObjectNode("GraphFont", true);
        if (objectNode2 != null) {
            this.getGraphFont().setNonstyleXML(objectNode2);
        }
    }

    protected void resetStyle() {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, GraphDefaultValues.isFontsizeabsolute());
        if (this.m_font != null) {
            this.m_font.resetStyle();
        }
        super.resetStyle();
    }

    protected void createPropertyOverrideFlags() {
        if (this.m_font != null) {
            this.m_font.createPropertyOverrideFlags();
        }
        super.createPropertyOverrideFlags();
    }
}

