/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.ControllerListenerAdapter;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.BoldFontTool;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.FontNameTool;
import oracle.dss.dataView.gui.FontSizeTool;
import oracle.dss.dataView.gui.HorizontalAlignmentTool;
import oracle.dss.dataView.gui.ItalicFontTool;

public class ToolBar
extends JToolBar
implements PropertyChangeListener {
    protected UIDataview m_dataView;
    protected Vector m_toolsVector = new Vector();
    protected ToolbarControllerListener m_controllerListener;
    protected boolean m_isRolloverEnabled;
    protected boolean m_bSuperCalled = true;

    public ToolBar() {
        this.setBorderPainted(true);
    }

    public ToolBar(UIDataview uIDataview) {
        this.setBorderPainted(true);
        this.setDataView(uIDataview);
    }

    public void setDataView(UIDataview uIDataview) {
        if (this.m_dataView != null) {
            this.m_dataView.removeControllerListener(this.m_controllerListener);
        }
        this.m_dataView = uIDataview;
        if (this.m_dataView != null) {
            this.m_controllerListener = new ToolbarControllerListener();
            this.m_dataView.addControllerListener(this.m_controllerListener);
            this.setSelectedObject(new ControllerEvent(this.m_dataView, this.m_dataView.getSelectedObject()));
            this.update();
        }
    }

    public UIDataview getDataView() {
        return this.m_dataView;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        int n = 0;
        while (n < this.m_toolsVector.size()) {
            Object e = this.m_toolsVector.elementAt(n);
            if (e instanceof Component) {
                ((Component)e).setLocale(locale);
            }
            ++n;
        }
    }

    public void setSelectedObject(ControllerEvent controllerEvent) {
        if (controllerEvent.getSource() == this.m_dataView) {
            int n = 0;
            while (n < this.m_toolsVector.size()) {
                ((DataviewTool)this.m_toolsVector.elementAt(n)).selectedAction(controllerEvent, this.m_dataView, this);
                ++n;
            }
        }
    }

    public void update() {
        int n = 0;
        while (n < this.m_toolsVector.size()) {
            ((DataviewTool)this.m_toolsVector.elementAt(n)).update();
            ++n;
        }
    }

    public void setRolloverIconEnabled(boolean bl) {
        int n = 0;
        while (n < this.m_toolsVector.size()) {
            if (this.m_toolsVector.elementAt(n) instanceof DataviewToolbarRollover) {
                ((DataviewToolbarRollover)this.m_toolsVector.elementAt(n)).setRolloverIconEnabled(bl);
            }
            ++n;
        }
        this.m_isRolloverEnabled = bl;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_isRolloverEnabled;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public Component add(Component component) {
        if (component instanceof DataviewTool) {
            this.m_toolsVector.addElement(component);
        }
        return super.add(component);
    }

    public void remove(Component component) {
        if (component instanceof DataviewTool) {
            this.m_toolsVector.removeElement(component);
        }
        super.remove(component);
    }

    public void cleanUp() {
        if (this.m_toolsVector != null) {
            int n = 0;
            while (n < this.m_toolsVector.size()) {
                if ((DataviewTool)this.m_toolsVector.elementAt(n) != null) {
                    ((DataviewTool)this.m_toolsVector.elementAt(n)).cleanUp();
                    super.remove((Component)this.m_toolsVector.elementAt(n));
                }
                ++n;
            }
            this.m_toolsVector.removeAllElements();
            this.m_toolsVector = null;
        }
        if (this.m_dataView != null) {
            this.m_dataView.removeControllerListener(this.m_controllerListener);
        }
        this.m_dataView = null;
        this.m_controllerListener = null;
    }

    public void addComDataviewTools() {
        FontNameTool fontNameTool = new FontNameTool();
        fontNameTool.addPropertyChangeListener(this);
        FontSizeTool fontSizeTool = new FontSizeTool();
        fontSizeTool.addPropertyChangeListener(this);
        BoldFontTool boldFontTool = new BoldFontTool();
        boldFontTool.addPropertyChangeListener(this);
        ItalicFontTool italicFontTool = new ItalicFontTool();
        italicFontTool.addPropertyChangeListener(this);
        HorizontalAlignmentTool horizontalAlignmentTool = new HorizontalAlignmentTool();
        horizontalAlignmentTool.addPropertyChangeListener(this);
        this.add(fontNameTool);
        this.addToolBarSeparator();
        this.add(fontSizeTool);
        this.addToolBarSeparator();
        this.add(boldFontTool);
        this.add(italicFontTool);
        this.addToolBarSeparator();
        this.add(horizontalAlignmentTool);
    }

    protected void addToolBarSeparator() {
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            JSeparator jSeparator = new JSeparator(1);
            jSeparator.setPreferredSize(new Dimension(5, 24));
            jSeparator.setMaximumSize(new Dimension(5, 24));
            jSeparator.setMinimumSize(new Dimension(5, 24));
            jSeparator.setAlignmentX(0.5f);
            this.add(jSeparator);
            this.add(Box.createHorizontalStrut(2));
        } else {
            super.addSeparator(new Dimension(1, this.getPreferredSize().height - 4));
        }
    }

    protected class ToolbarControllerListener
    extends ControllerListenerAdapter {
        ToolbarControllerListener() {
        }

        public void componentSelected(ControllerEvent controllerEvent) {
            ToolBar.this.setSelectedObject(controllerEvent);
        }
    }
}

