/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.DefaultDialog;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialog;
import oracle.dss.dataView.gui.PrintDialogsAdapter;
import oracle.dss.dataView.gui.PrintDialogsProvider;
import oracle.dss.dataView.gui.PrintPanel;
import oracle.dss.util.help.HelpContext;

public class PrintDialog
extends DefaultDialog
implements HelpContext {
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected boolean m_sysPrintDialog = true;
    protected HelpProvider m_helpProvider;
    private PrinterJob m_printerJob;
    private ViewPrinter _printer;
    private Frame _frame;
    private PrintDialogsAdapter m_adapter;
    private PageSetupDialog pageSetup;
    private PrintPanel m_printPanel;
    private Locale m_locale;
    ResourceBundle dvStrings;

    public PrintDialog(Frame frame, ViewPrinter viewPrinter) {
        super(frame, true, viewPrinter.getDataview().getLocale());
        this.constructPanel(viewPrinter);
        this.m_printerJob = PrinterJob.getPrinterJob();
        if (this._printer.getPageFormat() == null) {
            this._printer.setPageFormat(this.m_printerJob.defaultPage());
        }
        this.m_adapter = new PrintDialogsAdapter(viewPrinter, this, this.m_printerJob);
    }

    public PrintDialog(Frame frame, ViewPrinter viewPrinter, PrinterJob printerJob) {
        super(frame, true, viewPrinter.getDataview().getLocale());
        this.m_printerJob = printerJob;
        this.constructPanel(viewPrinter);
        this.m_adapter = new PrintDialogsAdapter(viewPrinter, this, printerJob);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.previewButton)) {
            if (!this.m_printPanel.apply()) return;
            Frame frame = WindowUtils.parentFrame((Component)this);
            ViewPrinter[] viewPrinterArray = new ViewPrinter[]{this._printer};
            PreviewDialog previewDialog = new PreviewDialog(frame, this.getIntlString("Print Preview"), viewPrinterArray, (PrintDialogsProvider)this.m_adapter);
            previewDialog.setHelpProvider(this.getHelpProvider());
            previewDialog.setVisible(true);
            return;
        }
        if (actionEvent.getSource().equals(this.helpButton)) {
            if (this.getHelpProvider() == null) {
                return;
            }
            try {
                if (this.getHelpProvider() != null) {
                    this.getHelpProvider().showHelp((Component)this);
                }
            }
            catch (HelpUnavailableException helpUnavailableException) {}
        } else {
            if (actionEvent.getSource().equals(this.okButton)) {
                if (!this.m_printPanel.apply()) {
                    return;
                }
                if (this.m_sysPrintDialog && !this.m_printerJob.printDialog()) {
                    return;
                }
                if (!this._printer.startPrint(false)) {
                    this.setVisible(false);
                    return;
                }
                try {
                    try {
                        this.m_printerJob.setPrintable(this._printer, this._printer.getPageFormat());
                        this.m_printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        this._printer.getDataview().getErrorHandler().log("java.awt.print.PrinterException", this.getClass().getName(), "actionPerformed(ActionEvent e)");
                        Object var6_8 = null;
                        this.setVisible(false);
                        this._printer.endPrint();
                        return;
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.setVisible(false);
                    this._printer.endPrint();
                    throw throwable;
                }
                this.setVisible(false);
                this._printer.endPrint();
                return;
            }
            if (actionEvent.getSource().equals(this.cancelButton)) {
                // empty if block
            }
        }
        super.actionPerformed(actionEvent);
    }

    public String getIntlString(String string) {
        return this.getIntlString(string, this.dvStrings);
    }

    public String getIntlString(String string, ResourceBundle resourceBundle) {
        String string2;
        if (resourceBundle == null) {
            return string;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string3 = string;
            return string3;
        }
        return string2;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        super.setLocale(this.m_locale);
        this.updateResourceBundle(locale);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_adapter != null) {
            this.m_adapter.setHelpProvider(this.m_helpProvider);
        }
        if (this.m_printPanel != null) {
            this.m_printPanel.setHelpProvider(this.m_helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setSystemPrintDialogDisplayed(boolean bl) {
        this.m_sysPrintDialog = bl;
    }

    public boolean isSystemPrintDialogDisplayed() {
        return this.m_sysPrintDialog;
    }

    protected void updateResourceBundle(Locale locale) {
        try {
            this.dvStrings = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.dvStrings = null;
        }
    }

    private void constructPanel(ViewPrinter viewPrinter) {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                PrintDialog.this.cancelButton.transferFocus();
            }
        });
        this._printer = viewPrinter;
        this.updateResourceBundle(viewPrinter.getDataview().getLocale());
        this.setTitle(this.getIntlString("title"));
        this.setResizable(true);
        this.m_printPanel = new PrintPanel(viewPrinter);
        this.m_printPanel.setPrintDialog(this);
        this.m_printPanel.setPrinterJob(this.m_printerJob);
        GrayPane grayPane = new GrayPane((Component)this.m_printPanel);
        this.getContentPane().add((Component)grayPane, "Center");
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)WindowUtils.parentFrame((Component)viewPrinter.getDataview()));
    }
}

