/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import org.exolab.castor.persist.cache.InvalidCacheTypeException;

public class CacheType {
    public static final CacheType CACHE_NONE = new CacheType(1);
    public static final String CACHE_NONE_TEXT = "none";
    public static final CacheType CACHE_COUNT_LIMITED = new CacheType(2);
    public static final String CACHE_COUNT_LIMITED_TEXT = "count-limited";
    public static final CacheType CACHE_TIME_LIMITED = new CacheType(3);
    public static final String CACHE_TIME_LIMITED_TEXT = "time-limited";
    public static final CacheType CACHE_UNLIMITED = new CacheType(4);
    public static final String CACHE_UNLIMITED_TEXT = "unlimited";
    private int _type = 0;

    private CacheType(int type) {
        this._type = type;
    }

    public static CacheType create(String type) throws InvalidCacheTypeException {
        CacheType cacheType = null;
        if (type == null || type.equals("")) {
            throw new InvalidCacheTypeException("Required cache type not specified");
        }
        if (type.toLowerCase().equals(CACHE_NONE_TEXT)) {
            cacheType = CACHE_NONE;
        } else if (type.toLowerCase().equals(CACHE_COUNT_LIMITED_TEXT)) {
            cacheType = CACHE_COUNT_LIMITED;
        } else if (type.toLowerCase().equals(CACHE_TIME_LIMITED_TEXT)) {
            cacheType = CACHE_TIME_LIMITED;
        } else if (type.toLowerCase().equals(CACHE_UNLIMITED_TEXT)) {
            cacheType = CACHE_UNLIMITED;
        } else {
            throw new InvalidCacheTypeException("Specified cache type " + type + " not supported.");
        }
        return cacheType;
    }

    public String toString() {
        String cacheType = null;
        switch (this._type) {
            case 1: {
                cacheType = CACHE_NONE_TEXT;
                break;
            }
            case 2: {
                cacheType = CACHE_COUNT_LIMITED_TEXT;
                break;
            }
            case 3: {
                cacheType = CACHE_TIME_LIMITED_TEXT;
                break;
            }
            case 4: {
                cacheType = CACHE_UNLIMITED_TEXT;
            }
        }
        return cacheType;
    }

    public boolean equals(Object cacheType) {
        if (cacheType != null) {
            return this._type == ((CacheType)cacheType)._type;
        }
        return false;
    }
}

