/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import jmapps.registry.VectorEditor;
import jmapps.registry.VectorPanel;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.PopupWait;

public class CDMPanel
extends JMPanel
implements VectorEditor,
ActionListener {
    Panel panelLeft;
    Button buttonDetect;
    VectorPanel panelDevices = null;
    Vector deviceVector;
    Vector deviceArray;
    Vector devices;
    TextArea textArea;
    int type;

    public CDMPanel() {
        this.setLayout(new GridLayout(1, 2, 6, 6));
        this.panelLeft = new Panel(new BorderLayout(6, 6));
        this.add(this.panelLeft);
        Panel panel = new Panel(new FlowLayout(0));
        this.panelLeft.add((Component)panel, "South");
        this.buttonDetect = new Button(JMFI18N.getResource("jmfregistry.capture.detect"));
        this.buttonDetect.addActionListener(this);
        panel.add(this.buttonDetect);
        this.createPanelDevices();
        panel = new Panel(new BorderLayout());
        this.add(panel);
        Label label = new Label(JMFI18N.getResource("jmfregistry.capture.details.label"));
        panel.add((Component)label, "North");
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        panel.add((Component)this.textArea, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.buttonDetect.getActionCommand())) {
            this.detectDevices();
        }
    }

    public boolean addToList(int n2, String string) {
        try {
            CaptureDeviceInfo captureDeviceInfo;
            String string2 = string;
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            if (obj instanceof CaptureDeviceInfo && ((captureDeviceInfo = (CaptureDeviceInfo)obj).getName() != null || captureDeviceInfo.getLocator() != null) && CaptureDeviceManager.addDevice(captureDeviceInfo)) {
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        catch (Error error) {
            System.err.println(error);
        }
        return false;
    }

    public void commit(int n2) {
        int n3 = 0;
        while (n3 < this.devices.size()) {
            CaptureDeviceManager.removeDevice((CaptureDeviceInfo)this.devices.elementAt(n3));
            ++n3;
        }
        n3 = 0;
        while (n3 < this.deviceVector.size()) {
            String string = (String)this.deviceVector.elementAt(n3);
            int n4 = 0;
            while (n4 < this.devices.size()) {
                if (((CaptureDeviceInfo)this.devices.elementAt(n4)).getName().equals(string)) {
                    CaptureDeviceManager.addDevice((CaptureDeviceInfo)this.devices.elementAt(n4));
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        try {
            CaptureDeviceManager.commit();
        }
        catch (IOException iOException) {
            System.err.println("CaptureDeviceManager.commit() - " + iOException);
        }
    }

    private void createPanelDevices() {
        if (this.panelDevices != null) {
            this.panelLeft.remove(this.panelDevices);
        }
        this.panelDevices = new VectorPanel(JMFI18N.getResource("jmfregistry.capture.vector.label"), this, 0);
        this.panelLeft.add((Component)this.panelDevices, "Center");
        this.panelLeft.validate();
    }

    private void detectDevices() {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Class<?> clazz4 = null;
        try {
            clazz = Class.forName("DirectSoundAuto");
        }
        catch (Exception exception) {}
        try {
            clazz2 = Class.forName("JavaSoundAuto");
        }
        catch (Exception exception) {}
        try {
            clazz3 = Class.forName("VFWAuto");
        }
        catch (Exception exception) {}
        if (clazz3 == null) {
            try {
                clazz3 = Class.forName("SunVideoAuto");
            }
            catch (Exception exception) {}
            try {
                clazz4 = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception exception) {}
        }
        if (clazz3 == null) {
            try {
                clazz3 = Class.forName("V4LAuto");
            }
            catch (Exception exception) {}
        }
        if (clazz == null && clazz2 == null && clazz3 == null && clazz4 == null) {
            return;
        }
        PopupWait popupWait = new PopupWait(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.mssg.capturequery")) + "\n" + JMFI18N.getResource("jmfregistry.appname") + " " + JMFI18N.getResource("jmstudio.mssg.lookingcapture"));
        popupWait.setVisible(true);
        try {
            Object obj;
            if (clazz != null) {
                obj = clazz.newInstance();
            }
            if (clazz2 != null) {
                obj = clazz2.newInstance();
            }
            if (clazz3 != null) {
                Object obj2 = clazz3.newInstance();
            }
            if (clazz4 != null) {
                Object obj3 = clazz4.newInstance();
            }
        }
        catch (ThreadDeath threadDeath) {
            popupWait.dispose();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            MessageDialog.createErrorDialog(new Frame(), JMFI18N.getResource("jmstudio.error.capturequery"));
        }
        popupWait.dispose();
        this.createPanelDevices();
    }

    public Vector getList(int n2) {
        this.devices = CaptureDeviceManager.getDeviceList(null);
        this.devices = (Vector)this.devices.clone();
        this.deviceVector = new Vector(10);
        Enumeration enumeration = this.devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            this.deviceVector.addElement(captureDeviceInfo.getName());
        }
        return this.deviceVector;
    }

    private String printFormats(Object object) {
        if (!(object instanceof Format[])) {
            return "null";
        }
        Format[] formatArray = (Format[])object;
        String string = "";
        int n2 = 0;
        while (n2 < formatArray.length) {
            string = String.valueOf(string) + n2 + ". " + formatArray[n2].getClass().getName() + "\n  " + formatArray[n2] + "\n";
            ++n2;
        }
        return string;
    }

    public void selectedIndex(int n2, int n3) {
        String string = "";
        String string2 = null;
        CaptureDeviceInfo captureDeviceInfo = null;
        if (n3 >= 0) {
            string2 = (String)this.deviceVector.elementAt(n3);
        }
        if (string2 != null) {
            captureDeviceInfo = CaptureDeviceManager.getDevice(string2);
        }
        if (captureDeviceInfo != null) {
            string = String.valueOf(string) + JMFI18N.getResource("jmfregistry.details.name") + " = " + captureDeviceInfo.getName() + "\n\n";
            string = String.valueOf(string) + JMFI18N.getResource("jmfregistry.details.locator") + " = " + captureDeviceInfo.getLocator() + "\n\n";
            string = String.valueOf(string) + JMFI18N.getResource("jmfregistry.details.outformats") + "---->\n\n" + this.printFormats(captureDeviceInfo.getFormats()) + "\n\n";
        }
        this.textArea.setText(string);
    }

    public void setList(int n2, Vector vector) {
        this.deviceVector = vector;
    }

    public Vector stringArrayToVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        return vector;
    }

    public String[] vectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }
}

