/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class IndexedColorFormat
extends VideoFormat {
    protected int lineStride = -1;
    protected byte[] redValues = null;
    protected byte[] greenValues = null;
    protected byte[] blueValues = null;
    protected int mapSize = -1;
    private static String ENCODING = "irgb";

    public IndexedColorFormat(Dimension dimension, int n2, Class clazz, float f2, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(ENCODING, dimension, n2, clazz, f2);
        this.lineStride = n3;
        this.redValues = byArray;
        this.greenValues = byArray2;
        this.blueValues = byArray3;
        this.mapSize = n4;
    }

    public Object clone() {
        IndexedColorFormat indexedColorFormat = new IndexedColorFormat(this.size, this.maxDataLength, this.dataType, this.frameRate, this.lineStride, this.mapSize, this.redValues, this.greenValues, this.blueValues);
        indexedColorFormat.copy(this);
        return indexedColorFormat;
    }

    protected void copy(Format format) {
        super.copy(format);
        if (format instanceof IndexedColorFormat) {
            IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format;
            this.mapSize = indexedColorFormat.mapSize;
            this.redValues = indexedColorFormat.redValues;
            this.greenValues = indexedColorFormat.greenValues;
            this.blueValues = indexedColorFormat.blueValues;
            this.lineStride = indexedColorFormat.lineStride;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IndexedColorFormat) {
            IndexedColorFormat indexedColorFormat = (IndexedColorFormat)object;
            return super.equals(object) && this.mapSize == indexedColorFormat.mapSize && this.redValues == indexedColorFormat.redValues && this.greenValues == indexedColorFormat.greenValues && this.blueValues == indexedColorFormat.blueValues && this.lineStride == indexedColorFormat.lineStride;
        }
        return false;
    }

    public byte[] getBlueValues() {
        return this.blueValues;
    }

    public byte[] getGreenValues() {
        return this.greenValues;
    }

    public int getLineStride() {
        return this.lineStride;
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getRedValues() {
        return this.redValues;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof IndexedColorFormat)) {
            return format2;
        }
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format;
        IndexedColorFormat indexedColorFormat2 = (IndexedColorFormat)format2;
        indexedColorFormat2.mapSize = this.mapSize != -1 ? this.mapSize : indexedColorFormat.mapSize;
        indexedColorFormat2.redValues = this.redValues != null ? this.redValues : indexedColorFormat.redValues;
        indexedColorFormat2.greenValues = this.greenValues != null ? this.greenValues : indexedColorFormat.greenValues;
        indexedColorFormat2.blueValues = this.blueValues != null ? this.blueValues : indexedColorFormat.blueValues;
        indexedColorFormat2.lineStride = this.lineStride != -1 ? this.lineStride : indexedColorFormat.lineStride;
        return indexedColorFormat2;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof IndexedColorFormat)) {
            return true;
        }
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)format;
        return !(this.mapSize != -1 && indexedColorFormat.mapSize != -1 && this.mapSize != indexedColorFormat.mapSize || this.redValues != null && indexedColorFormat.redValues != null && !this.redValues.equals(indexedColorFormat.redValues) || this.greenValues != null && indexedColorFormat.greenValues != null && !this.greenValues.equals(indexedColorFormat.greenValues) || this.blueValues != null && indexedColorFormat.blueValues != null && !this.blueValues.equals(indexedColorFormat.blueValues) || this.lineStride != -1 && indexedColorFormat.lineStride != -1 && this.lineStride != indexedColorFormat.lineStride);
    }

    public Format relax() {
        IndexedColorFormat indexedColorFormat = (IndexedColorFormat)super.relax();
        if (indexedColorFormat == null) {
            return null;
        }
        indexedColorFormat.lineStride = -1;
        return indexedColorFormat;
    }
}

