/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;

public class Buffer {
    protected long timeStamp = -1L;
    protected long duration = -1L;
    protected Format format = null;
    protected int flags = 0;
    protected Object data = null;
    protected Object header = null;
    protected int length = 0;
    protected int offset = 0;
    protected long sequenceNumber = 0x7FFFFFFFFFFFFFFEL;
    public static final int FLAG_EOM = 1;
    public static final int FLAG_DISCARD = 2;
    public static final int FLAG_SILENCE = 4;
    public static final int FLAG_SID = 8;
    public static final int FLAG_KEY_FRAME = 16;
    public static final int FLAG_NO_DROP = 32;
    public static final int FLAG_NO_WAIT = 64;
    public static final int FLAG_NO_SYNC = 96;
    public static final int FLAG_SYSTEM_TIME = 128;
    public static final int FLAG_RELATIVE_TIME = 256;
    public static final int FLAG_FLUSH = 512;
    public static final int FLAG_SYSTEM_MARKER = 1024;
    public static final int FLAG_RTP_MARKER = 2048;
    public static final int FLAG_RTP_TIME = 4096;
    public static final int FLAG_BUF_OVERFLOWN = 8192;
    public static final int FLAG_BUF_UNDERFLOWN = 16384;
    public static final int FLAG_LIVE_DATA = 32768;
    public static final long TIME_UNKNOWN = -1L;
    public static final long SEQUENCE_UNKNOWN = 0x7FFFFFFFFFFFFFFEL;

    public Object clone() {
        Buffer buffer = new Buffer();
        Object object = this.getData();
        if (object != null) {
            buffer.data = object instanceof byte[] ? ((byte[])object).clone() : (object instanceof int[] ? ((int[])object).clone() : (object instanceof short[] ? ((short[])object).clone() : object));
        }
        if (this.header != null) {
            buffer.header = this.header instanceof byte[] ? ((byte[])this.header).clone() : (this.header instanceof int[] ? ((int[])this.header).clone() : (this.header instanceof short[] ? ((short[])this.header).clone() : this.header));
        }
        buffer.format = this.format;
        buffer.length = this.length;
        buffer.offset = this.offset;
        buffer.timeStamp = this.timeStamp;
        buffer.duration = this.duration;
        buffer.sequenceNumber = this.sequenceNumber;
        buffer.flags = this.flags;
        return buffer;
    }

    public void copy(Buffer buffer) {
        this.copy(buffer, false);
    }

    public void copy(Buffer buffer, boolean bl) {
        if (bl) {
            Object object = this.data;
            this.data = buffer.data;
            buffer.data = object;
        } else {
            this.data = buffer.data;
        }
        this.header = buffer.header;
        this.format = buffer.format;
        this.length = buffer.length;
        this.offset = buffer.offset;
        this.timeStamp = buffer.timeStamp;
        this.duration = buffer.duration;
        this.sequenceNumber = buffer.sequenceNumber;
        this.flags = buffer.flags;
    }

    public Object getData() {
        return this.data;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getFlags() {
        return this.flags;
    }

    public Format getFormat() {
        return this.format;
    }

    public Object getHeader() {
        return this.header;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isDiscard() {
        return (this.flags & 2) != 0;
    }

    public boolean isEOM() {
        return (this.flags & 1) != 0;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public void setDiscard(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setDuration(long l2) {
        this.duration = l2;
    }

    public void setEOM(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setFlags(int n2) {
        this.flags = n2;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setHeader(Object object) {
        this.header = object;
    }

    public void setLength(int n2) {
        this.length = n2;
    }

    public void setOffset(int n2) {
        this.offset = n2;
    }

    public void setSequenceNumber(long l2) {
        this.sequenceNumber = l2;
    }

    public void setTimeStamp(long l2) {
        this.timeStamp = l2;
    }
}

