/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;

public abstract class PacketFilter
implements PacketSource,
PacketConsumer {
    PacketSource source;
    PacketConsumer consumer;
    public Vector destAddressList = null;
    public Vector peerlist = null;
    public boolean control = false;

    public void close() {
    }

    public void closeConsumer() {
        this.close();
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    public void closeSource() {
        this.close();
        if (this.source != null) {
            this.source.closeSource();
        }
    }

    public String consumerString() {
        if (this.consumer == null) {
            return this.filtername();
        }
        return String.valueOf(this.filtername()) + " connected to " + this.consumer.consumerString();
    }

    public String filtername() {
        return this.getClass().getName();
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public Vector getDestList() {
        return null;
    }

    public PacketSource getSource() {
        return this.source;
    }

    public abstract Packet handlePacket(Packet var1);

    public abstract Packet handlePacket(Packet var1, int var2);

    public abstract Packet handlePacket(Packet var1, SessionAddress var2);

    public Packet receiveFrom() throws IOException {
        Packet packet = null;
        Packet packet2 = this.source.receiveFrom();
        if (packet2 != null) {
            packet = this.handlePacket(packet2);
        }
        return packet;
    }

    public void sendTo(Packet packet) throws IOException {
        Packet packet2 = packet;
        if (this.peerlist != null) {
            packet = this.handlePacket(packet2);
            int n2 = 0;
            while (n2 < this.peerlist.size()) {
                SessionAddress sessionAddress = (SessionAddress)this.peerlist.elementAt(n2);
                if (!this.control) {
                    ((UDPPacket)packet).remoteAddress = sessionAddress.getDataAddress();
                    ((UDPPacket)packet).remotePort = sessionAddress.getDataPort();
                } else {
                    ((UDPPacket)packet).remoteAddress = sessionAddress.getControlAddress();
                    ((UDPPacket)packet).remotePort = sessionAddress.getControlPort();
                }
                if (packet != null && this.consumer != null) {
                    this.consumer.sendTo(packet);
                }
                ++n2;
            }
        } else if (this.destAddressList != null) {
            int n3 = 0;
            while (n3 < this.destAddressList.size()) {
                SessionAddress sessionAddress = (SessionAddress)this.destAddressList.elementAt(n3);
                packet = this.handlePacket(packet2, sessionAddress);
                if (packet != null && this.consumer != null) {
                    this.consumer.sendTo(packet);
                }
                ++n3;
            }
        } else if (this.destAddressList == null && (packet = this.handlePacket(packet)) != null && this.consumer != null) {
            this.consumer.sendTo(packet);
        }
    }

    public void setConsumer(PacketConsumer packetConsumer) {
        this.consumer = packetConsumer;
    }

    public void setSource(PacketSource packetSource) {
        this.source = packetSource;
    }

    public String sourceString() {
        if (this.source == null) {
            return this.filtername();
        }
        return String.valueOf(this.filtername()) + " attached to " + this.source.sourceString();
    }
}

