/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLClassDescriptorResolver;

public class XMLContext {
    private XMLClassDescriptorResolver resolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);

    public XMLContext() {
        this.resolver.setClassLoader(this.getClass().getClassLoader());
    }

    public void addMapping(Mapping mapping) throws MappingException {
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
        this.resolver.setMappingLoader(mappingLoader);
    }

    public void addClass(String className) {
        this.resolver.addClass(className);
    }

    public void addClasses(String[] classNames) {
        this.resolver.addClasses(classNames);
    }

    public void addPackage(String packageName) throws ResolverException {
        this.resolver.addPackage(packageName);
    }

    public void addPackages(String[] packageNames) throws ResolverException {
        this.resolver.addPackages(packageNames);
    }

    public static Mapping createMapping() {
        Mapping mapping = new Mapping();
        return mapping;
    }

    public Marshaller createMarshaller() {
        Marshaller marshaller = new Marshaller();
        marshaller.setResolver(this.resolver);
        return marshaller;
    }

    public Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller = new Unmarshaller();
        unmarshaller.setResolver(this.resolver);
        return unmarshaller;
    }

    public void setResolver(XMLClassDescriptorResolver resolver) {
        this.resolver = resolver;
    }
}

