/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.util.Base64Encoder;
import org.castor.util.HexDecoder;
import org.castor.util.Messages;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MapHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.mapping.handlers.MapHandlers;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.SafeStack;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.MarshalListener;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.ProcessingInstruction;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.descriptors.RootArrayDescriptor;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.handlers.EnumFieldHandler;
import org.exolab.castor.xml.util.AnyNode2SAX2;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.exolab.castor.xml.util.DocumentHandlerAdapter;
import org.exolab.castor.xml.util.SAX2DOMHandler;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Marshaller
extends MarshalFramework {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$xml$Marshaller == null ? (class$org$exolab$castor$xml$Marshaller = Marshaller.class$("org.exolab.castor.xml.Marshaller")) : class$org$exolab$castor$xml$Marshaller));
    private static final String CDATA = "CDATA";
    private static final String DEFAULT_PREFIX = "ns";
    private static final String SERIALIZER_NOT_SAX_CAPABLE = "conf.serializerNotSaxCapable";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_TYPE = "xsi:type";
    private int NAMESPACE_COUNTER = 0;
    private static final StringClassDescriptor _StringClassDescriptor = new StringClassDescriptor();
    private boolean _asDocument = true;
    private XMLClassDescriptorResolver _cdResolver = null;
    int depth = 0;
    private OutputFormat _format = null;
    private ContentHandler _handler = null;
    private Configuration _config = null;
    private boolean _marshalExtendedType = true;
    private MarshalListener _marshalListener = null;
    private Namespaces _namespaces = null;
    private XMLNaming _naming = null;
    private List _packages = null;
    private Stack _parents = null;
    private List _processingInstructions = null;
    private String _rootElement = null;
    private boolean _saveMapKeys = true;
    private Serializer _serializer = null;
    private boolean _suppressNamespaces = false;
    private boolean _suppressXSIType = false;
    private boolean _useXSITypeAtRoot = false;
    private AttributeSetImpl _topLevelAtts = null;
    private AttributesImpl _attributes = null;
    private boolean _validate = false;
    static /* synthetic */ Class class$org$exolab$castor$xml$Marshaller;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$XMLClassDescriptorImpl;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public Marshaller(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        this._handler = new DocumentHandlerAdapter(handler);
        this.initialize();
    }

    public Marshaller(ContentHandler handler) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        this._handler = handler;
        this.initialize();
    }

    public Marshaller() {
        this.initialize();
    }

    public void setWriter(Writer out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument 'out' is null.");
        }
        this.configureSerializer(out);
    }

    public Marshaller(Writer out) throws IOException {
        this.initialize();
        this.setWriter(out);
    }

    private void configureSerializer(Writer out) throws IOException {
        this._serializer = this._config.getSerializer();
        if (this._serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        this._serializer.setOutputCharStream(out);
        this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
        if (this._handler == null) {
            String err = Messages.format(SERIALIZER_NOT_SAX_CAPABLE, this._serializer.getClass().getName());
            throw new RuntimeException(err);
        }
    }

    public Marshaller(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 'node' is null.");
        }
        this._handler = new DocumentHandlerAdapter(new SAX2DOMHandler(node));
        this.initialize();
    }

    private void initialize() {
        this._config = LocalConfiguration.getInstance();
        this._namespaces = new Namespaces();
        this._packages = new ArrayList(3);
        this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
        this._parents = new SafeStack();
        this._validate = this._config.marshallingValidation();
        this._naming = XMLNaming.getInstance();
        this._processingInstructions = new ArrayList(3);
        this._attributes = new AttributesImpl();
        this._topLevelAtts = new AttributeSetImpl();
        String val = this._config.getProperty("org.exolab.castor.xml.saveMapKeys", "true");
        if ("false".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            this._saveMapKeys = false;
        }
    }

    public void addProcessingInstruction(String target, String data) {
        if (target == null || target.length() == 0) {
            String err = "the argument 'target' must not be null or empty.";
            throw new IllegalArgumentException(err);
        }
        if (data == null) {
            String err = "the argument 'data' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._processingInstructions.add(new ProcessingInstruction(target, data));
    }

    public void setDoctype(String publicId, String systemId) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this._config.getOutputFormat();
            }
            this._format.setDoctype(publicId, systemId);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
            }
            catch (IOException iox) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error setting up document handler", (Throwable)iox);
                }
            }
        } else {
            String error = "doctype cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
    }

    public void setSupressXMLDeclaration(boolean supressXMLDeclaration) {
        this.setMarshalAsDocument(!supressXMLDeclaration);
    }

    public void setMarshalAsDocument(boolean asDocument) {
        block4: {
            this._asDocument = asDocument;
            if (this._serializer != null) {
                if (this._format == null) {
                    this._format = this._config.getOutputFormat();
                }
                this._format.setOmitXMLDeclaration(!asDocument);
                this._format.setOmitDocumentType(!asDocument);
                this._serializer.setOutputFormat(this._format);
                try {
                    this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
                }
                catch (IOException iox) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Error setting up document handler", (Throwable)iox);
                }
            }
        }
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._cdResolver == null) {
            this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
        }
        MappingUnmarshaller mum = new MappingUnmarshaller();
        MappingLoader resolver = mum.getMappingLoader(mapping, BindingType.XML);
        this._cdResolver.setMappingLoader(resolver);
    }

    public void setMarshalListener(MarshalListener listener) {
        this._marshalListener = listener;
    }

    public void setNamespaceMapping(String nsPrefix, String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            String err = "namespace URI must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._namespaces.addNamespace(nsPrefix, nsURI);
    }

    public void setRootElement(String rootElement) {
        this._rootElement = rootElement;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public void setNSPrefixAtRoot(boolean nsPrefixAtRoot) {
    }

    public boolean getNSPrefixAtRoot() {
        return true;
    }

    public ClassDescriptorResolver getResolver() {
        if (this._cdResolver == null) {
            this._cdResolver = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
        }
        return this._cdResolver;
    }

    public void setResolver(XMLClassDescriptorResolver cdr) {
        if (cdr != null) {
            this._cdResolver = cdr;
        }
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setMarshalExtendedType(boolean marshalExtendedType) {
        this._marshalExtendedType = marshalExtendedType;
    }

    public boolean getMarshalExtendedType() {
        return this._marshalExtendedType;
    }

    public static void marshal(Object object, Writer out) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        LOG.debug((Object)"- Marshaller called using *static* marshal(Object, Writer)");
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.marshal(object);
        }
        catch (IOException except) {
            throw new MarshalException(except);
        }
    }

    public static void marshal(Object object, DocumentHandler handler) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        LOG.debug((Object)"- Marshaller called using *static* marshal(Object, DocumentHandler)");
        Marshaller marshaller = new Marshaller(handler);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, ContentHandler handler) throws MarshalException, ValidationException, IOException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        LOG.debug((Object)"- Marshaller called using *static* marshal(Object, ContentHandler)");
        Marshaller marshaller = new Marshaller(handler);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, Node node) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        LOG.debug((Object)"- Marshaller called using *static* marshal(Object, Node)");
        Marshaller marshaller = new Marshaller(node);
        marshaller.marshal(object);
    }

    public void marshal(Object object) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Marshalling " + object.getClass().getName()));
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX2.fireEvents((AnyNode)object, this._handler, this._namespaces);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
        } else {
            this.validate(object);
            MarshalState mstate = new MarshalState(object, "root");
            if (this._asDocument) {
                try {
                    this._handler.startDocument();
                    for (int i = 0; i < this._processingInstructions.size(); ++i) {
                        ProcessingInstruction pi = (ProcessingInstruction)this._processingInstructions.get(i);
                        this._handler.processingInstruction(pi.getTarget(), pi.getData());
                    }
                    this.marshal(object, null, this._handler, mstate);
                    this._handler.endDocument();
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            } else {
                this.marshal(object, null, this._handler, mstate);
            }
        }
    }

    private void marshal(Object object, XMLFieldDescriptor descriptor, ContentHandler handler, MarshalState mstate) throws MarshalException, ValidationException {
        String elemName;
        String valueType;
        String attValue;
        int i;
        if (object == null) {
            String err = "Marshaller#marshal: null parameter: 'object'";
            throw new MarshalException(err);
        }
        if (descriptor != null && descriptor.isTransient()) {
            return;
        }
        if (this._marshalListener != null && !this._marshalListener.preMarshal(object)) {
            return;
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX2.fireEvents((AnyNode)object, handler, this._namespaces);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
            return;
        }
        boolean containerField = false;
        if (descriptor != null && descriptor.isContainer()) {
            containerField = true;
        }
        if (this._parents.search(object) >= 0) {
            return;
        }
        this._parents.push(object);
        boolean isNil = object instanceof NilObject;
        Class _class = null;
        _class = !isNil ? object.getClass() : ((NilObject)object).getClassDescriptor().getJavaClass();
        boolean byteArray = false;
        if (_class.isArray()) {
            byteArray = _class.getComponentType() == Byte.TYPE;
        }
        boolean atRoot = false;
        if (descriptor == null) {
            descriptor = new XMLFieldDescriptorImpl(_class, "root", null, null);
            atRoot = true;
        }
        String name = descriptor.getXMLName();
        if (atRoot && this._rootElement != null) {
            name = this._rootElement;
        }
        boolean autoNameByClass = false;
        if (name == null) {
            autoNameByClass = true;
            name = _class.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            name = this._naming.toXMLName(name);
        }
        XMLClassDescriptor classDesc = null;
        boolean saveType = false;
        if (object instanceof NilObject) {
            classDesc = ((NilObject)object).getClassDescriptor();
        } else if (_class == descriptor.getFieldType()) {
            classDesc = (XMLClassDescriptor)descriptor.getClassDescriptor();
        }
        if (classDesc == null) {
            if (Marshaller.isPrimitive(_class) || byteArray) {
                classDesc = _StringClassDescriptor;
                Class<?> fieldType = descriptor.getFieldType();
                if (_class != fieldType) {
                    while (fieldType.isArray()) {
                        fieldType = fieldType.getComponentType();
                    }
                    saveType = !Marshaller.primitiveOrWrapperEquals(_class, fieldType);
                }
            } else {
                saveType = _class.isArray();
                String className = _class.getName();
                int idx = className.lastIndexOf(".");
                String pkgName = null;
                if (idx > 0 && !this._packages.contains(pkgName = className.substring(0, idx + 1))) {
                    this._packages.add(pkgName);
                }
                if (this._marshalExtendedType) {
                    if (_class != descriptor.getFieldType() || atRoot) {
                        saveType = true;
                        boolean containsDesc = false;
                        if (!atRoot) {
                            Class tmpType;
                            XMLClassDescriptor tmpDesc;
                            block204: {
                                String nsURI = descriptor.getNameSpaceURI();
                                tmpDesc = null;
                                try {
                                    tmpDesc = this._cdResolver.resolveByXMLName(name, nsURI, null);
                                }
                                catch (ResolverException rx) {
                                    if (!LOG.isDebugEnabled()) break block204;
                                    LOG.debug((Object)"Error resolving", (Throwable)rx);
                                }
                            }
                            if (tmpDesc != null && (tmpType = tmpDesc.getJavaClass()) == _class) {
                                boolean bl = containsDesc = !tmpType.isInterface();
                            }
                        }
                        if (!containsDesc) {
                            String tmpName;
                            if (atRoot) {
                                if (this._useXSITypeAtRoot) {
                                    XMLMappingLoader ml = (XMLMappingLoader)this._cdResolver.getMappingLoader();
                                    if (ml != null) {
                                        containsDesc = ml.getDescriptor(_class.getName()) != null;
                                    }
                                } else {
                                    containsDesc = true;
                                }
                            }
                            if (!containsDesc && pkgName == null && (classDesc = this.getClassDescriptor(_class)) != null && name.equals(tmpName = classDesc.getXMLName())) {
                                saveType = false;
                            }
                        }
                        if (containsDesc) {
                            saveType = false;
                        }
                    }
                    if (classDesc == null) {
                        classDesc = this.getClassDescriptor(_class);
                    }
                } else {
                    _class = descriptor.getFieldType();
                    classDesc = this.getClassDescriptor(_class);
                }
                if (classDesc == null && _class.isArray()) {
                    classDesc = new RootArrayDescriptor(_class);
                    if (atRoot) {
                        boolean bl = containerField = !this._asDocument;
                    }
                }
            }
            if (classDesc == null) {
                if (_class == (class$java$lang$Void == null ? (class$java$lang$Void = Marshaller.class$("java.lang.Void")) : class$java$lang$Void) || _class == (class$java$lang$Object == null ? (class$java$lang$Object = Marshaller.class$("java.lang.Object")) : class$java$lang$Object) || _class == (class$java$lang$Class == null ? (class$java$lang$Class = Marshaller.class$("java.lang.Class")) : class$java$lang$Class)) {
                    throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
                }
                this._parents.pop();
                return;
            }
        }
        if (autoNameByClass && classDesc.getXMLName() != null) {
            name = classDesc.getXMLName();
        }
        if (atRoot) {
            mstate._xmlName = name;
        }
        boolean bl = saveType = saveType && !this._suppressXSIType;
        if (saveType) {
            if (descriptor.getHandler() instanceof DateFieldHandler) {
                saveType = false;
            } else if (descriptor.getHandler() instanceof EnumFieldHandler) {
                saveType = false;
            } else if (isNil) {
                saveType = false;
            }
        }
        if (saveType) {
            XMLClassDescriptor xmlElementNameClassDesc;
            String xmlNamespace;
            String xmlElementName;
            block205: {
                xmlElementName = name;
                xmlNamespace = descriptor.getNameSpaceURI();
                xmlElementNameClassDesc = null;
                try {
                    xmlElementNameClassDesc = this._cdResolver.resolveByXMLName(xmlElementName, null, null);
                }
                catch (ResolverException rx) {
                    if (!LOG.isDebugEnabled()) break block205;
                    LOG.debug((Object)("Error resolving " + xmlElementName), (Throwable)rx);
                }
            }
            if (xmlElementName != null && xmlElementNameClassDesc != null) {
                XMLClassDescriptor tempContaining;
                try {
                    Iterator classDescriptorIter = this._cdResolver.resolveAllByXMLName(xmlElementName, null, null);
                    while (classDescriptorIter.hasNext() && _class != (xmlElementNameClassDesc = (XMLClassDescriptor)classDescriptorIter.next()).getJavaClass()) {
                        xmlElementNameClassDesc = null;
                    }
                }
                catch (ResolverException rx) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Error resolving " + xmlElementName), (Throwable)rx);
                    }
                    xmlElementNameClassDesc = null;
                }
                if (xmlElementNameClassDesc instanceof XMLClassDescriptorAdapter && (tempContaining = (XMLClassDescriptor)descriptor.getContainingClassDescriptor()) != null) {
                    XMLFieldDescriptor fieldDescMatch = tempContaining.getFieldDescriptor(xmlElementName, xmlNamespace, NodeType.Element);
                    MarshalFramework.InheritanceMatch[] matches = Marshaller.searchInheritance(xmlElementName, null, tempContaining, this._cdResolver);
                    if (matches.length == 1) {
                        boolean oneAndOnlyOneMatchedField;
                        boolean foundTheRightClass = xmlElementNameClassDesc != null && _class == xmlElementNameClassDesc.getJavaClass();
                        boolean bl2 = oneAndOnlyOneMatchedField = fieldDescMatch != null || matches[0].parentFieldDesc == descriptor;
                        if (foundTheRightClass && oneAndOnlyOneMatchedField) {
                            saveType = false;
                        }
                    }
                }
            }
        }
        if (!atRoot) {
            this._namespaces = this._namespaces.createNamespaces();
        }
        String nsPrefix = "";
        String nsURI = "";
        if (!this._suppressNamespaces) {
            String defaultNamespace;
            nsPrefix = descriptor.getNameSpacePrefix();
            if (nsPrefix == null) {
                nsPrefix = classDesc.getNameSpacePrefix();
            }
            if ((nsURI = descriptor.getNameSpaceURI()) == null) {
                nsURI = classDesc.getNameSpaceURI();
            }
            if (nsURI == null && nsPrefix != null) {
                nsURI = this._namespaces.getNamespaceURI(nsPrefix);
            } else if (nsPrefix == null && nsURI != null) {
                nsPrefix = this._namespaces.getNamespacePrefix(nsURI);
            }
            if (nsURI != null) {
                defaultNamespace = this._namespaces.getNamespaceURI("");
                if (nsPrefix == null && !nsURI.equals(defaultNamespace)) {
                    nsPrefix = defaultNamespace == null && atRoot ? "" : DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
                }
                this.declareNamespace(nsPrefix, nsURI);
            } else {
                nsURI = "";
                defaultNamespace = this._namespaces.getNamespaceURI("");
                if (defaultNamespace != null && !"".equals(defaultNamespace)) {
                    this._namespaces.addNamespace("", "");
                }
            }
        }
        AttributesImpl atts = new AttributesImpl();
        if (atRoot) {
            if (this._topLevelAtts.getSize() > 0) {
                this._namespaces.addNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            }
            for (int i2 = 0; i2 < this._topLevelAtts.getSize(); ++i2) {
                String localName;
                String qName = localName = this._topLevelAtts.getName(i2);
                String ns = "";
                if (!this._suppressNamespaces) {
                    ns = this._topLevelAtts.getNamespace(i2);
                    String prefix = null;
                    if (ns != null && ns.length() > 0) {
                        prefix = this._namespaces.getNonDefaultNamespacePrefix(ns);
                    }
                    if (prefix != null && prefix.length() > 0) {
                        qName = prefix + ':' + qName;
                    }
                    if (ns == null) {
                        ns = "";
                    }
                }
                atts.addAttribute(ns, localName, qName, CDATA, this._topLevelAtts.getValue(i2));
            }
        }
        int nestedAttCount = 0;
        XMLFieldDescriptor[] nestedAtts = null;
        XMLFieldDescriptor[] descriptors = null;
        descriptors = !descriptor.isReference() && !isNil ? classDesc.getAttributeDescriptors() : NO_FIELD_DESCRIPTORS;
        for (i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] == null) continue;
            String path = descriptors[i].getLocationPath();
            if (path != null && path.length() > 0) {
                if (nestedAtts == null) {
                    nestedAtts = new XMLFieldDescriptor[descriptors.length - i];
                }
                nestedAtts[nestedAttCount++] = descriptors[i];
                continue;
            }
            this.processAttribute(object, descriptors[i], atts);
        }
        if (mstate.nestedAttCount > 0) {
            for (i = 0; i < mstate.nestedAtts.length; ++i) {
                String path;
                XMLFieldDescriptor attDesc = mstate.nestedAtts[i];
                if (attDesc == null || !name.equals(path = attDesc.getLocationPath())) continue;
                mstate.nestedAtts[i] = null;
                mstate.nestedAttCount = 0;
                this.processAttribute(mstate.getOwner(), attDesc, atts);
            }
        }
        if (!isNil) {
            this.processContainerAttributes(object, classDesc, atts);
        }
        if ((attValue = descriptor.getProperty("xml:space")) != null) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", CDATA, attValue);
        }
        if ((attValue = descriptor.getProperty("xml:lang")) != null) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", CDATA, attValue);
        }
        if (saveType) {
            this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            String typeName = classDesc.getXMLName();
            boolean introspected = false;
            introspected = classDesc instanceof MarshalFramework.InternalXMLClassDescriptor ? ((MarshalFramework.InternalXMLClassDescriptor)classDesc).introspected() : Introspector.introspected(classDesc);
            if (typeName == null || introspected) {
                typeName = "java:" + _class.getName();
            } else if (classDesc instanceof RootArrayDescriptor) {
                typeName = "java:" + _class.getName();
            } else {
                String dcn = classDesc.getClass().getName();
                if (dcn.equals((class$org$exolab$castor$xml$util$XMLClassDescriptorImpl == null ? (class$org$exolab$castor$xml$util$XMLClassDescriptorImpl = Marshaller.class$("org.exolab.castor.xml.util.XMLClassDescriptorImpl")) : class$org$exolab$castor$xml$util$XMLClassDescriptorImpl).getName())) {
                    typeName = "java:" + _class.getName();
                } else {
                    String tns = classDesc.getNameSpaceURI();
                    String prefix = null;
                    if (tns != null && tns.length() > 0 && (prefix = this._namespaces.getNamespacePrefix(tns)) != null && prefix.length() > 0) {
                        typeName = prefix + ':' + typeName;
                    }
                }
            }
            atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", XSI_TYPE, CDATA, typeName);
        }
        if (isNil) {
            this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", CDATA, "true");
        }
        if ((valueType = descriptor.getSchemaType()) != null && valueType.equals("QName")) {
            object = this.resolveQName(object, descriptor);
        }
        String qName = null;
        if (nsPrefix != null) {
            int len = nsPrefix.length();
            if (len > 0) {
                StringBuffer sb = new StringBuffer(len + name.length() + 1);
                sb.append(nsPrefix);
                sb.append(':');
                sb.append(name);
                qName = sb.toString();
            } else {
                qName = name;
            }
        } else {
            qName = name;
        }
        Object firstNonNullValue = null;
        int firstNonNullIdx = 0;
        try {
            if (!containerField) {
                if (!isNil && descriptor.isNillable()) {
                    boolean isNilContent;
                    XMLFieldDescriptor desc = classDesc.getContentDescriptor();
                    descriptors = classDesc.getElementDescriptors();
                    int descCount = descriptors.length;
                    boolean bl3 = isNilContent = descCount > 0 || desc != null;
                    if (desc != null) {
                        Object value = desc.getHandler().getValue(object);
                        if (value != null) {
                            isNilContent = false;
                            descCount = 0;
                        } else if (desc.isNillable() && desc.isRequired()) {
                            isNilContent = false;
                            descCount = 0;
                        }
                    }
                    for (int i3 = 0; i3 < descCount; ++i3) {
                        desc = descriptors[i3];
                        if (desc == null) continue;
                        Object value = desc.getHandler().getValue(object);
                        if (value != null) {
                            isNilContent = false;
                            firstNonNullIdx = i3;
                            firstNonNullValue = value;
                            break;
                        }
                        if (!desc.isNillable() || !desc.isRequired()) continue;
                        isNilContent = false;
                        firstNonNullIdx = i3;
                        firstNonNullValue = new NilObject(classDesc, desc);
                        break;
                    }
                    if (isNilContent) {
                        this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
                        atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", CDATA, "true");
                    }
                }
                this._namespaces.sendStartEvents(handler);
                if (qName == null) {
                    String err = "Error in deriving name for type: " + _class.getName() + ", please report bug to: " + "http://castor.exolab.org.";
                    throw new IllegalStateException(err);
                }
                handler.startElement(nsURI, name, qName, atts);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        Stack wrappers = null;
        if (!isNil) {
            XMLFieldDescriptor cdesc = null;
            if (!descriptor.isReference()) {
                cdesc = classDesc.getContentDescriptor();
            }
            if (cdesc != null) {
                Object obj = null;
                try {
                    obj = cdesc.getHandler().getValue(object);
                }
                catch (IllegalStateException ise) {
                    LOG.warn((Object)("Error getting value from: " + object), (Throwable)ise);
                }
                if (obj != null) {
                    String path = cdesc.getLocationPath();
                    String currentLoc = null;
                    if (path != null) {
                        this._attributes.clear();
                        if (wrappers == null) {
                            wrappers = new SafeStack();
                        }
                        try {
                            while (path != null) {
                                elemName = null;
                                int idx = path.indexOf(47);
                                if (idx > 0) {
                                    elemName = path.substring(0, idx);
                                    path = path.substring(idx + 1);
                                } else {
                                    elemName = path;
                                    path = null;
                                }
                                currentLoc = currentLoc == null ? elemName : currentLoc + "/" + elemName;
                                String elemQName = elemName;
                                if (nsPrefix != null && nsPrefix.length() > 0) {
                                    elemQName = nsPrefix + ':' + elemName;
                                }
                                wrappers.push(new WrapperInfo(elemName, elemQName, currentLoc));
                                this._attributes.clear();
                                if (nestedAttCount > 0) {
                                    for (int na = 0; na < nestedAtts.length; ++na) {
                                        String tmpPath;
                                        if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                        this.processAttribute(object, nestedAtts[na], this._attributes);
                                        nestedAtts[na] = null;
                                        --nestedAttCount;
                                    }
                                }
                                handler.startElement(nsURI, elemName, elemQName, this._attributes);
                            }
                        }
                        catch (SAXException sx) {
                            throw new MarshalException(sx);
                        }
                    }
                    char[] chars = null;
                    Class<?> objType = obj.getClass();
                    if (objType.isArray() && objType.getComponentType() == Byte.TYPE) {
                        String schemaType = descriptor.getSchemaType();
                        chars = "hexBinary".equals(schemaType) ? new String(HexDecoder.encode((byte[])obj)).toCharArray() : Base64Encoder.encode((byte[])obj);
                    } else {
                        String str = obj.toString();
                        if (str != null && str.length() > 0) {
                            chars = str.toCharArray();
                        }
                    }
                    if (chars != null && chars.length > 0) {
                        try {
                            handler.characters(chars, 0, chars.length);
                        }
                        catch (SAXException sx) {
                            throw new MarshalException(sx);
                        }
                    }
                }
            } else if (descriptor.isReference()) {
                Object id = this.getObjectID(object);
                if (id != null) {
                    char[] chars = id.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
            } else {
                if (byteArray) {
                    String schemaType = descriptor.getSchemaType();
                    char[] chars = new char[]{};
                    chars = "hexBinary".equals(schemaType) ? new String(HexDecoder.encode((byte[])object)).toCharArray() : Base64Encoder.encode((byte[])object);
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
                if (Marshaller.isPrimitive(_class)) {
                    char[] chars = _class == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Marshaller.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) ? this.convertBigDecimalToString(object).toCharArray() : object.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
                if (Marshaller.isEnum(_class)) {
                    char[] chars = object.toString().toCharArray();
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
            }
        }
        descriptors = isNil || descriptor.isReference() ? NO_FIELD_DESCRIPTORS : classDesc.getElementDescriptors();
        ++this.depth;
        for (int i4 = firstNonNullIdx; i4 < descriptors.length; ++i4) {
            XMLFieldDescriptor elemDescriptor = descriptors[i4];
            Object obj = null;
            boolean nil = false;
            if (i4 == firstNonNullIdx && firstNonNullValue != null) {
                obj = firstNonNullValue;
            } else {
                try {
                    obj = elemDescriptor.getHandler().getValue(object);
                }
                catch (IllegalStateException ise) {
                    LOG.warn((Object)("Error marshalling " + object), (Throwable)ise);
                    continue;
                }
            }
            if (obj == null || obj instanceof Enumeration && !((Enumeration)obj).hasMoreElements()) {
                if (!elemDescriptor.isNillable() || !elemDescriptor.isRequired()) continue;
                nil = true;
            }
            String path = elemDescriptor.getLocationPath();
            String currentLoc = null;
            if (wrappers != null) {
                try {
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = (WrapperInfo)wrappers.peek();
                        if (path != null) {
                            if (wInfo.location.equals(path)) {
                                path = null;
                                break;
                            }
                            if (path.startsWith(wInfo.location + "/")) {
                                path = path.substring(wInfo.location.length() + 1);
                                currentLoc = wInfo.location;
                                break;
                            }
                        }
                        handler.endElement(nsURI, wInfo.localName, wInfo.qName);
                        wrappers.pop();
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (path != null) {
                this._attributes.clear();
                if (wrappers == null) {
                    wrappers = new SafeStack();
                }
                try {
                    while (path != null) {
                        String elemName2 = null;
                        int idx = path.indexOf(47);
                        if (idx > 0) {
                            elemName2 = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName2 = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName2 : currentLoc + "/" + elemName2;
                        String elemQName = elemName2;
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            elemQName = nsPrefix + ':' + elemName2;
                        }
                        wrappers.push(new WrapperInfo(elemName2, elemQName, currentLoc));
                        this._attributes.clear();
                        if (nestedAttCount > 0) {
                            for (int na = 0; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(nsURI, elemName2, elemQName, this._attributes);
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (nil) {
                obj = new NilObject(classDesc, elemDescriptor);
            }
            Class<?> type = obj.getClass();
            MarshalState myState = mstate.createMarshalState(object, name);
            myState.nestedAtts = nestedAtts;
            myState.nestedAttCount = nestedAttCount;
            if (type.isArray() && type.getComponentType() == Byte.TYPE) {
                this.marshal(obj, elemDescriptor, handler, myState);
            } else if (Marshaller.isCollection(type)) {
                MapHandler mapHandler;
                boolean processCollection = true;
                if (this._saveMapKeys && (mapHandler = MapHandlers.getHandler(type)) != null) {
                    processCollection = false;
                    MapItem item = new MapItem();
                    Enumeration keys = mapHandler.keys(obj);
                    while (keys.hasMoreElements()) {
                        item.setKey(keys.nextElement());
                        item.setValue(mapHandler.get(obj, item.getKey()));
                        this.marshal(item, elemDescriptor, handler, myState);
                    }
                }
                if (processCollection) {
                    CollectionHandler colHandler = this.getCollectionHandler(type);
                    Enumeration enumeration = colHandler.elements(obj);
                    while (enumeration.hasMoreElements()) {
                        Object item = enumeration.nextElement();
                        if (item == null) continue;
                        this.marshal(item, elemDescriptor, handler, myState);
                    }
                }
            } else {
                this.marshal(obj, elemDescriptor, handler, myState);
            }
            if (nestedAttCount <= 0) continue;
            nestedAttCount = myState.nestedAttCount;
        }
        if (wrappers != null) {
            try {
                while (!wrappers.empty()) {
                    WrapperInfo wInfo = (WrapperInfo)wrappers.pop();
                    handler.endElement(nsURI, wInfo.localName, wInfo.qName);
                }
            }
            catch (SAXException sx) {
                throw new MarshalException(sx);
            }
        }
        if (nestedAttCount > 0) {
            if (wrappers == null) {
                wrappers = new SafeStack();
            }
            for (int i5 = 0; i5 < nestedAtts.length; ++i5) {
                if (nestedAtts[i5] == null) continue;
                String path = nestedAtts[i5].getLocationPath();
                if (nestedAtts[i5].getHandler().getValue(object) == null) {
                    nestedAtts[i5] = null;
                    --nestedAttCount;
                    continue;
                }
                String currentLoc = null;
                try {
                    while (path != null) {
                        int idx = path.indexOf(47);
                        elemName = null;
                        if (idx > 0) {
                            elemName = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName : currentLoc + "/" + elemName;
                        String elemQName = elemName;
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            elemQName = nsPrefix + ':' + elemName;
                        }
                        wrappers.push(new WrapperInfo(elemName, elemQName, null));
                        this._attributes.clear();
                        if (path == null) {
                            this.processAttribute(object, nestedAtts[i5], this._attributes);
                            nestedAtts[i5] = null;
                            --nestedAttCount;
                        }
                        if (nestedAttCount > 0) {
                            for (int na = i5 + 1; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(nsURI, elemName, elemQName, this._attributes);
                    }
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = (WrapperInfo)wrappers.pop();
                        handler.endElement(nsURI, wInfo.localName, wInfo.qName);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new MarshalException(e);
                }
            }
        }
        try {
            if (!containerField) {
                handler.endElement(nsURI, name, qName);
                this._namespaces.sendEndEvents(handler);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        --this.depth;
        this._parents.pop();
        if (!atRoot) {
            this._namespaces = this._namespaces.getParent();
        }
        if (this._marshalListener != null) {
            this._marshalListener.postMarshal(object);
        }
    }

    private String convertBigDecimalToString(Object object) throws MarshalException {
        String stringValue;
        float javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if ((double)javaVersion >= 1.5) {
            try {
                Method method = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Marshaller.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("toPlainString", null);
                stringValue = (String)method.invoke(object, (Object[])null);
            }
            catch (Exception e) {
                LOG.error((Object)"Problem accessing java.math.BigDecimal.toPlainString().", (Throwable)e);
                throw new MarshalException("Problem accessing java.math.BigDecimal.toPlainString().", e);
            }
        } else {
            stringValue = object.toString();
        }
        return stringValue;
    }

    private Object getObjectID(Object object) throws MarshalException {
        if (object == null) {
            return null;
        }
        Object id = null;
        XMLClassDescriptor cd = this.getClassDescriptor(object.getClass());
        String err = null;
        if (cd != null) {
            XMLFieldDescriptor fieldDesc = (XMLFieldDescriptor)cd.getIdentity();
            if (fieldDesc != null) {
                FieldHandler fieldHandler = fieldDesc.getHandler();
                if (fieldHandler != null) {
                    try {
                        id = fieldHandler.getValue(object);
                    }
                    catch (IllegalStateException ise) {
                        err = ise.toString();
                    }
                } else {
                    err = "FieldHandler for Identity descriptor is null.";
                }
            } else {
                err = "No identity descriptor available";
            }
        } else {
            err = "Unable to resolve ClassDescriptor.";
        }
        if (err != null) {
            String errMsg = "Unable to resolve ID for instance of class '";
            errMsg = errMsg + object.getClass().getName();
            errMsg = errMsg + "' due to the following error: ";
            throw new MarshalException(errMsg + err);
        }
        return id;
    }

    private boolean declareNamespace(String nsPrefix, String nsURI) {
        boolean declared = false;
        if (nsURI != null && nsURI.length() != 0) {
            String tmpURI = this._namespaces.getNamespaceURI(nsPrefix);
            if (tmpURI != null && tmpURI.equals(nsURI)) {
                return declared;
            }
            String tmpPrefix = this._namespaces.getNamespacePrefix(nsURI);
            if (tmpPrefix == null || !tmpPrefix.equals(nsPrefix)) {
                this._namespaces.addNamespace(nsPrefix, nsURI);
                declared = true;
            }
        }
        return declared;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public void setEncoding(String encoding) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this._config.getOutputFormat();
            }
            this._format.setEncoding(encoding);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = new DocumentHandlerAdapter(this._serializer.asDocumentHandler());
            }
            catch (IOException iox) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error setting encoding to " + encoding), (Throwable)iox);
                }
            }
        } else {
            String error = "encoding cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("noNamespaceSchemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("schemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSuppressNamespaces(boolean suppressNamespaces) {
        this._suppressNamespaces = suppressNamespaces;
    }

    public void setSuppressXSIType(boolean suppressXSIType) {
        this._suppressXSIType = suppressXSIType;
    }

    public void setUseXSITypeAtRoot(boolean useXSITypeAtRoot) {
        this._useXSITypeAtRoot = useXSITypeAtRoot;
    }

    private XMLClassDescriptor getClassDescriptor(Class _class) throws MarshalException {
        XMLClassDescriptor classDesc = null;
        try {
            if (!Marshaller.isPrimitive(_class)) {
                classDesc = (XMLClassDescriptor)this._cdResolver.resolve(_class);
            }
        }
        catch (ResolverException rx) {
            Throwable actual = rx.getCause();
            if (actual instanceof MarshalException) {
                throw (MarshalException)actual;
            }
            if (actual != null) {
                throw new MarshalException(actual);
            }
            throw new MarshalException(rx);
        }
        if (classDesc != null) {
            classDesc = new MarshalFramework.InternalXMLClassDescriptor(classDesc);
        }
        return classDesc;
    }

    private void processAttribute(Object object, XMLFieldDescriptor attDescriptor, AttributesImpl atts) throws MarshalException {
        Class<?> objType;
        Enumeration enumeration;
        String localName;
        if (attDescriptor == null) {
            return;
        }
        if (attDescriptor.getNodeType() == NodeType.Namespace) {
            Object map;
            MapHandler mapHandler;
            if (!this._suppressNamespaces && (mapHandler = MapHandlers.getHandler(map = attDescriptor.getHandler().getValue(object))) != null) {
                Enumeration keys = mapHandler.keys(map);
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object val = mapHandler.get(map, key);
                    this.declareNamespace(key.toString(), val.toString());
                }
            }
            return;
        }
        String qName = localName = attDescriptor.getXMLName();
        String namespace = "";
        if (!this._suppressNamespaces) {
            namespace = attDescriptor.getNameSpaceURI();
            if (namespace != null && namespace.length() > 0) {
                String prefix = attDescriptor.getNameSpacePrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = this._namespaces.getNonDefaultNamespacePrefix(namespace);
                }
                if (prefix == null || prefix.length() == 0) {
                    prefix = DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
                }
                this.declareNamespace(prefix, namespace);
                qName = prefix + ':' + qName;
            } else {
                namespace = "";
            }
        }
        Object value = null;
        try {
            value = attDescriptor.getHandler().getValue(object);
        }
        catch (IllegalStateException ise) {
            LOG.warn((Object)("Error getting value from " + object), (Throwable)ise);
            return;
        }
        if (attDescriptor.isReference() && value != null) {
            if (attDescriptor.isMultivalued()) {
                enumeration = null;
                if (value instanceof Enumeration) {
                    enumeration = (Enumeration)value;
                } else {
                    CollectionHandler colHandler = null;
                    try {
                        colHandler = CollectionHandlers.getHandler(value.getClass());
                    }
                    catch (MappingException mx) {
                        throw new MarshalException(mx);
                    }
                    enumeration = colHandler.elements(value);
                }
                if (enumeration.hasMoreElements()) {
                    StringBuffer sb = new StringBuffer();
                    int v = 0;
                    while (enumeration.hasMoreElements()) {
                        if (v > 0) {
                            sb.append(' ');
                        }
                        sb.append(this.getObjectID(enumeration.nextElement()).toString());
                        ++v;
                    }
                    value = sb;
                } else {
                    value = null;
                }
            } else {
                value = this.getObjectID(value);
            }
        } else if (attDescriptor.isMultivalued() && value != null) {
            enumeration = null;
            if (value instanceof Enumeration) {
                enumeration = (Enumeration)value;
            } else {
                CollectionHandler colHandler = null;
                try {
                    colHandler = CollectionHandlers.getHandler(value.getClass());
                }
                catch (MappingException mx) {
                    throw new MarshalException(mx);
                }
                enumeration = colHandler.elements(value);
            }
            if (enumeration.hasMoreElements()) {
                StringBuffer sb = new StringBuffer();
                int v = 0;
                while (enumeration.hasMoreElements()) {
                    if (v > 0) {
                        sb.append(' ');
                    }
                    sb.append(enumeration.nextElement().toString());
                    ++v;
                }
                value = sb;
            } else {
                value = null;
            }
        } else if (value != null && (objType = value.getClass()).isArray() && objType.getComponentType() == Byte.TYPE) {
            String schemaType = attDescriptor.getSchemaType();
            value = "hexBinary".equals(schemaType) ? new String(HexDecoder.encode((byte[])value)) : new String(Base64Encoder.encode((byte[])value));
        }
        if (value != null) {
            String valueType = attDescriptor.getSchemaType();
            if (valueType != null && valueType.equals("QName")) {
                value = this.resolveQName(value, attDescriptor);
            }
            atts.addAttribute(namespace, localName, qName, CDATA, value.toString());
        }
    }

    private void processContainerAttributes(Object target, XMLClassDescriptor classDesc, AttributesImpl atts) throws MarshalException {
        if (classDesc instanceof XMLClassDescriptorImpl && !((XMLClassDescriptorImpl)classDesc).hasContainerFields()) {
            return;
        }
        XMLFieldDescriptor[] elemDescriptors = classDesc.getElementDescriptors();
        for (int i = 0; i < elemDescriptors.length; ++i) {
            if (elemDescriptors[i] == null || !elemDescriptors[i].isContainer()) continue;
            this.processContainerAttributes(target, elemDescriptors[i], atts);
        }
    }

    private void processContainerAttributes(Object target, XMLFieldDescriptor containerFieldDesc, AttributesImpl atts) throws MarshalException {
        if (target.getClass().isArray()) {
            int length = Array.getLength(target);
            for (int j = 0; j < length; ++j) {
                Object item = Array.get(target, j);
                if (item == null) continue;
                this.processContainerAttributes(item, containerFieldDesc, atts);
            }
            return;
        }
        if (target instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)target;
            while (enumeration.hasMoreElements()) {
                Object item = enumeration.nextElement();
                if (item == null) continue;
                this.processContainerAttributes(item, containerFieldDesc, atts);
            }
            return;
        }
        Object containerObject = containerFieldDesc.getHandler().getValue(target);
        if (containerObject == null) {
            return;
        }
        XMLClassDescriptor containerClassDesc = (XMLClassDescriptor)containerFieldDesc.getClassDescriptor();
        if (containerClassDesc == null && (containerClassDesc = this.getClassDescriptor(containerFieldDesc.getFieldType())) == null) {
            return;
        }
        XMLFieldDescriptor[] attrDescriptors = containerClassDesc.getAttributeDescriptors();
        for (int idx = 0; idx < attrDescriptors.length; ++idx) {
            if (attrDescriptors[idx] == null) continue;
            this.processAttribute(containerObject, attrDescriptors[idx], atts);
        }
        this.processContainerAttributes(containerObject, containerClassDesc, atts);
    }

    private Object resolveQName(Object value, XMLFieldDescriptor fieldDesc) {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        if (!(fieldDesc instanceof XMLFieldDescriptorImpl)) {
            return value;
        }
        String result = (String)value;
        String nsURI = null;
        int idx = -1;
        if (result.length() > 0 && result.charAt(0) == '{') {
            idx = result.indexOf(125);
            if (idx <= 0) {
                String err = "Bad QName value :'" + result + "', it should follow the pattern '{URI}value'";
                throw new IllegalArgumentException(err);
            }
        } else {
            return value;
        }
        nsURI = result.substring(1, idx);
        String prefix = ((XMLFieldDescriptorImpl)fieldDesc).getQNamePrefix();
        if (prefix == null) {
            prefix = this._namespaces.getNamespacePrefix(nsURI);
        }
        if (prefix == null) {
            prefix = DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
        }
        result = prefix.length() != 0 ? prefix + ":" + result.substring(idx + 1) : result.substring(idx + 1);
        this.declareNamespace(prefix, nsURI);
        return result;
    }

    private void validate(Object object) throws ValidationException {
        if (this._validate) {
            Validator validator = new Validator();
            ValidationContext context = new ValidationContext();
            context.setConfiguration(this._config);
            context.setResolver(this._cdResolver);
            validator.validate(object, context);
        }
    }

    public String getProperty(String name) {
        return this._config.getProperties().getProperty(name);
    }

    public void setProperty(String name, String value) {
        this._config.getProperties().setProperty(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NilObject {
        private XMLClassDescriptor _classDesc = null;
        private XMLFieldDescriptor _fieldDesc = null;

        NilObject(XMLClassDescriptor classDesc, XMLFieldDescriptor fieldDesc) {
            this._classDesc = classDesc;
            this._fieldDesc = fieldDesc;
        }

        public XMLClassDescriptor getClassDescriptor() {
            return this._classDesc;
        }

        public XMLFieldDescriptor getFieldDescriptor() {
            return this._fieldDesc;
        }
    }

    static class MarshalState {
        String xpath = null;
        XMLFieldDescriptor[] nestedAtts = null;
        int nestedAttCount = 0;
        private MarshalState _parent = null;
        private Object _owner = null;
        private String _xmlName = null;

        MarshalState(Object owner, String xmlName) {
            if (owner == null) {
                String err = "The argument 'owner' must not be null";
                throw new IllegalArgumentException(err);
            }
            if (xmlName == null) {
                String err = "The argument 'xmlName' must not be null";
                throw new IllegalArgumentException(err);
            }
            this._owner = owner;
            this._xmlName = xmlName;
        }

        MarshalState createMarshalState(Object owner, String xmlName) {
            MarshalState ms = new MarshalState(owner, xmlName);
            ms._parent = this;
            return ms;
        }

        String getXPath() {
            if (this.xpath == null) {
                this.xpath = this._parent != null ? this._parent.getXPath() + "/" + this._xmlName : this._xmlName;
            }
            return this.xpath;
        }

        Object getOwner() {
            return this._owner;
        }

        MarshalState getParent() {
            return this._parent;
        }
    }

    static class WrapperInfo {
        String localName = null;
        String qName = null;
        String location = null;

        WrapperInfo(String localName, String qName, String location) {
            this.localName = localName;
            this.qName = qName;
            this.location = location;
        }
    }
}

