/*
 * Decompiled with CFR 0.152.
 */
package view.binding.swing;

import java.awt.Container;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.binding.AttributesBinding;
import oracle.binding.RangeBinding;
import oracle.binding.UpdateListener;
import view.sample.swing.HRPanel;

public class STableBinder
extends AbstractTableModel
implements UpdateListener,
ListSelectionListener {
    private RangeBinding mBinding;
    private JTable mControl;
    private HRPanel mHrPanel;
    private Exception mError;
    private boolean mSelRowInProg;
    private boolean mRunnableRefreshLaterSelectRow;
    private Runnable mRunnableRefeshLater;
    private Runnable mRunnableReportException;
    List mRangeSet;
    private static /* synthetic */ Class class$java$lang$String;

    public STableBinder(RangeBinding rangeBinding, JTable jTable, HRPanel hRPanel) {
        this.mBinding = rangeBinding;
        this.mControl = jTable;
        this.mHrPanel = hRPanel;
        Container container = jTable.getParent();
        while (container != null) {
            if (container instanceof JScrollPane) break;
            container = container.getParent();
        }
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.mBinding.setListener(this);
    }

    public void updateRenderer() {
        this.mRangeSet = null;
        this.refresh(true);
    }

    void fireTableDataChangedRestoreSelection(boolean bl) {
        int n = this.mControl.getSelectedRow();
        this.mSelRowInProg = true;
        try {
            this.fireTableDataChanged();
            if (bl && n >= 0 && this.mControl.getSelectedRow() < 0 && n >= 0) {
                this.selectRowOfIndex(n);
            }
            Object var4_3 = null;
            this.mSelRowInProg = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mSelRowInProg = false;
            throw throwable;
        }
    }

    private void selectRowOfIndex(int n) {
        JTable jTable = this.mControl;
        if (jTable == null) {
            return;
        }
        if (n >= 0) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
        } else {
            jTable.getSelectionModel().clearSelection();
        }
    }

    private void refresh(boolean bl) {
        this.mRunnableRefreshLaterSelectRow = bl;
        if (this.mRunnableRefeshLater == null) {
            this.mRunnableRefeshLater = new 2();
            SwingUtilities.invokeLater(this.mRunnableRefeshLater);
        }
    }

    private void reportExceptionLater() {
        if (this.mRunnableReportException == null) {
            this.mRunnableReportException = new 1();
            SwingUtilities.invokeLater(this.mRunnableReportException);
        }
    }

    private void _refreshLater(boolean bl) {
        block5: {
            if (this.mBinding != null && this.mError == null) {
                try {
                    this.fireTableDataChangedRestoreSelection(bl ^ true);
                    int n = this.mBinding.getCurrentRowIndex();
                    if (n < 0) break block5;
                    this.mSelRowInProg = true;
                    try {
                        this.selectRowOfIndex(n);
                        Object var5_3 = null;
                        this.mSelRowInProg = false;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        this.mSelRowInProg = false;
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    if (this.mError != null) break block5;
                    this.mError = exception;
                    this.reportExceptionLater();
                }
            }
        }
    }

    public String getColumnName(int n) {
        return this.mBinding.getLabelSet()[n];
    }

    public Class getColumnClass(int n) {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = STableBinder.class$("java.lang.String");
        }
        return clazz;
    }

    public int getColumnCount() {
        return this.mBinding.getLabelSet().length;
    }

    public int getRowCount() {
        if (this.mRangeSet == null) {
            this.mRangeSet = this.mBinding.getRangeSet();
        }
        return this.mRangeSet.size();
    }

    public AttributesBinding getRowBinding(int n) {
        if (this.mRangeSet == null) {
            this.mRangeSet = this.mBinding.getRangeSet();
        }
        return (AttributesBinding)this.mRangeSet.get(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getRowBinding(n).isUpdateable(n2);
    }

    public Object getValueAt(int n, int n2) {
        return this.getRowBinding(n).getInputValue(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getRowBinding(n).setInputValue(n2, object);
        this.mHrPanel.updateActionRenderer();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (this.mSelRowInProg || listSelectionModel.getValueIsAdjusting()) {
                return;
            }
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                this.mBinding.setCurrentRowAtIndex(n);
            }
        }
        catch (RuntimeException runtimeException) {
            this.refresh(true);
            throw runtimeException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            STableBinder.this.mRunnableRefeshLater = null;
            STableBinder.this._refreshLater(STableBinder.this.mRunnableRefreshLaterSelectRow);
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            if (STableBinder.this.mError != null) {
                STableBinder.this.mRunnableReportException = null;
                if (STableBinder.this.mError instanceof RuntimeException) {
                    throw (RuntimeException)STableBinder.this.mError;
                }
                STableBinder.this.mError.printStackTrace();
                throw new RuntimeException(STableBinder.this.mError.getMessage());
            }
        }
    }

    public class UpdateNavigatedRunnableImpl
    implements Runnable {
        int rowIndex;

        UpdateNavigatedRunnableImpl(int n) {
            this.rowIndex = n;
        }

        void setRowIndex(int n) {
            this.rowIndex = n;
        }

        public void run() {
            JTable jTable = STableBinder.this.mControl;
            Rectangle rectangle = jTable.getCellRect(this.rowIndex, 0, false);
            if (rectangle != null) {
                jTable.scrollRectToVisible(rectangle);
            }
            STableBinder.this.mSelRowInProg = true;
            try {
                STableBinder.this.selectRowOfIndex(this.rowIndex);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                STableBinder.this.mSelRowInProg = false;
                throw throwable;
            }
            STableBinder.this.mSelRowInProg = false;
        }
    }
}

