/*
 * Decompiled with CFR 0.152.
 */
package jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import jndi.MetadataNameParser;

public class MetadataContext
implements Context {
    protected Hashtable myEnv;
    protected Hashtable bindings;
    protected static final NameParser myParser = new MetadataNameParser();
    protected static MetadataContext _context = new MetadataContext();

    private /* synthetic */ void $init$() {
        this.bindings = new Hashtable(11);
    }

    public MetadataContext() {
        this.$init$();
    }

    MetadataContext(Hashtable hashtable) {
        this.$init$();
        this.myEnv = hashtable != null ? (Hashtable)hashtable.clone() : null;
    }

    public static Context getStaticNamespace(Hashtable hashtable) {
        return _context;
    }

    private MetadataContext(Hashtable hashtable, Hashtable hashtable2) {
        this(hashtable);
        this.bindings = hashtable2;
    }

    private MetadataContext cloneCtx() {
        return new MetadataContext(this.myEnv, this.bindings);
    }

    protected String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 5) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return name.get(4);
        }
        return name.toString();
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneCtx();
        }
        String string = this.getMyComponents(name);
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NameNotFoundException(name + " not found");
        }
        return v;
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String string = this.getMyComponents(name);
        if (this.bindings.get(string) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(string, object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String string = this.getMyComponents(name);
        this.bindings.put(string, object);
    }

    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        String string = this.getMyComponents(name);
        this.bindings.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name.isEmpty() || name2.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        String string = this.getMyComponents(name);
        String string2 = this.getMyComponents(name2);
        if (this.bindings.get(string2) != null) {
            throw new NameAlreadyBoundException(name2.toString() + " is already bound");
        }
        Object v = this.bindings.remove(string);
        if (v == null) {
            throw new NameNotFoundException(name.toString() + " not bound");
        }
        this.bindings.put(string2, v);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfNames(this.bindings.keys());
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            NamingEnumeration<NameClassPair> namingEnumeration;
            try {
                namingEnumeration = ((Context)object).list("");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ((Context)object).close();
                throw throwable;
            }
            ((Context)object).close();
            return namingEnumeration;
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfBindings(this.bindings.keys());
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            NamingEnumeration<Binding> namingEnumeration;
            try {
                namingEnumeration = ((Context)object).listBindings("");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ((Context)object).close();
                throw throwable;
            }
            ((Context)object).close();
            return namingEnumeration;
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("MetadataContext does not support subcontexts");
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("MetadataContext does not support subcontexts");
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Object object = this.lookup(name);
        if (object instanceof Context) {
            ((Context)object).close();
        }
        return myParser;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
    }

    public class ListOfNames
    implements NamingEnumeration {
        protected Enumeration names;

        ListOfNames(Enumeration enumeration) {
            this.names = enumeration;
        }

        public boolean hasMoreElements() {
            try {
                boolean bl = this.hasMore();
                return bl;
            }
            catch (NamingException namingException) {
                boolean bl = false;
                return bl;
            }
        }

        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String string = (String)this.names.nextElement();
            String string2 = MetadataContext.this.bindings.get(string).getClass().getName();
            return new NameClassPair(string, string2);
        }

        public Object nextElement() {
            try {
                Object object = this.next();
                return object;
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException(namingException.toString());
            }
        }

        public void close() {
        }
    }

    public class ListOfBindings
    extends ListOfNames {
        ListOfBindings(Enumeration enumeration) {
            super(enumeration);
        }

        public Object next() throws NamingException {
            String string = (String)this.names.nextElement();
            return new Binding(string, MetadataContext.this.bindings.get(string));
        }
    }
}

