/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.util;

import br.gov.rs.tce.util.exception.EncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Encoding {
    static Log LOG = LogFactory.getLog(Encoding.class.getClass());
    public static final String DEFAULT_ENCODING = "ISO-8859-1";

    public byte[] encode(String data) throws EncodingException {
        return this.encode(data, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(String data, String charsetName) throws EncodingException {
        try {
            Charset charset = Charset.forName(charsetName);
            CharsetEncoder encoder = charset.newEncoder();
            CharBuffer charBuffer = null;
            Class<Encoding> clazz = Encoding.class;
            synchronized (Encoding.class) {
                charBuffer = CharBuffer.wrap(data.toCharArray());
                // ** MonitorExit[var6_7] (shouldn't be in output)
                ByteBuffer byteBuffer = encoder.encode(charBuffer);
                if (byteBuffer.hasArray()) {
                    return byteBuffer.array();
                }
                return null;
            }
        }
        catch (CharacterCodingException e) {
            LOG.warn((Object)("Erro ao usar o charset '" + charsetName + "' para codificacao! Verifique se ele deve ser utilizado nesse contexto"), (Throwable)e);
            throw new EncodingException("Erro ao usar o charset '" + charsetName + "' para codificacao! Verifique se ele deve ser utilizado nesse contexto", e);
        }
    }

    public String decode(byte[] data) throws EncodingException {
        return this.decode(data, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decode(byte[] data, String charsetName) throws EncodingException {
        try {
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder decoder = charset.newDecoder();
            ByteBuffer byteBuffer = null;
            Class<Encoding> clazz = Encoding.class;
            synchronized (Encoding.class) {
                byteBuffer = ByteBuffer.wrap(data);
                // ** MonitorExit[var6_7] (shouldn't be in output)
                CharBuffer charBuffer = decoder.decode(byteBuffer);
                return charBuffer.toString();
            }
        }
        catch (CharacterCodingException e) {
            LOG.warn((Object)("Erro ao usar o charset '" + charsetName + "' para decodificacao! Verifique se ele deve ser utilizado nesse contexto"), (Throwable)e);
            throw new EncodingException("Erro ao usar o charset '" + charsetName + "' para decodificacao! Verifique se ele deve ser utilizado nesse contexto", e);
        }
    }
}

