/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import br.gov.rs.tce.adf.util.DataBindingHelper;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.QuadroAbstrato;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.quadros.DecimalFormatCellRenderer;
import br.gov.rs.tce.pad.visao.panel.quadros.PopupSelecaoContas;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadro;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUStatusBar;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUTableBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TelaQuadroComum
extends JPanel
implements JUPanel,
TelaQuadro,
PadModelo {
    private static final Log log = LogFactory.getLog(TelaQuadroComum.class);
    protected QuadroContas _quadroContas;
    protected JUPanelBinding _panelBinding;
    protected BindingContext _bindingContext;
    protected Set<String> _iteratorNames = new HashSet<String>();
    protected Set<String> _tableControlNames = new HashSet<String>();
    private IdentificadorConta _identificadorConta;
    private ActionListener _btnPopupListener;
    private static DefaultCellEditor CELL_EDITOR_DESABILITADO;
    private static DefaultCellEditor DEFAULT_CELL_EDITOR;
    public static final String FORMATO_CODIGO_CONTA_PADRAO = "00000000000000000000";
    public static final String PARAM_CODIGO_CONTA_PROPERTY = "formato-codigo-conta";
    public static final String PARAM_CD_RECURSO_PROPERTY = "formato-cdrecurso";
    public static final String PARAM_VLR_INDICE_PROPERTY = "formato-vlr-indice";
    public static final String PARAM_DESABILITAR_COLUNA_POR_BIMESTRE = "desabilitar-coluna-bimestre";
    public static final String READ_ONLY_SCREEN_PROPERTY = "READ_ONLY_SCREEN";
    private static final Object[][] TAMANHO_COLUNAS;
    protected static final DefaultTableCellRenderer DEFAULT_HEADER_CELL_RENDERER;
    protected static final DefaultTableCellRenderer NUMERO_ALINHADO_DIR_RENDERER_HABILITADO;
    protected static final DefaultTableCellRenderer NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO;

    protected void jbInit() throws Exception {
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        this.inicializaPropriedadesTela(remessa, this._quadroContas);
    }

    @Override
    public void inicializaDadosPlanilha(IdentificadorConta ident) {
        this._identificadorConta = ident;
    }

    protected abstract void inicializaPropriedadesTela(Remessa var1, QuadroContas var2);

    public static final JFrame findJFrameParent(Component child) {
        return (JFrame)SwingUtilities.getWindowAncestor(child);
    }

    public final void btnPopup_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ContasModule app = DatacontrolHelper.getContasModuleAppModule(this._bindingContext);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        PopupSelecaoContas.exibePopupSelecaoContas(this._quadroContas, remessa, DatabaseHelper.recuperaTipoBancoDados(app), this._bindingContext, this._btnPopupListener, (Component)e.getSource(), this._quadroContas.getCodigoPlanilha(), this._identificadorConta);
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected final void preparaBindingContext(BindingContext bindCtx) {
        if (this._panelBinding.getPanel() == null) {
            this._panelBinding = this._panelBinding.setup(bindCtx, (Object)this);
            this._panelBinding.refreshControl();
            try {
                this.jbInit();
                this._panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this._panelBinding.reportException((Throwable)ex);
            }
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this._panelBinding;
    }

    public abstract void finalizaTelaEspecifico();

    @Override
    public final void finalizaTela() {
        this._panelBinding.release(DCDataControl.REL_VIEW_REFS);
        this._bindingContext.remove((Object)this._panelBinding.getName());
        this._panelBinding.release();
        this.finalizaTelaEspecifico();
    }

    @Override
    public final void initializaDataBindings(Remessa remessa, BindingContext bindCtx, QuadroContas quadroContas, ActionListener btnPopupListener) {
        if (quadroContas == null) {
            throw new IllegalArgumentException("QuadroContas n\u00e3o pode ser nulo");
        }
        if (bindCtx == null) {
            throw new IllegalArgumentException("BindingContext n\u00e3o pode ser nulo");
        }
        if (btnPopupListener == null) {
            throw new IllegalArgumentException("Listener do botao popup n\u00e3o pode ser nulo");
        }
        this._bindingContext = bindCtx;
        this._panelBinding = new JUPanelBinding();
        this._btnPopupListener = btnPopupListener;
        this.initializaDataBindingsEspecificos(bindCtx, quadroContas);
        this.preparaBindingContext(bindCtx);
        this.ajustaLabelsQuadro(remessa, quadroContas);
    }

    protected void inicializaBindingQuadro(QuadroContas quadroContas, JTable tblQuadro, JUStatusBar sbNumRegistros) {
        String nomeViewObject = quadroContas.getNomeViewObject();
        if (nomeViewObject == null) {
            throw new IllegalArgumentException("Nome do viewObject \u00e9 nulo para o quadro: " + quadroContas.getNome());
        }
        DCIteratorBinding iter = DataBindingHelper.adicionaIteratorBinding(this._bindingContext, this._panelBinding, DataBindingHelper.criaNomeIteratorDef(quadroContas.getNome()), "ContasModuleDataControl", nomeViewObject, this._iteratorNames);
        String quadroControlBindingName = DataBindingHelper.criaNomeTableDef(quadroContas.getNome());
        quadroContas.setControlBindingName(quadroControlBindingName);
        JUTableBinding tableBinding = DataBindingHelper.adicionaTableBinding(this._bindingContext, this._panelBinding, quadroControlBindingName, quadroContas.getColunasQuadroArray(), iter.getName(), this._tableControlNames);
        tblQuadro.setModel((TableModel)this.getPanelBinding().bindUIControl(quadroControlBindingName, (Object)tblQuadro));
        if (sbNumRegistros != null) {
            sbNumRegistros.setModel(JUStatusBar.createPanelBinding((JUPanelBinding)this.getPanelBinding(), (JUStatusBar)sbNumRegistros));
            sbNumRegistros.setVisible(true);
        }
    }

    protected abstract void ajustaLabelsQuadro(Remessa var1, QuadroContas var2) throws IllegalArgumentException;

    @Override
    public void setQuadroContas(QuadroContas quadroContas) {
        this._quadroContas = quadroContas;
    }

    protected abstract void initializaDataBindingsEspecificos(BindingContext var1, QuadroContas var2);

    protected final void ajustaTamanhoColunas(JTable tabela, String[] colunas, int[] tamanhos) {
        int countCol = tabela.getColumnModel().getColumnCount();
        block0: for (int i = 0; i < countCol; ++i) {
            TableColumn coluna = tabela.getColumnModel().getColumn(i);
            if (tamanhos != null && tamanhos.length > 0) {
                int preferredWidth = tamanhos[i];
                coluna.setPreferredWidth(preferredWidth);
                coluna.setWidth(preferredWidth);
                continue;
            }
            for (int j = 0; j < TAMANHO_COLUNAS.length; ++j) {
                int width;
                Object[] tamanho = TAMANHO_COLUNAS[j];
                if (!tamanho[0].equals(colunas[i])) continue;
                int preferredWidth = width = ((Integer)tamanho[1]).intValue();
                coluna.setPreferredWidth(preferredWidth);
                coluna.setWidth(width);
                continue block0;
            }
        }
    }

    protected final String[] getColunasQuadro() {
        return this._quadroContas.getColunasQuadroArray();
    }

    protected final int[] getTamanhoColunas() {
        return this._quadroContas.getTamanhoColunasArray();
    }

    @Override
    public void preparaTela() {
        throw new IllegalStateException("Esta metodo n\u00e3o deve ser chamado.");
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        throw new IllegalStateException("Esta metodo n\u00e3o deve ser chamado.");
    }

    protected static void inicializaTableRenderers(JTable tabela, QuadroAbstrato quadroContas, String nomeTableCtrlBinding, JUPanelBinding panelBinding) {
        if (tabela == null) {
            return;
        }
        if (panelBinding == null) {
            throw new IllegalArgumentException("PanelBinding n\u00e3o pode ser nulo");
        }
        JUControlBinding ctrBinding = panelBinding.findControlBinding(nomeTableCtrlBinding);
        if (ctrBinding == null) {
            throw new IllegalArgumentException("N\u00e3o foi possivel localizar o Controlbinding: " + nomeTableCtrlBinding);
        }
        ((JLabel)((Object)tabela.getDefaultRenderer(String.class))).setBackground(Color.LIGHT_GRAY);
        DEFAULT_CELL_EDITOR.getComponent().setFont(tabela.getFont());
        AttributeDef[] defs = ((JUCtrlValueBinding)ctrBinding).getAttributeDefs();
        if (defs == null) {
            log.warn((Object)"defs is null");
            return;
        }
        for (int i = 0; i < defs.length; ++i) {
            Class type = defs[i].getJavaType();
            DefaultTableCellRenderer renderer = null;
            TableColumn coluna = tabela.getColumnModel().getColumn(i);
            Parametro paramFormatoCdRecurso = quadroContas.getParametroPorNome(PARAM_CD_RECURSO_PROPERTY);
            Parametro paramFormatoVlrIndice = quadroContas.getParametroPorNome(PARAM_VLR_INDICE_PROPERTY);
            if ("CdConta".equals(defs[i].getName())) {
                Parametro paramFormatoCdConta = quadroContas.getParametroPorNome(PARAM_CODIGO_CONTA_PROPERTY);
                String formatoCdConta = null;
                formatoCdConta = paramFormatoCdConta != null ? paramFormatoCdConta.getValor() : FORMATO_CODIGO_CONTA_PADRAO;
                coluna.setCellRenderer(TelaQuadroComum.criaTableCellRendererCdConta(formatoCdConta.length()));
                continue;
            }
            if ("CdRecurso".equals(defs[i].getName()) && paramFormatoCdRecurso != null) {
                String formatoCdCRecurso = null;
                formatoCdCRecurso = paramFormatoCdRecurso.getValor();
                coluna.setCellRenderer(TelaQuadroComum.criaTableCellRenderer(formatoCdCRecurso.length(), formatoCdCRecurso.length()));
                continue;
            }
            if ("VlrIndice".equals(defs[i].getName()) && paramFormatoVlrIndice != null) {
                String formatoCampo = null;
                formatoCampo = paramFormatoVlrIndice.getValor();
                log.info((Object)("campo " + defs[i].getName() + " ; format = " + formatoCampo));
                coluna.setCellRenderer(TelaQuadroComum.criaTableCellDecimalFormatterRenderer(formatoCampo));
                continue;
            }
            if (!Number.class.isAssignableFrom(type)) continue;
            Boolean readOnly = Boolean.valueOf((String)defs[i].getProperty(READ_ONLY_SCREEN_PROPERTY));
            byte updatableFlag = defs[i].getUpdateableFlag();
            if (readOnly.booleanValue() || updatableFlag != 2) {
                coluna.setCellEditor(CELL_EDITOR_DESABILITADO);
                renderer = NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO;
            } else {
                coluna.setCellEditor(DEFAULT_CELL_EDITOR);
                renderer = NUMERO_ALINHADO_DIR_RENDERER_HABILITADO;
            }
            coluna.setCellRenderer(renderer);
        }
    }

    protected static void configuraColunasDesabilitadas(BindingContext bindingCtx, JTable tabela, QuadroAbstrato quadroContas) {
        Parametro param = quadroContas.getParametroPorNome(PARAM_DESABILITAR_COLUNA_POR_BIMESTRE);
        if (param != null && !"".equals(param.getValor())) {
            int periodoAtual = DatacontrolHelper.getRemessaDataControl(bindingCtx).getPeriodoInformacoes();
            String[] colunas = param.getValor().split(";");
            for (int i = 0; i < colunas.length; ++i) {
                String[] partes = colunas[i].split("-");
                if (partes == null || partes.length != 2) {
                    throw new ConfiguracaoException("\u00c9 necess\u00e1rio um hifen entre o n\u00famero da coluna e a lista de bimestres a serem desabilitados: " + colunas[i]);
                }
                String[] periodos = partes[1].split(",");
                boolean desabilitar = false;
                for (int p = 0; p < periodos.length; ++p) {
                    if (periodoAtual != Integer.valueOf(periodos[p])) continue;
                    desabilitar = true;
                }
                if (!desabilitar) continue;
                int indiceColuna = Integer.parseInt(partes[0]);
                TableColumn coluna = tabela.getColumnModel().getColumn(indiceColuna);
                coluna.setCellEditor(CELL_EDITOR_DESABILITADO);
                coluna.setCellRenderer(NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO);
            }
        }
    }

    protected static DefaultTableCellRenderer criaTableCellRendererCdConta(final int qtdDigitos) {
        DefaultTableCellRenderer cdContaRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    String newValue = value instanceof BigDecimal ? value.toString() : (String)value;
                    if (newValue.length() >= qtdDigitos) {
                        super.setValue(newValue.substring(newValue.length() - qtdDigitos, newValue.length()));
                    } else {
                        super.setValue(newValue);
                    }
                }
            }

            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
        cdContaRenderer.setHorizontalAlignment(4);
        cdContaRenderer.setBackground(Color.LIGHT_GRAY);
        return cdContaRenderer;
    }

    protected static DefaultTableCellRenderer criaTableCellRenderer(final int minQtdDigitos, final int maxQtdDigitos) {
        DefaultTableCellRenderer cdContaRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    String newValue = value instanceof BigDecimal ? value.toString() : (String)value;
                    if (newValue.length() > maxQtdDigitos) {
                        super.setValue(newValue.substring(newValue.length() - maxQtdDigitos, newValue.length()));
                    } else if (newValue.length() < minQtdDigitos) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < minQtdDigitos - newValue.length(); ++i) {
                            sb.append("0");
                        }
                        super.setValue(sb.toString() + newValue);
                    } else {
                        super.setValue(newValue);
                    }
                }
            }

            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
        cdContaRenderer.setHorizontalAlignment(4);
        cdContaRenderer.setBackground(Color.LIGHT_GRAY);
        return cdContaRenderer;
    }

    protected static DefaultTableCellRenderer criaTableCellDecimalFormatterRenderer(String pattern) {
        DecimalFormatCellRenderer cdContaRenderer = new DecimalFormatCellRenderer(pattern);
        return cdContaRenderer;
    }

    protected static void desabilitaReziseColunasJTable(JTable tabela) {
        TableColumnModel modeloColunasTotal = tabela.getColumnModel();
        for (int i = 0; i < modeloColunasTotal.getColumnCount(); ++i) {
            TableColumn coluna = modeloColunasTotal.getColumn(i);
            coluna.setResizable(false);
        }
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    static {
        TAMANHO_COLUNAS = new Object[][]{{"CdConta", 125}, {"CdUnidade", 53}, {"DsConta", 194}, {"VlrContabil", 94}, {"VlrAjuste", 94}, {"VlrAjustado", 94}};
        DEFAULT_HEADER_CELL_RENDERER = new DefaultTableCellRenderer();
        NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO = new DefaultTableCellRenderer();
        NUMERO_ALINHADO_DIR_RENDERER_HABILITADO = new DefaultTableCellRenderer(){
            private Color unselectedForeground;
            private Color unselectedBackground;
            Border selecionado = BorderFactory.createLineBorder(Color.RED);

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                    super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
                }
                this.setFont(table.getFont());
                if (hasFocus) {
                    this.setBorder(this.selecionado);
                    if (table.isCellEditable(row, column)) {
                        super.setForeground(Color.BLACK);
                        super.setBackground(Color.WHITE);
                    }
                } else {
                    this.setBorder(noFocusBorder);
                }
                this.setValue(value);
                return this;
            }
        };
        DEFAULT_HEADER_CELL_RENDERER.setHorizontalTextPosition(0);
        DEFAULT_HEADER_CELL_RENDERER.setHorizontalAlignment(0);
        DEFAULT_HEADER_CELL_RENDERER.setBackground(Color.getHSBColor(1.0f, 0.0f, 0.6f));
        DEFAULT_HEADER_CELL_RENDERER.setForeground(Color.BLACK);
        NUMERO_ALINHADO_DIR_RENDERER_HABILITADO.setHorizontalAlignment(4);
        NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO.setHorizontalAlignment(4);
        NUMERO_ALINHADO_DIR_RENDERER_DESABILITADO.setBackground(Color.LIGHT_GRAY);
        JTextField tf = new JTextField();
        tf.setBackground(Color.LIGHT_GRAY);
        CELL_EDITOR_DESABILITADO = new DefaultCellEditor(tf){

            @Override
            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
        JTextField d = new JTextField(){

            @Override
            public void setText(String str) {
                super.setText(str);
                this.selectAll();
            }

            @Override
            protected Document createDefaultModel() {
                return new NumberDocument();
            }

            class NumberDocument
            extends PlainDocument {
                NumberDocument() {
                }

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    StringBuilder buffer = new StringBuilder();
                    boolean number = true;
                    if (str == null) {
                        return;
                    }
                    char[] upper = str.toCharArray();
                    for (int i = 0; i < upper.length; ++i) {
                        if (Character.isDigit(upper[i]) || upper[i] == ',' || upper[i] == '-' || upper[i] == '+') {
                            buffer.append(upper[i]);
                            continue;
                        }
                        number = false;
                    }
                    if (number) {
                        super.insertString(offs, buffer.toString(), a);
                    }
                }
            }
        };
        DEFAULT_CELL_EDITOR = new DefaultCellEditor(d);
    }
}

