/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DecimalFormatCellRenderer
extends DefaultTableCellRenderer {
    final DecimalFormat df1 = new DecimalFormat("#,##0.00");
    final NumberFormat parser = NumberFormat.getInstance(new Locale("pt"));
    private static final Log log = LogFactory.getLog(DecimalFormatCellRenderer.class);

    DecimalFormatCellRenderer(String pattern) {
        this.df1.applyPattern(pattern);
        this.setHorizontalAlignment(4);
        this.setBackground(Color.LIGHT_GRAY);
    }

    @Override
    public void setValue(Object value) {
        String newVal = "";
        if (value instanceof BigDecimal) {
            newVal = this.df1.format((BigDecimal)value);
        } else if (value instanceof String) {
            try {
                Number n = this.parser.parse((String)value);
                newVal = this.df1.format(n);
            }
            catch (ParseException e) {
                log.warn((Object)("pe: " + e + " ; value=" + value + " ; " + value.getClass()));
                newVal = (String)value;
            }
        } else {
            log.warn((Object)("classe? " + value + " ; " + value.getClass()));
            newVal = value.toString();
        }
        super.setValue(newVal);
    }
}

