/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC208;
import java.awt.Component;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC208
extends PadAbstractAction {
    SimpleDateFormat dataBr = new SimpleDateFormat("dd/MM/yyyy");

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        String resposta;
        ServicoPAD ser = ActionAvancarUC208.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("TransparenciaGestaoFiscalView");
        Row row = vo.getCurrentRow();
        TelaUC208 tela208 = (TelaUC208)tela;
        boolean foiPreenchidoPeloMenosUmEndereco = false;
        boolean bLinha1Preenchida = false;
        boolean bLinha2Preenchida = false;
        boolean bLinha3Preenchida = false;
        Date dtPrimeiro = (Date)row.getAttribute("dtPrimeiro");
        Date dtSegundo = (Date)row.getAttribute("dtSegundo");
        Date dtTerceiro = (Date)row.getAttribute("dtTerceiro");
        String descPrimeiro = (String)row.getAttribute("descPrimeiro");
        String descSegundo = (String)row.getAttribute("descSegundo");
        String descTerceiro = (String)row.getAttribute("descTerceiro");
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa remessa = ActionAvancarUC208.getRemessaDataControl(binding);
        int anoExercicio = remessa.getAnoExercicio();
        System.out.println(dtPrimeiro + " ; " + descPrimeiro + " ; anoexercicio=" + anoExercicio);
        if (!this.testaAnoDentroPeriodo(dtPrimeiro)) {
            ActionAvancarUC208.exibeMensagemAviso("Data " + this.getDateBr(dtPrimeiro) + " deve ter ano igual ou superior a 2000 e n\u00e3o pode superar a data de preenchimento em mais de sessenta dias", form);
            return false;
        }
        if (!this.testaAnoDentroPeriodo(dtSegundo)) {
            ActionAvancarUC208.exibeMensagemAviso("Data " + this.getDateBr(dtSegundo) + " deve ter ano igual ou superior a 2000 e n\u00e3o pode superar a data de preenchimento em mais de sessenta dias", form);
            return false;
        }
        if (!this.testaAnoDentroPeriodo(dtTerceiro)) {
            ActionAvancarUC208.exibeMensagemAviso("Data " + this.getDateBr(dtTerceiro) + " deve ter ano igual ou superior a 2000 e n\u00e3o pode superar a data de preenchimento em mais de sessenta dias", form);
            return false;
        }
        if (dtPrimeiro != null || tela208.isPreenchido(descPrimeiro)) {
            if (!this.isDataOk(dtPrimeiro, form) || !this.isURLOk(descPrimeiro, form)) {
                return false;
            }
            foiPreenchidoPeloMenosUmEndereco = true;
            bLinha1Preenchida = true;
        }
        if (dtSegundo != null || tela208.isPreenchido(descSegundo)) {
            if (!this.isDataOk(dtSegundo, form) || !this.isURLOk(descSegundo, form)) {
                return false;
            }
            bLinha2Preenchida = true;
        }
        if (dtTerceiro != null || tela208.isPreenchido(descTerceiro)) {
            if (!this.isDataOk(dtTerceiro, form) || !this.isURLOk(descTerceiro, form)) {
                return false;
            }
            bLinha3Preenchida = true;
        }
        if (!tela208.isInfoNaoDisponibilizadaChecked()) {
            if (bLinha2Preenchida && !bLinha1Preenchida) {
                ActionAvancarUC208.exibeMensagemAviso("A segunda linha de endere\u00e7o eletr\u00f4nico somente deve ser preenchida quando a primeira j\u00e1 estiver preenchida", form);
                return false;
            }
            if (bLinha3Preenchida && !bLinha2Preenchida) {
                ActionAvancarUC208.exibeMensagemAviso("A terceira linha de endere\u00e7o eletr\u00f4nico somente deve ser preenchida quando a segunda j\u00e1 estiver preenchida", form);
                return false;
            }
            if (!bLinha1Preenchida) {
                ActionAvancarUC208.exibeMensagemAviso("Ao menos um endere\u00e7o eletr\u00f4nico deve ser informado", form);
                return false;
            }
        }
        tela208.persiste(dtPrimeiro, this.getNonNullString(descPrimeiro), remessa, ser, "1", binding);
        tela208.persiste(dtSegundo, this.getNonNullString(descSegundo), remessa, ser, "2", binding);
        tela208.persiste(dtTerceiro, this.getNonNullString(descTerceiro), remessa, ser, "3", binding);
        ViewObject voData = ser.findViewObject("TransparenciaGestaoFiscalView");
        voData.executeQuery();
        voData.first();
        log.debug((Object)("N\u00ba Linhas View Audiencias Publicas = " + voData.getRowCount()));
        System.out.println(">>>>>> Transacao Suja/Modificada ? = " + ser.getTransaction().isDirty() + " / " + binding.findDataControl("ServicoPADDataControl").isTransactionModified());
        String textoSituacaoNaoPreenchimento = "";
        if (tela208.deveJustificarNaoPreenchimento() && !foiPreenchidoPeloMenosUmEndereco) {
            ViewObject voJus = ser.findViewObject("JustificativasDaRemessa");
            voJus.setWhereClause("TIPO_PLANILHA = " + TipoJustificativa.JUSTIFICA_TRANSPARENCIA_GF + " and CD_PLANILHA = " + 1);
            voJus.executeQuery();
            Row rowJus = voJus.first();
            System.out.println("row: " + rowJus + " : " + (rowJus != null ? rowJus.getAttribute("Texto") : ""));
            if (rowJus == null || rowJus.getAttribute("Texto") == null || ((String)rowJus.getAttribute("Texto")).trim().equals("")) {
                ActionAvancarUC208.exibeMensagemAviso("O n\u00e3o preenchimento de endere\u00e7o(s) eletr\u00f4nico(s) deve ser justificado pelo bot\u00e3o \"Observa\u00e7\u00f5es\"", form);
                return false;
            }
            textoSituacaoNaoPreenchimento = "DEVERIA_ESTAR_CUMPRINDO";
        } else {
            textoSituacaoNaoPreenchimento = "POSSUI_PRAZO";
        }
        String string = resposta = tela208.isInfoNaoDisponibilizadaChecked() ? "S" : "N";
        if (!tela208.isInfoNaoDisponibilizadaChecked()) {
            textoSituacaoNaoPreenchimento = "";
        }
        ser.insereRespostaRemessa(remessa, "55", resposta, textoSituacaoNaoPreenchimento, true);
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        dc.commitTransaction();
        return true;
    }

    boolean isDataOk(Date d, Component form) {
        if (d == null) {
            ActionAvancarUC208.exibeMensagemAviso("O campo Data de in\u00edcio da disponibiliza\u00e7\u00e3o deve ser v\u00e1lida", form);
            return false;
        }
        return true;
    }

    boolean isURLOk(String url, Component form) {
        if (url == null) {
            ActionAvancarUC208.exibeMensagemAviso("Endere\u00e7o eletr\u00f4nico deve estar preenchido", form);
            return false;
        }
        String regex = "^(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        if (url.trim().matches(regex)) {
            return true;
        }
        ActionAvancarUC208.exibeMensagemAviso("Endere\u00e7o eletr\u00f4nico n\u00e3o \u00e9 v\u00e1lido. Exemplo: http://www.transparencia.rs.gov.br/", form);
        return false;
    }

    String getNonNullString(String s) {
        if (s == null || s.equals("")) {
            return " ";
        }
        return s;
    }

    boolean testaAnoDentroPeriodo(Date d) {
        if (d == null) {
            return true;
        }
        int minAno = 2000;
        int ano = this.getAno(d);
        Date dataHoje = new Date(System.currentTimeMillis());
        float diffDiasPublicacaoHoje = (d.getTime() - dataHoje.getTime()) / 86400000L;
        if (diffDiasPublicacaoHoje > 60.0f) {
            System.out.println("testaAnoDentroPeriodo: diff (d [" + d + "] - hoje [" + dataHoje + "]) > 60");
            return false;
        }
        return ano >= minAno;
    }

    int getAno(Date d) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(d);
        return g.get(1);
    }

    String getDateBr(Date d) {
        return this.dataBr.format(d);
    }
}

