/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC103A;
import br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC103;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC103A
extends PadAbstractAction {
    private BindingContext _binding;
    private TelaUC103A _tela;

    public ActionAvancarUC103A() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        this._tela = (TelaUC103A)tela;
        this._binding = binding;
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa rem = ActionAvancarUC103A.getRemessaDataControl(binding);
        boolean retorno = false;
        CompactacaoHelper comp = new CompactacaoHelper();
        if (this._tela.getPath() == null || "".equals(this._tela.getPath())) {
            ActionAvancarUC103A.exibeMensagemAviso("Local de destino da remessa deve ser informado.", form);
            return false;
        }
        File fDestino = new File(this._tela.getPath());
        boolean isDisquete = false;
        File fRemessa = new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP + "remessa.dat");
        File ftest = new File(this._tela.getPath(), "remessa.dat");
        try {
            if (fRemessa.getCanonicalFile().equals(ftest.getCanonicalFile())) {
                ActionAvancarUC103A.exibeMensagemAviso("Local de destino da remessa n\u00e3o pode ser a pasta \"remessa\"", form);
                return false;
            }
        }
        catch (IOException e1) {
            throw new PADActionException("Erro: " + e1.getMessage(), e1);
        }
        if (ftest.exists() && !isDisquete) {
            if (!ActionAvancarUC103A.exibeMensagemSimNao("Existe uma remessa no local informado. Deseja sobrescrever?", form)) {
                return false;
            }
            ftest.delete();
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionAvancarUC103A.this._tela.acaoBanner(true);
                }
            });
            final ActionAvancarUC103.ProgressBarBoundedRangeModel copia = new ActionAvancarUC103().new ActionAvancarUC103.ProgressBarBoundedRangeModel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionAvancarUC103A.this._tela.setProgressoArquivoModel(copia);
                    ActionAvancarUC103A.this._tela.setMaxValueProgressBar(100);
                }
            });
            copia.setLabelEtiqueta(this._tela.getLabelEtiqueta());
            copia.setBindingContext(this._binding);
            try {
                retorno = comp.copiaArquivoRemessa(fRemessa, fDestino, copia);
            }
            catch (Exception e) {
                ActionAvancarUC103A.exibeMensagemErro("Erro ao copiar remessa. Verifique sua unidade de destino (" + fDestino.getPath() + ")", form);
                return false;
            }
            if (retorno) {
                ActionAvancarUC103A.exibeMensagemAviso("A grava\u00e7\u00e3o dos arquivos de informa\u00e7\u00f5es foi finalizada com sucesso.", form);
                copia.fireEmiteEtiqueta(isDisquete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PADActionException("UC103A", "br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC103A.class", e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActionAvancarUC103A.this._tela.acaoBanner(false);
            }
        });
        if ("BACKUP".equals(this._tela.getLabelEtiqueta()) && retorno) {
            ServicoPAD ser = ActionAvancarUC103A.getServicoPADAppModule(binding);
            if (this.verificaPeriodo(rem) && ser.existeIndiretasConsolidacao()) {
                ActionAvancarUC103A.exibeMensagemAviso("Lembre-se de realizar a consolida\u00e7\u00e3o", this._tela);
            }
        }
        return retorno;
    }

    private boolean exibeMensagemConfirmacao(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        return JOptionPane.showConfirmDialog(form, mensagem, "Aten\u00e7\u00e3o", 2) == 0;
    }

    private boolean verificaPeriodo(Remessa remessa) {
        String tpEntrega = remessa.getTipoEntrega() == null ? "" : remessa.getTipoEntrega();
        int periodo = remessa.getPeriodoInformacoes();
        boolean retorno = false;
        if (tpEntrega.equals("S") && (periodo == 3 || periodo == 6)) {
            retorno = true;
        }
        if (tpEntrega.equals("Q") && (periodo == 2 || periodo == 4 || periodo == 6)) {
            retorno = true;
        }
        return retorno;
    }
}

