/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.commons.sql.ClausulaWhere;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.ContasModuleImpl;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DateUtils;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaFinalizacao;
import br.gov.rs.tce.pad.visao.panel.TelaUC039;
import br.gov.rs.tce.pad.visao.panel.TelaUC039C;
import br.gov.rs.tce.pad.visao.panel.TelaUC041;
import br.gov.rs.tce.pad.visao.panel.TelaUC060;
import br.gov.rs.tce.pad.visao.panel.TelaUC060B;
import br.gov.rs.tce.pad.visao.panel.TelaUC201;
import br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC039;
import br.gov.rs.tce.ws.validacao.client.Recebimento;
import br.gov.rs.tce.ws.validacao.client.SiapcLicitaconClient;
import java.sql.Date;
import java.util.GregorianCalendar;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC039C
extends PadAbstractAction {
    private boolean deDataParaPeriodo(Row remessaRow, TelaUC039C _tela) {
        Date d = (Date)remessaRow.getAttribute("DtFinalCompl");
        if (d == null) {
            ActionAvancarUC039C.exibeMensagemAviso("A data final das informa\u00e7\u00f5es complementares precisa ser informada.", _tela);
            return false;
        }
        int anoExercicio = _tela.getAnoExercicio();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int mes = cal.get(2);
        int ano = cal.get(1);
        if (ano != anoExercicio) {
            ActionAvancarUC039C.exibeMensagemAviso("Data final das informa\u00e7\u00f5es complementares deve pertencer ao Ano do Exerc\u00edcio.", _tela);
            return false;
        }
        remessaRow.setAttribute("AnoExercicio", (Object)_tela.getAnoExercicio());
        switch (mes) {
            case 0: 
            case 1: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)1);
                break;
            }
            case 2: 
            case 3: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)2);
                break;
            }
            case 4: 
            case 5: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)3);
                break;
            }
            case 6: 
            case 7: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)4);
                break;
            }
            case 8: 
            case 9: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)5);
                break;
            }
            case 10: 
            case 11: {
                remessaRow.setAttribute("PeriodoInformacoes", (Object)6);
            }
        }
        return true;
    }

    private void setaMes(Row remessaRow, TelaUC039C _tela) {
        Date d = (Date)remessaRow.getAttribute("DtFinalCompl");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int mes = cal.get(2) + 1;
        remessaRow.setAttribute("Mes", (Object)mes);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        System.setProperty("user.timezone", "America/Sao_Paulo");
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        TelaUC039C _tela = (TelaUC039C)tela;
        Remessa remessa = ActionAvancarUC039C.getRemessaSemAnoBiDataControl(binding);
        boolean resposta = true;
        boolean possuiCamaraIntegrada = false;
        boolean deletarLinhas = false;
        if (!this.validaCNPJ(_tela)) {
            return false;
        }
        ActionAvancarUC039.atualizaCNPJ(_tela.getCnpjEntidade(), binding, remessa);
        ServicoPAD ser = ActionAvancarUC039C.getServicoPADAppModule(binding);
        ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
        Row remessaRow = voRemessa.getCurrentRow();
        if (!this.deDataParaPeriodo(remessaRow, _tela)) {
            return false;
        }
        this.setaMes(remessaRow, _tela);
        if (remessa != null) {
            possuiCamaraIntegrada = remessa.isPossuiCamaraIntegrada();
            int periodoAnterior = remessa.getPeriodoInformacoes();
            int anoExercicioAnterior = remessa.getAnoExercicio();
            int anoExercicioAtual = _tela.getAnoExercicio();
            remessa.setDataFinal((Date)remessaRow.getAttribute("DtFinalCompl"));
            remessa.setPeriodoInformacoes((Integer)remessaRow.getAttribute("PeriodoInformacoes"));
            remessa.setTipoOperacao(6);
            if (periodoAnterior != remessa.getPeriodoInformacoes() || anoExercicioAnterior != anoExercicioAtual) {
                ser.limpaDadosMudancaPeriodo();
                remessa.setCargaArquivosSelecaoEfetuada(false);
                remessaRow.setAttribute("SituacaoCarga", (Object)0);
            }
        }
        if (_tela.getAnoExercicio() != 0) {
            Integer ano = _tela.getAnoExercicio();
            if (ano.intValue() != remessa.getAnoExercicio()) {
                ser.limpaDadosMudancaPeriodo();
            }
            remessaRow.setAttribute("AnoExercicio", (Object)ano);
            remessa.setAnoExercicio(ano);
            remessa.setCnpjEntidade(_tela.getCnpjEntidade());
        }
        if (!_tela.validaCampos()) {
            return false;
        }
        Row entidadeRow = (Row)remessaRow.getAttribute("EntidadesView");
        Integer cdEntidade = null;
        if (entidadeRow != null) {
            cdEntidade = (Integer)entidadeRow.getAttribute("CdEntidade");
            String tipoEntidade = (String)entidadeRow.getAttribute("TipoSetorGov");
            Integer cdEntidadeOriginal = remessa.getCdEntidade();
            String tipoEntidadeOriginal = remessa.getTipoSetor();
            if (cdEntidadeOriginal != null && cdEntidadeOriginal.intValue() != cdEntidade.intValue()) {
                deletarLinhas = true;
            }
            if (tipoEntidadeOriginal != null && !tipoEntidadeOriginal.equals(tipoEntidade)) {
                deletarLinhas = true;
            }
            if (deletarLinhas) {
                resposta = _tela.limpaTabelasCadastros();
                form.defineCursor(3);
                if (resposta) {
                    TelaUC041._habilitarTelaUC041 = 1;
                    TelaUC060._habilitarTelaUC060 = 1;
                    TelaUC060B._habilitarTelaUC060B = 1;
                    TelaUC201._habilitarTelaUC201 = 1;
                    voRemessa.first();
                    voRemessa.previous();
                    Object[] valores = new Object[voRemessa.getAttributeCount()];
                    while (voRemessa.hasNext()) {
                        Row linha = voRemessa.next();
                        linha.setAttribute("ObsFinais", (Object)"");
                        linha.setAttribute("ManifestacaoConclusiva", (Object)"");
                        String principal = (String)linha.getAttribute("RemessaPrincipal");
                        if (principal != null && principal.equals("S")) {
                            for (int i = 0; i < linha.getAttributeCount(); ++i) {
                                valores[i] = linha.getAttribute(i);
                            }
                        }
                        linha.remove();
                    }
                    this.salvaDadosRemessa(binding);
                    Row rowNova = voRemessa.createRow();
                    for (int i = 0; i < valores.length; ++i) {
                        Object value;
                        if (voRemessa.getAttributeDef(i).getUpdateableFlag() != 2 || (value = valores[i]) == null) continue;
                        rowNova.setAttribute(i, valores[i]);
                    }
                    remessa.setCargaArquivosSelecaoEfetuada(false);
                    rowNova.setAttribute("SituacaoCarga", (Object)0);
                    rowNova.setAttribute("CamaraIntegrada", (Object)(possuiCamaraIntegrada ? "S" : "N"));
                    voRemessa.insertRow(rowNova);
                } else {
                    remessa.setCdEntidade(cdEntidadeOriginal);
                    remessa.setTipoSetor(tipoEntidadeOriginal);
                }
            }
        } else {
            log.warn((Object)"entidadeRow eh NULL!");
        }
        if (resposta) {
            remessa.setCdEntidade(cdEntidade);
            ser.atualizaCampoRemessa("VersaoPad", "25.1.0.5");
            this.salvaDadosRemessa(binding);
            ser.limpaDadosConsolidacao();
            if (remessa.getTipoSetor().equals("P")) {
                String respPer025 = null;
                respPer025 = possuiCamaraIntegrada ? "S" : "N";
                ActionAvancarUC039C.getServicoPADAppModule(binding).insereRespostaRemessa(ActionAvancarUC039C.getRemessaDataControl(binding), String.valueOf(25), respPer025, null, true);
            }
            if (remessa.getTipoSetor().equals("P") && remessa.isPossuiCamaraIntegrada()) {
                ViewObject voEntidades = ser.findViewObject("TodasEntidadesView");
                voEntidades.setWhereClause("(TIPO_SETOR_GOV = ? AND CD_ENTIDADE_PAI = ?)");
                voEntidades.setWhereClauseParam(0, (Object)"C");
                voEntidades.setWhereClauseParam(1, (Object)remessa.getCdEntidade());
                voEntidades.executeQuery();
                if (voEntidades.first() == null) {
                    ActionAvancarUC039C.exibeMensagemAviso("A camara integrada desta prefeitura n\u00e3o consta na base de dados. Entrar em contato com o Tribunal de Contas do Estado.", _tela);
                    return false;
                }
            }
            TelaUC039.removeResponsaveis(binding);
            RemessasViewRowImpl remessasViewRow = _tela.getRemessasViewRow();
            if (!TelaUC039.consultaResponsaveis(binding, remessasViewRow)) {
                return false;
            }
            if (deletarLinhas) {
                ser.removePublicacoesRemessa(remessa, null, true);
            }
            ser.removePublicacoesRemessa(remessa, this.criaFiltroRemovePublicacaoAntiga(ser, remessa), true);
            if (deletarLinhas || TelaUC039.limpaTabelasArquivos == 1) {
                form.defineCursor(3);
                ActionAvancarUC039C.exibeMensagemAviso("O PAD ir\u00e1 limpar as tabelas de arquivos, esse processo poder\u00e1 demorar alguns minutos.", _tela);
                form.defineCursor(3);
                ser.limpaTabelasArquivos(false);
                TelaUC039.limpaTabelasArquivos = 0;
            }
        }
        DCDataControl dc = binding.findDataControl("ContasModuleDataControl");
        ContasModuleImpl contas = (ContasModuleImpl)dc.getDataProvider();
        try {
            contas.setAnoBiGrupoContas(contas.createAnoBiGrupoContas());
        }
        catch (Exception e) {
            ActionAvancarUC039C.exibeMensagemErro("Ano e bimestre n\u00e3o localizados na tabela de contas desta vers\u00e3o do PAD.", _tela);
            return false;
        }
        Recebimento rec = SiapcLicitaconClient.selectDadosUltimoRecebimento(remessa.getCdEntidade(), DatabaseHelper.getConnection(ser));
        if (rec != null) {
            log.info((Object)("Recebimento: ano=" + rec.getAnoRecebimento() + " ; cd_recebimento = " + rec.getCdRecebimento() + " ; atual = " + rec.getAtual()));
        } else {
            log.info((Object)"Recebimento eh null");
        }
        if (_tela.alteradoOrgaoOuAno() || _tela.reconsultarSiapcLicitacon || rec == null) {
            boolean consSiapc = TelaUC039.consultaSiapcLicitacon(binding);
            if (!consSiapc) {
                return false;
            }
            _tela.reconsultarSiapcLicitacon = false;
        }
        TelaFinalizacao.setEscolhido(this.getRemessasViewRowImpl(binding).getEscolhidoPre());
        TelaFinalizacao.setCdOrgao(this.getRemessasViewRowImpl(binding).getCdEntidade().intValue());
        TelaFinalizacao.setAnoExercicio(this.getRemessasViewRowImpl(binding).getAnoExercicio());
        return resposta;
    }

    private RemessasViewRowImpl getRemessasViewRowImpl(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemCam = ser.findViewObject("RemessasDaEntidade");
        RemessasViewRowImpl remViewRow = (RemessasViewRowImpl)voRemCam.getCurrentRow();
        return remViewRow;
    }

    public ClausulaWhere criaFiltroRemovePublicacaoAntiga(ServicoPAD servico, Remessa remessa) {
        TipoBancoDados tpDB = DatabaseHelper.recuperaTipoBancoDados(servico);
        ClausulaWhere whereTotal = new ClausulaWhere("", "OR", tpDB);
        ClausulaWhere whereBi = new ClausulaWhere("", "AND", tpDB);
        whereBi.addCondicaoComparacaoData("DT_PUBLICACAO", DateUtils.getUltimoDataMes(remessa.getAnoExercicio() - 1, 11), " < ");
        whereBi.addCondicaoNumerica("PERIODO", remessa.getPeriodoInformacoes(), " > ");
        whereBi.addCondicaoString("TP_PERIODO", "B", " = ");
        ClausulaWhere whereQua = new ClausulaWhere("", "AND", tpDB);
        whereQua.addCondicaoNumerica("PERIODO", Math.abs(remessa.getPeriodoInformacoes() * 2 / 4), " > ");
        whereQua.addCondicaoString("TP_PERIODO", "Q", " = ");
        ClausulaWhere whereSem = new ClausulaWhere("", "AND", tpDB);
        whereSem.addCondicaoNumerica("PERIODO", Math.abs(remessa.getPeriodoInformacoes() * 2 / 6), " > ");
        whereSem.addCondicaoString("TP_PERIODO", "S", " = ");
        whereTotal.addInnerWhereClause(whereBi);
        whereTotal.addInnerWhereClause(whereQua);
        whereTotal.addInnerWhereClause(whereSem);
        return whereTotal;
    }

    private boolean validaCNPJ(TelaUC039C _tela) {
        boolean retorno = true;
        try {
            if (_tela.getCnpjEntidade().equals("")) {
                ActionAvancarUC039C.exibeMensagemAviso("O CNPJ precisa ser informado.", _tela);
                retorno = false;
            } else if (!ValidaCNPJ.validaCnpj(_tela.getCnpjEntidade())) {
                ActionAvancarUC039C.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
                retorno = false;
            }
        }
        catch (FormatoInvalidoException e) {
            retorno = false;
            e.printStackTrace();
            ActionAvancarUC039C.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
            return retorno;
        }
        return retorno;
    }
}

