/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class TelaUC058
extends JPanel
implements JUPanel,
PadModelo {
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC058UIModel");
    private JLabel lblTextoMunicipio = new JLabel("texto municipio");
    private JLabel lblTexto1 = new JLabel();
    private JRadioButton rbPerSemestral = new JRadioButton();
    private JRadioButton rbPerQuadrimenstral = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    static String SQL_MUN = "select m.NRO_HABITANTES, m.NOME_MUNICIPIO \n from remessas r \n join ENTIDADES e on r.CD_ENTIDADE = e.CD_ENTIDADE \n join MUNICIPIOS m on e.COD_MUNICIPIO = m.COD_MUNICIPIO \n where r.REMESSA_PRINCIPAL='S'";
    String nomeMunicipio = "";
    BigDecimal nroHabitantes = new BigDecimal(0);
    DecimalFormat df = new DecimalFormat("#,##0");

    public void jbInit() throws Exception {
        this.setLayout(null);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.lblTextoMunicipio.setBounds(new Rectangle(20, 15, 555, 15));
        this.lblTexto1.setText("Sua op\u00e7\u00e3o de entrega dos Demostrativos da Lei de Responsabilidade Fiscal \u00e9:");
        this.lblTexto1.setBounds(new Rectangle(20, 55, 555, 15));
        this.rbPerSemestral.setText("<html>SEMESTRAL: Munic\u00edpio com menos de 50.000 habitantes que optou por usar a faculdade prevista no inciso II<br>do art.63 da LRF, desde que n\u00e3o tenha excedido os limites legais da despesa com pessoal ou da d\u00edvida<br>consolidada, conforme art 20 da LRF e inciso II do art. 3\u00ba da Resolu\u00e7\u00e3o N\u00ba 40/2001 do Senado Federal, respectivamente.</html>");
        this.rbPerSemestral.setBounds(new Rectangle(15, 80, 580, 100));
        this.rbPerQuadrimenstral.setText("<html>QUADRIMESTRAL: Munic\u00edpio com 50.000 habitantes ou mais, ou munic\u00edpio com menos de 50.000 habitantes<br>que n\u00e3o tenha optado pela faculdade prevista no inciso II do art. 63 da LRF, e/ou estejam com os limites<br>legais da despesa com pessoal ou da d\u00edvida consolidada excedidos, conforme legisla\u00e7\u00e3o retrorreferida.</html>");
        this.rbPerQuadrimenstral.setBounds(new Rectangle(15, 180, 580, 100));
        this.add((Component)this.rbPerQuadrimenstral, null);
        this.add((Component)this.rbPerSemestral, null);
        this.add((Component)this.lblTextoMunicipio, null);
        this.add((Component)this.lblTexto1, null);
        this.inicializaRadioGroup();
    }

    private void inicializaRadioGroup() {
        this.buttonGroup.add(this.rbPerSemestral);
        this.buttonGroup.add(this.rbPerQuadrimenstral);
        BindingContext binding = this.panelBinding.getBindingContext();
        Remessa r = DatacontrolHelper.getRemessaDataControl(binding);
        String tipo = r.getTipoEntrega();
        if (tipo.equalsIgnoreCase("S")) {
            this.buttonGroup.setSelected(this.rbPerSemestral.getModel(), true);
        }
        if (tipo.equalsIgnoreCase("Q")) {
            this.buttonGroup.setSelected(this.rbPerQuadrimenstral.getModel(), true);
        }
    }

    void inicializaInfoMunicipio() {
        BindingContext binding = this.panelBinding.getBindingContext();
        ContasModule contasMod = DatacontrolHelper.getContasModuleAppModule(binding);
        ViewObject voSelect = contasMod.createViewObjectFromQueryStmt("select", SQL_MUN);
        Row r = voSelect.first();
        if (r != null) {
            this.nroHabitantes = (BigDecimal)r.getAttribute(0);
            this.nomeMunicipio = (String)r.getAttribute(1);
        }
        if (voSelect != null) {
            voSelect.remove();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC058 panel = new TelaUC058();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        this.inicializaInfoMunicipio();
        this.lblTextoMunicipio.setText("Popula\u00e7\u00e3o do Munic\u00edpio de " + this.nomeMunicipio + ": " + this.df.format(this.nroHabitantes) + " habitantes");
    }

    public String getRespostaPergunta() {
        if (this.rbPerSemestral.isSelected()) {
            return "S";
        }
        if (this.rbPerQuadrimenstral.isSelected()) {
            return "Q";
        }
        return null;
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    public int getNroHabitantes() {
        return this.nroHabitantes.intValue();
    }

    public String getNomeMunicipio() {
        return this.nomeMunicipio;
    }
}

