/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.adf.util.TCERadioButton;
import br.gov.rs.tce.pad.beans.types.TipoRespostasList;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.TelaUC084;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUButtonGroupBinding;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class TelaUC042
extends JPanel
implements JUPanel,
PadModelo {
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC042UIModel");
    private JLabel lblTexto1 = new JLabel();
    private ImageIcon indicadorIcon = PadImage.createImageIcon("imagens/indicador.gif");
    private JLabel lbltexto2 = new JLabel();
    private JULabel lblNaturezaJur = new JULabel();
    private JButton btnCnae = new JButton();
    private JCheckBox ckbDependente = new JCheckBox();
    private JTextField tfCodCnae = new JTextField();
    private TCERadioButton rdBtnQualificacao = new TCERadioButton();
    private JComboBox cbbNaturezaJur = new JComboBox();
    private JLabel lblTexto3 = new JLabel();
    private JTextField tfDsCnae = new JTextField();
    private TelaUC084 tela;

    private void inicializaTelaJTree() {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        this.tela = new TelaUC084((Frame)form, "C\u00f3digo da Atividade Econ\u00f4mica", true, this.panelBinding.getBindingContext());
        this.tela.setLocationRelativeTo(this);
    }

    public void jbInit() throws Exception {
        this.setLayout(null);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.lblTexto1.setText("Qualifica\u00e7\u00e3o da pessoa jurid\u00edca");
        this.lblTexto1.setBounds(new Rectangle(20, 20, 245, 15));
        this.lblTexto1.setFont(new Font("Tahoma", 1, 11));
        this.lbltexto2.setText("Informa\u00e7\u00f5es Complementares");
        this.lbltexto2.setBounds(new Rectangle(20, 105, 215, 15));
        this.lbltexto2.setFont(new Font("Tahoma", 1, 11));
        this.lblNaturezaJur.setBounds(new Rectangle(35, 180, 100, 15));
        this.lblNaturezaJur.setFont(new Font("Tahoma", 1, 11));
        this.btnCnae.setBounds(new Rectangle(20, 245, 30, 25));
        this.btnCnae.setBorder(BorderFactory.createEtchedBorder(1));
        this.btnCnae.setIcon(this.indicadorIcon);
        this.btnCnae.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC042.this.btnCnaeActionPerformed(e);
            }
        });
        this.ckbDependente.setText("Dependente conforme Art. 2\u00ba, inciso III da LRF");
        this.ckbDependente.setBounds(new Rectangle(35, 135, 350, 25));
        this.tfCodCnae.setBounds(new Rectangle(55, 250, 110, 20));
        this.tfCodCnae.setEditable(false);
        this.tfCodCnae.setRequestFocusEnabled(false);
        this.tfCodCnae.setEnabled(false);
        this.rdBtnQualificacao.setBounds(new Rectangle(35, 40, 350, 55));
        this.cbbNaturezaJur.setBounds(new Rectangle(140, 175, 465, 20));
        this.lblTexto3.setBounds(new Rectangle(20, 225, 350, 15));
        this.lblTexto3.setText("C\u00f3digo da Atividade Economica (CNAE - Fiscal)");
        this.lblTexto3.setFont(new Font("Tahoma", 1, 11));
        this.tfDsCnae.setBounds(new Rectangle(170, 250, 365, 20));
        this.tfDsCnae.setEditable(false);
        this.tfDsCnae.setEnabled(false);
        this.add((Component)this.tfDsCnae, null);
        this.add((Component)this.lblTexto3, null);
        this.add((Component)this.cbbNaturezaJur, null);
        this.add((Component)((Object)this.rdBtnQualificacao), null);
        this.add((Component)this.tfCodCnae, null);
        this.add((Component)this.ckbDependente, null);
        this.add((Component)this.btnCnae, null);
        this.add((Component)this.lblNaturezaJur, null);
        this.add((Component)this.lbltexto2, null);
        this.add((Component)this.lblTexto1, null);
        this.lblNaturezaJur.setText("Natureza Juridica");
        this.ckbDependente.setModel((ButtonModel)this.panelBinding.bindUIControl("Dependente1", (Object)this.ckbDependente));
        this.tfCodCnae.setDocument((Document)this.panelBinding.bindUIControl("CdAtividadeCnae", (Object)this.tfCodCnae));
        this.rdBtnQualificacao.setModel((JUButtonGroupBinding)this.panelBinding.bindUIControl("TpPessoaJuridica", (Object)this.rdBtnQualificacao));
        this.cbbNaturezaJur.setModel((ComboBoxModel)this.panelBinding.bindUIControl("NaturezaJuridica", (Object)this.cbbNaturezaJur));
        this.inicializaTelaJTree();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC042 panel = new TelaUC042();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
        ViewObject vo = ser.findViewObject("RespostasRemessa");
        vo.setWhereClause("CD_PERGUNTA = ?");
        vo.setWhereClauseParam(0, (Object)22);
        vo.executeQuery();
        vo.next();
        Row row = vo.getCurrentRow();
        if (row != null) {
            Integer codPergunta = (Integer)row.getAttribute("CdPergunta");
            String resp = (String)row.getAttribute("Resposta");
            if (resp != null) {
                if (resp.equals("S")) {
                    this.rdBtnQualificacao.setSelectedIndex(TipoRespostasList.CD_SIM_NUM);
                } else {
                    this.rdBtnQualificacao.setSelectedIndex(TipoRespostasList.CD_NAO_NUM);
                }
            }
        } else {
            this.rdBtnQualificacao.setSelectedIndex(0);
        }
        this.tfDsCnae.setText("");
        this.setValoresCnae();
    }

    @Override
    public final void finalizaTela() {
        if (!this.verificaCodigoCNAE()) {
            BindingContext binding = this.panelBinding.getBindingContext();
            DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
            ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
            ser.getTransaction().rollback();
        }
    }

    @Override
    public boolean validaTela() {
        return this.verificaCodigoCNAE();
    }

    private void btnCnaeActionPerformed(ActionEvent e) {
        this.tela.setVisible(true);
        this.setValoresCnae();
    }

    private void setValoresCnae() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
        ViewObject vo = ser.findViewObject("DadosRemessaEmpresa");
        if (vo != null) {
            vo.first();
            Row row = vo.getCurrentRow();
            if (row != null) {
                Integer codigoCnae = (Integer)row.getAttribute("CdAtividadeCnae");
                Integer codigoGrupo = (Integer)row.getAttribute("CdAtividadeGrupo");
                String codigoClasse = (String)row.getAttribute("CdAtividadeClasse");
                this.setDescricaoCnae(codigoCnae, codigoGrupo, codigoClasse);
            }
        }
    }

    private boolean verificaCodigoCNAE() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
        ViewObject vo = ser.findViewObject("DadosRemessaEmpresa");
        if (vo != null) {
            Integer codigo;
            vo.first();
            Row row = vo.getCurrentRow();
            if (row != null && (codigo = (Integer)row.getAttribute("CdAtividadeCnae")) == null) {
                return false;
            }
        }
        return true;
    }

    private void setDescricaoCnae(Integer codigoCnae, Integer codigoGrupo, String codigoClasse) {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
        ViewObject vo = ser.findViewObject("CnaeAtividadeEconomicaView");
        if (vo != null) {
            vo.setWhereClause("CD_ATIVIDADE_CNAE = ? AND CD_ATIVIDADE_GRUPO = ? AND CD_ATIVIDADE_CLASSE = ?");
            vo.setWhereClauseParam(0, (Object)codigoCnae);
            vo.setWhereClauseParam(1, (Object)codigoGrupo);
            vo.setWhereClauseParam(2, (Object)codigoClasse);
            vo.executeQuery();
            vo.first();
            Row row = vo.getCurrentRow();
            if (row != null) {
                String classe = (String)row.getAttribute("CdAtividadeClasse");
                String grupo = (String)row.getAttribute("CdAtividadeGrupo");
                DecimalFormat formatterGrupo = new DecimalFormat("00");
                grupo = formatterGrupo.format(new Long(grupo));
                DecimalFormat f = new DecimalFormat("0000000");
                String cnae = f.format(codigoCnae.longValue());
                cnae = this.formataCnae(cnae);
                String codigo = classe + "." + grupo + "." + cnae;
                this.tfCodCnae.setText(codigo);
                this.tfDsCnae.setText((String)row.getAttribute("DsAtividadeCnae"));
            }
        }
    }

    private String formataCnae(String codigo) {
        String value = "";
        if (codigo != null) {
            String first = codigo.substring(0, 4);
            String second = codigo.substring(4, 5);
            String last = codigo.substring(5, 7);
            value = first + "-" + second + "/" + last;
        }
        return value;
    }
}

