/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.MesList;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasCamarasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ResponsaveisViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.SubstituicoesViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.DateUtils;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadErrorDialog;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.PopUpUC039;
import br.gov.rs.tce.pad.visao.panel.TelaUC100;
import br.gov.rs.tce.pad.visao.swing.PadFoneField;
import br.gov.rs.tce.pad.visao.swing.PadTextFieldBinding;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import br.gov.rs.tce.siapc.exception.ContadorNaoEncontradoFault;
import br.gov.rs.tce.siapc.exception.ResponsaveisFault;
import br.gov.rs.tce.siapc.exception.ResponsavelNaoEncontradoFault;
import br.gov.rs.tce.util.TCEUIManager;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import br.gov.rs.tce.ws.validacao.client.Recebimento;
import br.gov.rs.tce.ws.validacao.client.SiapcLicitaconClient;
import https.wsresponsaveis_tce_rs_gov.ContadorWSPojo;
import https.wsresponsaveis_tce_rs_gov.EntidadeWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsaveisWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsavelAtualWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsavelWSPojo;
import https.wsresponsaveis_tce_rs_gov.SubstitutoWSPojo;
import https.wsresponsaveis_tce_rs_gov_br.Exception;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.NoRouteToHostException;
import java.sql.Connection;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC039
extends JPanel
implements JUPanel,
PadModelo {
    private static final Log log = LogFactory.getLog(TelaUC039.class);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC039UIModel");
    private final BorderLayout borderLayout = new BorderLayout();
    private final JPanel jpFundo = new JPanel();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JPanel jpCabecalho = new JPanel();
    private final JPanel jpMeio = new JPanel();
    private final GridBagLayout gridBagLayout2 = new GridBagLayout();
    private final JULabel lbLogradouro = new JULabel();
    private final JTextField tfLogradouro = new JTextField();
    private final JULabel lbNr = new JULabel();
    private final JULabel lbTelefone = new JULabel();
    private final JULabel lbHomePage = new JULabel();
    private final JTextField tfHomePage = new JTextField();
    private final JULabel lbEmail = new JULabel();
    private final JTextField tfEmail = new JTextField();
    private final JULabel lbContabilista = new JULabel();
    private final JTextField tfContabilista = new JTextField();
    private final JTextField tfCrc = new JTextField();
    private final JULabel lbCRC = new JULabel();
    private final JULabel lbAnoExercicio = new JULabel();
    private final JLabel lbTexto1 = new JLabel();
    private final JULabel jULabel2 = new JULabel();
    private final JTextField tfPrefMuncipal = new JTextField();
    private final JLabel lbPrefMunicipal = new JLabel();
    private final XYLayout xYLayout1 = new XYLayout();
    private final JULabel jULabel1 = new JULabel();
    private final JComboBox jComboBox1 = new JComboBox();
    private final JComboBox cbbPeriodicidade = new JComboBox();
    private final JComboBox<MesList> jComboBoxMes = new JComboBox<MesList>(MesList.values());
    private final JULabel jULabel3 = new JULabel();
    private final JTextField tfCnpj = new JTextField();
    private final JULabel lblCnpj = new JULabel();
    private final JSpinner spnExercicio = new JSpinner();
    private final JTextField tfCompl = new JTextField();
    private final JTextField tfNr = new JTextField();
    private Long opcaoAnterComboOrgao;
    private Integer opcaoAnterComboPeriodo;
    private Integer opcaoAnterExercicio;
    private Integer cbLastCod;
    private final JButton btnConsultar = new JButton();
    private RemessasViewRowImpl remessasViewRow;
    public static int limpaTabelasArquivos = 0;
    public static Boolean fezBackup = false;
    public Boolean reconsultarResponsaveis = false;
    public boolean reconsultarSiapcLicitacon = false;
    public static final String MSG_ERRO_CONEXAO = "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o TCE. Favor verifique sua conex\u00e3o com a internet. Caso o erro persista, entre em contato com o TCE.";
    public static final String MSG_ERRO_CONEXAO_RESPONSAVEIS = "Erro ao estabelecer conex\u00e3o com o TCE. Poss\u00edvel problema de cadastro no SISCAD.";
    public static final String MSG_ERRO_INESPERADO = "Erro inesperado: ";
    public static final String NOME_REPRESENTANTE = "NomeRepresentante";
    public static final String LOGRADOURO = "Logradouro";
    public static final String NUMERO = "Nr";
    public static final String COMPLEMENTO = "Compl";
    public static final String TELEFONE = "Telefone";
    public static final String HOMEPAGE = "Homepage";
    public static final String EMAIL = "Email";
    public static final String CONTABILISTA = "Contabilista";
    public static final String CRC = "Crc";
    public static final String CNPJ = "Cnpj";
    private final PadFoneField tfTelefone = new PadFoneField("(**)#######*", "Campo Telefone deve estar preenchido adequadamente.");
    public boolean bindingConcluido = false;

    public static void setFezBackup(Boolean fezBackup) {
        TelaUC039.fezBackup = fezBackup;
    }

    public void jbInit() throws java.lang.Exception {
        this.setLayout(this.borderLayout);
        this.setBounds(new Rectangle(10, 10, 500, 400));
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 340));
        this.setMaximumSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.jpFundo.setLayout(this.borderLayout1);
        this.jpCabecalho.setBorder(BorderFactory.createEtchedBorder(1));
        this.jpCabecalho.setLayout((LayoutManager)this.xYLayout1);
        this.jpCabecalho.setPreferredSize(new Dimension(254, 80));
        this.jpMeio.setBorder(BorderFactory.createEtchedBorder(1));
        this.jpMeio.setLayout(this.gridBagLayout2);
        this.jpMeio.setPreferredSize(new Dimension(493, 80));
        this.tfEmail.setSize(new Dimension(180, 20));
        this.lbTexto1.setText("Dados Cadastrais:");
        this.jComboBoxMes.setMaximumSize(new Dimension(50, 20));
        this.jComboBoxMes.setSize(new Dimension(95, 20));
        this.tfCnpj.setEditable(false);
        this.tfCnpj.setEnabled(false);
        TCEUIManager.setDefaultBorder(this.tfCnpj);
        this.jpCabecalho.add((Component)this.lblCnpj, new XYConstraints(35, 55, 40, 15));
        this.jpCabecalho.add((Component)this.tfCnpj, new XYConstraints(75, 50, 155, 20));
        this.jpCabecalho.add((Component)this.btnConsultar, new XYConstraints(240, 50, 120, 20));
        this.jpCabecalho.add((Component)this.jComboBox1, new XYConstraints(75, 25, 525, 20));
        this.jpCabecalho.add((Component)this.jULabel1, new XYConstraints(30, 30, 45, 15));
        this.jpCabecalho.add((Component)this.lbTexto1, new XYConstraints(10, 10, 110, 10));
        this.jpFundo.add((Component)this.jpCabecalho, "North");
        this.jpFundo.add((Component)this.jpMeio, "Center");
        this.jpMeio.add((Component)this.lbLogradouro, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 15, 2), 0, 0));
        this.jpMeio.add((Component)this.tfLogradouro, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 332, 0));
        this.jpMeio.add((Component)this.lbNr, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 5), 2, 0));
        this.jpMeio.add((Component)this.lbTelefone, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 7, 10, 3), 0, 0));
        this.jpMeio.add((Component)this.lbHomePage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 15, 2), 0, 0));
        this.jpMeio.add((Component)this.tfHomePage, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 269, 0));
        this.jpMeio.add((Component)this.lbEmail, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 15, 2), 0, 0));
        this.jpMeio.add((Component)this.tfEmail, new GridBagConstraints(4, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 160, 0));
        this.jpMeio.add((Component)this.lbContabilista, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jpMeio.add((Component)this.tfContabilista, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 332, 0));
        this.jpMeio.add((Component)this.tfCrc, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 89, 0));
        this.jpMeio.add((Component)this.lbCRC, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jpMeio.add((Component)this.lbAnoExercicio, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.jpMeio.add((Component)this.jULabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 10, 2), 0, 0));
        this.jpMeio.add((Component)this.tfPrefMuncipal, new GridBagConstraints(1, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 498, 0));
        this.jpMeio.add((Component)this.lbPrefMunicipal, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jpMeio.add(this.jComboBoxMes, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 47, 0));
        this.jpMeio.add((Component)this.jULabel3, new GridBagConstraints(3, 5, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.jpMeio.add((Component)this.spnExercicio, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 23, 0));
        this.jpMeio.add((Component)this.tfCompl, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 270, 0));
        this.jpMeio.add((Component)this.tfNr, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 90, 0));
        this.jpMeio.add((Component)this.tfTelefone, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 90, 0));
        this.add((Component)this.jpFundo, "Center");
        this.lbLogradouro.setText(this.panelBinding.findCtrlValueBinding(LOGRADOURO).getLabel());
        this.tfLogradouro.setDocument((Document)this.panelBinding.bindUIControl("Logradouro1", (Object)this.tfLogradouro));
        this.lbNr.setText(this.panelBinding.findCtrlValueBinding(NUMERO).getLabel());
        this.lbTelefone.setText(this.panelBinding.findCtrlValueBinding(TELEFONE).getLabel());
        this.lbHomePage.setText(this.panelBinding.findCtrlValueBinding(HOMEPAGE).getLabel());
        this.tfHomePage.setDocument((Document)this.panelBinding.bindUIControl("Homepage1", (Object)this.tfHomePage));
        this.lbEmail.setText("E-mail:");
        this.tfEmail.setDocument((Document)this.panelBinding.bindUIControl("Email1", (Object)this.tfEmail));
        this.lbContabilista.setText(this.panelBinding.findCtrlValueBinding(CONTABILISTA).getLabel());
        this.tfContabilista.setDocument((Document)this.panelBinding.bindUIControl("Contabilista1", (Object)this.tfContabilista));
        this.tfCrc.setDocument((Document)this.panelBinding.bindUIControl(CRC, (Object)this.tfCrc));
        this.lbCRC.setText(this.panelBinding.findCtrlValueBinding("Crc1").getLabel());
        this.lbAnoExercicio.setText(this.panelBinding.findCtrlValueBinding("AnoExercicio").getLabel());
        this.jULabel2.setText(this.panelBinding.findCtrlValueBinding("Compl1").getLabel());
        this.tfPrefMuncipal.setDocument((Document)this.panelBinding.bindUIControl(NOME_REPRESENTANTE, (Object)this.tfPrefMuncipal));
        this.lbPrefMunicipal.setText("Respons\u00e1vel");
        this.jULabel1.setText(this.panelBinding.findCtrlValueBinding("CdEntidade").getLabel());
        this.jComboBox1.setModel((ComboBoxModel)this.panelBinding.bindUIControl("CdEntidade1", (Object)this.jComboBox1));
        this.jULabel3.setText("Per\u00edodo informa\u00e7\u00f5es:");
        this.tfCnpj.setDocument((Document)this.panelBinding.bindUIControl(CNPJ, (Object)this.tfCnpj));
        this.lblCnpj.setText("CNPJ:");
        this.btnConsultar.setText("Atualizar Dados");
        this.panelBinding.bindUIControl("CdEntidade1", (Object)this.cbLastCod);
        this.jComboBox1.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TelaUC039.this.validaCNPJEntidade(e);
            }
        });
        Calendar now = Calendar.getInstance();
        int ano = now.get(1);
        SpinnerNumberModel spinnerNumber = new SpinnerNumberModel(ano, 2006, ano + 1, 1);
        this.spnExercicio.setOpaque(false);
        this.spnExercicio.setBackground(Color.white);
        this.lbTexto1.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.jULabel1.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lblCnpj.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.btnConsultar.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbLogradouro.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.jULabel2.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbHomePage.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbContabilista.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbAnoExercicio.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.jULabel3.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbCRC.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbEmail.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbTelefone.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbNr.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.lbPrefMunicipal.setFont(new Font("Microsoft Sans Serif", 0, 11));
        this.jComboBoxMes.setMinimumSize(new Dimension(50, 20));
        this.tfEmail.setBounds(new Rectangle(433, 106, 180, 20));
        this.tfEmail.setPreferredSize(new Dimension(160, 20));
        this.jComboBoxMes.setBounds(new Rectangle(502, 167, 70, 20));
        this.jComboBoxMes.setPreferredSize(new Dimension(50, 20));
        this.spnExercicio.setModel(spinnerNumber);
        this.spnExercicio.setEditor(new JSpinner.NumberEditor(this.spnExercicio, "#"));
        ((JSpinner.DefaultEditor)this.spnExercicio.getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.spnExercicio.getEditor()).getTextField().setBackground(Color.white);
        this.tfCompl.setDocument((Document)this.panelBinding.bindUIControl("Compl2", (Object)this.tfCompl));
        this.preparaTamanhoCampos();
        this.tfNr.setDocument((Document)this.panelBinding.bindUIControl("Nr1", (Object)this.tfNr));
        this.tfTelefone.setDocument(PadTextFieldBinding.createAttributeBinding((JUFormBinding)this.panelBinding, this.tfTelefone, "RemessasDaEntidade", null, "RemessasDaEntidadeIterator", TELEFONE));
        this.btnConsultar.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                PadWizardForm form = PadWizardHelper.getInstance().getForm();
                try {
                    form.defineCursor(3);
                    TelaUC039.this.limparCampos();
                    TelaUC039.this.consultaWebService((ViewRowImpl)TelaUC039.this.jComboBox1.getSelectedItem());
                    TelaUC039.this.reconsultarSiapcLicitacon = true;
                }
                catch (java.lang.Exception e1) {
                    e1.printStackTrace();
                }
                finally {
                    form.defineCursor(0);
                }
            }
        });
        this.btnConsultar.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                TelaUC039.this.reconsultarResponsaveis = true;
            }
        });
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TelaUC039.this.jComboBox1.getSelectedItem() == null || TelaUC039.this.jComboBox1.getSelectedItem().equals("Selecione um org\u00e3o")) {
                    TelaUC039.this.btnConsultar.setEnabled(false);
                } else {
                    TelaUC039.this.btnConsultar.setEnabled(true);
                }
                Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(TelaUC039.this.getPanelBinding().getBindingContext());
                if (TelaUC039.this.btnConsultar.isEnabled() && e.getStateChange() == 1 && TelaUC039.this.jComboBox1.getSelectedItem() != null && TelaUC039.this.jComboBox1.getSelectedIndex() != 0 && !TelaUC039.this.jComboBox1.getSelectedItem().equals("Selecione um org\u00e3o") && remessa.getTipoOperacao() != 4 && remessa.getTipoOperacao() != 5) {
                    Integer cdEntidade = (Integer)((ViewRowImpl)TelaUC039.this.jComboBox1.getSelectedItem()).getAttribute(0);
                    if (!TelaUC039.this.remessasViewRow.isDead()) {
                        if (TelaUC039.this.remessasViewRow.getCdEntidade() == null) {
                            TelaUC039.this.cbLastCod = 0;
                        } else {
                            TelaUC039.this.cbLastCod = TelaUC039.this.remessasViewRow.getCdEntidade().intValue();
                        }
                    }
                    if (!cdEntidade.equals(TelaUC039.this.cbLastCod)) {
                        TelaUC039.this.cbLastCod = cdEntidade;
                        TelaUC039.this.btnConsultar.doClick();
                    }
                }
            }
        });
        this.desativarCampos();
    }

    Row getRemessaDaEntidade() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
        ViewObject vo = ser.findViewObject("RemessasDaEntidade");
        return vo.getCurrentRow();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (java.lang.Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC039 panel = new TelaUC039();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    private MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            exc.printStackTrace();
        }
        return formatter;
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
                this.bindingConcluido = true;
                this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
            }
            catch (java.lang.Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void consultaWebService(ViewRowImpl selectedItem) {
        try {
            ResponsaveisWSClient.initalize();
            Integer cdEntidade = (Integer)selectedItem.getAttribute(0);
            if (cdEntidade > 1) {
                System.out.println("-------------------> CONSULTOU!");
                EntidadeWSPojo entidade = ResponsaveisWSClient.buscarDadosEntidade(cdEntidade.longValue());
                ResponsavelAtualWSPojo responsavelAtual = entidade.getResponsavel();
                if (responsavelAtual == null) {
                    throw new ResponsavelNaoEncontradoFault();
                }
                Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(this.getPanelBinding().getBindingContext());
                if (remessa.getTipoSetor().equals("C")) {
                    this.removeRemessasCamaras();
                }
                this.remessasViewRow.setCdEntidade(BigDecimal.valueOf(cdEntidade.intValue()));
                this.remessasViewRow.setEscolhidoPre("S");
                this.remessasViewRow.setRespAdminFinan(entidade.getResponsavelFinanceiro());
                this.remessasViewRow.setRespCtrlInterno(entidade.getResponsavelCi());
                this.preencheCampo(this.tfPrefMuncipal, NOME_REPRESENTANTE, responsavelAtual.getNome());
                this.preencheCampo(this.tfLogradouro, LOGRADOURO, entidade.getLogradouro());
                this.preencheCampo(this.tfNr, NUMERO, entidade.getNumero().toString());
                this.preencheCampo(this.tfCompl, COMPLEMENTO, entidade.getComplemento());
                this.preencheCampo(this.tfTelefone, TELEFONE, entidade.getTelefone());
                this.preencheCampo(this.tfHomePage, HOMEPAGE, entidade.getHomepage());
                this.preencheCampo(this.tfEmail, EMAIL, TelaUC039.substring(entidade.getEmail(), 50));
                this.preencheCampo(this.tfCnpj, CNPJ, String.format("%014d", entidade.getCgc()));
                List<ContadorWSPojo> contadores = entidade.getContadores().getContador();
                if (contadores.size() == 0) {
                    throw new ContadorNaoEncontradoFault();
                }
                if (contadores.size() == 1) {
                    ContadorWSPojo contador = contadores.get(0);
                    this.preencheCampo(this.tfContabilista, CONTABILISTA, contador.getNome());
                    this.preencheCampo(this.tfCrc, CRC, contador.getCrc());
                } else {
                    PopUpUC039 popUpContadores = new PopUpUC039((Frame)PadWizardHelper.getInstance().getForm(), contadores);
                    popUpContadores.pack();
                    popUpContadores.setLocationRelativeTo(this);
                    popUpContadores.setVisible(true);
                    ContadorWSPojo contador = popUpContadores.getContadorSelecionado();
                    this.preencheCampo(this.tfContabilista, CONTABILISTA, contador.getNome());
                    this.preencheCampo(this.tfCrc, CRC, contador.getCrc());
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            if (e.getMessage().indexOf("invalid JAXP api or implementation") > -1) {
                TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO_RESPONSAVEIS);
            } else {
                TelaUC039.exibeMensagemWarning(MSG_ERRO_INESPERADO + e.getMessage());
            }
        }
        catch (ResponsavelNaoEncontradoFault e) {
            log.warn((Object)("ResponsavelNaoEncontradoFault: " + e));
            TelaUC039.exibeMensagemWarning(e.getMessage());
        }
        catch (ResponsaveisFault e) {
            log.warn((Object)("ResponsaveisFault: " + e));
            TelaUC039.exibeMensagemWarning(e.getMessage());
        }
        catch (SOAPFaultException e) {
            log.warn((Object)("SOAPFaultException: " + (Object)((Object)e)));
            e.printStackTrace();
            TelaUC039.exibeMensagemWarning(TelaUC039.trataSoapFaultMessage(e.getMessage()));
            this.limparCampos();
        }
        catch (Exception e) {
            log.warn((Object)("wsresponsaveis_tce_rs_gov_br.Exception: " + e));
            e.printStackTrace();
            this.exibeMensagemErro(e);
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
            TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
        }
        catch (WebServiceException e) {
            log.warn((Object)("WebServiceException: " + (Object)((Object)e)));
            e.printStackTrace();
            if (e.getCause() != null && e.getCause() instanceof ClassNotFoundException) {
                this.exibeMensagemErro((java.lang.Exception)((Object)e));
            } else {
                TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
            }
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            this.exibeMensagemErro(e);
        }
    }

    static String trataSoapFaultMessage(String msg) {
        return msg.replace("Client received SOAP Fault from server: ", "").replace("Please see the server log to find more detail regarding exact cause of the failure.", "");
    }

    static String substring(String s, int maxSize) {
        if (s == null) {
            return null;
        }
        if (s.length() > maxSize) {
            return s.substring(0, maxSize);
        }
        return s;
    }

    private ViewObject getRemessasCamarasVO() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemCam = ser.findViewObject("DadosRemessaCamara");
        return voRemCam;
    }

    public void removeRemessasCamaras() {
        ViewObject remCamVO = this.getRemessasCamarasVO();
        RemessasCamarasViewRowImpl currentRowRemCam = (RemessasCamarasViewRowImpl)remCamVO.first();
        while (currentRowRemCam != null) {
            currentRowRemCam.remove();
            currentRowRemCam = (RemessasCamarasViewRowImpl)remCamVO.next();
        }
        remCamVO.clearCache();
    }

    public boolean validaResponsaveis() {
        this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
        Long opcaoAtualComboOrgao = ((Integer)((ViewRowImpl)this.jComboBox1.getSelectedItem()).getAttribute(0)).longValue();
        Integer opcaoAtualComboPeriodo = this.remessasViewRow.getPeriodoInformacoes();
        Integer opcaoAtualExercicio = (Integer)this.spnExercicio.getValue();
        if (!this.opcaoAnterComboOrgao.equals(opcaoAtualComboOrgao) || !this.opcaoAnterComboPeriodo.equals(opcaoAtualComboPeriodo) || !this.opcaoAnterExercicio.equals(opcaoAtualExercicio) || this.reconsultarResponsaveis.booleanValue()) {
            this.reconsultarResponsaveis = false;
            return true;
        }
        return false;
    }

    public boolean alteradoOrgaoOuAno() {
        this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
        Long opcaoAtualComboOrgao = ((Integer)((ViewRowImpl)this.jComboBox1.getSelectedItem()).getAttribute(0)).longValue();
        Integer opcaoAtualExercicio = (Integer)this.spnExercicio.getValue();
        return !this.opcaoAnterComboOrgao.equals(opcaoAtualComboOrgao) || !this.opcaoAnterExercicio.equals(opcaoAtualExercicio);
    }

    public RemessasViewRowImpl getRemessasViewRow() {
        if (this.remessasViewRow.isDead()) {
            this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
        }
        return this.remessasViewRow;
    }

    public static void removeResponsaveis(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ser.getTransaction().executeCommand("DELETE FROM RESPONSAVEIS");
        ser.getTransaction().executeCommand("DELETE FROM SUBSTITUICOES");
    }

    public static boolean consultaResponsaveis(BindingContext binding, RemessasViewRowImpl remessasViewRow) {
        try {
            DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
            ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
            ViewObject voResponsaveis = ser.findViewObject("Responsaveis");
            ViewObject voSubstituicoes = ser.findViewObject("SubstituicoesView");
            Long cdEntidade = remessasViewRow.getCdEntidade().longValue();
            Long cdRemessa = remessasViewRow.getCdRemessa().longValue();
            String anoExercicio = remessasViewRow.getAnoExercicio().toString();
            String periodoInicio = "01/01/" + anoExercicio;
            Integer periodoInfo = remessasViewRow.getPeriodoInformacoes();
            Date dataPeriodoFim = DateUtils.getLastDateOfPeriod(periodoInfo, "b", remessasViewRow.getAnoExercicio());
            String periodoFim = TelaUC039.formatarData(dataPeriodoFim.toString());
            Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
            String tipoEntidade = remessa.getTipoSetor().equals("C") ? "C" : "P";
            log.info((Object)("-> buscarResponsaveis: org=" + cdEntidade + " ; ini=" + periodoInicio + " ; fim=" + periodoFim));
            ResponsaveisWSClient.initalize();
            ResponsaveisWSPojo responsaveis = ResponsaveisWSClient.buscarResponsaveis(cdEntidade, periodoInicio, periodoFim);
            List<ResponsavelWSPojo> respList = responsaveis.getResponsavel();
            List<SubstitutoWSPojo> subsList = responsaveis.getSubstituto();
            log.info((Object)("respList.size(): " + respList.size() + " ; subsList.size(): " + subsList.size()));
            HashSet<String> responsaveisPorCpf = new HashSet<String>();
            HashSet<String> substitutosPorCpf = new HashSet<String>();
            for (int i = 0; i < respList.size(); ++i) {
                String cpf;
                if (respList.get(i).getCpf() == null) {
                    log.warn((Object)("cpf nulo? [" + i + "]: " + respList.get(i).getNome()));
                }
                if (responsaveisPorCpf.contains(cpf = "A" + respList.get(i).getCpf())) {
                    log.info((Object)("responsavel duplicado [" + i + "]: " + respList.get(i).getCpf() + "/" + respList.get(i).getNome()));
                    continue;
                }
                ResponsaveisViewRowImpl currentRowResp = (ResponsaveisViewRowImpl)voResponsaveis.createRow();
                log.info((Object)("responsavel [" + i + "]: " + respList.get(i).getCpf() + "/" + respList.get(i).getNome()));
                TelaUC039.preencheTabela((Row)currentRowResp, "CdRemessa", cdRemessa);
                TelaUC039.preencheTabela((Row)currentRowResp, "CdEntidade", cdEntidade);
                TelaUC039.preencheTabela((Row)currentRowResp, "Cargo", respList.get(i).getCargo());
                TelaUC039.preencheTabela((Row)currentRowResp, "Cpf", respList.get(i).getCpf());
                TelaUC039.preencheTabela((Row)currentRowResp, "DtAto", respList.get(i).getDataAto());
                TelaUC039.preencheTabela((Row)currentRowResp, "DtTermino", respList.get(i).getFimMandato());
                TelaUC039.preencheTabela((Row)currentRowResp, "DtInicio", respList.get(i).getInicioMandato());
                TelaUC039.preencheTabela((Row)currentRowResp, "Nome", respList.get(i).getNome());
                TelaUC039.preencheTabela((Row)currentRowResp, "Rg", respList.get(i).getRg());
                TelaUC039.preencheTabela((Row)currentRowResp, "TpAto", respList.get(i).getTipoAto());
                TelaUC039.preencheTabela((Row)currentRowResp, "TpResponsavel", "A");
                TelaUC039.preencheTabela((Row)currentRowResp, "IdPrefeituraCamara", tipoEntidade);
                voResponsaveis.insertRow((Row)currentRowResp);
                responsaveisPorCpf.add(cpf);
            }
            HashSet<String> datasIniSubs = new HashSet<String>();
            for (int i = 0; i < subsList.size(); ++i) {
                SubstitutoWSPojo substituto = subsList.get(i);
                String cpf = "S" + subsList.get(i).getCpf();
                if (!substitutosPorCpf.contains(cpf)) {
                    log.info((Object)("responsavel substituto [" + i + "]: " + subsList.get(i).getCpf() + "/" + subsList.get(i).getNome()));
                    ResponsaveisViewRowImpl currentRowResp = (ResponsaveisViewRowImpl)voResponsaveis.createRow();
                    TelaUC039.preencheTabela((Row)currentRowResp, "CdRemessa", cdRemessa);
                    TelaUC039.preencheTabela((Row)currentRowResp, "CdEntidade", cdEntidade);
                    TelaUC039.preencheTabela((Row)currentRowResp, "Cargo", subsList.get(i).getCargo());
                    TelaUC039.preencheTabela((Row)currentRowResp, "Cpf", subsList.get(i).getCpf());
                    TelaUC039.preencheTabela((Row)currentRowResp, "DtAto", subsList.get(i).getDataAto());
                    TelaUC039.preencheTabela((Row)currentRowResp, "Nome", subsList.get(i).getNome());
                    TelaUC039.preencheTabela((Row)currentRowResp, "Rg", subsList.get(i).getRg());
                    TelaUC039.preencheTabela((Row)currentRowResp, "TpAto", subsList.get(i).getTipoAto());
                    TelaUC039.preencheTabela((Row)currentRowResp, "TpResponsavel", "S");
                    TelaUC039.preencheTabela((Row)currentRowResp, "IdPrefeituraCamara", tipoEntidade);
                    voResponsaveis.insertRow((Row)currentRowResp);
                    substitutosPorCpf.add(cpf);
                } else {
                    log.info((Object)("responsavel substituto duplicado [" + i + "]: " + subsList.get(i).getCpf() + "/" + subsList.get(i).getNome()));
                }
                log.info((Object)("#substituicoes [" + i + "] = " + substituto.getPeriodo().size()));
                for (int j = 0; j < substituto.getPeriodo().size(); ++j) {
                    String dtInicio = substituto.getPeriodo().get(j).getInicioSub();
                    if (!datasIniSubs.contains(dtInicio)) {
                        Long cpfResp = subsList.get(i).getCpf();
                        Long cpfSubst = subsList.get(i).getPeriodo().get(j).getCpfSubstituto();
                        String cpfSubstStr = "A" + cpfSubst;
                        String cpfRespStr = "S" + cpfResp;
                        log.info((Object)("substituto [" + i + "]: " + cpfRespStr + "/" + subsList.get(i).getNome() + " ;  [cpf-substituto = " + cpfSubstStr + "] ; " + subsList.get(i).getPeriodo().get(j).getInicioSub() + " -- " + subsList.get(i).getPeriodo().get(j).getFimSub()));
                        boolean dobreak = false;
                        if (!responsaveisPorCpf.contains(cpfSubstStr) && !substitutosPorCpf.contains(cpfSubstStr)) {
                            log.warn((Object)("cpf responsavel subst n\u00e3o encontrado: " + cpfSubstStr));
                            dobreak = true;
                        }
                        if (!responsaveisPorCpf.contains(cpfRespStr) && !substitutosPorCpf.contains(cpfRespStr)) {
                            log.warn((Object)("cpf responsavel n\u00e3o encontrado: " + cpfRespStr));
                            dobreak = true;
                        }
                        if (dobreak) continue;
                        log.info((Object)("substituto encontrado... " + cpfSubstStr + " / " + cpfRespStr + " ; ini: " + substituto.getPeriodo().get(j).getInicioSub() + " ; fim: " + substituto.getPeriodo().get(j).getFimSub()));
                        SubstituicoesViewRowImpl currentRowSubs = (SubstituicoesViewRowImpl)voSubstituicoes.createRow();
                        TelaUC039.preencheTabela((Row)currentRowSubs, "Cpf", cpfSubst);
                        TelaUC039.preencheTabela((Row)currentRowSubs, "CpfSubstituto", cpfResp);
                        TelaUC039.preencheTabela((Row)currentRowSubs, "DtInicio", substituto.getPeriodo().get(j).getInicioSub());
                        TelaUC039.preencheTabela((Row)currentRowSubs, "DtFim", substituto.getPeriodo().get(j).getFimSub());
                        TelaUC039.preencheTabela((Row)currentRowSubs, "CdRemessa", cdRemessa);
                        TelaUC039.preencheTabela((Row)currentRowSubs, "CdEntidade", cdEntidade);
                        TelaUC039.preencheTabela((Row)currentRowSubs, "Poder", tipoEntidade);
                        TelaUC039.preencheTabela((Row)currentRowSubs, "TpResponsavelAdm", "A");
                        TelaUC039.preencheTabela((Row)currentRowSubs, "TpResponsavelSub", "S");
                        voSubstituicoes.insertRow((Row)currentRowSubs);
                        datasIniSubs.add(dtInicio);
                        continue;
                    }
                    log.info((Object)("substituto fora da data [" + i + "]: " + subsList.get(i).getCpf() + "/" + subsList.get(i).getNome() + " ; " + subsList.get(i).getPeriodo().get(j).getInicioSub() + " -- " + subsList.get(i).getPeriodo().get(j).getFimSub()));
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            if (e.getMessage().indexOf("invalid JAXP api or implementation") > -1) {
                TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO_RESPONSAVEIS);
                return false;
            }
            TelaUC039.exibeMensagemWarning(MSG_ERRO_INESPERADO + e.getMessage());
            return false;
        }
        catch (SOAPFaultException e) {
            TelaUC039.exibeMensagemWarning(e.getMessage());
            return false;
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
            TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
            return false;
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
            return false;
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void preencheTabela(Row row, String fieldKey, Object content) {
        try {
            if (content != null) {
                if (fieldKey.equals("DtInicio") || fieldKey.equals("DtTermino") || fieldKey.equals("DtFim") || fieldKey.equals("DtAto")) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                    Date data = new Date(sdf.parse((String)content).getTime());
                    row.setAttribute(fieldKey, (Object)data);
                } else {
                    row.setAttribute(fieldKey, content);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static String formatarData(String data) {
        String[] dataPieces = data.split("-");
        StringBuilder dataFormatada = new StringBuilder().append(dataPieces[2]).append("/").append(dataPieces[1]).append("/").append(dataPieces[0]);
        return dataFormatada.toString();
    }

    private void preencheCampo(JTextField field, String key, String content) {
        if (content != null) {
            this.panelBinding.getControlBinding((Object)field).getCurrentRow().setAttribute(key, (Object)content);
            this.panelBinding.getControlBinding((Object)field).refreshControl();
        } else {
            this.panelBinding.getControlBinding((Object)field).getCurrentRow().setAttribute(key, (Object)" ");
            this.panelBinding.getControlBinding((Object)field).refreshControl();
        }
    }

    private void limparCampos() {
        this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
        this.remessasViewRow.setNomeRepresentante("");
        this.remessasViewRow.setLogradouro("");
        this.remessasViewRow.setNr("");
        this.remessasViewRow.setCompl("");
        this.remessasViewRow.setTelefone(" ");
        this.remessasViewRow.setHomepage("");
        this.remessasViewRow.setEmail("");
        this.remessasViewRow.setContabilista("");
        this.remessasViewRow.setCrc("");
        this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfLogradouro).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfNr).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfCompl).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfTelefone).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfHomePage).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfEmail).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfContabilista).refreshControl();
        this.panelBinding.getControlBinding((Object)this.tfCrc).refreshControl();
        this.desativarCampos();
    }

    private void desativarCampos() {
        this.tfPrefMuncipal.setEditable(false);
        this.tfLogradouro.setEditable(false);
        this.tfNr.setEditable(false);
        this.tfCompl.setEditable(false);
        this.tfTelefone.setEditable(false);
        this.tfHomePage.setEditable(false);
        this.tfEmail.setEditable(false);
        this.tfContabilista.setEditable(false);
        this.tfCrc.setEditable(false);
        this.tfPrefMuncipal.setFocusable(false);
        this.tfLogradouro.setFocusable(false);
        this.tfNr.setFocusable(false);
        this.tfCompl.setFocusable(false);
        this.tfTelefone.setFocusable(false);
        this.tfHomePage.setFocusable(false);
        this.tfEmail.setFocusable(false);
        this.tfContabilista.setFocusable(false);
        this.tfCrc.setFocusable(false);
        this.jComboBox1.setEnabled(true);
        this.jComboBoxMes.setEnabled(true);
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_PREFMUNICIPAL = 100;
        int MAX_CHARACTERS_LOGRADOURO = 50;
        int MAX_CHARACTERS_COMPL = 20;
        int MAX_CHARACTERS_NR = 5;
        int MAX_CHARACTERS_HOMEPAGE = 50;
        int MAX_CHARACTERS_EMAIL = 50;
        int MAX_CHARACTERS_CONTABILISTA = 100;
        int MAX_CHARACTERS_CRC = 20;
        int MAX_CHARACTERS_RESPONSAVEL = 100;
        int MAX_CHARACTERS_CARGO = 50;
        int MAX_CHARACTERS_CNPJ = 14;
        ((AbstractDocument)this.tfPrefMuncipal.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_PREFMUNICIPAL));
        ((AbstractDocument)this.tfLogradouro.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_LOGRADOURO));
        ((AbstractDocument)this.tfCompl.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_COMPL));
        ((AbstractDocument)this.tfNr.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_NR));
        ((AbstractDocument)this.tfHomePage.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_HOMEPAGE));
        ((AbstractDocument)this.tfEmail.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_EMAIL));
        ((AbstractDocument)this.tfContabilista.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CONTABILISTA));
        ((AbstractDocument)this.tfCrc.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CRC));
        ((AbstractDocument)this.tfCnpj.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CNPJ));
    }

    @Override
    public void preparaTela() {
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(this.panelBinding.getBindingContext());
        if (remessa != null) {
            ViewRowImpl viewRowImplEntidade;
            BindingContext binding = this.panelBinding.getBindingContext();
            DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
            ServicoPAD ser = (ServicoPAD)dc.getDataProvider();
            ViewObject vo = ser.findViewObject("RemessasDaEntidade");
            Row r = vo.getCurrentRow();
            if (r != null) {
                Integer value = (Integer)r.getAttribute("AnoExercicio");
                SpinnerNumberModel model = (SpinnerNumberModel)this.spnExercicio.getModel();
                Comparable<?> min = model.getMinimum();
                Comparable<?> max = model.getMaximum();
                if (value != null && min.compareTo(value) <= 0 && max.compareTo(value) >= 0) {
                    this.spnExercicio.getModel().setValue(value);
                }
            }
            ViewObject voEntidades = ser.findViewObject("EntidadeDaRemessa");
            voEntidades.setWhereClause("Tipo_Setor_Gov = ?");
            voEntidades.setWhereClauseParam(0, (Object)remessa.getTipoSetor());
            voEntidades.executeQuery();
            if (remessa.getCdEntidade() != null) {
                this.validaEntidadeRemessa(ser, remessa);
            }
            if ((viewRowImplEntidade = (ViewRowImpl)this.jComboBox1.getSelectedItem()) == null) {
                this.jComboBox1.addItem("Selecione um org\u00e3o");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Row r = TelaUC039.this.getRemessaDaEntidade();
                if (r == null || r.getAttribute("CdEntidade") == null) {
                    TelaUC039.this.setaAnoPadrao();
                    TelaUC039.this.setaMesPadrao();
                } else {
                    Object o = r.getAttribute("Mes");
                    if (o instanceof Integer) {
                        int mesIndex = (Integer)o - 1;
                        TelaUC039.this.jComboBoxMes.setSelectedIndex(mesIndex);
                        log.info((Object)("setando m\u00eas [" + mesIndex + "] ; r.CdEntidade = " + r.getAttribute("CdEntidade")));
                    } else {
                        log.info((Object)("m\u00eas n\u00e3o setado [" + o + "] ; r.CdEntidade = " + r.getAttribute("CdEntidade")));
                    }
                }
            }
        });
        this.jComboBoxMes.setEnabled(true);
        this.btnConsultar.setEnabled(true);
        this.remessasViewRow = (RemessasViewRowImpl)this.panelBinding.getControlBinding((Object)this.tfPrefMuncipal).getCurrentRow();
        if (fezBackup.booleanValue()) {
            this.limparCampos();
            fezBackup = false;
        }
        this.desativarCampos();
        if (this.remessasViewRow != null) {
            BigDecimal cdEntidade = this.remessasViewRow.getCdEntidade();
            this.opcaoAnterComboOrgao = cdEntidade == null ? Long.valueOf(-1L) : Long.valueOf(this.remessasViewRow.getCdEntidade().longValue());
            this.opcaoAnterComboPeriodo = this.remessasViewRow.getPeriodoInformacoes();
            this.opcaoAnterExercicio = this.remessasViewRow.getAnoExercicio();
        }
        TelaUC100.setTipoOperacaoConsolidacao(false);
    }

    private boolean validaCNPJEntidade(PopupMenuEvent e) {
        if (this.bindingConcluido) {
            try {
                ViewRowImpl viewRowImplEntidade = (ViewRowImpl)this.jComboBox1.getSelectedItem();
                if (viewRowImplEntidade == null) {
                    this.jComboBox1.setSelectedIndex(0);
                }
            }
            catch (java.lang.Exception exp) {
                log.warn((Object)("Erro na validacao: " + exp));
            }
        }
        return true;
    }

    private void validaEntidadeRemessa(ServicoPAD servico, Remessa remessa) {
        Row entidadeRow;
        ViewObject voRemessa = servico.findViewObject("RemessasDaEntidade");
        Row remessaRow = voRemessa.first();
        if (remessaRow != null && (entidadeRow = (Row)remessaRow.getAttribute("EntidadesView")) != null) {
            String tipoEntidade = (String)entidadeRow.getAttribute("TipoSetorGov");
            String tipoEntidadeOriginal = remessa.getTipoSetor();
            if (tipoEntidadeOriginal != null && !tipoEntidadeOriginal.equals(tipoEntidade)) {
                this.tfCnpj.setText("");
            }
        }
    }

    public int getAnoExercicio() {
        return (Integer)this.spnExercicio.getValue();
    }

    public boolean limpaTabelasCadastros() {
        int option = 1;
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
        option = JOptionPane.showOptionDialog(form, "Ao mudar o Tipo de Setor de Governo ou alterar a Entidade, o PAD limpar\u00e1 todas as tabelas de cadastro.\nVoc\u00ea deseja prosseguir?", "Aten\u00e7\u00e3o", 0, 3, null, options, options[0]);
        return option == 0;
    }

    public boolean validaCampos(String tipoEntidade) {
        String entidade = "";
        if ((ViewRowImpl)this.jComboBox1.getSelectedItem() != null) {
            entidade = ((ViewRowImpl)this.jComboBox1.getSelectedItem()).getAttribute(0).toString();
        }
        if (entidade.equals("") || entidade.equals("-1")) {
            TelaUC039.exibeMensagemWarning("O nome do Setor de Governo precisa ser informado.");
            return false;
        }
        if (!VersaoUtils.isDebugModeEnabled()) {
            if (this.tfPrefMuncipal.getText().equals("")) {
                TelaUC039.exibeMensagemWarning("O Nome do Representante do setor de governo precisa ser informado.");
                return false;
            }
            if (this.tfLogradouro.getText().equals("")) {
                TelaUC039.exibeMensagemWarning("O Endere\u00e7o precisa ser informado.");
                return false;
            }
            if (this.tfTelefone.getText().equals("(  )        ")) {
                TelaUC039.exibeMensagemWarning("O Telefone precisa ser informado.");
                return false;
            }
            if (this.tfEmail.getText().equals("")) {
                TelaUC039.exibeMensagemWarning("O Endere\u00e7o de E-mail precisa ser informado.");
                return false;
            }
            if (this.tfContabilista.getText().equals("")) {
                TelaUC039.exibeMensagemWarning("O Nome do Contabilista precisa ser informado.");
                return false;
            }
            if (this.tfCrc.getText().equals("")) {
                TelaUC039.exibeMensagemWarning("O CRC do contabilista precisa ser informado.");
                return false;
            }
            if (tipoEntidade.equals("P") || tipoEntidade.equals("C")) {
                if (this.remessasViewRow.getRespAdminFinan() == null || this.remessasViewRow.getRespAdminFinan().isEmpty()) {
                    TelaUC039.exibeMensagemWarning("O Respons\u00e1vel Financeiro nao est\u00e1 definido. Favor atualizar cadastro no SISCAD.");
                    return false;
                }
                if (this.remessasViewRow.getRespCtrlInterno() == null || this.remessasViewRow.getRespCtrlInterno().isEmpty()) {
                    TelaUC039.exibeMensagemWarning("O Respons\u00e1vel do Controle Interno nao est\u00e1 definido. Favor atualizar cadastro no SISCAD.");
                    return false;
                }
            }
        }
        return true;
    }

    public static void exibeMensagemWarning(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    public static void exibeMensagemErro(JUFormBinding formBnd, java.lang.Exception e) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        PadErrorDialog errorDialog = new PadErrorDialog(form);
        errorDialog.reportException(formBnd, e);
    }

    public void exibeMensagemErro(java.lang.Exception e) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        PadErrorDialog errorDialog = new PadErrorDialog(form);
        errorDialog.reportException((JUFormBinding)this.panelBinding, e);
    }

    public String getCnpjEntidade() {
        return this.tfCnpj.getText();
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    private void tfNr_keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' || c == ' ') {
            this.getToolkit().beep();
            e.consume();
        }
    }

    public boolean isRemessaCamara() {
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(this.getPanelBinding().getBindingContext());
        return remessa.getTipoSetor().equals("C");
    }

    void setaPeriodoPadrao() {
        Calendar now = Calendar.getInstance();
        int mes = now.get(2) + 1;
        int bimestre = mes < 4 ? 1 : (mes < 6 ? 2 : (mes < 8 ? 3 : (mes < 10 ? 4 : (mes < 12 ? 5 : 6))));
        int index = bimestre - 1;
        log.info((Object)("setaPeriodoPadrao: index==" + index + " / mes==" + mes + " / size==" + this.cbbPeriodicidade.getModel().getSize()));
        if (index < this.cbbPeriodicidade.getModel().getSize()) {
            this.cbbPeriodicidade.setSelectedIndex(bimestre - 1);
        } else {
            log.warn((Object)("setaPeriodoPadrao: n\u00e3o foi poss\u00edvel. index==" + index + " / size==" + this.cbbPeriodicidade.getModel().getSize()));
        }
    }

    void setaMesPadrao() {
        Calendar now = Calendar.getInstance();
        int mes = now.get(2) + 1;
        log.info((Object)("setaMesPadrao: mes==" + mes + " / size==" + this.jComboBoxMes.getModel().getSize()));
        if (mes < this.jComboBoxMes.getModel().getSize()) {
            this.jComboBoxMes.setSelectedIndex(mes >= 1 ? mes - 1 : 0);
        } else {
            log.warn((Object)("setaMesPadrao: n\u00e3o foi poss\u00edvel. mes==" + mes + " / size==" + this.cbbPeriodicidade.getModel().getSize()));
        }
    }

    void setaAnoPadrao() {
        Calendar now = Calendar.getInstance();
        int ano = now.get(1);
        log.info((Object)("setaAnoPadrao: ano == " + ano));
        this.spnExercicio.getModel().setValue(ano);
    }

    public static boolean consultaSiapcLicitacon(BindingContext binding) {
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
        if (remessa == null || remessa.getCdEntidade() == null) {
            log.warn((Object)"Remessa is null", (Throwable)new RuntimeException("Remessa is null"));
            return false;
        }
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
        Connection conn = DatabaseHelper.getConnection(ser);
        try {
            SiapcLicitaconClient.initialize();
            Recebimento rec = SiapcLicitaconClient.buscaUltimoRecebimento(remessa.getCdEntidade(), remessa.getAnoExercicio(), conn);
            if (rec == null) {
                log.info((Object)"sem recebimento anterior");
            } else {
                SiapcLicitaconClient.atualizaRemessa(remessa.getCdEntidade(), rec, conn);
                if (rec.getAnoRecebimento() != remessa.getAnoExercicio() - 1) {
                    log.info((Object)("ultima remessa NAO eh do ano imediatamente anterior [rec.getAnoRecebimento()=" + rec.getAnoRecebimento() + "; remessa.getAnoExercicio()=" + remessa.getAnoExercicio() + "]"));
                } else {
                    String lei = TipoEntidadesList.getLeiPorTipoSetor(remessa.getTipoSetor());
                    log.info((Object)("ultima remessa eh do ano imediatamente anterior [rec.getAnoRecebimento()=" + rec.getAnoRecebimento() + "; remessa.getAnoExercicio()=" + remessa.getAnoExercicio() + " ; lei=" + lei + "]"));
                    if (lei.equals("4320/64") && remessa.getAnoExercicio() >= 2017) {
                        long count = SiapcLicitaconClient.buscaBalVerEncECarrega(remessa.getCdEntidade(), remessa.getAnoExercicio() - 1, conn);
                        log.info((Object)("BalVerEnc:: " + count + " linhas importadas"));
                    }
                }
            }
            if (remessa.getTipoSetor().equals("P")) {
                SiapcLicitaconClient.buscaValoresSiaECarrega(remessa.getCdEntidade(), remessa.getAnoExercicio() - 1, conn);
            } else {
                SiapcLicitaconClient.deleteAllValoresSia(conn);
            }
            SiapcLicitaconClient.buscaLicitacoesVencedoresECarrega(remessa.getCdEntidade(), true, conn);
            SiapcLicitaconClient.buscaContratosECarrega(remessa.getCdEntidade(), true, conn);
            if (!remessa.getTipoSetor().equals("P")) {
                Integer cdEntidadePai = TelaUC039.getCdEntidadePai(ser, remessa.getCdEntidade());
                if (cdEntidadePai != null) {
                    log.info((Object)("Entidade consultando licita\u00e7\u00f5es e contratos da entidade pai [cd_entidade=" + remessa.getCdEntidade() + ";cd_entidade_pai=" + cdEntidadePai + "]"));
                    SiapcLicitaconClient.buscaLicitacoesVencedoresECarrega(cdEntidadePai, false, conn);
                    SiapcLicitaconClient.buscaContratosECarrega(cdEntidadePai, false, conn);
                } else {
                    log.warn((Object)("Entidade sem entidade pai? [cd_entidade=" + remessa.getCdEntidade() + "]"));
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)("Erro [IOException] no consultaSiapcLicitacon [" + e.getMessage() + "]"), (Throwable)e);
            SiapcLicitaconClient.limpaDadosUltimoRecebimento(remessa.getCdEntidade(), conn);
            TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
            return false;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Erro [RuntimeException] no consultaSiapcLicitacon [" + e.getMessage() + "]"), (Throwable)e);
            SiapcLicitaconClient.limpaDadosUltimoRecebimento(remessa.getCdEntidade(), conn);
            TelaUC039.exibeMensagemWarning(MSG_ERRO_INESPERADO + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean consultaLicitacon(BindingContext binding) {
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
        if (remessa == null || remessa.getCdEntidade() == null) {
            log.warn((Object)"Remessa is null", (Throwable)new RuntimeException("Remessa is null"));
            return false;
        }
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
        Connection conn = DatabaseHelper.getConnection(ser);
        try {
            SiapcLicitaconClient.initialize();
            SiapcLicitaconClient.buscaLicitacoesVencedoresECarrega(remessa.getCdEntidade(), true, conn);
            SiapcLicitaconClient.buscaContratosECarrega(remessa.getCdEntidade(), true, conn);
            if (!remessa.getTipoSetor().equals("P")) {
                Integer cdEntidadePai = TelaUC039.getCdEntidadePai(ser, remessa.getCdEntidade());
                if (cdEntidadePai != null) {
                    log.info((Object)("Entidade consultando licita\u00e7\u00f5es e contratos da entidade pai [cd_entidade=" + remessa.getCdEntidade() + ";cd_entidade_pai=" + cdEntidadePai + "]"));
                    SiapcLicitaconClient.buscaLicitacoesVencedoresECarrega(cdEntidadePai, false, conn);
                    SiapcLicitaconClient.buscaContratosECarrega(cdEntidadePai, false, conn);
                } else {
                    log.warn((Object)("Entidade sem entidade pai? [cd_entidade=" + remessa.getCdEntidade() + "]"));
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)("Erro [IOException] no consultaLicitacon [" + e.getMessage() + "]"), (Throwable)e);
            SiapcLicitaconClient.limpaDadosUltimoRecebimento(remessa.getCdEntidade(), conn);
            TelaUC039.exibeMensagemWarning(MSG_ERRO_CONEXAO);
            return false;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Erro [RuntimeException] no consultaLicitacon [" + e.getMessage() + "]"), (Throwable)e);
            SiapcLicitaconClient.limpaDadosUltimoRecebimento(remessa.getCdEntidade(), conn);
            TelaUC039.exibeMensagemWarning(MSG_ERRO_INESPERADO + e.getMessage());
            return false;
        }
        return true;
    }

    static Integer getCdEntidadePai(ServicoPAD ser, int cdEntidade) {
        Integer ret = null;
        ViewObject vo = ser.createViewObjectFromQueryStmt("UC039getCdEntidadePai", "select e.cd_entidade_pai from entidades e where cd_entidade = " + cdEntidade);
        vo.executeQuery();
        long queryRowCount = 0L;
        while (vo.hasNext()) {
            Row r = vo.next();
            ret = ((BigDecimal)r.getAttribute(0)).intValue();
            if (++queryRowCount <= 1L) continue;
            log.warn((Object)("queryRowCount==" + queryRowCount));
        }
        vo.closeRowSet();
        vo.remove();
        return ret;
    }

    public MesList getMesSelecionado() {
        return (MesList)((Object)this.jComboBoxMes.getSelectedItem());
    }
}

