/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.util.VersaoUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.jbo.JboException;
import oracle.jbo.common.StringManager;
import oracle.jbo.uicli.UIMessageBundle;

class JUErrorDialog
extends JDialog
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private JPanel mPanel = new JPanel();
    private JButton mOKButton = new JButton(StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02600", null, null));
    private JButton mDetailsButton;
    private JButton mStackTracesButton;
    private JButton mClipboardButton;
    private JTextArea mTextArea = new JTextArea(5, 80);
    private Exception mEx;
    private boolean mShowDetails;
    private boolean mShowStackTraces;
    private String mDetailsButtonText = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02610", null, null);
    private String mNoDetailsButtonText = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02611", null, null);
    private String mStackTracesButtonText = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02612", null, null);
    private String mNoStackTracesButtonText = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02613", null, null);
    private String mDetailSep1 = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02615", null, null);
    private String mDetailSep2 = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02616", null, null);
    private String mDetailLevel = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02617", null, null);
    private String mDetailHeader = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02618", null, null);
    private String mDetailIndent = StringManager.getString((String)UIMessageBundle.class.getName(), (String)"02619", null, null);

    JUErrorDialog(Frame parent, String title, boolean modal, Exception ex) {
        super(parent, title, modal);
        this.mEx = ex;
        this.jbInit();
        this.pack();
    }

    void formErrorMessage(int num, int lev, StringBuffer buff, Exception ex) {
        Object[] nextLevDetails;
        String indent = "";
        for (int j = 1; j < lev; ++j) {
            indent = indent + this.mDetailIndent;
        }
        if (lev > 0) {
            buff.append(indent).append(this.mDetailSep1).append(this.mDetailLevel).append(lev).append(this.mDetailHeader).append(num).append(this.mDetailSep2).append("\n");
        }
        if (this.mShowStackTraces) {
            StringWriter stkWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stkWriter));
            stkWriter.flush();
            buff.append(indent).append(stkWriter.toString()).append("\n");
        } else {
            String strmsg = ex.getLocalizedMessage();
            buff.append(indent).append("(").append(ex.getClass().getName()).append(") ").append(strmsg).append("\n");
        }
        if (this.mShowDetails && ex instanceof JboException && (nextLevDetails = ((JboException)((Object)ex)).getDetails()) != null) {
            for (int j = 0; j < nextLevDetails.length; ++j) {
                this.formErrorMessage(j, lev + 1, buff, (Exception)nextLevDetails[j]);
            }
        }
    }

    String getErrorMessage() {
        StringBuffer msgBuff = new StringBuffer();
        this.formErrorMessage(0, 0, msgBuff, this.mEx);
        return msgBuff.toString();
    }

    boolean hasDetails() {
        if (this.mEx instanceof JboException) {
            Object[] details = ((JboException)((Object)this.mEx)).getDetails();
            return details != null && details.length > 0;
        }
        return false;
    }

    void jbInit() {
        this.mPanel.add(this.mOKButton);
        if (this.mEx != null) {
            this.mDetailsButton = new JButton(this.mDetailsButtonText);
            this.mDetailsButton.setEnabled(this.hasDetails());
            this.mPanel.add(this.mDetailsButton);
            this.mStackTracesButton = new JButton(this.mStackTracesButtonText);
            this.mStackTracesButton.setEnabled(true);
            this.mPanel.add(this.mStackTracesButton);
            this.mClipboardButton = new JButton();
            this.mClipboardButton.setText("Copiar Info");
            this.mClipboardButton.setToolTipText("Copiar para a area de transferencia");
            this.mPanel.add(this.mClipboardButton);
        }
        this.getRootPane().setDefaultButton(this.mOKButton);
        this.mTextArea.setEditable(false);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setBackground(this.getBackground());
        this.mOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUErrorDialog.this.setVisible(false);
                JUErrorDialog.this.dispose();
            }
        });
        if (this.mDetailsButton != null) {
            this.mDetailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!JUErrorDialog.this.mShowDetails) {
                        JUErrorDialog.this.mShowDetails = true;
                        JUErrorDialog.this.mDetailsButton.setText(JUErrorDialog.this.mNoDetailsButtonText);
                        JUErrorDialog.this.mTextArea.setText(JUErrorDialog.this.getErrorMessage());
                    } else {
                        JUErrorDialog.this.mShowDetails = false;
                        JUErrorDialog.this.mDetailsButton.setText(JUErrorDialog.this.mDetailsButtonText);
                        JUErrorDialog.this.mTextArea.setText(JUErrorDialog.this.getErrorMessage());
                    }
                }
            });
        }
        if (this.mStackTracesButton != null) {
            this.mStackTracesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!JUErrorDialog.this.mShowStackTraces) {
                        JUErrorDialog.this.mShowStackTraces = true;
                        JUErrorDialog.this.mStackTracesButton.setText(JUErrorDialog.this.mNoStackTracesButtonText);
                        JUErrorDialog.this.mTextArea.setText(JUErrorDialog.this.getErrorMessage());
                    } else {
                        JUErrorDialog.this.mShowStackTraces = false;
                        JUErrorDialog.this.mStackTracesButton.setText(JUErrorDialog.this.mStackTracesButtonText);
                        JUErrorDialog.this.mTextArea.setText(JUErrorDialog.this.getErrorMessage());
                    }
                }
            });
        }
        if (this.mClipboardButton != null) {
            this.mClipboardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = JUErrorDialog.this.getToolkit().getSystemClipboard();
                    StringSelection contents = new StringSelection(JUErrorDialog.getInfo() + JUErrorDialog.this.getErrorMessage());
                    clipboard.setContents(contents, null);
                }
            });
        }
        this.getContentPane().add((Component)new JScrollPane(this.mTextArea), "Center");
        this.getContentPane().add((Component)this.mPanel, "South");
    }

    public void showError() {
        this.getParent().setCursor(Cursor.getPredefinedCursor(0));
        this.mTextArea.setText(this.getErrorMessage());
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public static String getInfo() {
        String userDir;
        StringBuffer infoBuff = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        infoBuff.append("PAD 25.1.0.5\n");
        infoBuff.append("Sistema operacional = " + System.getProperty("os.name") + " " + System.getProperty("sun.os.patch.level") + " ; " + System.getProperty("os.version") + "\n");
        infoBuff.append("Vers\u00e3o Java Runtime = " + System.getProperty("java.version") + " ; " + System.getProperty("java.runtime.version") + "\n");
        infoBuff.append("Runtime.maxMemory()/-Xmx = " + Runtime.getRuntime().maxMemory() + "\n");
        infoBuff.append("Charset.defaultCharset() = " + Charset.defaultCharset() + "\n");
        infoBuff.append("file.encoding = " + System.getProperty("file.encoding") + "\n");
        infoBuff.append("java.home = " + System.getProperty("java.home") + "\n");
        infoBuff.append("java.vm.name = " + System.getProperty("java.vm.name") + "\n");
        infoBuff.append("java.vm.vendor = " + System.getProperty("java.vm.vendor") + "\n");
        infoBuff.append("user.dir = " + System.getProperty("user.dir") + "\n");
        infoBuff.append("user.home = " + System.getProperty("user.home") + "\n");
        infoBuff.append("user.name = " + System.getProperty("user.name") + "\n");
        infoBuff.append("user.country = " + System.getProperty("user.country") + "\n");
        String dir = userDir = System.getProperty("user.dir");
        infoBuff.append("permissao-escrita [" + dir + "] = " + VersaoUtils.hasWritePermission(new File(dir)) + "\n");
        dir = userDir + File.separator + "remessa";
        infoBuff.append("permissao-escrita [" + dir + "] = " + VersaoUtils.hasWritePermission(new File(dir)) + "\n");
        dir = userDir + File.separator + "database";
        infoBuff.append("permissao-escrita [" + dir + "] = " + VersaoUtils.hasWritePermission(new File(dir)) + "\n");
        infoBuff.append("Data/hora = " + sdf.format(new Date().getTime()) + "\n\n");
        return infoBuff.toString();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

