/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util.test;

import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.excecao.SenhaInvalidaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.util.CodigoBarrasHelper;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;

public class MontaDadosCRP {
    private static final String DIR_ARQUIVOS_DEFAULT = "C:/Extrator/pcdi_extraidos/88488366000100.2007.2.V.2007.05.21.15.02.08.207251071820642.00";
    private static final String DIR_KEY_DEFAULT = "C:/Advancedit/TCE005J/Fontes/Siapc-PAD-Desktop/remessa/tcenet-bdl.200.0A7D.pfx";
    private File diretorioOrigem = new File("C:/Extrator/pcdi_extraidos/88488366000100.2007.2.V.2007.05.21.15.02.08.207251071820642.00");

    public MontaDadosCRP() {
        File f = new File(DIR_ARQUIVOS_DEFAULT + File.separator + "/remessa_info.xml");
        File arquivoPFX = new File(DIR_KEY_DEFAULT);
        Remessa remessa = new Remessa();
        RemessaInfo remInfo = null;
        remInfo = (RemessaInfo)ConfiguracaoControle.carregaDadosArquivoXML("remessa-info", f, true);
        remessa.setTipoSetor(remInfo.getTipoOrgao());
        remessa.setPeriodoInformacoes(remInfo.getPeriodoInformacoes());
        this.geraTXTCripto(remInfo, null, arquivoPFX);
    }

    public MontaDadosCRP(String pathFiles, String pathKey) {
        File f = null;
        try {
            f = new File(pathFiles + File.separator + "remessa_info.xml");
            this.diretorioOrigem = new File(pathFiles);
        }
        catch (NullPointerException npe) {
            f = new File(DIR_ARQUIVOS_DEFAULT + File.separator + "remessa_info.xml");
            this.diretorioOrigem = new File(DIR_ARQUIVOS_DEFAULT);
        }
        if (pathFiles == null || !f.exists() || !this.diretorioOrigem.exists()) {
            f = new File(DIR_ARQUIVOS_DEFAULT + File.separator + "remessa_info.xml");
            this.diretorioOrigem = new File(DIR_ARQUIVOS_DEFAULT);
        }
        File arquivoPFX = null;
        try {
            arquivoPFX = new File(pathKey);
        }
        catch (NullPointerException npe) {
            arquivoPFX = new File(DIR_KEY_DEFAULT);
        }
        if (pathKey == null || !arquivoPFX.exists()) {
            arquivoPFX = new File(DIR_KEY_DEFAULT);
        }
        Remessa remessa = new Remessa();
        RemessaInfo remInfo = null;
        remInfo = (RemessaInfo)ConfiguracaoControle.carregaDadosArquivoXML("remessa-info", f, true);
        remessa.setTipoSetor(remInfo.getTipoOrgao());
        remessa.setPeriodoInformacoes(remInfo.getPeriodoInformacoes());
        this.geraTXTCripto(remInfo, null, arquivoPFX);
    }

    public void geraTXTCripto(RemessaInfo reme, char[] senha, File certificado) {
        block9: {
            ArrayList<File> arquivosTXT = new ArrayList<File>();
            File[] arquivoNomes = new File(this.getPath()).listFiles();
            for (int i = 0; i < arquivoNomes.length; ++i) {
                if (!arquivoNomes[i].getName().endsWith(".TXT")) continue;
                arquivosTXT.add(arquivoNomes[i]);
            }
            int cont = 0;
            CompactacaoHelper zip = new CompactacaoHelper();
            File destino = null;
            if (arquivosTXT.size() > 0) {
                arquivoNomes = new File[arquivosTXT.size()];
                Iterator i = arquivosTXT.iterator();
                while (i.hasNext()) {
                    arquivoNomes[cont] = (File)i.next();
                    ++cont;
                }
                destino = new File(this.getPath() + "dados.dat");
                zip.compacta(arquivoNomes, destino);
            }
            arquivosTXT = new ArrayList();
            arquivoNomes = new File(this.getPath()).listFiles();
            for (int i = 0; i < arquivoNomes.length; ++i) {
                if (!arquivoNomes[i].getName().endsWith(".xml")) continue;
                arquivosTXT.add(arquivoNomes[i]);
            }
            arquivoNomes = new File[arquivosTXT.size()];
            cont = 0;
            Iterator i = arquivosTXT.iterator();
            while (i.hasNext()) {
                arquivoNomes[cont] = (File)i.next();
                ++cont;
            }
            destino = new File(this.getPath() + "remessa.zip");
            zip = new CompactacaoHelper();
            zip.compacta(arquivoNomes, destino);
            try {
                CriptografiaControle.criptografa(new File(this.getPath() + "remessa.zip"), new File(this.getPath() + "remessa.crp"), "P@D.WEB?D&SKTOP;");
                CriptografiaControle.criptografa(new File(this.getPath() + "dados.dat"), new File(this.getPath() + "dados.crp"), "P@D.WEB?D&SKTOP;");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                String strSenha = null;
                strSenha = senha != null ? new String(senha) : "YABX5-EMUE7-ECDD7";
                AssinaturaDigitalControle.CertificationChainAndSignature cc = null;
                cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(new File(this.getPath() + "dados.crp"), certificado, strSenha);
                System.out.println("Assinatura INFO = " + reme.getAssinaturaTxt());
                System.out.println("assinatura NOVA = " + cc.getSignature());
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("failed to decrypt safe contents entry") < 0) break block9;
                throw new SenhaInvalidaException("Senha informada n\u00e3o confere com senha do arquivo de certificado");
            }
        }
        reme.calculaDigestRemessa();
        System.out.println("RVE =" + CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
        System.out.println("RVE LEG =" + CodigoBarrasHelper.constroiCodigoBarra(reme, 6));
        System.out.println("14 =" + CodigoBarrasHelper.constroiCodigoBarra(reme, 3));
        System.out.println("9 =" + CodigoBarrasHelper.constroiCodigoBarra(reme, 2));
    }

    private String getPath() {
        return this.diretorioOrigem.getAbsolutePath() + File.separator;
    }

    public static void main(String[] args) {
        String caminhoArquivos = null;
        String caminhoChave = null;
        if (args.length > 0) {
            caminhoArquivos = args[0];
        }
        if (args.length > 1) {
            caminhoChave = args[1];
        }
        MontaDadosCRP crp = new MontaDadosCRP(caminhoArquivos, caminhoChave);
    }
}

