/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.Row;
import oracle.jbo.SQLStmtException;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersaoUtils {
    private static String CODIGO_TABELA_INEXISTENTE_DERBY = "42X05";
    public static String VERSAO_DATABASE_VIEW = "VersaoDatabaseView";
    public ApplicationModule servicoPAD = null;
    private static Log log = LogFactory.getLog(VersaoUtils.class);

    private VersaoUtils() {
    }

    public VersaoUtils(ServicoPAD myServicoPad) {
        this.servicoPAD = myServicoPad;
    }

    public String getVersaoPADDatabase() {
        String versaoDatabase = null;
        ViewObject versaoDatabaseVO = this.servicoPAD.findViewObject(VERSAO_DATABASE_VIEW);
        VersaoUtils.logConnectionInfo(this.servicoPAD);
        if (versaoDatabaseVO != null) {
            Row r;
            versaoDatabaseVO.setWhereClause(null);
            versaoDatabaseVO.setWhereClauseParams(null);
            try {
                versaoDatabaseVO.executeQuery();
            }
            catch (SQLStmtException ex) {
                log.warn((Object)("getVersaoPADDatabase: versaoDatabase = " + versaoDatabase + " ; VERSAO_PAD = " + "25.1.0.5" + " ; ex = " + (Object)((Object)ex)));
                return versaoDatabase;
            }
            if (versaoDatabaseVO.getRowCount() > 0 && !"25.1.0.5".equals(versaoDatabase = (String)(r = versaoDatabaseVO.first()).getAttribute("Versao"))) {
                log.warn((Object)("getVersaoPADDatabase: versaoDatabase = " + versaoDatabase + " ; VERSAO_PAD = " + "25.1.0.5" + " [versao invalida]"));
                return null;
            }
        }
        log.info((Object)("getVersaoPADDatabase: versaoDatabase = " + versaoDatabase + " ; VERSAO_PAD = " + "25.1.0.5"));
        return versaoDatabase;
    }

    public static boolean isDebugModeEnabled() {
        return !"".equals("");
    }

    public static void logConnectionInfo(ApplicationModule servicoPAD) {
        try {
            Connection conn = DatabaseHelper.getConnection(servicoPAD);
            VersaoUtils.logConnectionInfo(conn);
        }
        catch (SQLException e) {
            log.warn((Object)("Exception: " + e));
        }
    }

    public static void logConnectionInfo(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        PreparedStatement ps = conn.prepareStatement("values syscs_util.syscs_get_database_property( 'DataDictionaryVersion' )");
        ResultSet rs = ps.executeQuery();
        rs.next();
        String dictVersion = rs.getString(1);
        rs.close();
        log.info((Object)("dbProduct= " + dbmd.getDatabaseProductName() + "; dbVersion= " + dbmd.getDatabaseProductVersion() + ";; dictVersion=" + dictVersion));
    }

    public static boolean hasWritePermission(File dir) {
        try {
            File f = File.createTempFile("padtmp", "txt", dir);
            f.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final int getVersaoInt(String versao) {
        return Integer.parseInt(versao.replaceAll("\\.", ""));
    }

    public static final String getVersaoTestId() {
        return "";
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("versao java invalida? [java.version=" + version + "]"));
            return 0;
        }
    }
}

