/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.util.OracleDateComparator;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;
import oracle.jbo.domain.Timestamp;

public class DateUtils {
    public static int getUltimoDiaMes(int ano, int mes) {
        return new GregorianCalendar(ano, mes, 1).getActualMaximum(5);
    }

    public static java.sql.Date getUltimoDataMes(int anoExercicio, int mes) {
        Calendar lastPeriodCal = Calendar.getInstance();
        lastPeriodCal.set(anoExercicio, mes, DateUtils.getUltimoDiaMes(anoExercicio, mes));
        return new java.sql.Date(lastPeriodCal.getTimeInMillis());
    }

    public static int getPrimeiroMesPeriodo(int periodo, String tipoPeriodo) {
        if ("B".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getPrimeiroMesPeriodo(periodo);
        }
        if ("Q".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getPrimeiroMesQuadrimestre(periodo);
        }
        if ("S".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getPrimeiroMesSemestre(periodo);
        }
        return -1;
    }

    public static int getUltimoMesPeriodo(int periodo, String tipoPeriodo) {
        if ("B".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getUltimoMesPeriodo(periodo);
        }
        if ("Q".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getUltimoMesQuadrimestre(periodo);
        }
        if ("S".equalsIgnoreCase(tipoPeriodo)) {
            return DateUtils.getUltimoMesSemestre(periodo);
        }
        return -1;
    }

    public static int getPrimeiroMesPeriodo(int periodo) {
        if (periodo == 1) {
            return 0;
        }
        if (periodo == 2) {
            return 2;
        }
        if (periodo == 3) {
            return 4;
        }
        if (periodo == 4) {
            return 6;
        }
        if (periodo == 5) {
            return 8;
        }
        if (periodo == 6) {
            return 10;
        }
        return -1;
    }

    public static int getPrimeiroMesQuadrimestre(int periodo) {
        if (periodo == 1) {
            return 0;
        }
        if (periodo == 2) {
            return 4;
        }
        if (periodo == 3) {
            return 8;
        }
        return -1;
    }

    public static int getPrimeiroMesSemestre(int periodo) {
        if (periodo == 1) {
            return 0;
        }
        if (periodo == 2) {
            return 6;
        }
        return -1;
    }

    public static int getUltimoMesPeriodo(int periodo) {
        if (periodo == 1) {
            return 1;
        }
        if (periodo == 2) {
            return 3;
        }
        if (periodo == 3) {
            return 5;
        }
        if (periodo == 4) {
            return 7;
        }
        if (periodo == 5) {
            return 9;
        }
        if (periodo == 6) {
            return 11;
        }
        return -1;
    }

    public static int getUltimoMesQuadrimestre(int periodo) {
        if (periodo == 1) {
            return 3;
        }
        if (periodo == 2) {
            return 7;
        }
        if (periodo == 3) {
            return 11;
        }
        return -1;
    }

    public static int getUltimoMesSemestre(int periodo) {
        if (periodo == 1) {
            return 5;
        }
        if (periodo == 2) {
            return 11;
        }
        return -1;
    }

    public static String getTextMonth(int month) {
        String mes = null;
        switch (month) {
            case 0: {
                mes = "Janeiro";
                break;
            }
            case 1: {
                mes = "Fevereiro";
                break;
            }
            case 2: {
                mes = "Mar\u00e7o";
                break;
            }
            case 3: {
                mes = "Abril";
                break;
            }
            case 4: {
                mes = "Maio";
                break;
            }
            case 5: {
                mes = "Junho";
                break;
            }
            case 6: {
                mes = "Julho";
                break;
            }
            case 7: {
                mes = "Agosto";
                break;
            }
            case 8: {
                mes = "Setembro";
                break;
            }
            case 9: {
                mes = "Outubro";
                break;
            }
            case 10: {
                mes = "Novembro";
                break;
            }
            case 11: {
                mes = "Dezembro";
            }
        }
        return mes;
    }

    public static oracle.jbo.domain.Date parseToOracleDate(java.sql.Date data) throws SQLException {
        return new oracle.jbo.domain.Date(data);
    }

    public static oracle.jbo.domain.Date parseToOracleDate(Date data) throws SQLException {
        return new oracle.jbo.domain.Date((Object)data.getTime());
    }

    public static java.sql.Date getDataInicioPeriodo(int periodo, int ano) {
        int mesInicio = DateUtils.getPrimeiroMesPeriodo(periodo);
        Calendar cal = Calendar.getInstance();
        cal.set(ano, mesInicio, 1);
        java.sql.Date dataInicio = new java.sql.Date(cal.getTimeInMillis());
        return dataInicio;
    }

    public static java.sql.Date getDataFimPeriodo(int periodo, int ano) {
        int mesFim = DateUtils.getUltimoMesPeriodo(periodo);
        int diaFim = DateUtils.getUltimoDiaMes(ano, mesFim);
        Calendar cal = Calendar.getInstance();
        cal.set(ano, mesFim, diaFim);
        java.sql.Date dataFim = new java.sql.Date(cal.getTimeInMillis());
        return dataFim;
    }

    public static java.sql.Date getDataInicioMes(int mes, int ano) {
        int mesInicio = mes - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(ano, mesInicio, 1);
        java.sql.Date dataFim = new java.sql.Date(cal.getTimeInMillis());
        return dataFim;
    }

    public static java.sql.Date getDataFimMes(int mes, int ano) {
        int mesFim = mes - 1;
        int diaFim = DateUtils.getUltimoDiaMes(ano, mesFim);
        Calendar cal = Calendar.getInstance();
        cal.set(ano, mesFim, diaFim);
        java.sql.Date dataFim = new java.sql.Date(cal.getTimeInMillis());
        return dataFim;
    }

    public static Date getDateFromString(String str) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        try {
            Date data = df.parse(str);
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStringFromDate(Date data) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return df.format(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        java.sql.Date data = DateUtils.getDataInicioPeriodo(2, 2005);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        System.out.println(" Data Inicio Segundo Semestre 2005 => " + sdf.format(data));
        data = DateUtils.getDataFimPeriodo(1, 2005);
        System.out.println(" Data Fim Primeiro Bimestre 2005 => " + sdf.format(data));
        data = DateUtils.getDataFimPeriodo(3, 2005);
        System.out.println(" Data Fim Terceiro Quadrimestre 2005 => " + sdf.format(data));
    }

    public static oracle.jbo.domain.Date getBC4JSysDate(ApplicationModule ser) {
        ViewObject vo = ser.createViewObjectFromQueryStmt("DateViewObject", "select sysdate from dual where 1 = 1");
        oracle.jbo.domain.Date sysDateBC4J = (oracle.jbo.domain.Date)vo.first().getAttribute(0);
        vo.remove();
        return sysDateBC4J;
    }

    public static Timestamp getBC4JSysTimestamp(ApplicationModule ser) {
        ViewObject vo = ser.createViewObjectFromQueryStmt("DateViewObject", "select sysdate from dual where 1 = 1");
        Timestamp sysTimeBC4J = (Timestamp)vo.first().getAttribute(0);
        vo.remove();
        return sysTimeBC4J;
    }

    public static oracle.jbo.domain.Date getOracleDataMaior(ArrayList list) {
        return Collections.max(list, new OracleDateComparator());
    }

    public static java.sql.Date getLastDateOfPeriod(int periodoBimestre, String tipoPeriodo, int anoExercicio) {
        Calendar lastPeriodCal = Calendar.getInstance();
        lastPeriodCal.set(anoExercicio, DateUtils.getUltimoMesPeriodo(periodoBimestre, tipoPeriodo), 1);
        int lastDay = lastPeriodCal.getActualMaximum(5);
        lastPeriodCal.set(anoExercicio, DateUtils.getUltimoMesPeriodo(periodoBimestre, tipoPeriodo), lastDay);
        return new java.sql.Date(lastPeriodCal.getTimeInMillis());
    }

    public static java.sql.Date getFirstDateOfPeriodo(int periodoBimestre, String tipoPeriodo, int anoExercicio) {
        Calendar lastPeriodCal = Calendar.getInstance();
        lastPeriodCal.set(anoExercicio, DateUtils.getPrimeiroMesPeriodo(periodoBimestre, tipoPeriodo), 1);
        int lastDay = lastPeriodCal.getActualMaximum(5);
        lastPeriodCal.set(anoExercicio, DateUtils.getPrimeiroMesPeriodo(periodoBimestre, tipoPeriodo), lastDay);
        return new java.sql.Date(lastPeriodCal.getTimeInMillis());
    }

    public static boolean isAnoBissesto(int ano) {
        boolean retorno = false;
        if (ano % 4 == 0 && (ano % 100 != 0 || ano % 400 == 0)) {
            retorno = true;
        }
        return retorno;
    }
}

