/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.server.ApplicationModuleImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseHelper {
    private static TipoBancoDados TIPO_BANCO = null;
    private static Log log = LogFactory.getLog(DatabaseHelper.class);

    private DatabaseHelper() {
    }

    public static TipoBancoDados recuperaTipoBancoDados(Connection conexao) {
        TipoBancoDados tipo = TIPO_BANCO;
        if (tipo != null) {
            return tipo;
        }
        try {
            DatabaseMetaData metaData = conexao.getMetaData();
            tipo = DatabaseHelper.recuperaTipoBancoDados(metaData);
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
        return tipo;
    }

    public static TipoBancoDados recuperaTipoBancoDados(DatabaseMetaData metaData) {
        if (TIPO_BANCO != null) {
            return TIPO_BANCO;
        }
        try {
            String productName = metaData.getDatabaseProductName();
            TIPO_BANCO = TipoBancoDados.valueOf(productName);
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
        return TIPO_BANCO;
    }

    public static TipoBancoDados recuperaTipoBancoDados(ApplicationModule app) {
        if (TIPO_BANCO != null) {
            return TIPO_BANCO;
        }
        if (app == null) {
            throw new IllegalArgumentException("O ApplicationModule n\u00e3o pode ser null");
        }
        TIPO_BANCO = TipoBancoDados.valueOf(app.getTransaction().getConnectionMetadata().getJdbcURL());
        return TIPO_BANCO;
    }

    public static final Connection getConnection(ApplicationModule app) {
        Connection conn = null;
        try {
            ApplicationModuleImpl appImpl = (ApplicationModuleImpl)app;
            CallableStatement callSt = appImpl.getDBTransaction().createCallableStatement("select 1 from remessas", 1);
            conn = callSt.getConnection();
        }
        catch (SQLException e) {
            throw new PersistenciaException("10018", null, e);
        }
        return conn;
    }

    public static final void fechaDerbyDatabase() {
        block2: {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 50000) break block2;
                log.error((Object)"Erro ao fechar banco de dados.", (Throwable)e);
            }
        }
        log.debug((Object)"Banco de Dados Derby fechado com sucesso");
    }
}

