/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class CodigoBarrasHelper {
    public static final int RELATORIO_RVE = 1;
    public static final int RELATORIO_MODELO_9 = 2;
    public static final int RELATORIO_MODELO_14 = 3;
    public static final int RELATORIO_MCI_9 = 4;
    public static final int RELATORIO_MCI_14 = 5;
    public static final int RELATORIO_RVE_LEG = 6;
    public static final int RELATORIO_DC_BP = 8;
    public static final int RELATORIO_DC_BO = 9;
    public static final int RELATORIO_DC_DVP = 10;
    private static List<Integer> listaRelatoriosPAD = new ArrayList<Integer>();
    static NumberFormat formatter;

    private CodigoBarrasHelper() {
    }

    public static String constroiCodigoBarra(RemessaInfo remessa, int tipoRelatorio) {
        CRC32 gerador = new CRC32();
        Integer exercicio = remessa.getAnoExercicio();
        byte[] digest = remessa.getDigestRemessaArray();
        Integer periodo = remessa.getPeriodoInformacoes();
        Integer grupoEntrega = remessa.getGrupoEntrega();
        switch (tipoRelatorio) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                throw new IllegalArgumentException("Tipo de relat\u00f3rio n\u00e3o executado por esta classe deve ser executado na classe do programa MCI.");
            }
            default: {
                throw new IllegalArgumentException("Tipo de relat\u00f3rio n\u00e3o \u00e9 v\u00e1lido, use as constantes definidas na classe.");
            }
        }
        if (exercicio == null) {
            throw new IllegalArgumentException("AnoExercicio n\u00e3o pode ser nulo.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Digest da remessa n\u00e3o pode ser nulo.");
        }
        if (periodo == null) {
            throw new IllegalArgumentException("Periodo de informa\u00e7\u00f5es n\u00e3o pode ser nulo.");
        }
        if (grupoEntrega == null) {
            throw new IllegalArgumentException("Grupo de Entrega n\u00e3o pode ser nulo.");
        }
        gerador.update(digest);
        String crc32 = formatter.format(gerador.getValue());
        String anoExecicio = exercicio.toString().substring(2);
        StringBuffer codigoBarras = new StringBuffer(17);
        codigoBarras.append(periodo).append(anoExecicio).append(String.format("%02d", tipoRelatorio)).append(String.format("%02d", grupoEntrega)).append(crc32);
        return codigoBarras.toString();
    }

    public static synchronized int getGrupoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            if (codBarras.length() == 15) {
                retorno = Integer.parseInt(codBarras.substring(4, 5));
            } else if (codBarras.length() == 17) {
                retorno = Integer.parseInt(codBarras.substring(5, 7));
            }
        }
        return retorno;
    }

    public static synchronized boolean isRelatorioPAD(int tipoRelatorio) {
        return listaRelatoriosPAD.contains(tipoRelatorio);
    }

    public static synchronized int getTipoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            if (codBarras.length() == 15) {
                retorno = Integer.parseInt(codBarras.substring(3, 4));
            } else if (codBarras.length() == 17) {
                retorno = Integer.parseInt(codBarras.substring(3, 5));
            }
        }
        return retorno;
    }

    public static synchronized int getPeriodoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(0, 1));
        }
        if (!CodigoBarrasHelper.isRelatorioPAD(CodigoBarrasHelper.getTipoRelatorio(codBarras))) {
            switch (retorno) {
                case 1: {
                    retorno = 2;
                    break;
                }
                case 2: {
                    retorno = 4;
                    break;
                }
                case 3: {
                    retorno = 6;
                    break;
                }
                case 4: {
                    retorno = 3;
                    break;
                }
                case 5: {
                    retorno = 6;
                }
            }
        }
        return retorno;
    }

    public static synchronized int getAnoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(1, 3));
        }
        return 2000 + retorno;
    }

    public static synchronized int getAnoRelatorio2Digitos(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(1, 3));
        }
        return retorno;
    }

    static {
        listaRelatoriosPAD.add(1);
        listaRelatoriosPAD.add(6);
        listaRelatoriosPAD.add(3);
        listaRelatoriosPAD.add(2);
        listaRelatoriosPAD.add(8);
        listaRelatoriosPAD.add(9);
        formatter = new DecimalFormat("0000000000");
    }
}

