/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.complementares;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class TCE4810_32
extends RegraLinha {
    public static final String CONTADOR = "verificacao.4810_32.contador";
    public static final String CONTADOR_GERAL = "verificacao.4810_32.contadorGeral";
    private DecimalFormat dcFormat = new DecimalFormat("##0.00");

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        Integer contador = (Integer)contexto.getAtributo(CONTADOR);
        Integer contadorGeral = (Integer)contexto.getAtributo(CONTADOR_GERAL);
        if (contador == null) {
            contador = 0;
        }
        if (contadorGeral == null) {
            contadorGeral = 0;
        }
        if (evento.getTipoEvento() == 3) {
            Integer codBanco = (Integer)valoresCampos.getValorCampo("codBancoFuncionario");
            String codAgencia = (String)valoresCampos.getValorCampo("codAgenciaFuncionario");
            String codContaCorrente = (String)valoresCampos.getValorCampo("codContaCorrenteFuncionario");
            contadorGeral = contadorGeral + 1;
            contexto.adicionaAtributo(CONTADOR_GERAL, contadorGeral);
            if (codBanco == null || codBanco.equals(0) || codAgencia == null || codAgencia.equals("") || codContaCorrente == null || codContaCorrente.equals("")) {
                contador = contador + 1;
                contexto.adicionaAtributo(CONTADOR, contador);
            }
        } else if (evento.getTipoEvento() == 1) {
            BigDecimal percentual;
            if (contador > 0 && (percentual = new BigDecimal(contador.doubleValue() * 100.0 / contadorGeral.doubleValue()).setScale(2, 0)).doubleValue() > 0.0) {
                Object[] argumentos = new Object[]{this.dcFormat.format(percentual.doubleValue())};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
            }
            contexto.removeAtributo(CONTADOR);
            contexto.removeAtributo(CONTADOR_GERAL);
        }
    }
}

