/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.ParametrosList;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraConsultaBanco;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;

public class RegraConsultaBancoGenerica
extends RegraConsultaBanco {
    @Override
    public void executaRegraVerificacao(ImportacaoEvento evento) {
        SituacaoVerificacao situacaoVerificacao = evento.getSituacaoVerificacao();
        long initTime = System.currentTimeMillis();
        try {
            TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(this._conexao.getMetaData());
            ConsultaSQL consultaSQL = this._configuracao.recuperaConsultaSQL(situacaoVerificacao.getRemessa(), evento.getMetadadosArquivoAtual().getCabecalho(), tpBanco);
            String sql = this.substituiPadroes(consultaSQL.getSql(), this._configuracao.getParametros());
            List valores = (List)this._queryRunner.query(this._conexao, sql, consultaSQL.getValoresParametros(), (ResultSetHandler)new ValidaResultado(situacaoVerificacao, this._metaDadosArquivo.getArquivo()));
            if (valores != null && valores.size() > 0) {
                this.criaMensagemAssociada(situacaoVerificacao, valores);
            }
            log.debug((Object)("regra-banco: " + this._configuracao.getNome() + " - tempo: " + (System.currentTimeMillis() - initTime) + "ms"));
        }
        catch (SQLException e) {
            log.warn((Object)("erro: regra-banco: " + this._configuracao.getNome() + " - tempo: " + (System.currentTimeMillis() - initTime) + "ms - erro: " + e));
            throw new PersistenciaException(e);
        }
    }

    protected void criaMensagemAssociada(SituacaoVerificacao situacao, List valores) {
        for (int index = 0; index < valores.size(); ++index) {
            this.geraMensagemAssociadaRegra(situacao, this._metaDadosArquivo.getArquivo(), (Object[])valores.get(index));
        }
    }

    String substituiPadroes(String sql, ParametrosList parametrosList) {
        List<String> nomes = parametrosList.buscaNomesParametros("consulta.substituir.");
        for (String n : nomes) {
            Parametro p = parametrosList.getParametroPorNome(n);
            String nome = n.substring("consulta.substituir.".length());
            sql = StringUtils.replace((String)sql, (String)nome, (String)p.getValor());
        }
        return sql;
    }

    private final class ValidaResultado
    implements ResultSetHandler {
        private SituacaoVerificacao _situacao;
        private Arquivo _arquivo;

        ValidaResultado(SituacaoVerificacao situacao, Arquivo arquivo) {
            this._situacao = situacao;
            this._arquivo = arquivo;
        }

        public Object handle(ResultSet rs) throws SQLException {
            Object[] valores = null;
            Object nomeArquivo = null;
            ArrayList<Object[]> listRetorno = null;
            int countColunas = rs.getMetaData().getColumnCount();
            listRetorno = new ArrayList<Object[]>();
            while (rs.next()) {
                valores = new Object[countColunas];
                for (int i = 0; i < valores.length; ++i) {
                    valores[i] = rs.getObject(i + 1);
                }
                listRetorno.add(valores);
                valores = null;
            }
            return listRetorno;
        }
    }
}

