/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao;

import br.gov.rs.tce.pad.beans.RegraConfig;
import br.gov.rs.tce.pad.beans.Regras;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.verificacao.RegraAbstrata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RegrasFactory {
    private Regras _regras = (Regras)ConfiguracaoControle.carregaDadosArquivoXML("regras");
    private static RegrasFactory _instancia;
    static Log log;

    private RegrasFactory() {
    }

    public static final RegrasFactory getInstancia() {
        if (_instancia == null) {
            _instancia = new RegrasFactory();
        }
        return _instancia;
    }

    public RegraAbstrata constroiRegra(RegraConfig regraConfig) {
        Object cls = null;
        String regraJavaClass = null;
        RegraAbstrata regraAbstrata = null;
        if (this._regras == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio carregar as mensagens antes atrav\u00e9s do metodo: \"public void carregaRegras(String arquivoXML)\".");
        }
        regraJavaClass = regraConfig.getJavaClass();
        regraAbstrata = this.criaRegraAbstrata(regraJavaClass, regraConfig);
        regraAbstrata.setConfiguracao(regraConfig);
        return regraAbstrata;
    }

    private RegraAbstrata criaRegraAbstrata(String regraJavaClass, RegraConfig regraConfig) {
        RegraAbstrata regraAbstrata = null;
        Class<?> cls = null;
        try {
            cls = Class.forName(regraJavaClass);
            regraAbstrata = (RegraAbstrata)cls.newInstance();
        }
        catch (Exception ex) {
            throw new VerificacaoException("10021", new Object[]{regraConfig.getNome(), regraJavaClass}, ex);
        }
        return regraAbstrata;
    }

    public RegraAbstrata constroiRegra(String nomeRegra) {
        RegraConfig regraConfig = null;
        regraConfig = this._regras.getRegraPorNome(nomeRegra);
        return this.constroiRegra(regraConfig);
    }

    static {
        log = LogFactory.getLog(RegrasFactory.class);
    }
}

