/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.RegraConfig;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.excecao.NumeroMaximoMensagemException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.verificacao.Regra;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RegraAbstrata
implements Regra {
    protected RegraConfig _configuracao;
    protected MetadadosArquivoContabil _metaDadosArquivo;
    protected static final Log log = LogFactory.getLog(RegraAbstrata.class);

    protected final String getParametro(String nome) {
        Parametro parametro = null;
        String value = null;
        parametro = this._configuracao.getParametro(nome.toLowerCase());
        if (parametro != null) {
            value = parametro.getValor();
        }
        return value;
    }

    protected final boolean executarParaPeriodo(int periodo) {
        return this._configuracao.isAssociadaPeriodo(periodo);
    }

    protected final boolean executarParaMes(int mes) {
        return this._configuracao.isAssociadaMes(mes);
    }

    protected final boolean executaParaEntidade(String codigoEntidade) {
        return this._configuracao.isAssociadaEntidade(codigoEntidade);
    }

    @Override
    public final void executaRegra(ImportacaoEvento evento) throws VerificacaoException, NumeroMaximoMensagemException {
        long time = System.currentTimeMillis();
        try {
            this._metaDadosArquivo = evento.getMetadadosArquivoAtual();
            this.executaRegraVerificacao(evento);
            this._metaDadosArquivo = null;
        }
        catch (Exception ex) {
            if (ex instanceof NumeroMaximoMensagemException) {
                throw (NumeroMaximoMensagemException)((Object)ex);
            }
            if (!(ex instanceof VerificacaoException)) {
                log.error((Object)"Exce\u00e7\u00e3o durante execu\u00e7\u00e3o regra n\u00e3o encapsulada em Verifica\u00e7\u00e3oException", (Throwable)ex);
                throw new VerificacaoException(ex);
            }
            throw (VerificacaoException)((Object)ex);
        }
        finally {
            if (log.isDebugEnabled()) {
                long elapsed = System.currentTimeMillis() - time;
                log.debug((Object)("Execu\u00e7\u00e3o Regra " + this._configuracao.getNome() + " finalizada em: " + elapsed + " ms."));
            }
        }
    }

    protected abstract void executaRegraVerificacao(ImportacaoEvento var1);

    protected void geraMensagemAssociadaRegra(SituacaoVerificacao situacaoVerificacao, Arquivo arquivo, Object[] argumentos) {
        this.geraMensagemAssociadaRegra(situacaoVerificacao, null, null, arquivo, argumentos, null);
    }

    protected void geraMensagemAssociadaRegra(SituacaoVerificacao situacaoVerificacao, String nomeColuna, Long linha, Arquivo arquivo, Object[] argumentos) {
        this.geraMensagemAssociadaRegra(situacaoVerificacao, nomeColuna, linha, arquivo, argumentos, null);
    }

    protected void geraMensagemAssociadaRegra(SituacaoVerificacao situacaoVerificacao, Arquivo arquivo, Object[] argumentos, String tipoMensagem) {
        this.geraMensagemAssociadaRegra(situacaoVerificacao, null, null, arquivo, argumentos, tipoMensagem);
    }

    protected void geraMensagemAssociadaRegra(SituacaoVerificacao situacaoVerificacao, String nomeColuna, Long linha, Arquivo arquivo, Object[] argumentos, String tipoMensagem) {
        int coluna = arquivo.getFormato().getNumeroCampoPorColuna(nomeColuna);
        MensagemFactory msgFactory = MensagemFactory.getInstancia();
        MensagemInstancia msg = msgFactory.constroiMensagem(this._configuracao.getCodigoMensagem(), coluna, linha, arquivo, argumentos, tipoMensagem);
        situacaoVerificacao.adicionaMensagem(msg);
    }

    @Override
    public final String getCodigoMensagem() {
        return this._configuracao.getCodigoMensagem();
    }

    public final void setConfiguracao(RegraConfig configuracao) {
        this._configuracao = configuracao;
    }
}

