/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.servico;

import br.gov.rs.tce.adf.servico.TCEApplicationModeluImpl;
import br.gov.rs.tce.commons.sql.ClausulaWhere;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.IdentificadorArquivoVerificacao;
import br.gov.rs.tce.pad.beans.SubsidiosVereadoresBean;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.excecao.ValidacaoException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDerbyDBImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ArquivosComplementaresViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ClassesAtividadeEconomicaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.CnaeAtividadeEconomicaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.CobBarrasRemessaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ComboAdministradoresImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ConsorciosViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaContrapartidaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaViewSelecaoImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.DescricaoJustificativaImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.EntIndiretasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.EntidadesViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.GruposAtividadeEconomicaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.HistoricoVerificacaoViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.JustificativasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.MunicipioViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ParametrosWebViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.PerguntasRespostasImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.PerguntasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.PrestadoraServicoViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.PublicacoesViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasCamarasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasEmpresasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasPrefeiturasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ResponsaveisViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RespostasRemessasViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RpRecursosViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.SituacaoVerificacaoViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.SubsidioVereadoresTableViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.SubstituicoesViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.TabelaDePublicacoesDescricaoDaRemessaLegislativoViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.TransparenciaGestaoFiscalViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ValidadorWebViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.VersaoDatabaseViewImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.modelo.servico.negocio.EntIndiretasImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.JustificativasImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.RemessasImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.RespostasRemessasImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.SubsidioVereadoresImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.SubstituicoesImpl;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.ProcessaArquivoHelper;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.Session;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewObjectImpl;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicoPADImpl
extends TCEApplicationModeluImpl
implements ServicoPAD {
    static int cdPlanilhaIndireta = 1;
    static int idProducer = 0;
    private final int amId = ++idProducer;
    private static final Log log = LogFactory.getLog(ServicoPADImpl.class);

    public ServicoPADImpl() {
        log.debug((Object)("AM com ID " + this.amId + " esta sendo criado"));
    }

    public static void main(String[] args) {
        ServicoPADImpl.launchTester((String)"br.gov.rs.tce.pad.modelo.servico", (String)"ServicoPADOracle");
    }

    @Override
    public int getAmId() {
        return this.amId;
    }

    protected void afterConnect() {
        log.debug((Object)("Application Module com id " + this.amId + " acabou de ser conectado"));
        super.afterConnect();
    }

    protected void prepareSession(Session session) {
        log.debug((Object)("Application Module com id " + this.amId + " esta prestes a ser utilizado em outra conexao"));
        super.prepareSession(session);
    }

    protected void finalize() throws Throwable {
        log.debug((Object)("Application Module com id " + this.amId + " esta sendo garbage collected"));
        super.finalize();
    }

    public ClassesAtividadeEconomicaViewImpl getClassesAtividadeEconomicaView1() {
        return (ClassesAtividadeEconomicaViewImpl)this.findViewObject("ClassesAtividadeEconomicaView1");
    }

    public GruposAtividadeEconomicaViewImpl getGruposAtividadeEconomicaView1() {
        return (GruposAtividadeEconomicaViewImpl)this.findViewObject("GruposAtividadeEconomicaView1");
    }

    public PublicacoesViewImpl getPublicacoesView1() {
        return (PublicacoesViewImpl)this.findViewObject("PublicacoesView1");
    }

    public SituacaoVerificacaoViewImpl getSituacaoVerificacaoView1() {
        return (SituacaoVerificacaoViewImpl)this.findViewObject("SituacaoVerificacaoView1");
    }

    public RemessasPrefeiturasViewImpl getRemessasPrefeiturasView1() {
        return (RemessasPrefeiturasViewImpl)this.findViewObject("RemessasPrefeiturasView1");
    }

    public ViewLinkImpl getHistRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("HistRem1FkLink1");
    }

    public ViewLinkImpl getPserRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("PserRem1FkLink1");
    }

    public ViewLinkImpl getPubRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("PubRem1FkLink1");
    }

    public ViewLinkImpl getReemRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("ReemRem1FkLink1");
    }

    public ViewLinkImpl getRereRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("RereRem1FkLink1");
    }

    public ViewLinkImpl getSitverRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("SitverRem1FkLink1");
    }

    public ViewLinkImpl getRemcaRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("RemcaRem1FkLink1");
    }

    public ViewLinkImpl getRemprefRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("RemprefRem1FkLink1");
    }

    public ViewLinkImpl getMunicipioEntidadeLink1() {
        return (ViewLinkImpl)this.findViewLink("MunicipioEntidadeLink1");
    }

    public ViewLinkImpl getRemessaEntidadeLink1() {
        return (ViewLinkImpl)this.findViewLink("RemessaEntidadeLink1");
    }

    public RemessasViewImpl getRemessasDaEntidade() {
        return (RemessasViewImpl)this.findViewObject("RemessasDaEntidade");
    }

    public CnaeAtividadeEconomicaViewImpl getCnaeAtividadeEconomicaView() {
        return (CnaeAtividadeEconomicaViewImpl)this.findViewObject("CnaeAtividadeEconomicaView");
    }

    public HistoricoVerificacaoViewImpl getHistoricoVerificacaoDaRemessa() {
        return (HistoricoVerificacaoViewImpl)this.findViewObject("HistoricoVerificacaoDaRemessa");
    }

    public PrestadoraServicoViewImpl getPrestadoraServicoRemessa() {
        return (PrestadoraServicoViewImpl)this.findViewObject("PrestadoraServicoRemessa");
    }

    public PublicacoesViewImpl getPublicacoesDaRemessa() {
        return (PublicacoesViewImpl)this.findViewObject("PublicacoesDaRemessa");
    }

    public RemessasEmpresasViewImpl getDadosRemessaEmpresa() {
        return (RemessasEmpresasViewImpl)this.findViewObject("DadosRemessaEmpresa");
    }

    public RespostasRemessasViewImpl getRespostasRemessa() {
        return (RespostasRemessasViewImpl)this.findViewObject("RespostasRemessa");
    }

    public SituacaoVerificacaoViewImpl getSituacaoVerificacao() {
        return (SituacaoVerificacaoViewImpl)this.findViewObject("SituacaoVerificacao");
    }

    public RemessasCamarasViewImpl getDadosRemessaCamara() {
        return (RemessasCamarasViewImpl)this.findViewObject("DadosRemessaCamara");
    }

    public RemessasPrefeiturasViewImpl getDadosRemessaPrefeitura() {
        return (RemessasPrefeiturasViewImpl)this.findViewObject("DadosRemessaPrefeitura");
    }

    public MunicipioViewImpl getTodosMunicipiosView() {
        return (MunicipioViewImpl)this.findViewObject("TodosMunicipiosView");
    }

    public MunicipioViewImpl getMunicipioDaEntidade() {
        return (MunicipioViewImpl)this.findViewObject("MunicipioDaEntidade");
    }

    public EntidadesViewImpl getEntidadeDaRemessa() {
        return (EntidadesViewImpl)this.findViewObject("EntidadeDaRemessa");
    }

    public EntidadesViewImpl getTodasEntidadesView() {
        return (EntidadesViewImpl)this.findViewObject("TodasEntidadesView");
    }

    public ViewObjectImpl getTabelaDePublicacoesDaRemessaView() {
        return (ViewObjectImpl)this.findViewObject("TabelaDePublicacoesDaRemessaView");
    }

    public ViewObjectImpl getTabelaDePublicacoesTodasView() {
        return (ViewObjectImpl)this.findViewObject("TabelaDePublicacoesTodasView");
    }

    public ViewLinkImpl getTabPubRem1ViewLink1() {
        return (ViewLinkImpl)this.findViewLink("TabPubRem1ViewLink1");
    }

    public ViewObjectImpl getTabelaDePublicacoesDescricaoDaRemessaView() {
        return (ViewObjectImpl)this.findViewObject("TabelaDePublicacoesDescricaoDaRemessaView");
    }

    public ViewObjectImpl getTabelaDePublicacoesDescricaoTodasView() {
        return (ViewObjectImpl)this.findViewObject("TabelaDePublicacoesDescricaoTodasView");
    }

    public ViewLinkImpl getTabPubDescRem1ViewLink1() {
        return (ViewLinkImpl)this.findViewLink("TabPubDescRem1ViewLink1");
    }

    public ViewObjectImpl getSubsidioVereadoresDaRemessaView() {
        return (ViewObjectImpl)this.findViewObject("SubsidioVereadoresDaRemessaView");
    }

    public ViewObjectImpl getSubsidioVereadoresTodosView() {
        return (ViewObjectImpl)this.findViewObject("SubsidioVereadoresTodosView");
    }

    public ViewLinkImpl getSubVerRemViewLink1() {
        return (ViewLinkImpl)this.findViewLink("SubVerRemViewLink1");
    }

    public ViewObjectImpl getContasVerificacaoDaRemessaView() {
        return (ViewObjectImpl)this.findViewObject("ContasVerificacaoDaRemessaView");
    }

    public ViewLinkImpl getCtaVerRemViewLink1() {
        return (ViewLinkImpl)this.findViewLink("CtaVerRemViewLink1");
    }

    public PerguntasViewImpl getPerguntasView() {
        return (PerguntasViewImpl)this.findViewObject("PerguntasView");
    }

    public EntIndiretasViewImpl getEntIndiretasView() {
        return (EntIndiretasViewImpl)this.findViewObject("EntIndiretasView");
    }

    public ViewLinkImpl getEntIndiretasRemessaFkLink1() {
        return (ViewLinkImpl)this.findViewLink("EntIndiretasRemessaFkLink1");
    }

    public JustificativasViewImpl getJustificativasDaRemessa() {
        return (JustificativasViewImpl)this.findViewObject("JustificativasDaRemessa");
    }

    public ConsorciosViewImpl getConsorciosView() {
        return (ConsorciosViewImpl)this.findViewObject("ConsorciosView");
    }

    public ViewLinkImpl getJustRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("JustRem1FkLink1");
    }

    @Override
    public void inserePublicacoesRemessa(Remessa remessa, Date dtPublicacao, String tpPeriodo, Integer periodo, String tipoPublicacao, String descricao) {
        this.inserePublicacoesRemessa(remessa, dtPublicacao, tpPeriodo, periodo, tipoPublicacao, descricao, true);
    }

    @Override
    public void inserePublicacoesRemessa(Remessa remessa, Date dtPublicacao, String tpPeriodo, Integer periodo, String tipoPublicacao, String descricao, boolean commit) {
        this.inserePublicacoesRemessa(remessa, dtPublicacao, tpPeriodo, periodo, tipoPublicacao, descricao, this.getTipoPoder(remessa), commit);
    }

    @Override
    public void inserePublicacoesRemessa(Remessa remessa, Date dtPublicacao, String tpPeriodo, Integer periodo, String tipoPublicacao, String descricao, String poder) {
        this.inserePublicacoesRemessa(remessa, dtPublicacao, tpPeriodo, periodo, tipoPublicacao, descricao, poder, true);
    }

    @Override
    public void inserePublicacoesRemessa(Remessa remessa, Date dtPublicacao, String tpPeriodo, Integer periodo, String tipoPublicacao, String descricao, String poder, boolean commit) {
        this.inserePublicacoesRemessa(remessa, dtPublicacao, tpPeriodo, periodo, tipoPublicacao, descricao, poder, TipoBancoDados.DERBY_DB, commit);
    }

    @Override
    public void inserePublicacoesRemessa(Remessa remessa, Date dtPublicacao, String tpPeriodo, Integer periodo, String tipoPublicacao, String descricao, String poder, TipoBancoDados tipoBD, boolean commit) {
        try {
            ClausulaWhere whereBuilder = new ClausulaWhere(tipoBD);
            whereBuilder.addCondicaoNumerica("PERIODO", periodo);
            whereBuilder.addCondicaoString("TP_PERIODO", tpPeriodo);
            whereBuilder.addCondicaoString("TP_PUBLICACAO", tipoPublicacao);
            whereBuilder.addCondicaoString("PODER", poder);
            ViewObject vo = this.findViewObject("PublicacoesDaRemessa");
            Row row = null;
            vo.clearCache();
            vo.setWhereClause(whereBuilder.toString());
            vo.setWhereClauseParams(null);
            vo.executeQuery();
            vo.first();
            if (vo.getRowCount() == 0) {
                row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("DtPublicacao", (Object)dtPublicacao);
                row.setAttribute("Periodo", (Object)periodo);
                row.setAttribute("TpPeriodo", (Object)tpPeriodo);
                row.setAttribute("TpPublicacao", (Object)tipoPublicacao);
                row.setAttribute("Descricao", (Object)descricao);
                row.setAttribute("Poder", (Object)poder);
                vo.insertRow(row);
            } else {
                row = vo.getCurrentRow();
                if (dtPublicacao == null) {
                    row.remove();
                } else {
                    row.setAttribute("DtPublicacao", (Object)dtPublicacao);
                    if (!"".equals(descricao.trim())) {
                        int limite = 500;
                        if (descricao.length() > limite) {
                            throw new ValidacaoException("Campo n\u00e3o pode ter tamanho maior que " + limite + " caracteres", "");
                        }
                        row.setAttribute("Descricao", (Object)descricao);
                    }
                }
            }
            if (commit) {
                this.getTransaction().commit();
            }
        }
        catch (ValidacaoException e) {
            throw e;
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir publica\u00e7\u00f5es da remessa"}, e);
        }
    }

    @Override
    public void removePublicacoesRemessa(Remessa remessa, ClausulaWhere whereClause, boolean commit) {
        try {
            ViewObject vo = this.findViewObject("PublicacoesDaRemessa");
            vo.clearCache();
            if (whereClause != null) {
                vo.setWhereClause(whereClause.toString());
            }
            vo.executeQuery();
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                vo.next().remove();
            }
            if (commit) {
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir publica\u00e7\u00f5es da remessa"}, e);
        }
    }

    @Override
    public void removeConsorcios(Remessa remessa, ClausulaWhere whereClause, boolean commit) {
        try {
            ViewObject vo = this.findViewObject("ConsorciosView");
            vo.clearCache();
            if (whereClause != null) {
                vo.setWhereClause(whereClause.toString());
            }
            vo.executeQuery();
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                vo.next().remove();
            }
            if (commit) {
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir publica\u00e7\u00f5es da remessa"}, e);
        }
    }

    public void removeEnderecosTransparenciaGF(Remessa remessa, int numLinhasAManter) {
        try {
            this.getTransaction().commit();
            ViewObject vo = this.findViewObject("PublicacoesDaRemessa");
            vo.setWhereClauseParams(null);
            vo.setWhereClause("TP_PUBLICACAO = 'T'");
            vo.executeQuery();
            vo.first();
            vo.previous();
            int count = 1;
            while (vo.hasNext()) {
                Row row = vo.next();
                log.debug((Object)("removeEnderecosTransparenciaGF: row[" + count + "/" + numLinhasAManter + "]: " + row.getAttribute("DtPublicacao") + "/" + row.getAttribute("Descricao")));
                if (count > numLinhasAManter) {
                    log.debug((Object)("removendo Row [" + count + "/" + numLinhasAManter + "]: " + row.getAttribute("DtPublicacao") + "/" + row.getAttribute("Descricao")));
                    row.setAttribute("Descricao", (Object)" ");
                    row.setAttribute("DtPublicacao", null);
                }
                ++count;
            }
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir publica\u00e7\u00f5es da remessa"}, e);
        }
    }

    @Override
    public void removeAdministradoresRemessa(Remessa remessa, ClausulaWhere whereClause, boolean commit) {
        try {
            ViewObject vo = this.findViewObject("AdministradoresView");
            vo.clearCache();
            if (whereClause != null) {
                vo.setWhereClause(whereClause.toString());
            }
            vo.executeQuery();
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                vo.next().remove();
            }
            if (commit) {
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir administradores da remessa"}, e);
        }
    }

    private String getTipoPoder(Remessa remessa) {
        String retorno = "";
        String tipoSetor = remessa.getTipoSetor();
        if (tipoSetor.equals("P")) {
            retorno = "E";
        } else if (tipoSetor.equals("C")) {
            retorno = "L";
        }
        return retorno;
    }

    @Override
    public void insereRespostaRemessa(Remessa remessa, String cdPergunta, String resposta, String texto) {
        this.insereRespostaRemessa(remessa, cdPergunta, resposta, texto, true);
    }

    @Override
    public void insereRespostaRemessa(Remessa remessa, String cdPergunta, String resposta, String texto, boolean commit) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ControleRespostasRemessa", this.getRespostasRemessa().getDefFullName());
            Key k = RespostasRemessasImpl.createPrimaryKey(Integer.parseInt(cdPergunta), remessa.getCdEntidade(), remessa.getCdRemessa());
            Row rowf = vo.getRow(k);
            if (rowf != null) {
                rowf.setAttribute("Resposta", (Object)resposta);
                rowf.setAttribute("Texto", (Object)texto);
            } else {
                Row row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("CdPergunta", (Object)cdPergunta);
                row.setAttribute("Resposta", (Object)resposta);
                row.setAttribute("Texto", (Object)texto);
                vo.insertRow(row);
            }
            if (commit) {
                this.getTransaction().commit();
            }
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Respostas da Remessa"}, e);
        }
        finally {
            vo.remove();
        }
    }

    @Override
    public void removeRespostaRemessa(Remessa remessa, String cdPergunta) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ControleRespostasRemessa", this.getRespostasRemessa().getDefFullName());
            Key k = RespostasRemessasImpl.createPrimaryKey(Integer.parseInt(cdPergunta), remessa.getCdEntidade(), remessa.getCdRemessa());
            Row rowf = vo.getRow(k);
            if (rowf != null) {
                rowf.remove();
            }
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Respostas da Remessa"}, e);
        }
        finally {
            vo.remove();
        }
    }

    @Override
    public void atualizaJustificativaRemessa(Remessa remessa, TipoJustificativa tipoJustiticativa, Integer cdPlanilha, String textoJustificativa) {
        try {
            JustificativasViewImpl vo = this.getJustificativasDaRemessa();
            Key k = JustificativasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), tipoJustiticativa.getCodigo(), cdPlanilha);
            Row rowf = vo.getRow(k);
            if (rowf == null) {
                throw new IllegalStateException("A utiliza\u00e7\u00e3o desse m\u00e9todo s\u00f3 \u00e9 permitida se j\u00e1 existir uma linha com dados n\u00e3o preenchidos para esta justificativa.");
            }
            rowf.setAttribute("Texto", (Object)textoJustificativa);
            rowf.setAttribute("Situacao", (Object)TipoJustificativa.JUSTIFICATIVA_PREENCHIDA);
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Justificativas da Remessa"}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insereJustificativasRemessa(TipoJustificativa tipoJustificativa, Integer cdPlanilha, Remessa remessa) {
        DescricaoJustificativaImpl voDescricoes = this.getDescricaoJustificativa();
        Key chave = new Key(new Object[]{tipoJustificativa.getCodigo(), cdPlanilha});
        Row linha = voDescricoes.getRow(chave);
        String nomePlanilha = null;
        try {
            if (linha == null) {
                throw new IllegalArgumentException("Justificativa n\u00e3o encontra-se na tabela DESCRICAO_JUSTIFICATIVA. TIPO_PLANILHA = [" + tipoJustificativa + "] CD_PLANILHA = [" + cdPlanilha + "]");
            }
            nomePlanilha = (String)linha.getAttribute("NomePlanilha");
            this.insereJustificativasRemessa(tipoJustificativa, cdPlanilha, nomePlanilha, null, remessa);
        }
        finally {
            if (voDescricoes != null) {
                voDescricoes.closeRowSet();
            }
        }
    }

    @Override
    public void insereJustificativasRemessaCondicional(TipoJustificativa tipoJustificativa, Integer cdPlanilha, Remessa remessa) {
        ViewObject vo = this.findViewObject("JustificativasView");
        try {
            vo.setWhereClause("TIPO_PLANILHA = ? AND CD_PLANILHA = ?");
            vo.setWhereClauseParam(0, (Object)tipoJustificativa.getCodigo());
            vo.setWhereClauseParam(1, (Object)cdPlanilha);
            vo.executeQuery();
            int rowCount = vo.getRowCount();
            if (rowCount == 0) {
                this.insereJustificativasRemessa(tipoJustificativa, cdPlanilha, remessa);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro durante a adi\u00e7\u00e3o condicional de Justificativas da Remessa"}, e);
        }
    }

    @Override
    public void removeJustificativasRemessa(Remessa remessa, TipoJustificativa tipo) {
        ViewObject vo = this.findViewObject("JustificativasView");
        try {
            vo.setWhereClauseParams(null);
            vo.setWhereClause("TIPO_PLANILHA = ?");
            vo.setWhereClauseParam(0, (Object)tipo.getCodigo());
            vo.executeQuery();
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                Row rowf = vo.next();
                if (rowf == null) continue;
                rowf.remove();
            }
            this.getTransaction().commit();
            remessa.removeCodigoJustificativa(tipo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao remover Justificativas da Remessa"}, e);
        }
    }

    public void removeJustificativas(Remessa remessa, TipoJustificativa tipo) {
        ViewObject vo = this.findViewObject("JustificativasView");
        try {
            vo.setWhereClause("TIPO_PLANILHA = ? and CD_REMESSA = ? and CD_ENTIDADE = ?");
            vo.setWhereClauseParam(0, (Object)tipo.getCodigo());
            vo.setWhereClauseParam(1, (Object)remessa.getCdRemessa());
            vo.setWhereClauseParam(2, (Object)remessa.getCdEntidade());
            vo.executeQuery();
            while (vo.hasNext()) {
                Row rowf = vo.next();
                if (rowf == null) continue;
                rowf.remove();
            }
            this.getTransaction().commit();
            remessa.removeCodigoJustificativa(tipo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao remover Justificativas da Remessa"}, e);
        }
        finally {
            if (vo != null) {
                vo.setWhereClause(null);
                vo.setWhereClauseParams(null);
                vo.closeRowSet();
            }
        }
    }

    @Override
    public void removeJustificativasRemessa(Remessa remessa, TipoJustificativa tipo, Integer cdPlanilha) {
        ViewObject vo = this.findViewObject("JustificativasView");
        try {
            vo.setWhereClause("TIPO_PLANILHA = ? AND CD_PLANILHA = ?");
            vo.setWhereClauseParam(0, (Object)tipo.getCodigo());
            vo.setWhereClauseParam(1, (Object)cdPlanilha);
            vo.executeQuery();
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                Row rowf = vo.next();
                if (rowf == null) continue;
                rowf.remove();
            }
            this.getTransaction().commit();
            remessa.removeCodigoJustificativa(tipo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao remover Justificativas da Remessa"}, e);
        }
    }

    @Override
    public void criaJustificativasDeValidacao(Remessa remessa) {
        ViewObject vo = null;
        BigDecimal cdVerificacao = new BigDecimal(1);
        this.removeJustificativas(remessa, TipoJustificativa.JUSTIFICA_REGRAS_VALIDACAO);
        vo = this.createViewObjectFromQueryStmt("MaxCdVerificacao", "Select max(cd_verificacao) from historico_verificacao where cd_remessa = ? and cd_entidade = ?");
        vo.setWhereClauseParam(0, (Object)remessa.getCdRemessa());
        vo.setWhereClauseParam(1, (Object)remessa.getCdEntidade());
        vo.executeQuery();
        if (vo.hasNext()) {
            Row r = vo.next();
            cdVerificacao = (BigDecimal)(r.getAttribute(0) == null ? new BigDecimal(1) : r.getAttribute(0));
        }
        vo.remove();
        ClausulaWhere whereBuilder = new ClausulaWhere(TipoBancoDados.DERBY_DB);
        whereBuilder.addCondicaoNumerica("CD_REMESSA", remessa.getCdRemessa());
        whereBuilder.addCondicaoNumerica("CD_ENTIDADE", remessa.getCdEntidade());
        whereBuilder.addCondicaoString("TIPO_ERRO", "J");
        whereBuilder.addCondicaoNumerica("CD_VERIFICACAO", cdVerificacao);
        vo = this.findViewObject("HistoricoVerificacaoDaRemessa");
        vo.setWhereClause(whereBuilder.toString());
        vo.executeQuery();
        int cdPlanilha = 1;
        while (vo.hasNext()) {
            Row row = vo.next();
            StringBuffer desc = new StringBuffer();
            desc.append(row.getAttribute("CdErro")).append(" - ").append(row.getAttribute("Descricao"));
            String nome = desc.toString();
            if (nome.length() > 500) {
                nome = nome.substring(0, 500);
            }
            this.insereJustificativasRemessa(TipoJustificativa.JUSTIFICA_REGRAS_VALIDACAO, cdPlanilha++, StringUtils.abbreviate((String)nome, (int)500), null, remessa);
        }
    }

    @Override
    public void insereJustificativasRemessa(TipoJustificativa tipoJustificativa, Integer cdPlanilha, String nomePlanilha, String cnpj, Remessa remessa) {
        boolean nova = false;
        try {
            ViewObject vo = this.findViewObject("JustificativasDaRemessa");
            Key k = JustificativasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), tipoJustificativa.getCodigo(), cdPlanilha);
            Row rowf = vo.getRow(k);
            if (rowf != null) {
                String cnpjAux = (String)rowf.getAttribute("CnpjEntIndireta");
                if (cnpjAux != null && cnpjAux.equals(cnpj)) {
                    rowf.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                    rowf.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                    rowf.setAttribute("TipoPlanilha", (Object)tipoJustificativa.getCodigo());
                    rowf.setAttribute("NomePlanilha", (Object)nomePlanilha);
                    rowf.setAttribute("CdPlanilha", (Object)cdPlanilha);
                    rowf.setAttribute("CnpjEntIndireta", (Object)cnpj);
                } else {
                    nova = true;
                }
            } else {
                nova = true;
            }
            if (nova) {
                Row row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("TipoPlanilha", (Object)tipoJustificativa.getCodigo());
                row.setAttribute("NomePlanilha", (Object)nomePlanilha);
                row.setAttribute("Situacao", (Object)TipoJustificativa.JUSTIFICATIVA_NAO_PREENCHIDA);
                row.setAttribute("CdPlanilha", (Object)cdPlanilha);
                row.setAttribute("Texto", null);
                row.setAttribute("CnpjEntIndireta", (Object)cnpj);
                vo.insertRow(row);
            }
            this.getTransaction().commit();
            remessa.insereCodigoJustificativa(tipoJustificativa);
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Justificativas da Remessa"}, e);
        }
    }

    public MunicipioViewImpl getMunicipioDaRemessa() {
        return (MunicipioViewImpl)this.findViewObject("MunicipioDaRemessa");
    }

    public ViewLinkImpl getMunicipioEntidadeLink2() {
        return (ViewLinkImpl)this.findViewLink("MunicipioEntidadeLink2");
    }

    public EntIndiretasViewImpl getEntIndiretasDaEntidade() {
        return (EntIndiretasViewImpl)this.findViewObject("EntIndiretasDaEntidade");
    }

    public ViewLinkImpl getEntIndiretasRemessaFkLink2() {
        return (ViewLinkImpl)this.findViewLink("EntIndiretasRemessaFkLink2");
    }

    public ResponsaveisViewImpl getAdministradoresView() {
        return (ResponsaveisViewImpl)this.findViewObject("AdministradoresView");
    }

    public ViewLinkImpl getResRem1FkLink2() {
        return (ViewLinkImpl)this.findViewLink("ResRem1FkLink2");
    }

    public ViewLinkImpl getResRem1FkLink3() {
        return (ViewLinkImpl)this.findViewLink("ResRem1FkLink3");
    }

    @Override
    public void insereEntidadesIndiretas(Remessa remessa) {
        ViewObject voEntidades = this.createViewObject("EntIndiretas", this.getTodasEntidadesView().getDefFullName());
        try {
            voEntidades.setWhereClause("TIPO_SETOR_GOV in ('A','F','M') AND CD_ENTIDADE_PAI = ?");
            voEntidades.setWhereClauseParam(0, (Object)remessa.getCdEntidade());
            voEntidades.executeQuery();
            while (voEntidades.hasNext()) {
                Row row = voEntidades.next();
                this.insereEntidadeIndireta(remessa, row);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Entidade Indireta"}, (Exception)((Object)e));
        }
        finally {
            if (voEntidades != null) {
                voEntidades.remove();
            }
        }
    }

    private void insereEntidadeIndireta(Remessa remessa, Row entityRow) throws JboException {
        if (entityRow != null) {
            Key k3;
            Row rowA;
            Key k2;
            Row rowE;
            Key k1;
            Integer cdEntidade = (Integer)entityRow.getAttribute("CdEntidade");
            String cnpj = (String)entityRow.getAttribute("Cnpj");
            String nome = (String)entityRow.getAttribute("Nome");
            Integer rpps = (Integer)entityRow.getAttribute("Rpps");
            String tipoSetor = (String)entityRow.getAttribute("TipoSetorGov");
            String status = "P";
            ViewObject vo = this.findViewObject("EntIndiretasView");
            Row row = vo.getRow(k1 = EntIndiretasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), cnpj, status));
            if (row == null && (rowE = vo.getRow(k2 = EntIndiretasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), cnpj, "E"))) == null && (rowA = vo.getRow(k3 = EntIndiretasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), cnpj, "A"))) == null) {
                row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("Cnpj", (Object)cnpj);
                row.setAttribute("NomeEntidade", (Object)nome);
                row.setAttribute("Rpps", (Object)rpps);
                row.setAttribute("CodOrgao", (Object)cdEntidade);
                row.setAttribute("Status", (Object)status);
                row.setAttribute("StatusConsolidacao", null);
                row.setAttribute("TipoSetorGov", (Object)tipoSetor);
                vo.insertRow(row);
            }
        }
    }

    @Override
    public void insereEntidadeIndireta(Integer cdEntidade, Integer cdRemessa, String cnpj, String nome, Integer rpps, Integer cdEntPai, String tipoSetor, String status) throws JboException {
        Key k;
        ViewObject vo = this.findViewObject("EntIndiretasView");
        Row row = vo.getRow(k = EntIndiretasImpl.createPrimaryKey(cdEntidade, cdRemessa, cnpj, status));
        if (row == null) {
            row = vo.createRow();
            row.setAttribute("CdRemessa", (Object)cdRemessa);
            row.setAttribute("CdEntidade", (Object)cdEntidade);
            row.setAttribute("Cnpj", (Object)cnpj);
            row.setAttribute("NomeEntidade", (Object)nome);
            row.setAttribute("Rpps", (Object)rpps);
            row.setAttribute("CodOrgao", (Object)cdEntPai);
            row.setAttribute("Status", (Object)status);
            row.setAttribute("StatusConsolidacao", null);
            row.setAttribute("TipoSetorGov", (Object)tipoSetor);
            vo.insertRow(row);
        }
        this.getTransaction().commit();
    }

    @Override
    public void atualizaEntidadeIndireta(Remessa remessa, String cnpj, String nome, String tipoSetor, Integer rpps, String status) throws PersistenciaException {
        try {
            ViewObject vo = this.findViewObject("EntIndiretasView");
            Key k = EntIndiretasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), cnpj, status);
            Row entRow = vo.getRow(k);
            if (entRow != null) {
                entRow.setAttribute("Cnpj", (Object)cnpj);
                entRow.setAttribute("NomeEntidade", (Object)nome);
                entRow.setAttribute("Rpps", (Object)rpps);
                entRow.setAttribute("Status", (Object)status);
                entRow.setAttribute("TipoSetorGov", (Object)tipoSetor);
                this.getTransaction().commit();
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar Entidade Indireta"}, (Exception)((Object)e));
        }
    }

    @Override
    public void insereSubstituicao(Remessa remessa, String cpf, Date dtInicio, String cpfSubstituto, Date dtFim, String poder) {
        try {
            ViewObject vo = this.findViewObject("SubstituicoesView");
            Key k = SubstituicoesImpl.createPrimaryKey(remessa.getCdRemessa(), remessa.getCdEntidade(), new BigDecimal(cpf), dtInicio, poder);
            Row rowf = vo.getRow(k);
            if (rowf != null) {
                rowf.setAttribute("DtFim", (Object)dtFim);
                rowf.setAttribute("CpfSubstituto", (Object)cpfSubstituto);
                rowf.setAttribute("Poder", (Object)poder);
            } else {
                Row row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("Cpf", (Object)cpf);
                row.setAttribute("DtInicio", (Object)dtInicio);
                row.setAttribute("DtFim", (Object)dtFim);
                row.setAttribute("CpfSubstituto", (Object)cpfSubstituto);
                row.setAttribute("Poder", (Object)poder);
                vo.insertRow(row);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Erro ao inserir Substitui\u00e7\u00f5es."}, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaMandato(String tipoResponsavel, String idPrefeituraCamara, Date dtInicio, Date dtFim, String cpf) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ResponsaveisValidaMandato", this.getResponsaveis().getDefFullName());
            if (vo != null) {
                vo.setWhereClause("TP_RESPONSAVEL = ? AND ID_PREFEITURA_CAMARA = ? AND (? BETWEEN DT_INICIO AND DT_TERMINO OR ? BETWEEN DT_INICIO AND DT_TERMINO OR (? < DT_INICIO AND ? > DT_TERMINO)) AND CPF = ?");
                vo.setWhereClauseParam(0, (Object)tipoResponsavel);
                vo.setWhereClauseParam(1, (Object)idPrefeituraCamara);
                vo.setWhereClauseParam(2, (Object)dtInicio);
                vo.setWhereClauseParam(3, (Object)dtFim);
                vo.setWhereClauseParam(4, (Object)dtInicio);
                vo.setWhereClauseParam(5, (Object)dtFim);
                vo.setWhereClauseParam(6, (Object)cpf);
                vo.executeQuery();
                vo.next();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaMandatoResponsavel(String tipoResponsavel, String idPrefeituraCamara, Date dtInicio, Date dtFim, String cpf) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ResponsaveisValidaMandato", this.getResponsaveis().getDefFullName());
            if (vo != null) {
                vo.setWhereClause("TP_RESPONSAVEL = ? AND ID_PREFEITURA_CAMARA = ? AND (? BETWEEN DT_INICIO AND DT_TERMINO OR ? BETWEEN DT_INICIO AND DT_TERMINO OR (? < DT_INICIO AND ? > DT_TERMINO)) AND CPF <> ?");
                vo.setWhereClauseParam(0, (Object)tipoResponsavel);
                vo.setWhereClauseParam(1, (Object)idPrefeituraCamara);
                vo.setWhereClauseParam(2, (Object)dtInicio);
                vo.setWhereClauseParam(3, (Object)dtFim);
                vo.setWhereClauseParam(4, (Object)dtInicio);
                vo.setWhereClauseParam(5, (Object)dtFim);
                vo.setWhereClauseParam(6, (Object)cpf);
                vo.executeQuery();
                vo.next();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaLacunasAdministradoresMandato(String tipoResponsavel, String idPrefeituraCamara, Date dtInicio, Date dtFim, Date dia) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("validaLacunasAdministradoresMandatoView", this.getResponsaveis().getDefFullName());
            if (vo != null) {
                vo.setWhereClause("TP_RESPONSAVEL = ? AND ID_PREFEITURA_CAMARA = ? AND ? >= DT_INICIO AND (? <= DT_TERMINO OR DT_TERMINO IS NULL)");
                vo.setWhereClauseParam(0, (Object)tipoResponsavel);
                vo.setWhereClauseParam(1, (Object)idPrefeituraCamara);
                vo.setWhereClauseParam(2, (Object)dia);
                vo.setWhereClauseParam(3, (Object)dia);
                vo.executeQuery();
                vo.next();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaPeriodoAdministracao(Integer cdEntidade, String cpf, Date dtInicio, Date dtFim, String idPrefeituraCamara, String tpResponsavel) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ResponsaveisPeriodo", this.getResponsaveis().getDefFullName());
            if (vo != null) {
                vo.setWhereClause(" ID_PREFEITURA_CAMARA = ?  AND TP_RESPONSAVEL = ?  AND DT_INICIO <= ? AND DT_TERMINO >= ? AND CD_ENTIDADE = ? AND CPF = ?");
                vo.setWhereClauseParam(0, (Object)idPrefeituraCamara);
                vo.setWhereClauseParam(1, (Object)tpResponsavel);
                vo.setWhereClauseParam(2, (Object)dtInicio);
                vo.setWhereClauseParam(3, (Object)dtFim);
                vo.setWhereClauseParam(4, (Object)cdEntidade);
                vo.setWhereClauseParam(5, (Object)cpf);
                vo.executeQuery();
                boolean bl = vo.getRowCount() > 0;
                return bl;
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaDataInicioSubstituicao(String cpf, Date dtInicio, String poder) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("SubstitutosValidaData", this.getSubstituicoesView().getDefFullName());
            if (vo != null) {
                vo.setWhereClause(" ? = DT_INICIO AND PODER = ? AND CPF = ?");
                vo.setWhereClauseParam(0, (Object)dtInicio);
                vo.setWhereClauseParam(1, (Object)poder);
                vo.setWhereClauseParam(2, (Object)cpf);
                vo.executeQuery();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaTodosCpfseDatasInicioSubs(String poder) {
        ViewObject vo = null;
        StringBuffer retorno = new StringBuffer();
        try {
            vo = this.createViewObject("SubstitutosValidaChave", this.getSubstituicoesView().getDefFullName());
            if (vo != null) {
                vo.setWhereClause("PODER = ?");
                vo.setWhereClauseParam(0, (Object)poder);
                vo.executeQuery();
                vo.first();
                vo.previous();
                while (vo.hasNext()) {
                    Row r = vo.next();
                    SimpleDateFormat sd = new SimpleDateFormat("dd/MM/yyyy");
                    if (retorno.length() > 1) {
                        retorno.append(";");
                    }
                    retorno.append(vo.getCurrentRowIndex() + 1 + ";");
                    retorno.append(sd.format(r.getAttribute("DtInicio")));
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaExiteSubstituicaoPeriodo(Date dtInicio, Date dtFim, String poder) {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("SubstitutosValidaData", this.getSubstituicoesView().getDefFullName());
            if (vo != null) {
                vo.setWhereClause(" ( ? BETWEEN DT_INICIO AND DT_FIM OR ? BETWEEN DT_INICIO AND DT_FIM OR (? <= DT_INICIO AND ? >= DT_FIM) ) AND PODER = ?");
                vo.setWhereClauseParam(0, (Object)dtInicio);
                vo.setWhereClauseParam(1, (Object)dtFim);
                vo.setWhereClauseParam(2, (Object)dtInicio);
                vo.setWhereClauseParam(3, (Object)dtFim);
                vo.setWhereClauseParam(4, (Object)poder);
                vo.executeQuery();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaSubstituicao(String cpf, Date dtInicio, Date dtFim, String poder) {
        block6: {
            ViewObject vo = null;
            try {
                vo = this.createViewObject("SubstitutosValidaData", this.getSubstituicoesView().getDefFullName());
                if (vo == null) break block6;
                vo.setWhereClause(" ( ? BETWEEN DT_INICIO AND DT_FIM OR ? BETWEEN DT_INICIO AND DT_FIM OR (? <= DT_INICIO AND ? >= DT_FIM) ) AND PODER = ?");
                vo.setWhereClauseParam(0, (Object)dtInicio);
                vo.setWhereClauseParam(1, (Object)dtFim);
                vo.setWhereClauseParam(2, (Object)dtInicio);
                vo.setWhereClauseParam(3, (Object)dtFim);
                vo.setWhereClauseParam(4, (Object)poder);
                vo.executeQuery();
                while (vo.next() != null) {
                    Row row = vo.getCurrentRow();
                    String cpfAdm = row.getAttribute("Cpf").toString();
                    Date data = (Date)row.getAttribute("DtInicio");
                    if (cpfAdm.equals(cpf) && data.equals(dtInicio)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (vo != null) {
                    vo.remove();
                }
            }
        }
        return false;
    }

    @Override
    public BigDecimal getPrimeiroAdmin() {
        BigDecimal cpf = null;
        ViewObject vo = this.findViewObject("AdministradoresView");
        if (vo != null) {
            vo.first();
            Row r = vo.getCurrentRow();
            if (r != null) {
                cpf = (BigDecimal)vo.getCurrentRow().getAttribute("Cpf");
            }
        }
        return cpf;
    }

    @Override
    public BigDecimal getPrimeiroSubs() {
        BigDecimal cpf = null;
        ViewObject vo = this.findViewObject("SubstitutosView");
        if (vo != null) {
            vo.first();
            Row r = vo.getCurrentRow();
            if (r != null) {
                cpf = (BigDecimal)vo.getCurrentRow().getAttribute("Cpf");
            }
        }
        return cpf;
    }

    @Override
    public BigDecimal getPrimeiroMunicipio() {
        BigDecimal cd = null;
        ViewObject vo = this.findViewObject("TodosMunicipiosView");
        if (vo != null) {
            vo.first();
            Row r = vo.getCurrentRow();
            if (r != null) {
                cd = (BigDecimal)vo.getCurrentRow().getAttribute("CodigoMunicipio");
            }
        }
        return cd;
    }

    public SubsidioVereadoresTableViewImpl getSubsidioVereadoresTableView() {
        return (SubsidioVereadoresTableViewImpl)this.findViewObject("SubsidioVereadoresTableView");
    }

    public ViewLinkImpl getRemSubVerFkLink1() {
        return (ViewLinkImpl)this.findViewLink("RemSubVerFkLink1");
    }

    public ResponsaveisViewImpl getResponsaveis() {
        return (ResponsaveisViewImpl)this.findViewObject("Responsaveis");
    }

    public ViewLinkImpl getResRem1FkLink1() {
        return (ViewLinkImpl)this.findViewLink("ResRem1FkLink1");
    }

    public MunicipioViewImpl getMunicipioView1() {
        return (MunicipioViewImpl)this.findViewObject("MunicipioView1");
    }

    public ViewLinkImpl getRespMunLink1() {
        return (ViewLinkImpl)this.findViewLink("RespMunLink1");
    }

    @Override
    public void limpaRemessa() {
        this.limpaRemessa(true);
    }

    @Override
    public void limpaRemessa(boolean rollback) {
        try {
            ViewObject voRemessa;
            ViewObject voSubstituicoes;
            if (rollback) {
                this.getTransaction().rollback();
            }
            if ((voSubstituicoes = this.findViewObject("SubstituicoesView")) != null) {
                this.getTransaction().executeCommand("Delete from substituicoes");
                this.getTransaction().commit();
                voSubstituicoes.clearCache();
                voSubstituicoes.executeQuery();
            }
            if ((voRemessa = this.findViewObject("RemessasDaEntidade")) != null) {
                this.getTransaction().executeCommand("Delete from remessas");
                this.getTransaction().commit();
                voRemessa.clearCache();
                voRemessa.executeQuery();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void deletaRemessa(Remessa remessa) {
        if (remessa == null) {
            throw new IllegalArgumentException("Remessa n\u00e3o pode ser nula");
        }
        Key k = RemessasImpl.createPrimaryKey(new BigDecimal("" + remessa.getCdEntidade()), new BigDecimal("" + remessa.getCdRemessa()));
        ViewObject reme = this.findViewObject("RemessasDaEntidade");
        Row row = reme.getRow(k);
        if (row != null) {
            row.remove();
            this.getTransaction().commit();
        } else {
            log.warn((Object)("Remessa da entidade " + remessa.getCdEntidade() + " n\u00e3o encontrada"));
        }
    }

    @Override
    public boolean existemIndiretasNaoConsolidadas() {
        boolean retorno = false;
        ViewObject vo = null;
        try {
            vo = this.createViewObjectFromQueryStmt("VerificaIndiretas", "Select * from ent_indiretas where (STATUS_CONSOLIDACAO = 0 or status_consolidacao is null) AND STATUS != 'E'");
            vo.executeQuery();
            retorno = vo.getRowCount() > 0;
            vo.setWhereClause(null);
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    @Override
    public void insereSubsidiosVereadores(List<SubsidiosVereadoresBean> subsidios) {
        HashMap<Integer, String> erros = new HashMap<Integer, String>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        SubsidioVereadoresTableViewImpl vo = this.getSubsidioVereadoresTableView();
        for (SubsidiosVereadoresBean bean : subsidios) {
            try {
                Key k = SubsidioVereadoresImpl.createPrimaryKey(bean.getCdRemessa(), bean.getCdEntidade(), bean.getTpSubsidio(), bean.getTpRepresentante(), bean.getMes());
                Row r = vo.getRow(k);
                if (r != null) {
                    r.setAttribute("ValorSubsidio", (Object)bean.getVlrSubsidio());
                    continue;
                }
                Row row = vo.createRow();
                row.setAttribute("CdRemessa", (Object)bean.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)bean.getCdEntidade());
                row.setAttribute("Mes", (Object)bean.getMes());
                row.setAttribute("TpRepresentante", (Object)bean.getTpRepresentante());
                row.setAttribute("TpSubsidio", (Object)bean.getTpSubsidio());
                row.setAttribute("ValorSubsidio", (Object)bean.getVlrSubsidio());
            }
            catch (Exception e) {
                erros.put(bean.getMes().intValue(), e.getMessage());
            }
        }
        if (!erros.isEmpty()) {
            StringBuffer er = new StringBuffer("");
            for (int i = 0; i < 12; ++i) {
                if (erros.get(i + 1) == null) continue;
                cal.set(2, i);
                log.info((Object)("month[" + i + "]: " + cal.get(2) + " // " + new SimpleDateFormat("MMMMM").format(cal.getTime())));
                er.append("Os valores digitados para o m\u00eas " + new SimpleDateFormat("MMMMM").format(cal.getTime()) + " n\u00e3o est\u00e3o preenchidos adequadamente.\n");
            }
            throw new ValidacaoException(er.toString(), "");
        }
        this.getTransaction().commit();
    }

    public PerguntasRespostasImpl getPerguntasRespostas() {
        return (PerguntasRespostasImpl)this.findViewObject("PerguntasRespostas");
    }

    public DescricaoJustificativaImpl getDescricaoJustificativa() {
        return (DescricaoJustificativaImpl)this.findViewObject("DescricaoJustificativa");
    }

    @Override
    public void verificaJustificativasEntidadesIndiretas(Remessa remessa) {
        this.validaEntidadesIndiretasRemovidas();
        ViewObject voIndiretas = this.createViewObject("VerificaEntIndiretas", this.getEntIndiretasDaEntidade().getDefFullName());
        try {
            voIndiretas.setWhereClause("STATUS IN ('E', 'N', 'A')");
            voIndiretas.executeQuery();
            Row row = null;
            String nome = "";
            if (voIndiretas.getRowCount() > 0) {
                while (voIndiretas.hasNext()) {
                    row = voIndiretas.next();
                    String status = (String)row.getAttribute("Status");
                    String cnpj = (String)row.getAttribute("Cnpj");
                    if (this.verificaExisteJustificativaIndireta(cnpj, status)) {
                        if (status.equals("E")) {
                            nome = "Exclus\u00e3o da entidade: " + row.getAttribute("NomeEntidade");
                        } else if (status.equals("N")) {
                            nome = "Inser\u00e7\u00e3o da entidade: " + row.getAttribute("NomeEntidade");
                        } else if (status.equals("A")) {
                            nome = "Altera\u00e7\u00e3o da entidade: " + row.getAttribute("NomeEntidade");
                        }
                        this.insereJustificativasRemessa(TipoJustificativa.JUSTIFICA_ADM_INDIRETA, cdPlanilhaIndireta, nome, cnpj, remessa);
                    }
                    ++cdPlanilhaIndireta;
                }
            } else {
                remessa.removeCodigoJustificativa(TipoJustificativa.JUSTIFICA_ADM_INDIRETA);
            }
        }
        catch (JboException jboExc) {
            jboExc.printStackTrace();
            throw new PersistenciaException(jboExc);
        }
        finally {
            if (voIndiretas != null) {
                voIndiretas.remove();
            }
        }
    }

    private void validaEntidadesIndiretasRemovidas() {
        JustificativasViewImpl voJust = this.getJustificativasDaRemessa();
        try {
            voJust.setWhereClause("TIPO_PLANILHA = ?");
            voJust.setWhereClauseParam(0, TipoJustificativa.JUSTIFICA_ADM_INDIRETA.getCodigo());
            voJust.executeQuery();
            while (voJust.hasNext()) {
                Row row = voJust.next();
                if (!this.existeCnpjEntidadesIndiretas(row)) continue;
                row.remove();
            }
            this.getTransaction().commit();
        }
        finally {
            if (voJust != null) {
                voJust.setWhereClause(null);
                voJust.setWhereClauseParams(null);
                voJust.closeRowSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existeCnpjEntidadesIndiretas(Row rowJust) {
        boolean existe = false;
        ViewObject voIndiretas = this.createViewObject("ExisteEntIndiretas", this.getEntIndiretasDaEntidade().getDefFullName());
        String cnpj = (String)rowJust.getAttribute("CnpjEntIndireta");
        String textoJustificativa = (String)rowJust.getAttribute("NomePlanilha");
        if (cnpj != null && textoJustificativa != null) {
            try {
                voIndiretas.setWhereClause("CNPJ = ?");
                voIndiretas.setWhereClauseParam(0, (Object)cnpj);
                voIndiretas.executeQuery();
                while (voIndiretas.hasNext()) {
                    Row row = voIndiretas.next();
                    String entidade = (String)row.getAttribute("NomeEntidade");
                    if (entidade == null) continue;
                    if (textoJustificativa.indexOf(entidade) == -1) {
                        existe = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (voIndiretas != null) {
                    voIndiretas.remove();
                }
            }
        }
        return existe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verificaExisteJustificativaIndireta(String cnpj, String status) {
        JustificativasViewImpl voJust = this.getJustificativasDaRemessa();
        boolean existe = false;
        try {
            voJust.setWhereClause("TIPO_PLANILHA = ? AND CNPJ_ENT_INDIRETA = ?");
            voJust.setWhereClauseParam(0, TipoJustificativa.JUSTIFICA_ADM_INDIRETA.getCodigo());
            voJust.setWhereClauseParam(1, cnpj);
            voJust.executeQuery();
            boolean bl = existe = voJust.getRowCount() == 0;
            while (voJust.hasNext()) {
                String desc;
                Row r = voJust.next();
                if (r == null || (desc = (String)r.getAttribute("NomePlanilha")) == null) continue;
                if ("E".equals(status)) {
                    if (desc.indexOf("Exclus\u00e3o") < 0) {
                        existe = true;
                        continue;
                    }
                    existe = false;
                } else if ("N".equals(status)) {
                    if (desc.indexOf("Inser\u00e7\u00e3o") < 0) {
                        existe = true;
                        continue;
                    }
                    existe = false;
                } else {
                    if (!"A".equals(status)) continue;
                    if (desc.indexOf("Altera\u00e7\u00e3o") < 0) {
                        existe = true;
                        continue;
                    }
                    existe = false;
                }
                break;
            }
        }
        finally {
            if (voJust != null) {
                voJust.setWhereClause(null);
                voJust.setWhereClauseParams(null);
                voJust.closeRowSet();
            }
        }
        log.debug((Object)("Existe Justificativa para." + cnpj));
        return existe;
    }

    public RpRecursosViewImpl getRpRecursosView() {
        return (RpRecursosViewImpl)this.findViewObject("RpRecursosView");
    }

    public ViewLinkImpl getRpRecursosFkLink1() {
        return (ViewLinkImpl)this.findViewLink("RpRecursosFkLink1");
    }

    @Override
    public boolean existeIndiretasConsolidacao() {
        boolean retorno = false;
        ViewObject vo = null;
        try {
            vo = this.createViewObjectFromQueryStmt("VerificaIndiretas", "Select * from ent_indiretas where TIPO_SETOR_GOV IN ('A','F','M') AND STATUS != 'E'");
            vo.executeQuery();
            retorno = vo.getRowCount() > 0;
            vo.setWhereClause(null);
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    @Override
    public void limpaJustificativasPosVerificacaoArquivos() {
        try {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (TipoJustificativa tj : TipoJustificativa.JUSTIFICATIVAS_A_NAO_REMOVER_POS_VERIFICACAO_ARQUIVOS) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(tj.getCodigo());
            }
            this.executeCommand("delete from justificativas where TIPO_PLANILHA NOT IN (" + sb.toString() + ")");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Justificativas"});
        }
    }

    @Override
    public void limpaJustificativasPosCargaArquivos() {
        try {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (TipoJustificativa tj : TipoJustificativa.JUSTIFICATIVAS_A_NAO_REMOVER_POS_CARGA_ARQUIVOS) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(tj.getCodigo());
            }
            this.executeCommand("delete from justificativas where TIPO_PLANILHA NOT IN (" + sb.toString() + ")");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Justificativas"});
        }
    }

    @Override
    public void limpaTodasJustificativas() {
        try {
            this.executeCommand("delete from justificativas");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Justificativas"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isJustificouTodas(TipoJustificativa tipoJustificativa) {
        ViewObject voJustificativa = null;
        boolean ok = true;
        try {
            voJustificativa = this.createViewObject("voVerificaTodasJustificativas", this.getJustificativasDaRemessa().getDefFullName());
            voJustificativa.setWhereClause("TIPO_PLANILHA = ?");
            voJustificativa.setWhereClauseParam(0, (Object)tipoJustificativa.getCodigo());
            voJustificativa.executeQuery();
            voJustificativa.first();
            voJustificativa.previous();
            while (voJustificativa.hasNext()) {
                Row linha = voJustificativa.next();
                Integer situacao = (Integer)linha.getAttribute("Situacao");
                if (situacao != null && !situacao.equals(TipoJustificativa.JUSTIFICATIVA_NAO_PREENCHIDA)) continue;
                ok = false;
                log.info((Object)("tipo justificativa = " + tipoJustificativa.getCodigo() + " ; situacao = " + situacao));
            }
        }
        finally {
            if (voJustificativa != null) {
                voJustificativa.remove();
            }
        }
        return ok;
    }

    @Override
    public void salvaIdentificadoresIntegridadeArquivos(Remessa remessa) {
        try {
            Iterator<IdentificadorArquivoVerificacao> it = remessa.getIdentificadoresArquivoIterator();
            while (it.hasNext()) {
                IdentificadorArquivoVerificacao identVer = it.next();
                this.executeCommand("delete from identificador_arquivo where cd_remessa=" + remessa.getCdRemessa() + " and cd_entidade = " + remessa.getCdEntidade() + " and identificador =  " + identVer.getIdentificadorArquivo().hashCode());
                if (!identVer.hasValidDisgest()) continue;
                this.executeCommand("insert into identificador_arquivo (cd_remessa, cd_entidade, identificador, hash_dados) values (" + remessa.getCdRemessa() + ", " + remessa.getCdEntidade() + ", " + identVer.getIdentificadorArquivo().hashCode() + ", '" + identVer.getDisgestArquivoCodificado() + "')");
            }
            this.getTransaction().commit();
        }
        catch (JboException jboe) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10043", new Object[]{jboe.getMessage()}, (Exception)((Object)jboe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNomeEntidade(Remessa remessa) {
        String nome = null;
        ViewObject vo = null;
        try {
            vo = this.createViewObjectFromQueryStmt("Consulta4ServicoPADGetNomeEntidade", "SELECT CD_ENTIDADE, NOME FROM ENTIDADES");
            vo.clearCache();
            vo.setWhereClause("CD_ENTIDADE = ?");
            vo.setWhereClauseParam(0, (Object)remessa.getCdEntidade());
            vo.executeQuery();
            vo.next();
            Row row = vo.getCurrentRow();
            if (row != null) {
                nome = (String)row.getAttribute(1);
            }
        }
        catch (Exception e) {
            log.error((Object)"Erro ao obter nome da entidade.", (Throwable)e);
        }
        finally {
            if (vo != null) {
                vo.setWhereClause(null);
                vo.setWhereClauseParams(null);
                vo.clearCache();
                vo.executeQuery();
                vo.remove();
            }
        }
        return nome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void limpaDadosConsolidacao() {
        ViewObject remessa = null;
        ViewObject indiretas = null;
        try {
            remessa = this.createViewObject("RemessaIndireta", this.getRemessasDaEntidade().getDefFullName());
            indiretas = this.createViewObject("IndiretasConsolidadas", this.getEntIndiretasView().getDefFullName());
            if (remessa != null) {
                remessa.setWhereClause("remessa_principal != 'S'");
                remessa.setWhereClauseParams(null);
                remessa.executeQuery();
                while (remessa.hasNext()) {
                    Row r = remessa.first();
                    r.remove();
                }
            }
            if (indiretas != null) {
                indiretas.setWhereClause("status != 'E'");
                indiretas.setWhereClauseParams(null);
                indiretas.executeQuery();
                while (indiretas.hasNext()) {
                    Row row = indiretas.next();
                    row.setAttribute("StatusConsolidacao", (Object)0);
                }
            }
            this.getTransaction().executeCommand("delete from cod_barras_remessa");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)"Erro ao limpar dados da remessa de consolidacao", (Throwable)e);
        }
        finally {
            if (remessa != null) {
                remessa.remove();
            }
            if (indiretas != null) {
                indiretas.remove();
            }
        }
    }

    @Override
    public void limpaDadosParaConsolidacao() {
        this.limpaDadosConsolidacao();
        try {
            this.getTransaction().executeCommand("delete from RESPOSTAS_REMESSAS");
            this.getTransaction().executeCommand("delete from Publicacoes");
            this.getTransaction().executeCommand("delete from Substituicoes");
            this.getTransaction().executeCommand("delete from RESPONSAVEIS");
            this.getTransaction().executeCommand("delete from HISTORICO_VERIFICACAO");
            this.getTransaction().executeCommand("delete from JUSTIFICATIVAS");
            this.getTransaction().executeCommand("delete from PRESTADORA_SERVICO");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)"Erro ao limpar dados da remessa de consolidacao", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remessa getRemessaPrincipal() {
        ViewObject remessasView = null;
        ViewObject entidadeView = null;
        Object arquivosCompView = null;
        Remessa remessa = null;
        try {
            remessasView = this.createViewObjectFromQueryStmt("RemessaPrincipal", "Select * from remessas where remessa_principal = 'S'");
            if (remessasView == null) {
                throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar o ViewObject de Remessas: RemessasDaEntidade");
            }
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow == null) {
                throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar a Remessas Principal");
            }
            remessa = new Remessa();
            remessa.setDiretorioOrigem((String)remessaRow.getAttribute("DIR_ARQUIVOS"));
            Integer anoExercicio = Integer.parseInt("" + remessaRow.getAttribute("ANO_EXERCICIO"));
            if (anoExercicio != null) {
                remessa.setAnoExercicio(anoExercicio);
            }
            String tpEntrega = (String)remessaRow.getAttribute("TP_ENTREGA");
            remessa.setTipoEntrega(tpEntrega);
            Integer peridodo = Integer.parseInt("" + remessaRow.getAttribute("PERIODO_INFORMACOES"));
            remessa.setPeriodoInformacoes(peridodo);
            Integer mes = Integer.parseInt("" + remessaRow.getAttribute("MES"));
            remessa.setMes((int)mes);
            remessa.setCdRemessa(1);
            remessa.setCargaArquivosSelecaoEfetuada("1".equals("" + remessaRow.getAttribute("SITUACAO_CARGA")));
            remessa.setCdEntidade(Integer.parseInt("" + remessaRow.getAttribute("CD_ENTIDADE")));
            entidadeView = this.createViewObjectFromQueryStmt("EntidadePrincipal", "Select * from entidades where cd_entidade = " + remessa.getCdEntidade());
            entidadeView.executeQuery();
            Row entidadeRow = entidadeView.first();
            if (entidadeRow != null) {
                remessa.setCnpjEntidade((String)entidadeRow.getAttribute("CNPJ"));
                remessa.setTipoSetor((String)entidadeRow.getAttribute("TIPO_SETOR_GOV"));
            }
            remessa.setTipoEntrega(tpEntrega);
            String resposta = this.getRespostaPergunta(29, remessa);
            remessa.setHonrouCompromissos("S".equals(resposta));
            remessa.setPossuiIndiretas(this.existeIndiretasConsolidacao());
        }
        finally {
            if (remessasView != null) {
                remessasView.remove();
            }
            if (entidadeView != null) {
                entidadeView.remove();
            }
            if (arquivosCompView != null) {
                arquivosCompView.remove();
            }
        }
        return remessa;
    }

    @Override
    public void insereRemessa(RemessaInfo remessaInfo) throws Exception {
        Key k = RemessasImpl.createPrimaryKey(new BigDecimal("" + remessaInfo.getCodigoEntidade()), new BigDecimal("" + remessaInfo.getCodigoRemessa()));
        ViewObject viewRemessa = this.findViewObject("RemessasDaEntidade");
        Row row = viewRemessa.getRow(k);
        if (row != null) {
            throw new PADRuntimeException("Impossivel inserir remessa j\u00e1 existente");
        }
        viewRemessa.executeQuery();
        Row remessaRow = viewRemessa.createRow();
        remessaRow.setAttribute("CdEntidade", (Object)remessaInfo.getCodigoEntidade());
        remessaRow.setAttribute("CdRemessa", (Object)remessaInfo.getCodigoRemessa());
        remessaRow.setAttribute("AnoExercicio", (Object)remessaInfo.getAnoExercicio());
        remessaRow.setAttribute("DtGravacao", (Object)(remessaInfo.getDataGeracao() == null ? null : new Date(remessaInfo.getDataGeracao().getTime())));
        remessaRow.setAttribute("CodBarras", (Object)remessaInfo.getCodBarrasRve());
        remessaRow.setAttribute("TpEntrega", (Object)remessaInfo.getTipoEntrega());
        remessaRow.setAttribute("PeriodoInformacoes", (Object)remessaInfo.getPeriodoInformacoes());
        remessaRow.setAttribute("VersaoPad", (Object)remessaInfo.getVersao());
        remessaRow.setAttribute("SituacaoCarga", (Object)0);
        viewRemessa.insertRow(remessaRow);
        this.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRespostaPergunta(int codigoPergunta, Remessa rem) {
        ViewObject vo = null;
        String resp = null;
        try {
            vo = this.createViewObjectFromQueryStmt("respostaRemessaTMP", "Select cd_remessa, cd_entidade, cd_pergunta, resposta from respostas_remessas");
            vo.setWhereClause("cd_pergunta = ? and cd_remessa = ? and cd_entidade = ?");
            vo.setWhereClauseParam(0, (Object)codigoPergunta);
            vo.setWhereClauseParam(1, (Object)rem.getCdRemessa());
            vo.setWhereClauseParam(2, (Object)rem.getCdEntidade());
            vo.executeQuery();
            Row r = vo.first();
            if (r != null) {
                resp = (String)r.getAttribute("RESPOSTA");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTextoPergunta(int codigoPergunta, Remessa rem) {
        ViewObject vo = null;
        String resp = null;
        try {
            vo = this.createViewObjectFromQueryStmt("respostaRemessaTMP", "Select cd_remessa, cd_entidade, cd_pergunta, texto from respostas_remessas");
            vo.setWhereClause("cd_pergunta = ? and cd_remessa = ? and cd_entidade = ?");
            vo.setWhereClauseParam(0, (Object)codigoPergunta);
            vo.setWhereClauseParam(1, (Object)rem.getCdRemessa());
            vo.setWhereClauseParam(2, (Object)rem.getCdEntidade());
            vo.executeQuery();
            Row r = vo.first();
            if (r != null) {
                resp = (String)r.getAttribute("TEXTO");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return resp;
    }

    @Override
    public boolean existeEntidadesIndiretas() {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ValidaEntidadesIndiretas", this.getEntIndiretasDaEntidade().getDefFullName());
            if (vo != null) {
                vo.first();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    @Override
    public boolean existeEntidadesIndiretasVisiveis() {
        ViewObject vo = null;
        try {
            vo = this.createViewObject("ValidaEntidadesIndiretas", this.getEntIndiretasDaEntidade().getDefFullName());
            vo.setWhereClause("STATUS <> 'E'");
            if (vo != null) {
                vo.first();
                if (vo.getRowCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return false;
    }

    public SubstituicoesViewImpl getSubstituicoesView2() {
        return (SubstituicoesViewImpl)this.findViewObject("SubstituicoesView2");
    }

    public ResponsaveisViewImpl getSubstitutosView() {
        return (ResponsaveisViewImpl)this.findViewObject("SubstitutosView");
    }

    @Override
    public void atualizaCampoRemessa(String nomeCampo, String valor) {
        try {
            ViewObject vo;
            Row r;
            if (nomeCampo != null && (r = (vo = this.findViewObject("RemessasDaEntidade")).getCurrentRow()) != null) {
                r.setAttribute(nomeCampo, (Object)valor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ComboAdministradoresImpl getComboAdministradores() {
        return (ComboAdministradoresImpl)this.findViewObject("ComboAdministradores");
    }

    public ComboAdministradoresImpl getComboSubstitutos() {
        return (ComboAdministradoresImpl)this.findViewObject("ComboSubstitutos");
    }

    public SubstituicoesViewImpl getSubstituicoesView() {
        return (SubstituicoesViewImpl)this.findViewObject("SubstituicoesView");
    }

    public ViewLinkImpl getSubsRemFkLink1() {
        return (ViewLinkImpl)this.findViewLink("SubsRemFkLink1");
    }

    public ViewObjectImpl getAudienciasPublicasDataLocalView() {
        return (ViewObjectImpl)this.findViewObject("AudienciasPublicasDataLocalView");
    }

    public ViewLinkImpl getAudienPublicDtLocFKLink1() {
        return (ViewLinkImpl)this.findViewLink("AudienPublicDtLocFKLink1");
    }

    public CobBarrasRemessaViewImpl getCobBarrasRemessaView() {
        return (CobBarrasRemessaViewImpl)this.findViewObject("CobBarrasRemessaView");
    }

    public ViewLinkImpl getCOBA_REME_FkLink1() {
        return (ViewLinkImpl)this.findViewLink("COBA_REME_FkLink1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insereCodigosBarraRemessa(RemessaInfo rem) {
        if (rem == null) {
            throw new ConfiguracaoException("Remessa_Info n\u00e3o pode ser nulo na remessa para consolida\u00e7\u00e3o");
        }
        Remessa remessa = this.getRemessaPrincipal();
        CobBarrasRemessaViewImpl vo = this.getCobBarrasRemessaView();
        try {
            log.info((Object)("cod_barras:: " + remessa.getCdEntidade() + " / " + remessa.getCdRemessa()));
            vo.setWhereClauseParams(null);
            vo.setWhereClause(" cd_entidade = ? and cd_remessa = ? and cnpj_entidade = ?");
            vo.setWhereClauseParam(0, remessa.getCdEntidade());
            vo.setWhereClauseParam(1, remessa.getCdRemessa());
            vo.setWhereClauseParam(2, rem.getCnpjEntidade());
            vo.executeQuery();
            Row r = null;
            if (vo.getRowCount() > 0) {
                r = vo.first();
                r.setAttribute("CodRve", (Object)rem.getCodBarrasRve());
                r.setAttribute("CodRveLeg", (Object)rem.getCodBarrasRveLeg());
                r.setAttribute("CodModelo14", (Object)rem.getCodBarrasModelo14());
                r.setAttribute("CodModelo9", (Object)rem.getCodBarrasModelo9());
            } else {
                r = vo.createRow();
                r.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                r.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                r.setAttribute("CnpjEntidade", (Object)rem.getCnpjEntidade());
                r.setAttribute("CodRve", (Object)rem.getCodBarrasRve());
                r.setAttribute("CodRveLeg", (Object)rem.getCodBarrasRveLeg());
                r.setAttribute("CodModelo14", (Object)rem.getCodBarrasModelo14());
                r.setAttribute("CodModelo9", (Object)rem.getCodBarrasModelo9());
                vo.insertRow(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            vo.setWhereClauseParams(null);
            vo.setWhereClause("CD_entidade = ? and CD_remessa = ?");
            vo.setWhereClauseParam(0, remessa.getCdEntidade());
            vo.setWhereClauseParam(1, remessa.getCdRemessa());
            vo.executeQuery();
        }
    }

    public ContasRemessaContrapartidaViewImpl getContasRemessaContrapartidaView() {
        return (ContasRemessaContrapartidaViewImpl)this.findViewObject("ContasRemessaContrapartidaView");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCodBarrasRVEOriginal() {
        ViewObject vo = null;
        String retorno = null;
        try {
            vo = this.createViewObjectFromQueryStmt("VoCodBarras", "Select cod_rve   from cod_barras_remessa cb, remessas r , ENTIDADES E   where r.remessa_principal = 'S'   and r.cd_entidade = cb.cd_entidade  AND cb.CNPJ_entidade = E.CNPJ   AND E.TIPO_SETOR_GOV = 'P'");
            vo.executeQuery();
            Row r = vo.first();
            if (r != null) {
                retorno = (String)r.getAttribute("COD_RVE");
            }
        }
        catch (JboException e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    public ValidadorWebViewImpl getValidadorWebView() {
        return (ValidadorWebViewImpl)this.findViewObject("ValidadorWebView");
    }

    public ViewLinkImpl getRemessasValidadorWebViewLink1() {
        return (ViewLinkImpl)this.findViewLink("RemessasValidadorWebViewLink1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQuantidadeAdminSubsCadastrados(Integer cdEntidade, Integer cdRemessa, String tpResponsavel, String idPrefeituraCamara) {
        int retorno = 0;
        ViewObject vo = null;
        try {
            String sql = "SELECT * FROM responsaveis responsaveis WHERE responsaveis.cd_entidade = " + cdEntidade + " AND responsaveis.cd_remessa = " + cdRemessa + " AND responsaveis.tp_responsavel = '" + tpResponsavel + "' AND responsaveis.id_prefeitura_camara = '" + idPrefeituraCamara + "'";
            vo = this.createViewObjectFromQueryStmt("quantidadeCadastradaView", sql);
            vo.executeQuery();
            if (vo != null && vo.getRowCount() > 0) {
                retorno = vo.getRowCount();
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean responsaveisValidaCPF(Integer cdEntidade, Integer cdRemessa, String idPrefeituraCamara, String cpf) {
        boolean retorno = true;
        ViewObject vo = null;
        if (cpf == null) {
            return retorno;
        }
        try {
            String sql = "SELECT CPF FROM responsaveis responsaveis WHERE responsaveis.cd_entidade = " + cdEntidade + " AND responsaveis.cd_remessa = " + cdRemessa + " AND responsaveis.id_prefeitura_camara = '" + idPrefeituraCamara + "'";
            vo = this.createViewObjectFromQueryStmt("cpfResponsaveisView", sql);
            vo.executeQuery();
            while (vo.hasNext()) {
                Row row = vo.next();
                Object pCpf = row.getAttribute("CPF");
                if (!cpf.equals(pCpf.toString())) continue;
                retorno = false;
                break;
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String buscaTodosCpfResponsaveis(Integer cdEntidade, Integer cdRemessa, String tpResponsavel, String tpEntidade) {
        String retorno = "";
        ViewObject vo = null;
        try {
            String sql = "SELECT CPF FROM responsaveis responsaveis WHERE responsaveis.cd_entidade = " + cdEntidade + " AND responsaveis.cd_remessa = " + cdRemessa + " AND responsaveis.tp_responsavel = '" + tpResponsavel + "' AND responsaveis.id_prefeitura_camara = '" + tpEntidade + "'";
            vo = this.createViewObjectFromQueryStmt("TodosCpfResponsaveisView", sql);
            vo.executeQuery();
            while (vo.hasNext()) {
                Row row = vo.next();
                Object pCpf = row.getAttribute("CPF");
                retorno = retorno + pCpf.toString() + ";";
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    public ParametrosWebViewImpl getParametrosWebView() {
        return (ParametrosWebViewImpl)this.findViewObject("ParametrosWebView");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodigosRecursosWeb(Remessa remessa) {
        ViewObject vo = null;
        try {
            String sql = "select sum(case when cd_recurso in (20,30,31) then 1 else 0 end) as educacao , sum(case when cd_recurso in (40) then 1 else 0 end) as saudefrom recursoswhere cd_recurso in(20,30,31,40)";
            vo = this.createViewObjectFromQueryStmt("TesteRecursos", sql);
            vo.executeQuery();
            Row r = vo.first();
            if (r != null) {
                log.info((Object)("Valor educacao == " + r.getAttribute(0).toString()));
                log.info((Object)("Valor saude == " + r.getAttribute(1)));
                if (Integer.parseInt(r.getAttribute(0).toString()) > 0) {
                    remessa.setPossuiRecursoEducacao(true);
                } else {
                    remessa.setPossuiRecursoEducacao(false);
                }
                if (Integer.parseInt(r.getAttribute(1).toString()) > 0) {
                    remessa.setPossuiRecursoSaude(true);
                } else {
                    remessa.setPossuiRecursoSaude(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        throw new RuntimeException("N\u00e3o parece ser usado...");
    }

    @Override
    public void limpaDadosMudancaPeriodo() {
        this.getTransaction().executeCommand("delete from Historico_verificacao");
        this.getTransaction().executeCommand("delete from ent_indiretas");
        this.getTransaction().executeCommand("delete from justificativas");
    }

    public ViewLinkImpl getTabPubRem1ViewLink2_1() {
        return (ViewLinkImpl)this.findViewLink("TabPubRem1ViewLink2_1");
    }

    public ViewLinkImpl getTabPubDescRem1ViewLink2_1() {
        return (ViewLinkImpl)this.findViewLink("TabPubDescRem1ViewLink2_1");
    }

    public ViewObjectImpl getTabelaDePublicacoesDaRemessaLegislativoView() {
        return (ViewObjectImpl)this.findViewObject("TabelaDePublicacoesDaRemessaLegislativoView");
    }

    public TabelaDePublicacoesDescricaoDaRemessaLegislativoViewImpl getTabelaDePublicacoesDescricaoDaRemessaLegislativoView() {
        return (TabelaDePublicacoesDescricaoDaRemessaLegislativoViewImpl)this.findViewObject("TabelaDePublicacoesDescricaoDaRemessaLegislativoView");
    }

    public VersaoDatabaseViewImpl getVersaoDatabaseView() {
        return (VersaoDatabaseViewImpl)this.findViewObject("VersaoDatabaseView");
    }

    public ContasRemessaViewSelecaoImpl getContasRemessaViewSelecao() {
        return (ContasRemessaViewSelecaoImpl)this.findViewObject("ContasRemessaViewSelecao");
    }

    public EntidadesViewImpl getEntidadeDaCamara() {
        return (EntidadesViewImpl)this.findViewObject("EntidadeDaCamara");
    }

    public ViewLinkImpl getRemCamEntidadesLink1() {
        return (ViewLinkImpl)this.findViewLink("RemCamEntidadesLink1");
    }

    public JustificativasViewImpl getJustificativasView() {
        return (JustificativasViewImpl)this.findViewObject("JustificativasView");
    }

    @Override
    public void removeSubstituicoesAnosAnteriores() {
        try {
            Remessa rem = this.getRemessaPrincipal();
            int anoRem = rem.getAnoExercicio();
            this.executeCommand("delete from substituicoes where dt_fim < date('" + anoRem + "-01-01')");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Erro na remo\u00e7\u00e3o das substitui\u00e7\u00f5es de anos anteriores"}, e);
        }
    }

    public ArquivosComplementaresViewImpl getArquivosComplementaresDaRemessa() {
        return (ArquivosComplementaresViewImpl)this.findViewObject("ArquivosComplementaresDaRemessa");
    }

    public ViewLinkImpl getArqcRem1FkViewLink1() {
        return (ViewLinkImpl)this.findViewLink("ArqcRem1FkViewLink1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> buscaArquivosComplementaresNaoSelecionados() {
        ViewObject vo = null;
        ArrayList<String> listRetorno = new ArrayList<String>();
        try {
            String sql = "SELECT TIPO FROM arquivos_complementares WHERE solicitado = 'N' and tipo != 'PD'";
            vo = this.createViewObjectFromQueryStmt("ArquivosComplementaresDaRemessaTmp", sql);
            vo.executeQuery();
            while (vo.hasNext()) {
                Row row = vo.next();
                if (row == null) continue;
                Object tipo = row.getAttribute("TIPO");
                listRetorno.add(tipo.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return listRetorno;
    }

    @Override
    public void atualizaCNPJEntidade(String cdEntidade, String cnpjNovo) throws PersistenciaException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ENTIDADES SET CNPJ = '" + cnpjNovo + "' WHERE CD_ENTIDADE = " + cdEntidade);
            this.executeCommand(sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar Entidade"}, e);
        }
    }

    @Override
    public void atualizaRppsEntidade(int cdEntidade, int rpps) throws PersistenciaException {
        try {
            String sql = "UPDATE ENTIDADES SET RPPS = " + rpps + " WHERE CD_ENTIDADE = " + cdEntidade;
            int i1 = this.executeCommand(sql);
            String sql2 = "UPDATE ENT_INDIRETAS SET RPPS = " + rpps + " WHERE COD_ORGAO = " + cdEntidade;
            int i2 = this.executeCommand(sql2);
            log.debug((Object)("-- atualizaRppsEntidade:: update counts: i1/ENTIDADES==" + i1 + " ; i2/ENT_INDIRETAS==" + i2));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar Entidade"}, e);
        }
    }

    @Override
    public void atualizaCdEntidadePaiDaEntidade(int cdEntidade, int cdEntidadePai) throws PersistenciaException {
        try {
            String sql = "UPDATE ENTIDADES SET CD_ENTIDADE_PAI = " + cdEntidadePai + " WHERE CD_ENTIDADE = " + cdEntidade;
            int i1 = this.executeCommand(sql);
            log.debug((Object)("-- atualizaCdEntidadePaiDaEntidade:: update counts: i1/ENTIDADES==" + i1));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar Entidade"}, e);
        }
    }

    @Override
    public void atualizaTipoSetorGov(int cdEntidade, String tipoSetorGov) {
        try {
            String sql = "UPDATE ENTIDADES SET TIPO_SETOR_GOV = '" + tipoSetorGov + "' WHERE CD_ENTIDADE = " + cdEntidade;
            int i1 = this.executeCommand(sql);
            log.debug((Object)("-- atualizaTipoSetorGov:: update counts: i1/ENTIDADES==" + i1));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenciaException("10029", new Object[]{"Erro ao atualizar TIPO_SETOR_GOV"}, e);
        }
    }

    public static void erroProposital(String s) throws PersistenciaException {
        throw new PersistenciaException("10029", new Object[]{"Erro proposital: " + s});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> buscaArquivosComplementaresSelecionados() {
        ViewObject vo = null;
        ArrayList<String> listRetorno = new ArrayList<String>();
        try {
            String sql = "SELECT TIPO FROM arquivos_complementares WHERE solicitado = 'S' order by ordem";
            vo = this.createViewObjectFromQueryStmt("ArquivosComplementaresSel", sql);
            vo.executeQuery();
            while (vo.hasNext()) {
                Row row = vo.next();
                if (row == null) continue;
                Object tipo = row.getAttribute("TIPO");
                listRetorno.add(tipo.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return listRetorno;
    }

    @Override
    public void limpaArqComplementares() {
        try {
            ViewObject voArqCompl = this.findViewObject("ArquivosComplementaresDaRemessa");
            if (voArqCompl != null) {
                this.getTransaction().executeCommand("Delete from arquivos_complementares");
                this.getTransaction().commit();
                voArqCompl.clearCache();
                voArqCompl.executeQuery();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public List<Arquivo> removeArqComplementaresNaoSelecinados(List<Arquivo> list) {
        List<Object> idsArquivosSelec = new ArrayList();
        ArrayList<Arquivo> listTemp = new ArrayList<Arquivo>();
        try {
            List<String> idsArqComplemRemover = ProcessaArquivoHelper.todosIdsArqComplem();
            List<String> arqComplemSelec = this.buscaArquivosComplementaresSelecionados();
            boolean deveCarregarPD = this.deveCarregarArquivosRemessaNormal(arqComplemSelec);
            log.debug((Object)("deveCarregarPD[arqComplemSelec=" + arqComplemSelec + "]: " + deveCarregarPD));
            idsArquivosSelec = this.resolveIdentificadorArquivo(arqComplemSelec);
            idsArqComplemRemover.removeAll(idsArquivosSelec);
            Iterator<Arquivo> iterator = list.iterator();
            while (iterator.hasNext()) {
                Arquivo arq;
                Arquivo a = arq = iterator.next();
                if (!deveCarregarPD && !a.isComplementar()) {
                    listTemp.add(a);
                    continue;
                }
                for (String id : idsArqComplemRemover) {
                    if (!a.getIdentificador().toString().equalsIgnoreCase(id)) continue;
                    listTemp.add(a);
                }
            }
            log.debug((Object)("arquivosARemover: " + listTemp));
            list.removeAll(listTemp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private List<String> resolveIdentificadorArquivo(List<String> arqComplemSelec) {
        ArrayList<String> idsArquivos = new ArrayList<String>();
        for (String tipo : arqComplemSelec) {
            if (tipo.equalsIgnoreCase("LD")) {
                idsArquivos.add("TCE_4111");
                idsArquivos.add("TCE_4111_CAM");
            }
            if (tipo.equalsIgnoreCase("FP")) {
                idsArquivos.add("TCE_4810");
                idsArquivos.add("TCE_4820");
                idsArquivos.add("TCE_4960");
                idsArquivos.add("TCE_4810_6404");
                idsArquivos.add("TCE_4820_6404");
                idsArquivos.add("TCE_4960_6404");
                idsArquivos.add("PAGTO_POS");
                idsArquivos.add("PENSIONISTA");
                idsArquivos.add("DEPENDENTE");
            }
            if (!tipo.equalsIgnoreCase("RP")) continue;
            idsArquivos.add("TCE_4010");
        }
        return idsArquivos;
    }

    private boolean deveCarregarArquivosRemessaNormal(List<String> arqComplemSelec) {
        log.debug((Object)("deveCarregarArquivosRemessaNormal: arqComplemSelec=" + arqComplemSelec));
        boolean ret = true;
        for (String tipo : arqComplemSelec) {
            if (tipo.equalsIgnoreCase("LD")) {
                // empty if block
            }
            if (tipo.equalsIgnoreCase("FP")) {
                ret = false;
            }
            if (!tipo.equalsIgnoreCase("RP")) continue;
            ret = true;
            break;
        }
        log.debug((Object)("arqComplemSelec: ret=" + ret));
        return ret;
    }

    @Override
    public String resolveArquivoConfigFluxo(Integer tipoOperacao) {
        if (6 == tipoOperacao) {
            return "arquivos-complementares";
        }
        return "arquivos-principal";
    }

    @Override
    public void limpaTabelasArquivos(boolean isCargaArqSelecaoEfetuada) {
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-complementares");
        QueryRunner qr = new QueryRunner();
        RepositorioArquivosControleDerbyDBImpl repositorioArquivosControle = new RepositorioArquivosControleDerbyDBImpl();
        repositorioArquivosControle.inicializaRepositorioControle(DatabaseHelper.getConnection(this), qr);
        List<Arquivo> arquivosList = arquivos.getArquivos();
        for (int index = 0; index < arquivosList.size(); ++index) {
            Arquivo arquivo = arquivosList.get(index);
            Tabela tabela = arquivo.getTabela();
            if (tabela == null || isCargaArqSelecaoEfetuada && ("RUBRICAS".equals(tabela.getNome()) || "BAL_VERIFICACOES".equals(tabela.getNome()) || "BAL_RECEITAS".equals(tabela.getNome()))) continue;
            repositorioArquivosControle.limpaTabelaArquivo(arquivo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumeroHabitantesByCdEntidade(int codEntidade) {
        ViewObject vo = null;
        try {
            String sql = "select m.nro_habitantes \nfrom municipios m, entidades e\nwhere m.cod_municipio = e.cod_municipio\nand e.cd_entidade = " + codEntidade;
            vo = this.createViewObjectFromQueryStmt("NroHabitantesQuery", sql);
            vo.executeQuery();
            while (vo.hasNext()) {
                Row row = vo.next();
                if (row == null) continue;
                int n = ((BigDecimal)row.getAttribute(0)).intValue();
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return 0;
    }

    public TransparenciaGestaoFiscalViewImpl getTransparenciaGestaoFiscalView() {
        return (TransparenciaGestaoFiscalViewImpl)this.findViewObject("TransparenciaGestaoFiscalView");
    }

    public ViewLinkImpl getTransparenciaGFFKLink1() {
        return (ViewLinkImpl)this.findViewLink("TransparenciaGFFKLink1");
    }

    @Override
    public List<String> getArquivosIgnoraveis() {
        String[] arquivosIgnoraveis = new String[]{"BVMOVANT.TXT"};
        if (VersaoUtils.isDebugModeEnabled()) {
            arquivosIgnoraveis = new String[]{"BVMOVANT.TXT", "TCE_4111.TXT"};
        }
        return Arrays.asList(arquivosIgnoraveis);
    }
}

