/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.relatorio;

import br.gov.rs.tce.command.CommandCallback;
import br.gov.rs.tce.command.CommandRunner;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.MensagensVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.RelatorioControleException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.exportacao.ExportacaoDados;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.IndicadorProgresso;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import oracle.jbo.ApplicationModule;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.Driver;

public final class RelatorioControle
implements IndicadorProgresso {
    static final Log log = LogFactory.getLog(RelatorioControle.class);
    static final String PARAM_DEBUG = "debug";
    private ChangeListener _listenerEventos;
    private int _progresso;
    private String _situacao;

    public RelatorioControle() {
    }

    public RelatorioControle(ChangeListener listener) {
        this._listenerEventos = listener;
    }

    void constroiRelatorio(File arquivoSaidaPDF, String arquivoXML, String arquivoXSL) throws RelatorioControleException {
        this.constroiRelatorio(arquivoSaidaPDF, arquivoXML, arquivoXSL, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void constroiRelatorio(File arquivoSaidaPDF, String arquivoXML, String arquivoXSL, boolean isUTF8) throws RelatorioControleException {
        FileOutputStream outfile = null;
        InputStreamReader isXSL = null;
        InputStreamReader isXML = null;
        StringBuffer sb = new StringBuffer("Gerando arquivo PDF: ");
        String formatEncoding = "";
        formatEncoding = isUTF8 ? "UTF-8" : "ISO-8859-1";
        try {
            this.setSituacao(sb.append(arquivoSaidaPDF.getName()).toString());
            outfile = new FileOutputStream(arquivoSaidaPDF);
            Driver driver = new Driver();
            driver.setOutputStream((OutputStream)outfile);
            driver.setRenderer(1);
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
            TransformerFactory factory = TransformerFactory.newInstance();
            File f = new File(arquivoXSL);
            isXSL = f.exists() ? new InputStreamReader((InputStream)new FileInputStream(arquivoXSL), formatEncoding) : new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(arquivoXSL), formatEncoding);
            if (isXSL == null) {
                throw new RelatorioControleException("Arquivo XSL do relat\u00f3rio n\u00e3o foi encontrado.", arquivoXSL);
            }
            StreamSource source = new StreamSource(isXSL);
            Transformer transformer = factory.newTransformer(source);
            isXML = new InputStreamReader((InputStream)new FileInputStream(new File(arquivoXML)), formatEncoding);
            if (VersaoUtils.isDebugModeEnabled()) {
                transformer.setParameter(PARAM_DEBUG, "on");
            }
            if (isXML == null) {
                throw new RelatorioControleException("Arquivo XML do relat\u00f3rio n\u00e3o foi encontrado.", arquivoXML);
            }
            transformer.transform(new StreamSource(isXML), new SAXResult(driver.getContentHandler()));
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                System.out.print(System.getProperties());
                throw new RelatorioControleException("Verifique se n\u00e3o existe algum relat\u00f3rio aberto antes de gerar a assinatura.", arquivoSaidaPDF.getName(), new Exception(e));
                catch (Throwable e2) {
                    e2.printStackTrace();
                    log.warn((Object)("Erro " + e2 + " ; arquivoXML: " + arquivoXML));
                    System.out.print(System.getProperties());
                    throw new RelatorioControleException("Ocorre um erro durante a gera\u00e7\u00e3o do relat\u00f3rio [" + e2.getMessage() + "]", arquivoSaidaPDF.getName(), new Exception(e2));
                }
            }
            catch (Throwable throwable) {
                RelatorioControle.fechaArquivo(isXML);
                RelatorioControle.fechaArquivo(isXSL);
                RelatorioControle.fechaArquivo(outfile);
                throw throwable;
            }
        }
        RelatorioControle.fechaArquivo(isXML);
        RelatorioControle.fechaArquivo(isXSL);
        RelatorioControle.fechaArquivo(outfile);
    }

    private static void fechaArquivo(OutputStream outfile) {
        try {
            if (outfile != null) {
                outfile.close();
            }
        }
        catch (Exception e) {
            log.error((Object)new RelatorioControleException("Erro ao fechar o arquivo.", e.getMessage(), e));
        }
    }

    private static void fechaArquivo(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            log.error((Object)new RelatorioControleException("Erro ao fechar o arquivo.", e.getMessage(), e));
        }
    }

    public void geraRelatorios(Remessa remessa, ApplicationModule app, File diretorioDestino) {
        this.geraRelatorios("", remessa, app, null, diretorioDestino, true, true);
    }

    public void geraRelatorios(Remessa remessa, ApplicationModule app, ChangeListener listenerGeracaoXML, File diretorioDestino, boolean geraXML, boolean geraPDF) {
        this.geraRelatorios("", remessa, app, listenerGeracaoXML, diretorioDestino, geraXML, geraPDF);
    }

    void geraRelatorios(String path, Remessa remessa, ApplicationModule app, ChangeListener listenerGeracaoXML, File diretorioDestino, boolean geraXML, boolean geraPDF) {
        String pathWeb = path;
        ConsultasExtracaoList consultasRVE = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-rve.xml"), geraXML);
        ConsultasExtracaoList consultasRVELight = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-rve-lig.xml"), geraXML);
        ConsultasExtracaoList consultasRDI = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-rdi.xml"), geraXML);
        ConsultasExtracaoList consultasMOD9 = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-modelo9.xml"), geraXML);
        ConsultasExtracaoList consultasMOD14 = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-modelo14.xml"), geraXML);
        ConsultasExtracaoList consultasDcBalPat = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-dc-balpat.xml"), geraXML);
        ConsultasExtracaoList consultasDcBalOrc = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-dc-balorc.xml"), geraXML);
        ConsultasExtracaoList consultasDcDVP = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-dc-dvp.xml"), geraXML);
        ExportacaoDados exp = new ExportacaoDados(app, listenerGeracaoXML);
        TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(app);
        this.setProgresso(0);
        int periodo = remessa.getPeriodoInformacoes();
        boolean temIndiretas = ((ServicoPAD)app).existeIndiretasConsolidacao();
        boolean naoConsolidou = ((ServicoPAD)app).existemIndiretasNaoConsolidadas();
        log.info((Object)("geraRelatorios:: periodo: " + periodo + " ; grupo-entrega: " + remessa.getGrupoEntrega() + " ; geraXML: " + geraXML + " ; geraPDF: " + geraPDF + " ; temIndiretas: " + temIndiretas + " ; naoConsolidou: " + naoConsolidou));
        if (geraXML) {
            if (remessa.getGrupoEntrega() == 1 || remessa.getGrupoEntrega() == 5 || remessa.getGrupoEntrega() == 11 || remessa.getGrupoEntrega() == 12) {
                if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", "rve.xsl", consultasRVE, remessa, tpBanco, exp);
                    if (remessa.getGrupoEntrega() == 11 || remessa.getGrupoEntrega() == 12) {
                        this.geraDemonstrativosContabeis(remessa, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, consultasDcBalOrc, consultasDcDVP);
                    }
                }
                if (temIndiretas && !naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do Modelo 9");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "modelo9.pdf", "modelo9.xml", "modelo9.xsl", consultasMOD9, remessa, tpBanco, exp);
                }
            } else if (remessa.getGrupoEntrega() == 2 || remessa.getGrupoEntrega() == 13) {
                if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", "rve.xsl", consultasRVE, remessa, tpBanco, exp);
                }
                if (temIndiretas && !naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do Modelo 14");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "modelo14.pdf", "modelo14.xml", "modelo14.xsl", consultasMOD14, remessa, tpBanco, exp);
                }
                if (remessa.getGrupoEntrega() == 13) {
                    this.geraDemonstrativosContabeis(remessa, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, null, consultasDcDVP);
                }
            } else if (remessa.getGrupoEntrega() == 3 || remessa.getGrupoEntrega() == 14) {
                if (remessa.getTipoOperacao() == 6) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", "rve.xsl", consultasRVELight, remessa, tpBanco, exp);
                } else if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", "rve.xsl", consultasRVE, remessa, tpBanco, exp);
                }
                if (remessa.getGrupoEntrega() == 14) {
                    this.geraDemonstrativosContabeis(remessa, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, consultasDcBalOrc, consultasDcDVP);
                }
            } else if (remessa.getGrupoEntrega() == 7) {
                if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", "rve.xsl", consultasRVELight, remessa, tpBanco, exp);
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RDI");
                    this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "rdi.pdf", "rdi.xml", "rdi.xsl", consultasRDI, remessa, tpBanco, exp);
                }
            } else {
                throw new RuntimeException("GrupoEntrega desconhecido: " + remessa.getGrupoEntrega());
            }
        }
        if (geraPDF) {
            String arquivoXSL = "rve.xsl";
            if (remessa.getGrupoEntrega() == 1 || remessa.getGrupoEntrega() == 5 || remessa.getGrupoEntrega() == 11 || remessa.getGrupoEntrega() == 12) {
                if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", pathWeb + arquivoXSL, consultasRVE, remessa, tpBanco, exp);
                    if (remessa.getGrupoEntrega() == 11 || remessa.getGrupoEntrega() == 12) {
                        this.transformaPdfDemonstrativosContabeis(remessa, pathWeb, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, consultasDcBalOrc, consultasDcDVP);
                    }
                }
                if (temIndiretas && !naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do Modelo 9");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "modelo9.pdf", "modelo9.xml", pathWeb + "modelo9.xsl", consultasMOD9, remessa, tpBanco, exp);
                }
            } else if (remessa.getGrupoEntrega() == 2 || remessa.getGrupoEntrega() == 13) {
                if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", pathWeb + arquivoXSL, consultasRVE, remessa, tpBanco, exp);
                }
                if (temIndiretas && !naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do Modelo 14");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "modelo14.pdf", "modelo14.xml", pathWeb + "modelo14.xsl", consultasMOD14, remessa, tpBanco, exp);
                }
                if (remessa.getGrupoEntrega() == 13) {
                    this.transformaPdfDemonstrativosContabeis(remessa, pathWeb, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, null, consultasDcDVP);
                }
            } else if (remessa.getGrupoEntrega() == 3 || remessa.getGrupoEntrega() == 14) {
                if (remessa.getTipoOperacao() == 6) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", pathWeb + arquivoXSL, consultasRVELight, remessa, tpBanco, exp);
                } else if (temIndiretas && naoConsolidou || !temIndiretas) {
                    this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                    this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", pathWeb + arquivoXSL, consultasRVE, remessa, tpBanco, exp);
                }
                if (remessa.getGrupoEntrega() == 14) {
                    this.transformaPdfDemonstrativosContabeis(remessa, pathWeb, listenerGeracaoXML, diretorioDestino, exp, tpBanco, consultasDcBalPat, consultasDcBalOrc, consultasDcDVP);
                }
            } else if (remessa.getGrupoEntrega() == 7) {
                this.setSituacao("Gerando arquivos para relat\u00f3rio do RVE");
                this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rve.pdf", "rve.xml", pathWeb + arquivoXSL, consultasRVELight, remessa, tpBanco, exp);
                this.setSituacao("Gerando arquivos para relat\u00f3rio do RDI");
                this.transformaPDF(listenerGeracaoXML, diretorioDestino, "rdi.pdf", "rdi.xml", pathWeb + "rdi.xsl", consultasRDI, remessa, tpBanco, exp);
            } else {
                throw new RuntimeException("GrupoEntrega desconhecido: " + remessa.getGrupoEntrega());
            }
        }
    }

    void geraDemonstrativosContabeis(Remessa remessa, ChangeListener listenerGeracaoXML, File diretorioDestino, ExportacaoDados exp, TipoBancoDados tpBanco, ConsultasExtracaoList consultasDcBalPat, ConsultasExtracaoList consultasDcBalOrc, ConsultasExtracaoList consultasDcDvp) {
        this.setSituacao("Gerando arquivos para relat\u00f3rio DC-BalPat");
        this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "dc-balpat.pdf", "dc-balpat.xml", "dc-balpat.xsl", consultasDcBalPat, remessa, tpBanco, exp);
        if (consultasDcBalOrc != null) {
            this.setSituacao("Gerando arquivos para relat\u00f3rio DC-BalOrc");
            this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "dc-balorc.pdf", "dc-balorc.xml", "dc-balorc.xsl", consultasDcBalOrc, remessa, tpBanco, exp);
        }
        this.setSituacao("Gerando arquivos para relat\u00f3rio DC-Dvp");
        this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "dc-dvp.pdf", "dc-dvp.xml", "dc-dvp.xsl", consultasDcDvp, remessa, tpBanco, exp);
    }

    void transformaPdfDemonstrativosContabeis(Remessa remessa, String pathWeb, ChangeListener listenerGeracaoXML, File diretorioDestino, ExportacaoDados exp, TipoBancoDados tpBanco, ConsultasExtracaoList consultasDcBalPat, ConsultasExtracaoList consultasDcBalOrc, ConsultasExtracaoList consultasDcDvp) {
        this.setSituacao("Gerando arquivos para relat\u00f3rio DC-BalPat");
        this.transformaPDF(listenerGeracaoXML, diretorioDestino, "dc-balpat.pdf", "dc-balpat.xml", pathWeb + "dc-balpat.xsl", consultasDcBalPat, remessa, tpBanco, exp);
        if (consultasDcBalOrc != null) {
            this.setSituacao("Gerando arquivos para relat\u00f3rio DC-BalOrc");
            this.transformaPDF(listenerGeracaoXML, diretorioDestino, "dc-balorc.pdf", "dc-balorc.xml", pathWeb + "dc-balorc.xsl", consultasDcBalOrc, remessa, tpBanco, exp);
        }
        this.setSituacao("Gerando arquivos para relat\u00f3rio DC-Dvp");
        this.transformaPDF(listenerGeracaoXML, diretorioDestino, "dc-dvp.pdf", "dc-dvp.xml", pathWeb + "dc-dvp.xsl", consultasDcDvp, remessa, tpBanco, exp);
    }

    void geraDadosXML(ChangeListener listener, File diretorioDestino, String nomeArquivoDadosPDF, String nomeArquivoDadosXML, String nomeArquivoXSL, ConsultasExtracaoList consultasSQL, Remessa remessa, TipoBancoDados tpBanco, ExportacaoDados exp) {
        this.setSituacao("Preparando para gerar dados XML.");
        log.info((Object)("processando XML: " + nomeArquivoDadosXML + " [XSL = " + nomeArquivoXSL + "]"));
        this.preparaArquivoDadosRelatorio(diretorioDestino + File.separator + nomeArquivoDadosXML, consultasSQL, remessa, tpBanco, exp);
    }

    File transformaPDF(ChangeListener listener, File diretorioDestino, String nomeArquivoDadosPDF, String nomeArquivoDadosXML, String nomeArquivoXSL, ConsultasExtracaoList consultasSQL, Remessa remessa, TipoBancoDados tpBanco, ExportacaoDados exp) {
        this.setSituacao("Preparando transforma\u00e7\u00e3o do Relat\u00f3rio.");
        RelatorioControle relatorio = new RelatorioControle(listener);
        File saidaPDF = new File(diretorioDestino + File.separator + nomeArquivoDadosPDF);
        relatorio.constroiRelatorio(saidaPDF, diretorioDestino + File.separator + nomeArquivoDadosXML, nomeArquivoXSL, false);
        return saidaPDF;
    }

    private void preparaArquivoDadosRelatorio(String arquivo, ConsultasExtracaoList consultas, Remessa remessa, TipoBancoDados tpBanco, ExportacaoDados exp) {
        try {
            exp.montaXMLsaida(consultas, new File(arquivo), remessa, tpBanco, false);
        }
        catch (Exception e) {
            throw new RelatorioControleException("Erro durante a gera\u00e7\u00e3o do arquivo de sa\u00edda do relat\u00f3rio.", arquivo, e);
        }
    }

    public static boolean visualiza(File arquivoRelatorio, CommandCallback callback) {
        try {
            if (Desktop.isDesktopSupported()) {
                log.info((Object)("Usando Desktop.getDesktop().open(): " + arquivoRelatorio + " [callback " + (callback == null ? "null" : "not null") + "]"));
                Desktop.getDesktop().open(arquivoRelatorio);
                log.info((Object)"Usou Desktop.getDesktop().open()...");
                return true;
            }
            String comando = null;
            boolean wait = true;
            if (SystemUtils.IS_OS_WINDOWS_95 || SystemUtils.IS_OS_WINDOWS_98 || SystemUtils.IS_OS_WINDOWS_ME) {
                comando = "command.com /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            } else if (SystemUtils.IS_OS_WINDOWS) {
                comando = "cmd.exe /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                comando = "open \"" + arquivoRelatorio.getAbsolutePath() + "\"";
                wait = false;
            } else if (SystemUtils.IS_OS_UNIX) {
                comando = "xdg-open \"" + arquivoRelatorio.getAbsolutePath() + "\"";
                wait = false;
            } else {
                log.warn((Object)("sistema operacional desconhecido (utilizando como se Windows NT+) - os.name=" + System.getProperty("os.name")));
                comando = "cmd.exe /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            }
            CommandRunner runner = new CommandRunner();
            System.out.println("Comando para Abrir PDF: " + comando + " [callback " + (callback == null ? "null" : "not null") + " ; wait = " + wait + "]");
            if (callback != null) {
                runner.executeInThread(comando, null, callback);
                return true;
            }
            return runner.execute(comando, wait) < 1;
        }
        catch (Exception error) {
            log.error((Object)"Exception ao visualizar", (Throwable)error);
            throw new RelatorioControleException("O Arquivo solicitado n\u00e3o pode ser visualizado.", arquivoRelatorio.getAbsoluteFile().toString());
        }
    }

    public File geraRelatorioVerificacao(String destino, MensagensVerificacao envioXml, boolean isUTF8) {
        RemessaControle remessaControle = new RemessaControle(null, null);
        String arquivoXML = destino + "mensagensVerificacao.xml";
        String arquivoXSL = "mensagensVerificacao.xsl";
        File arquivoPdf = new File(destino + "mensagensVerificacao.pdf");
        try {
            remessaControle.geraXml(envioXml, new FileWriter(arquivoXML), "UTF-8");
        }
        catch (IOException exp) {
            throw new RelatorioControleException("Erro durante a gera\u00e7\u00e3o do arquivo de sa\u00edda do relat\u00f3rio.", arquivoXML, exp);
        }
        this.constroiRelatorio(arquivoPdf, arquivoXML, arquivoXSL, isUTF8);
        return arquivoPdf;
    }

    private void setProgresso(int progresso) {
        this._progresso = progresso;
        this.fireChangeEvent();
    }

    @Override
    public int getProgresso() {
        return this._progresso;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangeEvent();
    }

    @Override
    public String getSituacao() {
        return this._situacao;
    }

    private void fireChangeEvent() {
        if (this._listenerEventos != null) {
            ChangeEvent change = new ChangeEvent(this);
            this._listenerEventos.stateChanged(change);
        }
    }

    public static void main(String[] args) {
        String doc = null;
        String nomeXsl = null;
        doc = "rve";
        String nomePdf = "remessa\\" + doc + ".pdf";
        String nomeXml = "remessa\\" + doc + ".xml";
        if ("rve_leg".equals(doc)) {
            doc = "rve";
        }
        nomeXsl = "src\\" + doc + ".xsl";
        System.out.println("Diretorio atual: " + new File(".").getAbsolutePath());
        File arquivoSaidaPDF = new File(nomePdf);
        File arquivoXsl = new File(nomeXsl);
        File arquivoXml = new File(nomeXml);
        boolean ok = true;
        if (!arquivoXsl.canRead()) {
            System.err.println("N\u00e3o \u00e9 possivel ler o arquivo XSL: " + nomeXsl);
            ok = false;
        }
        if (!arquivoXml.exists()) {
            System.err.println("N\u00e3o \u00e9 possivel ler o arquivo XML: " + nomeXml);
            ok = false;
        }
        if (ok) {
            System.out.println("PDF:" + arquivoSaidaPDF.getAbsolutePath());
            System.out.println("XML:" + arquivoXml.getAbsolutePath());
            System.out.println("XSL:" + arquivoXsl.getAbsolutePath());
            RelatorioControle relatorio = new RelatorioControle();
            relatorio.constroiRelatorio(arquivoSaidaPDF, nomeXml, nomeXsl);
            CommandRunner cmd = new CommandRunner();
            StringWriter writer = new StringWriter();
            cmd.execute("cmd.exe /c start acrord32 " + arquivoSaidaPDF.getAbsolutePath(), writer);
            System.out.println(writer);
        }
    }
}

