/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.assdigital.excecao.AssinaturaDigitalException;
import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.excecao.ArquivoContabilNaoEncontradoException;
import br.gov.rs.tce.pad.excecao.ArquivoVazioException;
import br.gov.rs.tce.pad.excecao.CargaCanceladaException;
import br.gov.rs.tce.pad.excecao.FinalizadorException;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControleImpl;
import br.gov.rs.tce.pad.util.FasterBufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ArquivoContabilReader {
    protected MetadadosArquivoContabil _metadadosArquivo;
    private ImportacaoArquivoControle _importacaoControle;
    private FasterBufferedReader _bufferedReader = null;
    private MessageDigest _md = null;
    public static final String ALGORITMO = "MD5";
    public static final String FINALIZADOR = "FINALIZADOR";
    private static final Log log = LogFactory.getLog(ArquivoContabilReader.class);
    private static final int TAMANHO_BUFFER_LEITURA = 16384;
    static final int LOG_LINHA_MOD = 200000;

    public void abreArquivo(ContextoVerificacao contexto, SituacaoVerificacao situacao) throws ImportacaoException {
        try {
            this._md = AssinaturaDigitalControle.createDigest();
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        this._bufferedReader = this.abreBufferArquivo();
        this.processaArquivo(contexto, situacao);
    }

    public void fechaArquivo() throws ImportacaoException {
        try {
            if (this._bufferedReader != null) {
                this._bufferedReader.close();
            }
        }
        catch (IOException e) {
            throw new ImportacaoException(e);
        }
    }

    public byte[] getMessageDigest() {
        return this._metadadosArquivo.getDigestOriginal();
    }

    public void setImportacaoControle(ImportacaoArquivoControle importacaoControle) {
        this._importacaoControle = importacaoControle;
    }

    public ArquivoContabilReader(MetadadosArquivoContabil metadadosArquivo) throws ImportacaoException {
        this._metadadosArquivo = metadadosArquivo;
        if (metadadosArquivo == null) {
            System.err.println("ArquivoContabilReader com metadadosArquivo == null!");
        }
    }

    private void processaArquivo(ContextoVerificacao contexto, SituacaoVerificacao situacao) throws ImportacaoException, ArquivoVazioException {
        StringBuilder linha = null;
        int numeroLinhasArquivoLido = 0;
        boolean fimArquivoEncontrado = false;
        Arquivo arquivo = this._metadadosArquivo.getArquivo();
        long initTime = System.currentTimeMillis();
        try {
            log.info((Object)("iniciando carga: arquivo " + arquivo.getNome()));
            log.debug((Object)("-- caminho " + this._metadadosArquivo.getArquivoFisico()));
            while ((linha = this._bufferedReader.readLine()) != null) {
                if (!fimArquivoEncontrado) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new CargaCanceladaException("Processo interrompido pelo usu\u00e1rio");
                    }
                    if (numeroLinhasArquivoLido == 0) {
                        this._importacaoControle.trataCabecalho(contexto, situacao, linha);
                    } else if (linha.length() <= 0 || linha.charAt(0) != 'F' || linha.charAt(1) != 'I' || linha.charAt(2) != 'N' || linha.charAt(3) != 'A' || linha.charAt(4) != 'L' || linha.charAt(5) != 'I' || linha.charAt(6) != 'Z' || linha.charAt(7) != 'A' || linha.charAt(8) != 'D' || linha.charAt(9) != 'O' || linha.charAt(10) != 'R') {
                        this.processaLinha(numeroLinhasArquivoLido, linha, contexto, situacao);
                    } else {
                        if (numeroLinhasArquivoLido == 1 && this._metadadosArquivo.getArquivo().hasArquivoVazioCodigoMensagem() && !this._metadadosArquivo.getArquivo().isComplementar()) {
                            log.info((Object)("throw ArquivoVazioException..." + linha + " / " + numeroLinhasArquivoLido + " / " + this._metadadosArquivo.getArquivo().getNome() + " / " + this._metadadosArquivo.getArquivo().hasArquivoVazioCodigoMensagem()));
                            this._metadadosArquivo.setDigestOriginal(this._md.digest());
                            throw new ArquivoVazioException(this._metadadosArquivo.getArquivo().getIdentificador().toString());
                        }
                        this._importacaoControle.trataFinalizador(linha, numeroLinhasArquivoLido - 1, contexto, situacao);
                        fimArquivoEncontrado = true;
                    }
                    if (++numeroLinhasArquivoLido % 200000 != 0) continue;
                    log.info((Object)("   [log] linha " + numeroLinhasArquivoLido + " lida [used mem=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "]"));
                    continue;
                }
                if (fimArquivoEncontrado) {
                    situacao.adicionaMensagem(ImportacaoArquivoControleImpl.getMensagemFactory().constroiMensagem("FIM_04", arquivo, new Object[]{numeroLinhasArquivoLido}));
                }
                ++numeroLinhasArquivoLido;
            }
        }
        catch (IOException e) {
            log.warn((Object)("IOException: arquivo " + arquivo.getNome() + " - linha = " + numeroLinhasArquivoLido));
            throw new ImportacaoException(new IOException("Erro ao processar linha do arquivo " + arquivo.getNome() + " [" + numeroLinhasArquivoLido + " linhas lidas]", e));
        }
        catch (OutOfMemoryError e) {
            log.warn((Object)("OutOfMemoryError: arquivo " + arquivo.getNome() + " - linha = " + numeroLinhasArquivoLido + " [used mem=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "]"));
            throw e;
        }
        catch (RuntimeException e) {
            log.warn((Object)("   [RuntimeException] " + e + " ; arquivo = " + arquivo.getNome() + " ; linha = " + numeroLinhasArquivoLido));
            throw e;
        }
        finally {
            long elapsed = System.currentTimeMillis() - initTime;
            if (elapsed > 0L) {
                log.info((Object)("finalizada carga: arquivo " + arquivo.getNome() + " - linhas: " + numeroLinhasArquivoLido + " - lps: " + (long)(numeroLinhasArquivoLido * 1000) / elapsed + " - elapsed: " + elapsed + "ms"));
            } else {
                log.info((Object)("finalizada carga: arquivo " + arquivo.getNome() + " - linhas: " + numeroLinhasArquivoLido + " - lps infinito! (elapsed==0)"));
            }
        }
        this._metadadosArquivo.setLinhasLidas(numeroLinhasArquivoLido);
        if (!fimArquivoEncontrado) {
            FinalizadorException fe = new FinalizadorException(numeroLinhasArquivoLido);
            if (Mensagem.ehMensagemErro("FIM_01")) {
                throw fe;
            }
            ImportacaoArquivoControleImpl.trataFinalizadorException(situacao, arquivo, fe);
        } else {
            this._metadadosArquivo.setDigestOriginal(this._md.digest());
        }
    }

    private void processaLinha(int numeroLinhaAtual, StringBuilder linha, ContextoVerificacao contexto, SituacaoVerificacao situacao) {
        if (this._importacaoControle == null) {
            throw new ImportacaoException("10017", new Object[]{ImportacaoArquivoControle.class.getName()});
        }
        this._importacaoControle.processaLinha(numeroLinhaAtual, linha, contexto, situacao);
    }

    private FasterBufferedReader abreBufferArquivo() {
        FasterBufferedReader buf = null;
        try {
            File arquivo = this._metadadosArquivo.getArquivoFisico();
            String charsetPadrao = "ISO-8859-1";
            if (arquivo == null) {
                throw new ArquivoContabilNaoEncontradoException(this._metadadosArquivo.getArquivo().getNome());
            }
            if (!arquivo.exists()) {
                throw new ArquivoContabilNaoEncontradoException(arquivo.getAbsolutePath());
            }
            try {
                buf = new FasterBufferedReader(new InputStreamReader((InputStream)new DigestInputStream(new FileInputStream(arquivo), this._md), charsetPadrao), 16384);
            }
            catch (UnsupportedEncodingException ue) {
                log.debug((Object)("Erro UnsupportedEncodingException (" + charsetPadrao + ") - ser\u00e1 usado o 'default charset' - arquivo: " + arquivo));
                buf = new FasterBufferedReader(new InputStreamReader(new DigestInputStream(new FileInputStream(arquivo), this._md)), 16384);
            }
        }
        catch (FileNotFoundException e) {
            throw new ArquivoContabilNaoEncontradoException(this._metadadosArquivo.getArquivoFisico().getAbsolutePath());
        }
        return buf;
    }

    public MetadadosArquivoContabil getMetadadosArquivo() {
        return this._metadadosArquivo;
    }
}

