/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.decisao;

import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.action.PadModeloAction;
import br.gov.rs.tce.pad.modelo.decisao.DecisaoNavegacaoTelas;
import br.gov.rs.tce.pad.modelo.decisao.Navegacao;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.DCGenericDataControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NavegacaoTelasControle
extends DCGenericDataControl {
    public static final String NAVEGACAO_DATA_CONTROL = "$NavegacaoDataControl";
    private Navegacao _navegacao;
    private BindingContext _binding;
    private Log log = LogFactory.getLog(NavegacaoTelasControle.class);

    public NavegacaoTelasControle() {
        super(NAVEGACAO_DATA_CONTROL, Navegacao.class.getName(), (Object)new Navegacao(), true);
        this._navegacao = (Navegacao)this.getDataProvider();
        this._navegacao.avancarTela(DecisaoNavegacaoTelas.getInstancia().getTelaInicial());
    }

    public Tela avancarTela(String codigoTelaAtual, BindingContext binding) {
        this._binding = binding;
        DecisaoNavegacaoTelas decicaoTelas = DecisaoNavegacaoTelas.getInstancia();
        this.log.debug((Object)"Decis\u00e3o de tela - Inst\u00e2ncia");
        Tela atual = decicaoTelas.getTelaPorCodigo(codigoTelaAtual);
        Tela tela = decicaoTelas.escolheProximaTela(codigoTelaAtual, binding);
        this.log.debug((Object)"Tela - Limpa Modelo");
        this.limpaModelo(atual, binding);
        this.log.debug((Object)"Tela - Inicia Prepara\u00e7\u00e3o de Modelo");
        this.preparaModelo(tela, binding);
        this.log.debug((Object)"Tela - Finalizou Prepara\u00e7\u00e3o de Modelo");
        this._navegacao.avancarTela(tela);
        this.log.info((Object)("Avancando para tela: " + tela.getCodigo()));
        return tela;
    }

    public Tela voltarTela() {
        Tela telaAtual = this._navegacao.getTelaAtual();
        this.limpaModelo(telaAtual, this._binding);
        Tela tela = this._navegacao.voltarTela();
        this.preparaModelo(tela, this._binding);
        return tela;
    }

    public Tela voltarParaTela(String constanteTela) {
        Tela telaAtual = this._navegacao.getTelaAtual();
        this.limpaModelo(telaAtual, this._binding);
        Tela tela = this._navegacao.voltarParaTela(constanteTela);
        this.preparaModelo(tela, this._binding);
        return tela;
    }

    public boolean existeTela(String constanteTela) {
        return this._navegacao.existeTela(constanteTela);
    }

    public Tela getConfigTelaAtual() {
        return this._navegacao.getTelaAtual();
    }

    private void preparaModelo(Tela proxTela, BindingContext binding) {
        String nomeActionModelo = proxTela.getActionModelo();
        if (nomeActionModelo != null && nomeActionModelo.length() > 5) {
            PadModeloAction action = this.getAction(proxTela.getCodigo(), nomeActionModelo);
            action.preparaModelo(proxTela, binding);
        }
    }

    private void limpaModelo(Tela tela, BindingContext binding) {
        String classe = tela.getActionModelo();
        if (classe != null && !classe.equals("")) {
            PadModeloAction action = this.getAction(tela.getCodigo(), classe);
            action.limpaModelo(tela, binding);
        }
    }

    private PadModeloAction getAction(String codigoTela, String nomeClasse) throws PADActionException {
        PadModeloAction action = null;
        try {
            action = (PadModeloAction)Class.forName(nomeClasse).newInstance();
        }
        catch (Exception e) {
            throw new PADActionException(codigoTela, nomeClasse, e);
        }
        return action;
    }
}

