/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.decisao;

import br.gov.rs.tce.pad.beans.ConfigTelas;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.util.NavegacaoHelper;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class DecisaoNavegacaoFactory {
    private ConfigTelas _config;
    private static DecisaoNavegacaoFactory _instancia;
    private static final String ARQUIVO_DEFINICAO = "config-telas.xml";
    private static final String MAPPING_CONF = "mapping-config-telas.xml";

    private DecisaoNavegacaoFactory() {
        Mapping mapping = new Mapping();
        String tipoNavegacao = null;
        try {
            tipoNavegacao = NavegacaoHelper.getTipoNavegacao();
        }
        catch (PADRuntimeException pre) {
            tipoNavegacao = "DESKTOP";
        }
        try {
            InputSource source = new InputSource(this.getClass().getClassLoader().getResourceAsStream(MAPPING_CONF));
            mapping.loadMapping(source);
            if (!tipoNavegacao.equalsIgnoreCase("DESKTOP")) {
                throw new PADRuntimeException("O tipo de navega\u00e7\u00e3o deve ser NavegacaoHelper.NAVEGACAO_DESKTOP");
            }
            Unmarshaller unmar = new Unmarshaller(mapping);
            this._config = (ConfigTelas)unmar.unmarshal(new InputSource(this.getClass().getClassLoader().getResourceAsStream(ARQUIVO_DEFINICAO)));
        }
        catch (Exception e) {
            throw new ConfiguracaoException(e);
        }
    }

    public static final DecisaoNavegacaoFactory getInstancia() {
        if (_instancia == null) {
            _instancia = new DecisaoNavegacaoFactory();
        }
        return _instancia;
    }

    public ConfigTelas getConfigTelas() {
        return this._config;
    }
}

