/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloPadraoJustificativas;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.modelo.servico.negocio.JustificativasImpl;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import oracle.adf.model.BindingContext;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionModeloUC091
extends ActionModeloPadraoJustificativas {
    static final int M1_ENDIV = 12;
    static final int M1_DESP_PESS = 13;
    private static final Object[][] CONSULTAS_TOTAIS_MODELOS = new Object[][]{{1, "UC061A-TOTAL-UC091", new int[0], new String[]{"P"}}, {12, "UC061G-TOTAL-A", new int[0], new String[]{"P"}}, {13, "UC085-QUADRO-RCL", new int[0], new String[]{"C"}}, {13, "UC061G-TOTAL-B", new int[0], new String[]{"P"}}, {2, "UC062F-TOTAL-02", new int[0], new String[]{"P"}}, {4, "UC064A-TOTAL-02", new int[0], new String[]{"P"}}, {5, "UC065-TOTAL-QUADRO-01", new int[0], new String[]{"P"}}, {61, "UC066-TOTAL", new int[0], new String[]{"P"}}, {62, "UC066-TOTAL-QUADRO-03", new int[0], new String[]{"P"}}, {10, "UC068C-TOTAL-02", new int[]{1, 2, 3, 4, 5}, new String[]{"P", "C"}}, {10, "UC068CE-TOTAL-01", new int[]{6}, new String[]{"P", "C"}}};
    public static final int PRETO = 0;
    public static final int VERDE = 1;
    public static final int AZUL = 2;
    public static final int VERMELHO = 3;
    private double[][][] FAIXA_VALORES_LIMITES = new double[][][]{new double[][]{{2.0}, {0.0, 0.0, 48.6}, {1.0, 48.61, 51.3}, {2.0, 51.31, 54.0}, {3.0, 54.01, Double.MAX_VALUE}}, new double[][]{{4.0}, {0.0, 0.0, 108.0}, {2.0, 108.01, 120.0}, {3.0, 120.01, Double.MAX_VALUE}}, new double[][]{{61.0}, {0.0, 0.0, 14.4}, {2.0, 14.41, 16.0}, {3.0, 16.01, Double.MAX_VALUE}}, new double[][]{{62.0}, {0.0, 0.0, 6.3}, {2.0, 6.31, 7.0}, {3.0, 7.01, Double.MAX_VALUE}}, new double[][]{{10.0}, {0.0, 0.0, 5.4}, {1.0, 5.41, 5.7}, {2.0, 5.71, 6.0}, {3.0, 6.01, Double.MAX_VALUE}}};
    private double[][] MODELO_5_FAIXA_A = new double[][]{{0.0, 0.0, 19.8}, {2.0, 19.81, 22.0}, {3.0, 22.01, Double.MAX_VALUE}};
    private double[][] MODELO_5_FAIXA_B = new double[][]{{0.0, 0.0, 28.8}, {2.0, 28.81, 32.0}, {3.0, 32.01, Double.MAX_VALUE}};
    private static final Log log = LogFactory.getLog(ActionModeloUC091.class);

    @Override
    public void preparaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
        ContasModule contasMod = DatacontrolHelper.getContasModuleAppModule(binding);
        ViewObject vo = this.getServicoPADAppModule(binding).findViewObject("RemessasDaEntidade");
        if (vo.getCurrentRow() == null) {
            String principal;
            Row r = null;
            while ((r = vo.next()) != null && !(principal = (String)r.getAttribute("RemessaPrincipal")).equals("S")) {
            }
        }
        Remessa rem = this.getRemessaPrincipal(binding);
        this.carregaDadosTotaisModelos(contasMod, rem);
        super.preparaModelo(proxTela, binding);
        ServicoPAD servicoPad = DatacontrolHelper.getServicoPADAppModule(binding);
        this.calculaPercentualEAlertas(contasMod, servicoPad, rem);
    }

    @Override
    protected String getJustificativasWhereClause() {
        return "TIPO_PLANILHA = ?";
    }

    @Override
    protected Object[] getJustificativasWhereClauseParams() {
        return new Object[]{TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo()};
    }

    private void calculaPercentualEAlertas(ContasModule contasMod, ServicoPAD ser, Remessa rem) {
        ViewObject vo = ser.findViewObject("JustificativasDaRemessa");
        Integer nivelModelo2 = null;
        Integer nivelModelo4 = null;
        BigDecimal totalRCL = null;
        BigDecimal totalRCLec86 = null;
        BigDecimal totalRclEndiv = null;
        LinkedHashSet<Integer> setModelos = new LinkedHashSet<Integer>();
        for (Object[] o : CONSULTAS_TOTAIS_MODELOS) {
            setModelos.add((Integer)o[0]);
        }
        Integer[] modelos = setModelos.toArray(new Integer[0]);
        for (int i = 0; i < modelos.length; ++i) {
            int modelo = modelos[i];
            Key chave = JustificativasImpl.createPrimaryKey(rem.getCdEntidade(), rem.getCdRemessa(), TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo(), modelo);
            Row linha = vo.getRow(chave);
            if (linha != null) {
                Integer nivelAlerta = null;
                BigDecimal totalModelo = (BigDecimal)linha.getAttribute("VlModelo");
                if (modelo == 1) {
                    nivelAlerta = 0;
                    totalRCLec86 = totalRCL = totalModelo;
                    totalRclEndiv = totalRCL;
                }
                if (modelo == 13 || modelo == 12) {
                    nivelAlerta = 0;
                    if (totalRCL == null) {
                        totalRCL = totalModelo;
                    }
                    if (modelo == 13) {
                        totalRCLec86 = totalModelo;
                    }
                    if (modelo == 12) {
                        totalRclEndiv = totalModelo;
                    }
                }
                BigDecimal percentual = this.calculaPercentualSobreRCL(totalRCL, totalModelo);
                if (modelo == 4 || modelo == 5 || modelo == 61 || modelo == 62) {
                    percentual = this.calculaPercentualSobreRCL(totalRclEndiv, totalModelo);
                }
                nivelAlerta = this.calculaNivelAlertaModelos(modelo, percentual);
                switch (modelo) {
                    case 2: {
                        percentual = this.calculaPercentualSobreRCL(totalRCLec86, totalModelo);
                        nivelModelo2 = nivelAlerta = this.calculaNivelAlertaModelos(modelo, percentual);
                        break;
                    }
                    case 4: {
                        nivelModelo4 = nivelAlerta;
                        break;
                    }
                    case 5: {
                        nivelAlerta = this.calculaNivelAlertaModelo5(nivelModelo2, nivelModelo4, this.calculaPercentualSobreRCL(totalRCL, totalModelo), rem);
                    }
                }
                log.info((Object)("modelo[" + i + "] = " + modelo + "; totalModelo = " + totalModelo + "; totalRCL = " + totalRCL + "; totalRCLec86 = " + totalRCLec86 + "; percentual = " + percentual + "; nivelAlerta = " + nivelAlerta + "; nivelModelo2 = " + nivelModelo2 + "; nivelModelo4 = " + nivelModelo4));
                linha.setAttribute("NivelAlerta", (Object)nivelAlerta);
                linha.setAttribute("PorcentagemRCL", (Object)percentual);
                if (nivelAlerta == null || nivelAlerta != 0) continue;
                linha.setAttribute("Texto", null);
                linha.setAttribute("Situacao", (Object)0);
                continue;
            }
            log.info((Object)("modelo " + modelo + " n\u00e3o encontrado [vo: " + "JustificativasDaRemessa" + " ; codigo: " + TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo() + "]"));
        }
        ser.getTransaction().commit();
    }

    private void carregaDadosTotaisModelos(ContasModule contasMod, Remessa rem) {
        int periodoInf = rem.getPeriodoInformacoes();
        for (int i = 0; i < CONSULTAS_TOTAIS_MODELOS.length; ++i) {
            int[] periodos = new int[]{};
            Object[] dados = CONSULTAS_TOTAIS_MODELOS[i];
            Integer cdPlanilha = (Integer)dados[0];
            boolean ok = true;
            if (dados.length > 2) {
                periodos = (int[])dados[2];
                ok = periodos.length == 0;
            }
            for (int j = 0; j < periodos.length; ++j) {
                boolean bl = ok = periodos[j] == periodoInf;
                if (ok) break;
            }
            if (ok) {
                String[] entidades = (String[])dados[3];
                ok = false;
                String tipoSetor = rem.getTipoSetor();
                for (int j = 0; j < entidades.length; ++j) {
                    ok = tipoSetor.equals(entidades[j]);
                    if (cdPlanilha == 10 && "P".equals(entidades[j])) {
                        ok = false;
                    }
                    if (ok) break;
                }
            }
            if (!ok) continue;
            BigDecimal total = contasMod.recuperaTotalModelo((String)dados[1]);
            contasMod.carregaJustificativasTotaisQuadros(rem, (Integer)dados[0], total);
        }
    }

    private Integer calculaNivelAlertaModelo5(Integer nivelModelo2, Integer nivelModelo4, BigDecimal percentualRCL, Remessa remessa) {
        double[][] faixas = null;
        faixas = nivelModelo2 > 0 || nivelModelo4 > 0 || remessa.isHonrouCompromissos() ? this.MODELO_5_FAIXA_A : this.MODELO_5_FAIXA_B;
        Integer nivelAlerta = null;
        for (int i = 0; i < faixas.length; ++i) {
            double[] limites = faixas[i];
            BigDecimal minimo = new BigDecimal(limites[1]);
            BigDecimal maximo = new BigDecimal(limites[2]);
            if (percentualRCL.compareTo(minimo) < 0 || percentualRCL.compareTo(maximo) > 0) continue;
            nivelAlerta = (int)limites[0];
        }
        return nivelAlerta;
    }

    private Integer calculaNivelAlertaModelos(int cdPlanilha, BigDecimal percentualRCL) {
        int nivelAlerta = 0;
        for (int j = 0; j < this.FAIXA_VALORES_LIMITES.length; ++j) {
            double[][] faixas = this.FAIXA_VALORES_LIMITES[j];
            if ((int)faixas[0][0] != cdPlanilha) continue;
            for (int h = 1; h < faixas.length; ++h) {
                double[] limites = faixas[h];
                BigDecimal minimo = new BigDecimal(limites[1]);
                BigDecimal maximo = new BigDecimal(limites[2]);
                if (percentualRCL.compareTo(minimo) < 0 || percentualRCL.compareTo(maximo) > 0) continue;
                nivelAlerta = (int)limites[0];
            }
        }
        return nivelAlerta;
    }

    private BigDecimal calculaPercentualSobreRCL(BigDecimal totalModeloRCL, BigDecimal totalModelo) {
        if (totalModeloRCL.intValue() == 0) {
            return new BigDecimal(0);
        }
        return totalModelo.multiply(new BigDecimal(100)).divide(totalModeloRCL, 2, 6);
    }

    @Override
    protected String getJustificativasOrderByClause() {
        return "ORDENACAO,CD_PLANILHA";
    }
}

