/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.TelaPopup;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloPopup;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.ResolveStringConstantes;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ViewObjectImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionModeloPopupSelecao
implements ActionModeloPopup {
    private static Log log = LogFactory.getLog(ActionModeloPopupSelecao.class);
    public static final String POPUP_SELECAO_VO = "PopupSelecaoView";
    public static final String POPUP_SELECAO_VO_DEF = "br.gov.rs.tce.pad.modelo.servico.acessodados.PopupSelecaoView";
    static final Pattern cdrecurso = Pattern.compile("\\bcdrecurso\\b");

    @Override
    public void preparaModelo(Integer tipoConta, IdentificadorConta identConta, TelaPopup telaPopup, ConsultaSQL consultaOrigem, BindingContext binding) throws PADActionException {
        ContasModule mod = DatacontrolHelper.getContasModuleAppModule(binding);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(binding);
        TipoBancoDados tipoBD = DatabaseHelper.recuperaTipoBancoDados(mod);
        String titulo = ResolveStringConstantes.formataStringComConstantes(telaPopup.getTitulo(), remessa);
        telaPopup.setTitulo(titulo);
        String consultaFinalDadosPopup = null;
        if (tipoBD.equals(TipoBancoDados.ORACLE_DB)) {
            consultaFinalDadosPopup = this.montaConsultaSQLOracle(consultaOrigem.getSql(), identConta);
        } else if (tipoBD.equals(TipoBancoDados.DERBY_DB)) {
            consultaFinalDadosPopup = this.contemCdrecurso(consultaOrigem.getSql()) ? this.montaConsultaSQLDerbyComCdRecurso(consultaOrigem.getSql(), identConta) : this.montaConsultaSQLDerby(consultaOrigem.getSql(), identConta);
        } else {
            throw new IllegalArgumentException("N\u00e3o foi possivel montar uma consulta de dados.");
        }
        ViewObject popSelecaoVO = mod.findViewObject(POPUP_SELECAO_VO);
        if (popSelecaoVO != null) {
            popSelecaoVO.remove();
        }
        popSelecaoVO = mod.createViewObject(POPUP_SELECAO_VO, POPUP_SELECAO_VO_DEF);
        ((ViewObjectImpl)popSelecaoVO).setQuery(consultaFinalDadosPopup);
        log.debug((Object)("consultaFinalDadosPopup ==\n" + consultaFinalDadosPopup));
        Object[] paramOrigem = consultaOrigem.getValoresParametros();
        if (paramOrigem.length == 0) {
            paramOrigem = consultaOrigem.getValoresParametros(remessa, tipoBD);
        }
        int indiceParamTipoConta = 0;
        if (paramOrigem != null) {
            indiceParamTipoConta = paramOrigem.length;
            for (int i = 0; i < paramOrigem.length; ++i) {
                popSelecaoVO.setWhereClauseParam(i, paramOrigem[i]);
                log.info((Object)("PARAMETROS POPUP [1][" + i + "] == " + paramOrigem[i]));
            }
        }
        popSelecaoVO.setWhereClauseParam(indiceParamTipoConta, (Object)tipoConta);
        log.info((Object)("PARAMETROS POPUP [1a][" + indiceParamTipoConta + "] == " + tipoConta));
        if (identConta != IdentificadorConta.IDENTIFICADOR_CONTA_RELACIONAMENTO) {
            popSelecaoVO.setWhereClauseParam(++indiceParamTipoConta, (Object)tipoConta);
            log.info((Object)("PARAMETROS POPUP [2][" + indiceParamTipoConta + "] == " + tipoConta));
        }
        log.debug((Object)("query POPUP [identConta=" + identConta + "] ==>" + popSelecaoVO.getQuery()));
        log.debug((Object)("Data Antes exec " + new Date()));
        popSelecaoVO.executeQuery();
        popSelecaoVO.getRowCount();
        log.debug((Object)("Data depois exec " + new Date()));
        if (!telaPopup.isSelecaoMultipla()) {
            boolean achou = false;
            while (popSelecaoVO.hasNext()) {
                Row linha = popSelecaoVO.next();
                if (!((Boolean)linha.getAttribute("EstadoInicial")).booleanValue()) continue;
                achou = true;
                break;
            }
            if (!achou) {
                popSelecaoVO.first();
            }
        }
    }

    public Object[] findAllContaAutomatica(TelaPopup telaPopup, BindingContext binding) {
        ContasModule mod = DatacontrolHelper.getContasModuleAppModule(binding);
        ViewObject popSelecaoVO = mod.findViewObject(POPUP_SELECAO_VO);
        ArrayList<Row> cdContaAutomaticas = new ArrayList<Row>();
        Row linha = null;
        while (popSelecaoVO.hasNext()) {
            linha = popSelecaoVO.next();
            if (!((Boolean)linha.getAttribute("EstadoInicial")).booleanValue()) continue;
            cdContaAutomaticas.add(linha);
        }
        return cdContaAutomaticas.toArray();
    }

    protected String montaConsultaSQLOracle(String consultaOrigem, IdentificadorConta idConta) {
        StringBuffer consultaSQL = new StringBuffer("Select case when (b.cd_conta is not null) and (b.status='S') and (b.cd_unidade = '0' or b.cd_unidade = a.unidade) then 1 else 0 end estado").append(", case when (b.cd_conta is not null) and (b.status='S') and (b.cd_unidade = '0' or b.cd_unidade = a.unidade) then 1 else 0 end estadoinicial").append(", 0 cdrecurso").append(", a.conta").append(", a.dsconta").append(", a.unidade").append(", a.mes").append(", a.valor").append(", b.automatica").append(" from (").append(consultaOrigem).append(") a,");
        if (idConta != IdentificadorConta.IDENTIFICADOR_CONTA_RELACIONAMENTO) {
            consultaSQL.append("(SELECT * FROM contas_remessa WHERE cd_tipo = ? and automatica='N' or automatica is null) b");
        } else {
            consultaSQL.append("(SELECT * FROM contas_remessa WHERE cd_tipo = ?) b");
        }
        consultaSQL.append(" where a.conta = b.cd_conta(+)");
        if (idConta != IdentificadorConta.IDENTIFICADOR_CONTA_RELACIONAMENTO) {
            consultaSQL.append(" and a.conta not in (Select cd_conta from contas_remessa where cd_conta = a.conta and cd_tipo = ? and automatica = 'S')");
        }
        consultaSQL.append(" order by a.conta");
        return consultaSQL.toString();
    }

    protected String montaConsultaSQLDerby(String consultaOrigem, IdentificadorConta idConta) {
        StringBuffer consultaSQL = new StringBuffer("Select case when (b.cd_conta is not null) and (b.status='S') and (Integer(b.cd_unidade) = 0 or Integer(b.cd_unidade) = Integer(a.unidade)) then 1 else 0 end estado").append(", case when (b.cd_conta is not null) and (b.status='S') and (Integer(b.cd_unidade) = 0 or Integer(b.cd_unidade) = Integer(a.unidade)) then 1 else 0 end estadoinicial").append(", 0 cdrecurso").append(", a.conta").append(", a.dsconta").append(", a.unidade").append(", a.mes").append(", a.valor").append(", b.automatica").append(" from (").append(consultaOrigem).append(" ) a ");
        if (idConta != IdentificadorConta.IDENTIFICADOR_CONTA_RELACIONAMENTO) {
            consultaSQL.append(" left outer join (Select * from contas_remessa where cd_tipo = ? and automatica = 'N') b").append(" on (b.cd_conta = a.conta)").append(" where a.conta not in (Select cd_conta from contas_remessa where cd_conta = a.conta and cd_tipo = ? and automatica = 'S')");
        } else {
            consultaSQL.append(" left outer join (Select * from contas_remessa where cd_tipo = ?) b").append(" on (b.cd_conta = a.conta)");
        }
        consultaSQL.append(" order by a.conta");
        log.debug((Object)("montaConsultaSQLDerby:: " + consultaSQL));
        return consultaSQL.toString();
    }

    protected String montaConsultaSQLDerbyComCdRecurso(String consultaOrigem, IdentificadorConta idConta) {
        StringBuffer consultaSQL = new StringBuffer("Select case when (b.cd_conta is not null) and (b.status='S') and (Integer(b.cd_unidade) = 0 or Integer(b.cd_unidade) = Integer(a.unidade)) and (b.cd_recurso=a.cdrecurso) then 1 else 0 end estado\n").append(", case when (b.cd_conta is not null) and (b.status='S') and (Integer(b.cd_unidade) = 0 or Integer(b.cd_unidade) = Integer(a.unidade)) and (b.cd_recurso=a.cdrecurso) then 1 else 0 end estadoinicial\n").append(", a.cdrecurso").append(", a.conta").append(", a.dsconta").append(", a.unidade").append(", a.mes").append(", a.valor").append(", b.automatica\n").append(" from (\n").append(consultaOrigem).append("\n ) a\n");
        if (idConta != IdentificadorConta.IDENTIFICADOR_CONTA_RELACIONAMENTO) {
            consultaSQL.append(" left outer join (Select * from contas_remessa where cd_tipo = ? and automatica = 'N') b").append(" on (b.cd_conta = a.conta and b.cd_recurso = a.cdrecurso)\n").append(" where a.conta not in (Select cd_conta from contas_remessa where cd_conta = a.conta and cd_tipo = ? and automatica = 'S')\n");
        } else {
            consultaSQL.append(" left outer join (Select * from contas_remessa where cd_tipo = ?) b").append(" on (b.cd_conta = a.conta and b.cd_recurso = a.cdrecurso)\n");
        }
        consultaSQL.append(" order by a.cdrecurso, a.conta");
        log.debug((Object)("montaConsultaSQLDerbyComCdRecurso:: " + consultaSQL));
        return consultaSQL.toString();
    }

    public boolean contemCdrecurso(String consultaOrigem) {
        boolean ret = cdrecurso.matcher(consultaOrigem).find();
        log.debug((Object)("contemCdrecurso: " + ret));
        return ret;
    }

    public void limpaModelo(QuadroContas quadroContas, BindingContext binding) throws PADActionException {
    }
}

