/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.geracao;

import br.gov.rs.tce.pad.geracao.GeraAjuda;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeraMensagem {
    static final Log log = LogFactory.getLog(GeraAjuda.class);
    int DEFAULT_BUFFER_SIZE = 8192;
    String dirStr = "../PAD-Modelo/ajuda/html/avisos";
    String outMensagensStr = "../PAD-Modelo/src/mensagens-geradas.xml";
    static final Pattern PTRN_AVISO = Pattern.compile("<BODY>(?:\r\n)?([^<]+)(?:\r\n)?<BR>(?:\r\n)?<B>Tipo de Erro</B>(?:\r\n)?<BR>([^<]+)<BR>(?:\r\n)?<B>Descri(?:[^<]+) do Erro</B>(?:\r\n)?<BR>([^<]+)<BR>(?:\r\n)?<B>Como resolver</B>(?:\r\n)?<BR>(.+)</BODY>", 34);
    static final Pattern PTRN_AVISO2 = Pattern.compile("<BODY>(?:\r\n)?([^<]+)(?:\r\n)?<BR>(?:\r\n)?<B>Arquivo</B>(?:\r\n)?<BR>([^<]+)<BR><B>Tipo de Valida(?:[^<]+)</B>(?:\r\n)?<BR>([^<]+)<BR>(?:\r\n)?<B>Descri(?:[^<]+) do Erro</B>(?:\r\n)?<BR>([^<]+)<BR>(?:\r\n)?<B>Como resolver</B>(?:\r\n)?<BR>(.+)</BODY>", 34);

    String leArquivo(File f) throws IOException {
        String s = this.leArquivo(f, "Windows-1252");
        if (s.indexOf("charset=UTF-8") > 0) {
            s = this.leArquivo(f, "UTF-8");
        }
        s = s.replace('\u2013', '-');
        return s;
    }

    String leArquivo(File f, String charset) throws IOException {
        int n;
        InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(f), charset);
        char[] buf = new char[this.DEFAULT_BUFFER_SIZE];
        StringBuilder sb = new StringBuilder();
        while ((n = fr.read(buf)) >= 0) {
            sb.append(buf, 0, n);
        }
        ((Reader)fr).close();
        return sb.toString();
    }

    void escreveArquivo(File f, String s) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
        fw.write(s);
        ((Writer)fw).close();
    }

    String geraMensagem(String codigo, String arquivo, String texto, String comoResolver, String tipo) {
        String comoResolverFinal = comoResolver.trim();
        if (comoResolverFinal.indexOf("<") > 0) {
            comoResolverFinal = "<![CDATA[\n" + comoResolverFinal + "\n]]>";
        }
        return "  <mensagem>\n    <texto>" + texto.trim() + "</texto>\n    <tipo>" + tipo.trim() + "</tipo>\n    <codigo>" + codigo.trim() + "</codigo>\n    <arquivos>" + arquivo.trim() + "</arquivos>\n    <como-resolver>\n      " + comoResolverFinal + "\n    </como-resolver>\n  </mensagem>\n";
    }

    String prepend() {
        return "<mensagens>\n";
    }

    String append() {
        return "</mensagens>\n";
    }

    String getFName(File f) {
        String fname = f.getName();
        fname = fname.substring(0, fname.indexOf(46));
        return fname;
    }

    void carregaArquivosAjuda() throws IOException {
        File dir = new File(this.dirStr);
        if (!dir.exists()) {
            log.warn((Object)("n\u00c3\u00a3o existe: " + dir));
            log.info((Object)("work dir: " + System.getProperty("user.dir")));
        }
        File[] fls = dir.listFiles();
        int cY = 0;
        int cY2 = 0;
        int cN = 0;
        TreeMap<String, String> arquivos = new TreeMap<String, String>(new GeraAjuda.CodigoRegraComparator());
        for (File f : fls) {
            String content = this.leArquivo(f);
            Matcher m = PTRN_AVISO.matcher(content);
            if (m.find()) {
                String msg = this.geraMensagem(m.group(1), m.group(2), m.group(3), m.group(4), "");
                arquivos.put(this.getFName(f), msg);
                ++cY;
                continue;
            }
            Matcher m2 = PTRN_AVISO2.matcher(content);
            if (m2.find()) {
                String tipo = m2.group(3);
                if (tipo.equals("Erro")) {
                    tipo = "E";
                }
                if (tipo.equals("Aviso")) {
                    tipo = "W";
                }
                if (tipo.equals("Aviso Justificado")) {
                    tipo = "J";
                }
                String msg = this.geraMensagem(m2.group(1), m2.group(2), m2.group(4), m2.group(5), tipo);
                arquivos.put(this.getFName(f), msg);
                ++cY2;
                continue;
            }
            log.info((Object)("sem match: " + f));
            ++cN;
        }
        StringBuilder out = new StringBuilder();
        out.append(this.prepend());
        arquivos.entrySet();
        for (Map.Entry s : arquivos.entrySet()) {
            out.append((String)s.getValue());
        }
        out.append(this.append());
        File outf = new File(this.outMensagensStr);
        this.escreveArquivo(outf, out.toString());
        log.info((Object)("cY=" + cY + " ; cY2=" + cY2 + " ; cN=" + cN + " -- file: " + this.outMensagensStr));
    }

    public static void main(String[] args) throws IOException {
        GeraMensagem gm = new GeraMensagem();
        gm.carregaArquivosAjuda();
    }
}

