/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;

public class ValidacaoConsulta {
    private ConsultaSQL consultaSQL;
    private ApplicationModule applicationModule;
    private String codigoMensagem;
    public static String CD_MENSAGEM_DEFAULT = "VALIDACAO_CONSULTA";

    public ValidacaoConsulta(String codigoMensagem) {
        this.codigoMensagem = codigoMensagem;
    }

    public String getCodigoMensagem() {
        return this.codigoMensagem;
    }

    public void setCodigoMensgem(String codigoMesagem) {
        this.codigoMensagem = this.codigoMensagem;
    }

    public ConsultaSQL getConsultaSQL() {
        return this.consultaSQL;
    }

    public void setConsultaSQL(ConsultaSQL consultaSQL) {
        this.consultaSQL = consultaSQL;
    }

    public ApplicationModule getApplicationModule() {
        return this.applicationModule;
    }

    public void setApplicationModule(ApplicationModule applicationModule) {
        this.applicationModule = applicationModule;
    }

    public boolean validaDadosConsulta(ViewObject vo) {
        return true;
    }

    protected ViewObject createConsultaViewObject() {
        if (this.applicationModule == null) {
            throw new NullPointerException("Valor do Application Module Nulo");
        }
        if (this.consultaSQL == null) {
            throw new NullPointerException("Consulta de Validacao Nula");
        }
        ViewObject vo = this.applicationModule.createViewObjectFromQueryStmt("ValidaConsultaViewObject", this.consultaSQL.getSql());
        Object[] parametros = this.consultaSQL.getValoresParametros();
        for (int i = 0; i < parametros.length; ++i) {
            vo.setWhereClauseParam(i, parametros[i]);
        }
        if (this.consultaSQL == null) {
            throw new NullPointerException("View Object da Consulta de Validacao Nulo");
        }
        return vo;
    }

    public boolean validaConsulta() {
        boolean isValido = false;
        ViewObject voValida = this.createConsultaViewObject();
        if (!voValida.isExecuted()) {
            voValida.executeQuery();
        }
        isValido = this.validaDadosConsulta(voValida);
        if (voValida != null) {
            voValida.remove();
        }
        return isValido;
    }

    public MensagemInstancia getMensagem() {
        MensagemFactory msgFactory = MensagemFactory.getInstancia();
        if (this.codigoMensagem == null) {
            return msgFactory.constroiMensagem(CD_MENSAGEM_DEFAULT);
        }
        return msgFactory.constroiMensagem(this.codigoMensagem);
    }

    public MensagemInstancia getMensagem(Object[] argumentos) {
        MensagemFactory msgFactory = MensagemFactory.getInstancia();
        if (this.codigoMensagem == null) {
            return msgFactory.constroiMensagem(CD_MENSAGEM_DEFAULT, null, argumentos);
        }
        return msgFactory.constroiMensagem(this.codigoMensagem, null, argumentos);
    }
}

