/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.excecao.NumeroMaximoMensagemException;
import br.gov.rs.tce.pad.util.PropertiesUtil;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetadadosArquivoContabil {
    public static int DEFAULT_MAXIMO_MENSAGEM_AVISO;
    public static int DEFAULT_MAXIMO_MENSAGEM_JUSTIFICATIVA;
    public static final int MAXIMO_MENSAGEM_ERRO = 20;
    public static final int MAXIMO_MENSAGEM_INFORMATIVA = -1;
    public static int MAXIMO_MENSAGEM_AVISO;
    public static int MAXIMO_MENSAGEM_JUSTIFICATIVA;
    protected static final Log log;
    private Map<String, Integer> _contadorMensagens;
    public List<String> _mensagensAvisosIC;
    private byte[] _digestOriginal;
    private int _situacao;
    public static final int ARQUIVO_CARREGADO_ERRO = 2;
    public static final int ARQUIVO_CARREGADO_SUCESSO = 1;
    public static final int ARQUIVO_NAO_CARREGADO = 3;
    private Arquivo _arquivo;
    private CabecalhoArquivo _cabecalho;
    private File _arquivoFisico;
    private long _bytesLidos;
    private long _linhasLidas;
    private boolean _erroChavePrimaria;

    public MetadadosArquivoContabil(Arquivo arquivo) {
        this._arquivo = arquivo;
        this._contadorMensagens = new HashMap<String, Integer>();
        this._mensagensAvisosIC = new ArrayList<String>();
        this._cabecalho = new CabecalhoArquivo();
        this._situacao = 3;
        this._bytesLidos = 0L;
    }

    public int getSituacao() {
        return this._situacao;
    }

    public void setSituacao(int situacao) {
        this._situacao = situacao;
    }

    public void incrementaContadorMensagem(String tipoMensagem) {
        Mensagem.verificaTipoMensagem(tipoMensagem);
        Integer contador = this._contadorMensagens.get(tipoMensagem.toUpperCase());
        if (contador == null) {
            contador = 0;
        }
        this._contadorMensagens.put(tipoMensagem, contador + 1);
        if (this.isMaximoMensagemPorTipoAtingido(tipoMensagem)) {
            if (Mensagem.ehMensagemAviso(tipoMensagem)) {
                log.debug((Object)("tipo = " + tipoMensagem));
            } else {
                log.debug((Object)("tipo = " + tipoMensagem));
                if (!VersaoUtils.isDebugModeEnabled()) {
                    throw new NumeroMaximoMensagemException(tipoMensagem, contador + 1);
                }
            }
        }
    }

    private boolean isMaximoMensagemPorTipoAtingido(String tipoMensagem) {
        boolean atingido = false;
        Mensagem.verificaTipoMensagem(tipoMensagem);
        Integer contador = this._contadorMensagens.get(tipoMensagem.toUpperCase());
        int quantidade = 0;
        if (contador != null) {
            quantidade = contador;
        }
        if ("E".equals(tipoMensagem)) {
            atingido = quantidade >= 20;
        } else if (MAXIMO_MENSAGEM_AVISO != -1 && "W".equals(tipoMensagem)) {
            atingido = quantidade >= MAXIMO_MENSAGEM_AVISO;
        } else if (MAXIMO_MENSAGEM_JUSTIFICATIVA != -1 && "J".equals(tipoMensagem)) {
            atingido = quantidade >= MAXIMO_MENSAGEM_JUSTIFICATIVA;
        }
        return atingido;
    }

    public int getQuantidadeMensagem(String tipoMensagem) {
        Mensagem.verificaTipoMensagem(tipoMensagem);
        Integer contador = this._contadorMensagens.get(tipoMensagem.toUpperCase());
        int quantidade = 0;
        if (contador != null) {
            quantidade = contador;
        }
        return quantidade;
    }

    public int getNumeroErrosPorTipo(String tipoMensagem) {
        Mensagem.verificaTipoMensagem(tipoMensagem);
        Integer contador = this._contadorMensagens.get(tipoMensagem);
        int valor = 0;
        if (contador != null) {
            valor = contador;
        }
        return valor;
    }

    public void setCabecalho(CabecalhoArquivo cabecalho) {
        this._cabecalho = cabecalho;
    }

    public CabecalhoArquivo getCabecalho() {
        return this._cabecalho;
    }

    public Arquivo getArquivo() {
        return this._arquivo;
    }

    public File getArquivoFisico() {
        return this._arquivoFisico;
    }

    public void setArquivoFisico(File arquivoFisico) {
        this._arquivoFisico = arquivoFisico;
    }

    public void setDigestOriginal(byte[] digestOriginal) {
        this._digestOriginal = digestOriginal;
    }

    public byte[] getDigestOriginal() {
        return this._digestOriginal;
    }

    public long getBytesLidos() {
        return this._bytesLidos;
    }

    public void incrementaBytesLidos(int bytesLidos) {
        this._bytesLidos += (long)(bytesLidos + 2);
    }

    public long getTamanhoArquivo() {
        return this._arquivoFisico.length();
    }

    public void setErroChavePrimaria(boolean erroChavePrimaria) {
        this._erroChavePrimaria = erroChavePrimaria;
    }

    public boolean isErroChavePrimaria() {
        return this._erroChavePrimaria;
    }

    public List<String> getMensagensAvisosIC() {
        return this._mensagensAvisosIC;
    }

    public long getLinhasLidas() {
        return this._linhasLidas;
    }

    public void setLinhasLidas(long linhasLidas) {
        this._linhasLidas = linhasLidas;
    }

    static {
        Integer maxJustificativa;
        DEFAULT_MAXIMO_MENSAGEM_AVISO = 50;
        DEFAULT_MAXIMO_MENSAGEM_JUSTIFICATIVA = 10;
        MAXIMO_MENSAGEM_AVISO = 50;
        MAXIMO_MENSAGEM_JUSTIFICATIVA = 10;
        log = LogFactory.getLog(MetadadosArquivoContabil.class);
        Integer maxAviso = PropertiesUtil.carregaPropertyInteger("pad.MAXIMO_MENSAGEM_AVISO");
        if (maxAviso != null && maxAviso > DEFAULT_MAXIMO_MENSAGEM_AVISO) {
            MAXIMO_MENSAGEM_AVISO = maxAviso;
        }
        if ((maxJustificativa = PropertiesUtil.carregaPropertyInteger("pad.MAXIMO_MENSAGEM_JUSTIFICATIVA")) != null && maxJustificativa > DEFAULT_MAXIMO_MENSAGEM_JUSTIFICATIVA) {
            MAXIMO_MENSAGEM_JUSTIFICATIVA = maxJustificativa;
        }
        log.info((Object)("MetadadosArquivoContabil: MAXIMO_MENSAGEM_AVISO=" + MAXIMO_MENSAGEM_AVISO + " ; MAXIMO_MENSAGEM_JUSTIFICATIVA=" + MAXIMO_MENSAGEM_JUSTIFICATIVA));
    }
}

