/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.sql;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ClausulaInsert {
    String tableName;
    StringBuilder columnNames = new StringBuilder();
    StringBuilder columnValues = new StringBuilder();

    public ClausulaInsert(String tableName) {
        this.tableName = tableName;
    }

    public ClausulaInsert insertObject(String columnName, Object value) {
        this.init();
        this.columnNames.append(columnName);
        this.columnValues.append(value);
        return this;
    }

    public ClausulaInsert insertString(String columnName, String value) {
        this.init();
        this.columnNames.append(columnName);
        if (value != null) {
            this.columnValues.append('\'').append(value).append('\'');
        } else {
            this.columnValues.append("NULL");
        }
        return this;
    }

    public ClausulaInsert insertString(String columnName, Object value) {
        this.init();
        this.columnNames.append(columnName);
        if (value != null) {
            this.columnValues.append('\'').append(value.toString()).append('\'');
        } else {
            this.columnValues.append("NULL");
        }
        return this;
    }

    public ClausulaInsert insertDate(String columnName, Date value) {
        this.init();
        this.columnNames.append(columnName);
        if (value != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(value);
            String format = "dd/MM/yyyy HH:mm:ss";
            SimpleDateFormat df = new SimpleDateFormat(format);
            String dateStr = df.format(cal.getTime()).toString();
            String dataFinal = "TO_DATE('" + dateStr + "','dd/MM/YYYY HH24:mi:ss')";
            this.columnValues.append(dataFinal);
        } else {
            this.columnValues.append("NULL");
        }
        return this;
    }

    private boolean init() {
        if (this.columnNames.length() > 0) {
            this.columnNames.append(", ");
        }
        if (this.columnValues.length() > 0) {
            this.columnValues.append(", ");
        }
        return true;
    }

    public String toString() {
        return "INSERT INTO " + this.tableName + " (" + this.columnNames.toString() + ") VALUES (" + this.columnValues.toString() + ")";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

