/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.util;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class NavigationalAction
extends AbstractAction {
    protected int dx;
    protected int dy;
    protected boolean toggle;
    protected boolean extend;
    protected boolean inSelection;
    protected int suggestAnchorRow;
    protected int suggestAnchorColumn;
    protected int anchorRow;
    protected int anchorColumn;
    protected int leadRow;
    protected int leadColumn;

    public NavigationalAction(int dx, int dy, boolean toggle, boolean extend, boolean inSelection) {
        this.dx = dx;
        this.dy = dy;
        this.toggle = toggle;
        this.extend = extend;
        this.inSelection = inSelection;
    }

    public int getSuggestAnchorRow() {
        return this.suggestAnchorRow;
    }

    public void setSuggestAnchorRow(int suggestAnchorRow) {
        this.suggestAnchorRow = suggestAnchorRow;
    }

    public int getSuggestAnchorColumn() {
        return this.suggestAnchorColumn;
    }

    public void setSuggestAnchorColumn(int suggestAnchorColumn) {
        this.suggestAnchorColumn = suggestAnchorColumn;
    }

    private int clipToRange(int i, int a, int b) {
        return Math.min(Math.max(i, a), b - 1);
    }

    private void moveWithinTableRange(JTable table, int dx, int dy, boolean changeLead) {
        if (changeLead) {
            this.leadRow = this.clipToRange(this.leadRow + dy, 0, table.getRowCount());
            this.leadColumn = this.clipToRange(this.leadColumn + dx, 0, table.getColumnCount());
        } else {
            this.anchorRow = this.clipToRange(this.anchorRow + dy, 0, table.getRowCount());
            this.anchorColumn = this.clipToRange(this.anchorColumn + dx, 0, table.getColumnCount());
        }
    }

    private int selectionSpan(ListSelectionModel sm) {
        return sm.getMaxSelectionIndex() - sm.getMinSelectionIndex() + 1;
    }

    private int compare(int i, ListSelectionModel sm) {
        return this.compare(i, sm.getMinSelectionIndex(), sm.getMaxSelectionIndex() + 1);
    }

    private int compare(int i, int a, int b) {
        return i < a ? -1 : (i >= b ? 1 : 0);
    }

    private boolean moveWithinSelectedRange(JTable table, int dx, int dy, boolean ignoreCarry) {
        int colSgn;
        int rowSgn;
        boolean canStayInSelection;
        ListSelectionModel rsm = table.getSelectionModel();
        ListSelectionModel csm = table.getColumnModel().getSelectionModel();
        System.out.println("Start Anchor Row => " + this.anchorRow);
        System.out.println("Start Anchor Column => " + this.anchorColumn);
        int newAnchorRow = this.anchorRow + dy;
        int newAnchorColumn = this.anchorColumn + dx;
        int rowCount = this.selectionSpan(rsm);
        int columnCount = this.selectionSpan(csm);
        System.out.println("Contagem Row (1) => " + rowCount);
        System.out.println("Contagem Column (1) => " + columnCount);
        boolean bl = canStayInSelection = rowCount * columnCount > 1;
        if (canStayInSelection) {
            rowSgn = this.compare(newAnchorRow, rsm);
            colSgn = this.compare(newAnchorColumn, csm);
        } else {
            rowCount = table.getRowCount();
            columnCount = table.getColumnCount();
            System.out.println("Contagem Row (2) => " + rowCount);
            System.out.println("Contagem Column (2) => " + columnCount);
            rowSgn = this.compare(newAnchorRow, 0, rowCount);
            colSgn = this.compare(newAnchorColumn, 0, columnCount);
            System.out.println("Sgn Row (2) => " + rowSgn);
            System.out.println("Sgn Column (2) => " + colSgn);
        }
        this.anchorRow = newAnchorRow - rowCount * rowSgn;
        if (dy == 0) {
            this.anchorRow += colSgn;
        }
        if (this.anchorRow < 0) {
            this.anchorRow = rowCount - 1;
        }
        if (this.anchorRow >= rowCount) {
            this.anchorRow = 0;
        }
        this.anchorColumn = newAnchorColumn - columnCount * colSgn;
        if (dx == 0) {
            this.anchorColumn += rowSgn;
        }
        if (this.anchorColumn < 0) {
            this.anchorColumn = columnCount - 1;
        }
        if (this.anchorColumn >= columnCount) {
            this.anchorColumn = 0;
        }
        if (!ignoreCarry) {
            return this.moveWithinSelectedRange(table, rowSgn, colSgn, true);
        }
        return canStayInSelection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTable table = (JTable)e.getSource();
        ListSelectionModel rsm = table.getSelectionModel();
        this.anchorRow = rsm.getAnchorSelectionIndex() >= 0 ? rsm.getLeadSelectionIndex() : this.suggestAnchorRow;
        this.leadRow = rsm.getLeadSelectionIndex();
        ListSelectionModel csm = table.getColumnModel().getSelectionModel();
        this.anchorColumn = csm.getAnchorSelectionIndex() >= 0 ? csm.getAnchorSelectionIndex() : this.suggestAnchorColumn;
        this.leadColumn = csm.getLeadSelectionIndex();
        int oldAnchorRow = this.anchorRow;
        int oldAnchorColumn = this.anchorColumn;
        if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
            return;
        }
        if (!this.inSelection) {
            this.moveWithinTableRange(table, this.dx, this.dy, this.extend);
            if (!this.extend) {
                table.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
            } else {
                table.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
            }
        } else if (this.moveWithinSelectedRange(table, this.dx, this.dy, true)) {
            table.changeSelection(this.anchorRow, this.anchorColumn, true, true);
        } else {
            table.changeSelection(this.anchorRow, this.anchorColumn, false, false);
        }
        table.getSelectionModel().setAnchorSelectionIndex(this.anchorRow);
        table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(this.anchorColumn);
    }
}

