/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.ord.controls.DialogRunner;
import oracle.ord.controls.JMDialog;
import oracle.ord.controls.OrdMediaControl;

class JMPanel
extends JPanel
implements ActionListener,
ControllerListener {
    Player m_player;
    JComponent m_controlPanel;
    Component visual;
    Component control;
    int videoWidth;
    int videoHeight;
    int controlHeight;
    int insetWidth;
    int insetHeight;
    boolean firstTime;
    Dimension preferredSize;
    boolean m_autostart;
    static final String PLAYER_KEYCODE_START = "start_key";
    static final String PLAYER_MODIFIER_START = "start_modifier";
    static final String PLAYER_KEYCODE_STOP = "stop_key";
    static final String PLAYER_MODIFIER_STOP = "stop_modifier";
    static final String PLAYER_KEYCODE_PAUSE = "pause_key";
    static final String PLAYER_MODIFIER_PAUSE = "pause_modifier";
    static final String PLAYER_KEYCODE_VOLUMEUP = "volumeup_key";
    static final String PLAYER_MODIFIER_VOLUMEUP = "volumeup_modifier";
    static final String PLAYER_KEYCODE_VOLUMEDOWN = "volumedown_key";
    static final String PLAYER_MODIFIER_VOLUMEDOWN = "volumedown_modifier";
    static final String PLAYER_KEYCODE_TOGGLEMUTE = "togglemute_key";
    static final String PLAYER_MODIFIER_TOGGLEMUTE = "togglemute_modifier";
    static final String PLAYER_KEYCODE_REWIND = "rewind_key";
    static final String PLAYER_MODIFIER_REWIND = "rewind_modifier";
    static final String PLAYER_KEYCODE_FASTFORWARD = "fastforward_key";
    static final String PLAYER_MODIFIER_FASTFORWARD = "fastforward_modifier";
    static final String PLAYER_ACCELERATE_DELTA = "accelerate_delta";
    KeyStroke m_ksStart;
    String m_cmdStart;
    KeyStroke m_ksStop;
    String m_cmdStop;
    KeyStroke m_ksPause;
    String m_cmdPause;
    KeyStroke m_ksVolumeUp;
    String m_cmdVolumeUp;
    KeyStroke m_ksVolumeDown;
    String m_cmdVolumeDown;
    KeyStroke m_ksToggleMute;
    String m_cmdToggleMute;
    KeyStroke m_ksRewind;
    String m_cmdRewind;
    KeyStroke m_ksFastForward;
    String m_cmdFastForward;
    int m_acceDelta;
    boolean m_showControlPanel;

    private /* synthetic */ void $init$() {
        this.m_controlPanel = null;
        this.visual = null;
        this.control = null;
        this.videoWidth = 0;
        this.videoHeight = 0;
        this.controlHeight = 30;
        this.insetWidth = 10;
        this.insetHeight = 30;
        this.firstTime = true;
        this.preferredSize = new Dimension(320, 200);
        this.m_autostart = false;
        this.m_ksStart = null;
        this.m_cmdStart = "start";
        this.m_ksStop = null;
        this.m_cmdStop = "stop";
        this.m_ksPause = null;
        this.m_cmdPause = "pause";
        this.m_ksVolumeUp = null;
        this.m_cmdVolumeUp = "volumeUp";
        this.m_ksVolumeDown = null;
        this.m_cmdVolumeDown = "volumeDown";
        this.m_ksToggleMute = null;
        this.m_cmdToggleMute = "toggleMute";
        this.m_ksRewind = null;
        this.m_cmdRewind = "rewind";
        this.m_ksFastForward = null;
        this.m_cmdFastForward = "fastForward";
        this.m_acceDelta = 3;
        this.m_showControlPanel = true;
    }

    public JMPanel(Player player, String string, boolean bl) {
        this.$init$();
        this.m_autostart = bl;
        this.setLayout(new BorderLayout());
        this.setVisible(true);
        this.m_player = player;
        this.m_player.addControllerListener((ControllerListener)this);
        if (bl) {
            this.m_player.realize();
        }
        this.m_ksStart = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_START), this.m_getInt(PLAYER_MODIFIER_START), false);
        this.m_ksStop = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_STOP), this.m_getInt(PLAYER_MODIFIER_STOP), false);
        this.m_ksPause = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_PAUSE), this.m_getInt(PLAYER_MODIFIER_PAUSE), false);
        this.m_ksVolumeUp = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_VOLUMEUP), this.m_getInt(PLAYER_MODIFIER_VOLUMEUP), false);
        this.m_ksVolumeDown = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_VOLUMEDOWN), this.m_getInt(PLAYER_MODIFIER_VOLUMEDOWN), false);
        this.m_ksToggleMute = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_TOGGLEMUTE), this.m_getInt(PLAYER_MODIFIER_TOGGLEMUTE), false);
        this.m_ksRewind = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_REWIND), this.m_getInt(PLAYER_MODIFIER_REWIND), false);
        this.m_ksFastForward = KeyStroke.getKeyStroke(this.m_getInt(PLAYER_KEYCODE_FASTFORWARD), this.m_getInt(PLAYER_MODIFIER_FASTFORWARD), false);
        try {
            String string2 = OrdMediaControl.m_props.getProperty(PLAYER_ACCELERATE_DELTA);
            this.m_acceDelta = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registerKeyboardAction(this, this.m_cmdStart, this.m_ksStart, 2);
        this.registerKeyboardAction(this, this.m_cmdStop, this.m_ksStop, 2);
        this.registerKeyboardAction(this, this.m_cmdPause, this.m_ksPause, 2);
        this.registerKeyboardAction(this, this.m_cmdVolumeUp, this.m_ksVolumeUp, 2);
        this.registerKeyboardAction(this, this.m_cmdVolumeDown, this.m_ksVolumeDown, 2);
        this.registerKeyboardAction(this, this.m_cmdToggleMute, this.m_ksToggleMute, 2);
        this.registerKeyboardAction(this, this.m_cmdRewind, this.m_ksRewind, 2);
        this.registerKeyboardAction(this, this.m_cmdFastForward, this.m_ksFastForward, 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_player == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals(this.m_cmdStart)) {
            this.m_player.start();
        } else if (string.equals(this.m_cmdStop)) {
            this.m_player.stop();
            this.m_player.setMediaTime(new Time(0L));
        } else if (string.equals(this.m_cmdPause)) {
            this.m_player.stop();
        } else if (string.equals(this.m_cmdVolumeUp)) {
            this.m_adjustVolume(true);
        } else if (string.equals(this.m_cmdVolumeDown)) {
            this.m_adjustVolume(false);
        } else if (string.equals(this.m_cmdToggleMute)) {
            this.m_toggleMute();
        } else if (string.equals(this.m_cmdRewind)) {
            this.m_accelerate(true);
        } else if (string.equals(this.m_cmdFastForward)) {
            this.m_accelerate(false);
        }
    }

    private int m_getInt(String string) {
        String string2 = OrdMediaControl.m_props.getProperty(string);
        int n = 0;
        try {
            Class<?> clazz = Class.forName("java.awt.event.KeyEvent");
            Field field = clazz.getField(string2);
            n = field.getInt(null);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return n;
    }

    private void m_accelerate(boolean bl) {
        long l = (long)this.m_acceDelta * 1000000000L;
        long l2 = this.m_player.getMediaTime().getNanoseconds();
        Time time = null;
        if (bl) {
            long l3 = l2 < l ? 0L : l2 - l;
            time = new Time(l3);
        } else {
            time = new Time(l2 + l);
        }
        this.m_player.stop();
        this.m_player.setMediaTime(time);
        this.m_player.start();
    }

    private void m_toggleMute() {
        GainControl gainControl = this.m_player.getGainControl();
        boolean bl = gainControl.getMute();
        gainControl.setMute(bl ^ true);
    }

    private void m_adjustVolume(boolean bl) {
        GainControl gainControl = this.m_player.getGainControl();
        float f = 0.2f;
        float f2 = gainControl.getLevel();
        f2 = bl ? (f2 += f) : (f2 -= f);
        if ((double)f2 < 0.0) {
            f2 = 0.0f;
        } else if ((double)f2 > 1.0) {
            f2 = 1.0f;
        }
        gainControl.setLevel(f2);
    }

    public boolean getShowControlPanel() {
        return this.m_showControlPanel;
    }

    public void setShowControlPanel(boolean bl) {
        this.m_showControlPanel = bl;
    }

    public JComponent getControlPanel() {
        return this.m_controlPanel;
    }

    public void setControlPanel(JComponent jComponent) {
        this.m_controlPanel = jComponent;
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof RealizeCompleteEvent) {
            this.m_player.prefetch();
        } else if (controllerEvent instanceof PrefetchCompleteEvent) {
            if (this.visual != null) {
                return;
            }
            this.visual = this.m_player.getVisualComponent();
            if (this.visual != null) {
                Dimension dimension = this.visual.getPreferredSize();
                this.videoWidth = dimension.width;
                this.videoHeight = dimension.height;
                this.add("Center", this.visual);
            } else {
                this.videoWidth = 320;
            }
            Component component = this.control = this.m_controlPanel == null ? this.m_player.getControlPanelComponent() : this.m_controlPanel;
            if (this.control != null) {
                this.controlHeight = this.control.getPreferredSize().height;
                if (this.m_showControlPanel) {
                    this.add("South", this.control);
                }
            }
            this.setSize(this.videoWidth + this.insetWidth, this.videoHeight + this.controlHeight + this.insetHeight);
            this.revalidate();
            if (this.getRootPane() != null) {
                Container container = null;
                container = this.getRootPane().getParent();
                if (container instanceof JMDialog) {
                    SwingUtilities.invokeLater(new DialogRunner((JMDialog)container));
                }
            }
            if (this.m_autostart) {
                this.m_player.start();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            this.m_player.setMediaTime(new Time(0L));
        } else if (controllerEvent instanceof ControllerErrorEvent) {
            JOptionPane.showMessageDialog(this, ((ControllerErrorEvent)controllerEvent).getMessage(), null, 0);
        }
    }

    void closePlayer() {
        if (this.m_player != null) {
            this.m_player.close();
        }
        this.m_player = null;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.visual != null) {
            Dimension dimension = this.visual.getPreferredSize();
            n = dimension.width;
            n2 = dimension.height;
        } else {
            n = 320;
        }
        if (this.control != null) {
            n2 += this.control.getPreferredSize().height;
        }
        this.preferredSize = new Dimension(n + this.insetWidth, n2 + this.insetHeight);
        return this.preferredSize;
    }

    public void removeControllerListener() {
        if (this.m_player != null) {
            this.m_player.removeControllerListener((ControllerListener)this);
        }
    }
}

